{{-- resources/views/tenant/signup.blade.php --}}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register Your Dealership | CARISMA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .signup-container {
            max-width: 1200px;
            margin: 3rem auto;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            background-color: #fff;
            padding: 2rem;
        }
        .form-section {
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid #eee;
        }
        .form-section:last-child {
            border-bottom: none;
        }
        .signup-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        .signup-header h1 {
            color: #2c3e50;
            font-weight: 600;
        }
        .plan-card {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 1.5rem;
            height: 100%;
            transition: all 0.3s;
            position: relative;
            cursor: pointer;
        }
        .plan-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .plan-card.selected {
            border-color: #4CAF50;
            box-shadow: 0 5px 15px rgba(76, 175, 80, 0.3);
        }
        .plan-card.best-plan {
            background-color: #1D19D8;
            color: white;
            border-color: #1D19D8;
        }
        .plan-card.best-plan .plan-price {
            color: white;
        }
        .plan-card .selected-badge {
            position: absolute;
            top: -10px;
            right: -10px;
            background-color: #4CAF50;
            color: white;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
        }
        .plan-card .best-badge {
            position: absolute;
            top: -10px;
            right: 10px;
            background-color: #ff6b35;
            color: white;
            border-radius: 15px;
            padding: 5px 15px;
            font-size: 12px;
            font-weight: bold;
        }
        .plan-price {
            font-size: 1.8rem;
            font-weight: bold;
            margin: 1rem 0;
            color: #3498db;
        }
        .plan-features {
            margin: 1.5rem 0;
            padding-left: 0;
        }
        .plan-features li {
            list-style: none;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            font-size: 0.9rem;
        }
        .plan-features li i {
            margin-right: 10px;
            width: 16px;
            text-align: center;
        }
        .plan-features li i.fa-check {
            color: #4CAF50;
        }
        .plan-features li i.fa-times {
            color: #dc3545;
        }
        .plan-card.best-plan .plan-features li i.fa-check {
            color: #4CAF50;
        }
        .plan-card.best-plan .plan-features li i.fa-times {
            color: #ff9999;
        }
        .subdomain-addon {
            display: flex;
            align-items: center;
        }
        .domain-text {
            margin-left: 5px;
            margin-right: 5px;
            font-weight: 600;
        }
        #subdomain-preview {
            font-style: italic;
            color: #666;
            margin-top: 5px;
        }
        .alert-info {
            background-color: #e3f2fd;
            border-color: #bbdefb;
        }
        .promo-section {
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 1.5rem;
            margin-bottom: 1rem;
        }
        .promo-input-group {
            display: flex;
            gap: 10px;
            align-items: end;
        }
        .promo-input-group input {
            flex: 1;
        }
        .promo-feedback {
            margin-top: 0.5rem;
            font-size: 0.9rem;
        }
        .promo-feedback.success {
            color: #28a745;
        }
        .promo-feedback.error {
            color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="signup-container">
            <div class="signup-header">
                <h1>Carisma Score Board</h1>
                <p class="lead">Our New Pricing - Join CARISMA to streamline your dealership management</p>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form id="tenantSignupForm" action="{{ route('tenant.register') }}" method="POST">
                @csrf
                
                <div class="form-section">
                    <h3><i class="fas fa-building me-2"></i>Dealership Information</h3>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="company_name" class="form-label">Dealership Name</label>
                            <input type="text" class="form-control" id="company_name" name="company_name" 
                                value="{{ old('company_name') }}" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="subdomain" class="form-label">Subdomain</label>
                            <div class="subdomain-addon">
                                <input type="text" class="form-control" id="subdomain" name="subdomain" 
                                    value="{{ old('subdomain') }}" required 
                                    pattern="[a-z0-9]+" title="Only lowercase letters and numbers allowed">
                                <span class="domain-text">.carismacar.org</span>
                            </div>
                            <div id="subdomain-preview"></div>
                            <div class="form-text">This will be your unique URL. Use only lowercase letters and numbers, no spaces or special characters.</div>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="phone" class="form-label">Phone Number</label>
                            <input type="text" class="form-control" id="phone" name="phone" 
                                value="{{ old('phone') }}">
                        </div>
                        
                        <div class="col-md-6">
                            <label for="address" class="form-label">Address</label>
                            <input type="text" class="form-control" id="address" name="address" 
                                value="{{ old('address') }}">
                        </div>
                    </div>
                </div>
                
                <div class="form-section">
                    <h3><i class="fas fa-user-shield me-2"></i>Admin Account</h3>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="admin_name" class="form-label">Full Name</label>
                            <input type="text" class="form-control" id="admin_name" name="admin_name" 
                                value="{{ old('admin_name') }}" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="admin_email" class="form-label">Email Address</label>
                            <input type="email" class="form-control" id="admin_email" name="admin_email" 
                                value="{{ old('admin_email') }}" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="admin_password" class="form-label">Password</label>
                            <input type="password" class="form-control" id="admin_password" name="admin_password" 
                                required minlength="8">
                            <div class="form-text">Minimum 8 characters</div>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="admin_password_confirmation" class="form-label">Confirm Password</label>
                            <input type="password" class="form-control" id="admin_password_confirmation" 
                                name="admin_password_confirmation" required minlength="8">
                        </div>
                    </div>
                </div>
                
                <div class="form-section">
                    <h3><i class="fas fa-cubes me-2"></i>Choose Your Plan</h3>
                    <div class="row g-4">
                        <div class="col-md-4">
                            <div class="plan-card" data-plan="basic" onclick="selectPlan('basic')">
                                <div class="selected-badge d-none"><i class="fas fa-check"></i></div>
                                <h4>Basic</h4>
                                <div class="plan-price">$199/Month</div>
                                <p>Perfect for small dealerships just getting started.</p>
                                <ul class="plan-features">
                                    <li><i class="fas fa-check"></i> Scoreboard</li>
                                    <li><i class="fas fa-check"></i> Product Training videos for Advisors</li>
                                    <li><i class="fas fa-check"></i> BDC/Finance/Sales</li>
                                    <li><i class="fas fa-times"></i> Check for recalls most models</li>
                                    <li><i class="fas fa-times"></i> Sales Agents get safety data about vehicles</li>
                                    <li><i class="fas fa-times"></i> internal message system between employees</li>
                                    <li><i class="fas fa-times"></i> Service Videos Library</li>
                                    <li><i class="fas fa-times"></i> Menu set up</li>
                                    <li><i class="fas fa-times"></i> Service Appointment QR Codes</li>
                                    <li><i class="fas fa-times"></i> Service Dept. Landing Page for Appointments</li>
                                    <li><i class="fas fa-times"></i> Used Vehicle Values tool</li>
                                    <li><i class="fas fa-times"></i> E Business Cards</li>
                                    <li><i class="fas fa-times"></i> Service Reminder Sticker/Printer</li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="plan-card best-plan" data-plan="premium" onclick="selectPlan('premium')">
                                <div class="best-badge">Best Plan</div>
                                <div class="selected-badge d-none"><i class="fas fa-check"></i></div>
                                <h4>Premium</h4>
                                <div class="plan-price">$299/Month</div>
                                <p>Our most popular plan for growing dealerships.</p>
                                <ul class="plan-features">
                                    <li><i class="fas fa-check"></i> Scoreboard</li>
                                    <li><i class="fas fa-check"></i> Product Training videos for Advisors</li>
                                    <li><i class="fas fa-check"></i> BDC/Finance/Sales</li>
                                    <li><i class="fas fa-check"></i> Check for recalls most models</li>
                                    <li><i class="fas fa-check"></i> Sales Agents get safety data about vehicles</li>
                                    <li><i class="fas fa-check"></i> internal message system between employees</li>
                                    <li><i class="fas fa-check"></i> Service Videos Library</li>
                                    <li><i class="fas fa-times"></i> Menu set up</li>
                                    <li><i class="fas fa-times"></i> Service Appointment QR Codes</li>
                                    <li><i class="fas fa-times"></i> Service Dept. Landing Page for Appointments</li>
                                    <li><i class="fas fa-times"></i> Used Vehicle Values tool</li>
                                    <li><i class="fas fa-times"></i> E Business Cards</li>
                                    <li><i class="fas fa-times"></i> Service Reminder Sticker/Printer</li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="plan-card" data-plan="enterprise" onclick="selectPlan('enterprise')">
                                <div class="selected-badge d-none"><i class="fas fa-check"></i></div>
                                <h4>Enterprise</h4>
                                <div class="plan-price">$599/Month</div>
                                <p>For large dealerships with advanced needs.</p>
                                <ul class="plan-features">
                                    <li><i class="fas fa-check"></i> Scoreboard</li>
                                    <li><i class="fas fa-check"></i> Product Training videos for Advisors</li>
                                    <li><i class="fas fa-check"></i> BDC/Finance/Sales</li>
                                    <li><i class="fas fa-check"></i> Check for recalls most models</li>
                                    <li><i class="fas fa-check"></i> Sales Agents get safety data about vehicles</li>
                                    <li><i class="fas fa-check"></i> internal message system between employees</li>
                                    <li><i class="fas fa-check"></i> Service Videos Library</li>
                                    <li><i class="fas fa-check"></i> Menu set up</li>
                                    <li><i class="fas fa-check"></i> Service Appointment QR Codes</li>
                                    <li><i class="fas fa-check"></i> Service Dept. Landing Page for Appointments</li>
                                    <li><i class="fas fa-check"></i> Used Vehicle Values tool</li>
                                    <li><i class="fas fa-check"></i> E Business Cards</li>
                                    <li><i class="fas fa-check"></i> Service Reminder Sticker/Printer</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <input type="hidden" id="selected_plan" name="plan" value="premium">
                    <input type="hidden" id="final_promo_code" name="promo_code" value="">
                </div>
                
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i> After confirming your details, you'll be redirected to our secure payment page to complete your subscription.
                </div>
                
                <div class="d-grid gap-2 col-md-6 mx-auto mt-4">
                    <button type="button" class="btn btn-primary btn-lg" onclick="showConfirmation()">
                        <i class="fas fa-rocket me-2"></i> Purchase Plan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div class="modal fade" id="confirmationModal" tabindex="-1" aria-labelledby="confirmationModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmationModalLabel">
                        <i class="fas fa-check-circle me-2"></i>Confirm Your Subscription
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-8">
                            <h6><i class="fas fa-star me-2"></i>Selected Plan:</h6>
                            <p id="selected-plan-name" class="fw-bold text-primary"></p>
                            
                            <h6><i class="fas fa-building me-2"></i>Dealership:</h6>
                            <p id="selected-dealership"></p>
                            
                            <h6><i class="fas fa-envelope me-2"></i>Admin Email:</h6>
                            <p id="selected-email"></p>
                            
                            <!-- Promo Code Section in Modal -->
                            <div class="promo-section">
                                <h6><i class="fas fa-tag me-2"></i>Have a Promo Code?</h6>
                                <div class="promo-input-group">
                                    <div class="flex-grow-1">
                                        <input type="text" class="form-control" id="modal_promo_code" 
                                            placeholder="Enter promo code" maxlength="20">
                                    </div>
                                    <button type="button" class="btn btn-outline-primary" onclick="applyPromoCode()">
                                        Apply Code
                                    </button>
                                </div>
                                <div id="promo-feedback" class="promo-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body text-center">
                                    <h6><i class="fas fa-dollar-sign me-2"></i>Pricing Summary</h6>
                                    <div id="original-price" class="text-muted"></div>
                                    <div id="final-price" class="h4 text-primary"></div>
                                    <div id="promo-message" class="alert alert-success py-2" style="display: none;">
                                        <i class="fas fa-gift me-2"></i>
                                        <strong>First month FREE</strong> with promo code!
                                    </div>
                                    <div class="small text-muted mt-2">
                                        <i class="fas fa-info-circle me-1"></i>
                                        <span id="billing-note"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>Cancel
                    </button>
                    <button type="button" class="btn btn-primary btn-lg" onclick="proceedToPayment()">
                        <i class="fas fa-credit-card me-2"></i> Proceed to Payment
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Valid promo codes (same as backend)
        const validPromoCodes = ['CARISMA2025', 'FREEMONTH', 'LAUNCH'];
        
        // Plan pricing - must match backend exactly
        const planPricing = {
            'basic': { name: 'Basic', price: 199 },
            'premium': { name: 'Premium', price: 299 },
            'enterprise': { name: 'Enterprise', price: 599 }
        };

        let appliedPromoCode = '';

        // Function to handle plan selection
        function selectPlan(plan) {
            // Remove selected class from all plans
            document.querySelectorAll('.plan-card').forEach(card => {
                card.classList.remove('selected');
                card.querySelector('.selected-badge').classList.add('d-none');
            });
            
            // Add selected class to chosen plan
            const selectedCard = document.querySelector(`.plan-card[data-plan="${plan}"]`);
            selectedCard.classList.add('selected');
            selectedCard.querySelector('.selected-badge').classList.remove('d-none');
            
            // Update hidden input
            document.getElementById('selected_plan').value = plan;
        }
        
        // Function to validate promo code
        function isValidPromoCode(code) {
            return code && validPromoCodes.includes(code.toUpperCase());
        }
        
        // Function to apply promo code in modal
        function applyPromoCode() {
            const promoInput = document.getElementById('modal_promo_code');
            const promoCode = promoInput.value.trim().toUpperCase();
            const feedback = document.getElementById('promo-feedback');
            
            if (!promoCode) {
                feedback.textContent = 'Please enter a promo code';
                feedback.className = 'promo-feedback error';
                return;
            }
            
            if (isValidPromoCode(promoCode)) {
                appliedPromoCode = promoCode;
                feedback.textContent = '✓ Promo code applied successfully!';
                feedback.className = 'promo-feedback success';
                promoInput.value = promoCode;
                updatePricingDisplay();
            } else {
                appliedPromoCode = '';
                feedback.textContent = 'Invalid promo code. Please try again.';
                feedback.className = 'promo-feedback error';
                updatePricingDisplay();
            }
        }
        
        // Function to update pricing display
        function updatePricingDisplay() {
            const selectedPlan = document.getElementById('selected_plan').value;
            const plan = planPricing[selectedPlan];
            
            const originalPrice = document.getElementById('original-price');
            const finalPrice = document.getElementById('final-price');
            const promoMessage = document.getElementById('promo-message');
            const billingNote = document.getElementById('billing-note');
            
            if (appliedPromoCode) {
                originalPrice.innerHTML = '<s>$' + plan.price + '/month</s>';
                finalPrice.textContent = 'FREE for first month';
                promoMessage.style.display = 'block';
                billingNote.textContent = 'Then $' + plan.price + '/month after 30-day trial period';
            } else {
                originalPrice.textContent = '';
                finalPrice.textContent = '$' + plan.price + '/month';
                promoMessage.style.display = 'none';
                billingNote.textContent = 'Billed monthly';
            }
        }
        
        // Function to show confirmation modal
        function showConfirmation() {
            // Get form values
            const selectedPlan = document.getElementById('selected_plan').value;
            const companyName = document.getElementById('company_name').value;
            const subdomain = document.getElementById('subdomain').value;
            const adminEmail = document.getElementById('admin_email').value;
            const adminName = document.getElementById('admin_name').value;
            
            // Validate required fields
            if (!companyName || !subdomain || !adminEmail || !adminName) {
                alert('Please fill in all required fields before proceeding.');
                return;
            }
            
            // Validate password match
            const password = document.getElementById('admin_password').value;
            const confirmPassword = document.getElementById('admin_password_confirmation').value;
            if (password !== confirmPassword || password.length < 8) {
                alert('Please ensure passwords match and are at least 8 characters long.');
                return;
            }
            
            // Reset modal state
            appliedPromoCode = '';
            document.getElementById('modal_promo_code').value = '';
            document.getElementById('promo-feedback').textContent = '';
            document.getElementById('promo-feedback').className = 'promo-feedback';
            
            // Update modal content
            const plan = planPricing[selectedPlan];
            document.getElementById('selected-plan-name').textContent = plan.name;
            document.getElementById('selected-dealership').textContent = companyName + ' (' + subdomain + '.carismacar.org)';
            document.getElementById('selected-email').textContent = adminEmail;
            
            // Update pricing display
            updatePricingDisplay();
            
            // Show modal
            const modal = new bootstrap.Modal(document.getElementById('confirmationModal'));
            modal.show();
        }
        
        // Function to proceed to payment
        function proceedToPayment() {
            // Set the final promo code in the hidden input
            document.getElementById('final_promo_code').value = appliedPromoCode;
            
            // Submit the form
            document.getElementById('tenantSignupForm').submit();
        }
        
        // Initialize with Premium plan selected
        document.addEventListener('DOMContentLoaded', function() {
            selectPlan('premium');
            
            // Update subdomain preview
            const subdomainInput = document.getElementById('subdomain');
            const subdomainPreview = document.getElementById('subdomain-preview');
            
            subdomainInput.addEventListener('input', function() {
                // Convert to lowercase and remove special characters
                this.value = this.value.toLowerCase().replace(/[^a-z0-9]/g, '');
                
                if (this.value) {
                    subdomainPreview.textContent = `Your dealership will be available at: ${this.value}.carismacar.org`;
                } else {
                    subdomainPreview.textContent = '';
                }
            });
            
            // Allow Enter key to apply promo code
            document.getElementById('modal_promo_code').addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    applyPromoCode();
                }
            });
        });
    </script>
</body>
</html>