<div class="enhanced-leaderboard-container">
    @if($data && $data->count() > 0)
        <!-- Top 3 Performers Section -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="top-performers-card">
                    <div class="text-center mb-4">
                        <h4 class="text-primary">
                            <i class="fas fa-trophy me-2"></i>
                            Top 3 {{ $category }} Performers
                        </h4>
                        <p class="text-muted">Real-time performance rankings</p>
                    </div>
                    
                    <div class="d-flex align-items-end justify-content-center pt-6">
                        @foreach($top3 as $index => $performer)
                            @php
                                $position = $index + 1;
                                $isFirst = $position === 1;
                                $positionClass = $position === 1 ? 'leader-box-middle' : ($position === 2 ? 'leader-box-left' : 'leader-box-right');
                                $name = $performer->employee_name ?? $performer->department_name ?? 'N/A';
                                $image = $performer->image ?? '/assets/img/placeholder-img-2.png';
                                
                                // Get prize for this position
                                $prize = null;
                                if (isset($prizes) && $prizes->has($position)) {
                                    $prize = $prizes->get($position)->first();
                                }
                            @endphp
                            
                            <div class="{{ $positionClass }} position-relative">
                                <div class="position-absolute text-center">
                                    @if($isFirst)
                                        <img src="/assets/img/crown.png" alt="Crown" class="img-fluid mb-1">
                                    @endif
                                    <div class="img-circle-area">
                                        <img src="{{ $image }}" 
                                             alt="{{ $name }}" 
                                             class="rounded-circle img-fluid">
                                    </div>
                                    <span class="rank-badge rank-{{ $position }}">{{ $position }}</span>
                                </div>
                                <div class="text-center">
                                    <h6>{{ $performer->category ?? 'N/A' }}</h6>
                                    <div class="count {{ $isFirst ? 'my-2' : '' }}">{{ $performer->earned_points ?? 'N/A' }} pts</div>
                                    <div class="u-name">{{ $name }}</div>
                                    
                                    @if($prize)
                                        <div class="prize-info mt-2">
                                            <div class="prize-badge">
                                                <i class="fas fa-trophy me-1"></i>
                                                <strong>{{ $prize->title }}</strong>
                                            </div>
                                            @if($prize->prize_amount)
                                                <div class="prize-amount">
                                                    {{ $prize->formatted_amount }}
                                                </div>
                                            @endif
                                            @if($prize->description)
                                                <div class="prize-description">
                                                    <small>{{ $prize->description }}</small>
                                                </div>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Complete Ranking Section -->
        @if($complete_ranking && $complete_ranking->count() > 0)
            <div class="row">
                <div class="col-12">
                    <div class="complete-ranking-card">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h5 class="text-dark">
                                <i class="fas fa-list-ol me-2"></i>
                                Complete {{ $category }} Ranking
                            </h5>
                            <span class="badge bg-primary fs-6">{{ $complete_ranking->count() }} Total</span>
                        </div>
                        
                        <div class="table-responsive">
                            <table class="table leader-table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th scope="col" class="text-center">Rank</th>
                                        <th scope="col">{{ $category }}</th>
                                        <th scope="col" class="text-center">Category</th>
                                        <th scope="col" class="text-center">Points Earned</th>
                                        <th scope="col" class="text-center">Performance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($complete_ranking as $performer)
                                        @php
                                            $name = $performer->employee_name ?? $performer->department_name ?? 'N/A';
                                            $image = $performer->image ?? '/assets/img/placeholder-img-2.png';
                                            $maxPoints = $data->max('earned_points');
                                            $performancePercentage = $maxPoints > 0 ? round(($performer->earned_points / $maxPoints) * 100) : 0;
                                        @endphp
                                        
                                        <tr class="ranking-row" data-rank="{{ $performer->rank }}">
                                            <td class="align-middle text-center">
                                                <div class="table-circle-no">{{ $performer->rank }}</div>
                                            </td>
                                            <td class="align-middle">
                                                <div class="d-flex align-items-center">
                                                    <img src="{{ $image }}" 
                                                         alt="{{ $name }}" 
                                                         class="rounded-circle me-3" 
                                                         style="width: 40px; height: 40px; object-fit: cover;">
                                                    <div>
                                                        <div class="fw-semibold">{{ $name }}</div>
                                                        @if(isset($performer->department_name))
                                                            <small class="text-muted">{{ $performer->department_name }}</small>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="align-middle text-center">
                                                <span class="badge bg-secondary">{{ $performer->category ?? 'N/A' }}</span>
                                            </td>
                                            <td class="align-middle text-center">
                                                <strong class="text-primary fs-5">{{ $performer->earned_points ?? 'N/A' }} pts</strong>
                                            </td>
                                            <td class="align-middle">
                                                <div class="d-flex align-items-center">
                                                    <div class="progress flex-grow-1 me-2" style="height: 8px;">
                                                        <div class="progress-bar bg-gradient" 
                                                             style="width: {{ $performancePercentage }}%"
                                                             role="progressbar" 
                                                             aria-valuenow="{{ $performancePercentage }}" 
                                                             aria-valuemin="0" 
                                                             aria-valuemax="100">
                                                        </div>
                                                    </div>
                                                    <small class="text-muted">{{ $performancePercentage }}%</small>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        
        <!-- Performance Summary -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="performance-summary-card">
                    <div class="row text-center">
                        <div class="col-md-3">
                            <div class="summary-item">
                                <h6 class="text-muted">Total Participants</h6>
                                <h4 class="text-primary">{{ $data->count() }}</h4>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="summary-item">
                                <h6 class="text-muted">Highest Score</h6>
                                <h4 class="text-success">{{ $data->max('earned_points') ?? 0 }} pts</h4>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="summary-item">
                                <h6 class="text-muted">Average Score</h6>
                                <h4 class="text-info">{{ round($data->avg('earned_points') ?? 0) }} pts</h4>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="summary-item">
                                <h6 class="text-muted">Total Points</h6>
                                <h4 class="text-warning">{{ $data->sum('earned_points') ?? 0 }} pts</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    @else
        <!-- No Data State -->
        <div class="no-data-state">
            <div class="text-center py-5">
                <i class="fas fa-chart-line fa-4x text-muted mb-4"></i>
                <h4 class="text-muted">No Data Available</h4>
                <p class="text-muted">No leaderboard data found for the selected filters.</p>
                <button class="btn btn-outline-primary" onclick="location.reload()">
                    <i class="fas fa-refresh me-2"></i>
                    Refresh Data
                </button>
            </div>
        </div>
    @endif
</div>

<style>
.enhanced-leaderboard-container {
    animation: fadeInUp 0.5s ease-out;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.top-performers-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 15px;
    padding: 30px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    margin-bottom: 20px;
}

.complete-ranking-card {
    background: white;
    border-radius: 15px;
    padding: 25px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    border: 1px solid #e9ecef;
}

.performance-summary-card {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 15px;
    padding: 25px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.leader-box-left, .leader-box-middle, .leader-box-right {
    transition: all 0.3s ease;
    cursor: pointer;
    margin: 0 10px;
}

.leader-box-left:hover, .leader-box-middle:hover, .leader-box-right:hover {
    transform: translateY(-8px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.2);
}

.rank-badge {
    background: rgba(255,255,255,0.2);
    color: white;
    border-radius: 50%;
    width: 35px;
    height: 35px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 16px;
    margin: 0 auto;
    margin-top: 15px;
    backdrop-filter: blur(10px);
}

.rank-1 {
    background: linear-gradient(45deg, #ffd700, #ffed4e);
    color: #333;
    box-shadow: 0 6px 20px rgba(255, 215, 0, 0.5);
    transform: scale(1.1);
}

.rank-2 {
    background: linear-gradient(45deg, #c0c0c0, #e8e8e8);
    color: #333;
    box-shadow: 0 6px 20px rgba(192, 192, 192, 0.5);
}

.rank-3 {
    background: linear-gradient(45deg, #cd7f32, #daa520);
    color: white;
    box-shadow: 0 6px 20px rgba(205, 127, 50, 0.5);
}

.ranking-row {
    transition: all 0.3s ease;
    border-radius: 8px;
}

.ranking-row:hover {
    background-color: #f8f9fa;
    transform: translateX(8px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.table-circle-no {
    background: linear-gradient(45deg, #007bff, #0056b3);
    color: white;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    margin: 0 auto;
    box-shadow: 0 4px 15px rgba(0,123,255,0.3);
}

.progress {
    background-color: #e9ecef;
    border-radius: 10px;
    overflow: hidden;
}

.progress-bar {
    background: linear-gradient(45deg, #28a745, #20c997);
    border-radius: 10px;
    transition: width 0.8s ease;
}

.summary-item {
    padding: 15px;
    border-radius: 10px;
    background: white;
    margin: 5px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.summary-item:hover {
    transform: translateY(-5px);
}

.no-data-state {
    background: white;
    border-radius: 15px;
    padding: 50px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    border: 2px dashed #dee2e6;
}

/* Prize Styling */
.prize-info {
    background: rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    padding: 8px;
    margin-top: 8px;
    backdrop-filter: blur(10px);
}

.prize-badge {
    color: #ffd700;
    font-size: 0.9em;
    margin-bottom: 4px;
}

.prize-amount {
    color: #4ade80;
    font-weight: bold;
    font-size: 1.1em;
    margin-bottom: 4px;
}

.prize-description {
    color: rgba(255, 255, 255, 0.8);
    font-size: 0.8em;
    line-height: 1.2;
}

/* Responsive Design */
@media (max-width: 768px) {
    .top-performers-card {
        padding: 20px;
    }
    
    .leader-box-left, .leader-box-middle, .leader-box-right {
        margin-bottom: 20px;
    }
    
    .complete-ranking-card {
        padding: 15px;
    }
    
    .table-responsive {
        font-size: 14px;
    }
    
    .summary-item {
        margin-bottom: 15px;
    }
    
    .prize-info {
        padding: 6px;
        margin-top: 6px;
    }
    
    .prize-badge {
        font-size: 0.8em;
    }
    
    .prize-amount {
        font-size: 1em;
    }
    
    .prize-description {
        font-size: 0.75em;
    }
}

@media (max-width: 576px) {
    .d-flex.align-items-end.justify-content-center.pt-6 {
        flex-direction: column;
        align-items: center;
    }
    
    .leader-box-left, .leader-box-middle, .leader-box-right {
        margin: 10px 0;
    }
}
</style>
