
@if($employees->isEmpty())
    <h4>No Employees Record to Show</h4>
@else
    <div class="col-lg-4">
        <div class="border rounded-3 p-3">
            <div class="text-center">
                <h4>Top 3 Employees</h4>
                <p class="p-small">This Rank is not confirm it changes accordingly <br>with respect
                    to points.</p>
            </div>
            <div class="d-flex align-items-end pt-6">
                <!-- for 2nd Position -->
                @php
                    $emp = $employees->firstWhere('rank', '2');
                @endphp
                <div class="leader-box-left position-relative leaderboard-item">
                    <div class="position-absolute text-center">
                        <div class="img-circle-area">
                            <img src="{{asset('assets/img/placeholder-img-2.png' )}}" alt="" style="height: 100%" class="rounded-circle img-fluid">
                        </div>
                        <span>2</span>
                    </div>
                    <div class="text-center employee-info">
                        <h6>{{$emp->category ?? 'N/A'}}</h6>
                        <div class="count">{{$emp->earned_points ?? 'N/A'}} pts</div>
                        <div class="u-name">{{$emp->employee ?? 'N/A'}}</div>
                    </div>
                </div>
                <!-- for 1st Position -->
                @php
                    $emp = $employees->firstWhere('rank', '1');
                @endphp
                <div class="leader-box-middle position-relative leaderboard-item">
                    <div class="position-absolute text-center">
                        <img src="{{asset('assets')}}/img/crown.png" alt="" class="img-fluid mb-1">
                        <div class="img-circle-area">
                            <img src="{{asset('assets/img/placeholder-img-2.png')}}" alt="" style="height: 100%" class="rounded-circle img-fluid">
                        </div>
                        <span>1</span>
                    </div>
                    <div class="text-center employee-info">
                        <h6>{{$emp->category ?? 'N/A'}}</h6>
                        <div class="count my-2">{{$emp->earned_points ?? 'N/A'}} pts</div>
                        <div class="u-name">{{$emp->employee ?? 'N/A'}}</div>
                    </div>
                </div>
                <!-- for 3rd Position -->
                @php
                    $emp = $employees->firstWhere('rank', '3');
                @endphp
                <div class="leader-box-right position-relative leaderboard-item">
                    <div class="position-absolute text-center">
                        <div class="img-circle-area">
                            <img src="{{asset('assets/img/placeholder-img-2.png')}}" alt="" style="height: 100%" class="rounded-circle img-fluid">
                        </div>
                        <span>3</span>
                    </div>
                    <div class="text-center employee-info">
                        <h6>{{$emp->category ?? 'N/A'}}</h6>
                        <div class="count">{{$emp->earned_points ?? 'N/A'}} pts</div>
                        <div class="u-name">{{$emp->employee ?? 'N/A'}}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="row">
            <div class="col-12">
                <div class="border p-3 rounded-3">
                    <div class="table-responsive">
                        <table class="table leader-table">
                            <thead>
                            <tr>
                                <th scope="col">Rank</th>
                                <th scope="col">Employee</th>
                                <th scope="col">Category</th>
                                <th scope="col">Points Earn</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($employees as $employee)
                                <tr>
                                    <td class="align-middle">
                                        <div class="table-circle-no">{{$employee->rank}}</div>
                                    </td>
                                    <td class="align-middle">{{$employee->employee}}</td>
                                    <td class="align-middle">{{$employee->category}}</td>
                                    <td class="align-middle">{{$employee->earned_points}} pts</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
