<!-- Emoji Assignment Section -->
<div class="card mb-3">
    <div class="card-header">
        <h6 class="mb-0">
            <i class="fas fa-smile me-2"></i>Emoji & GIF Assignment
        </h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <label for="emojiSelect" class="form-label">Select Emoji/GIF</label>
                <select class="form-select" id="emojiSelect" name="emoji_id">
                    <option value="">Choose an emoji or GIF</option>
                    @if(isset($availableEmojis) && $availableEmojis->count() > 0)
                        @foreach($availableEmojis as $emoji)
                            <option value="{{ $emoji->id }}" data-type="{{ $emoji->type }}" data-content="{{ $emoji->type === 'emoji' ? $emoji->emoji_text : $emoji->url }}">
                                {{ $emoji->name }} ({{ ucfirst($emoji->type) }})
                            </option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="col-md-6">
                <label for="emojiMessage" class="form-label">Message (Optional)</label>
                <input type="text" class="form-control" id="emojiMessage" name="emoji_message" placeholder="Enter a message with the emoji/GIF">
            </div>
        </div>
        
        <!-- Emoji Preview -->
        <div id="emojiPreview" class="mt-3 text-center" style="display: none;">
            <div class="border rounded p-3 bg-light">
                <div id="previewContent" style="font-size: 2rem; min-height: 60px; display: flex; align-items: center; justify-content: center;"></div>
                <small class="text-muted" id="previewName"></small>
            </div>
        </div>
        
        <!-- Assignment History -->
        @if(isset($userEmojiAssignments) && $userEmojiAssignments->count() > 0)
            <div class="mt-3">
                <h6>Previous Assignments:</h6>
                <div class="row">
                    @foreach($userEmojiAssignments as $assignment)
                        <div class="col-md-4 mb-2">
                            <div class="border rounded p-2 bg-light">
                                <div class="text-center">
                                    @if($assignment->emoji->type === 'emoji')
                                        <span style="font-size: 1.5rem;">{{ $assignment->emoji->emoji_text }}</span>
                                    @else
                                        <img src="{{ $assignment->emoji->url }}" alt="{{ $assignment->emoji->name }}" style="max-height: 40px;">
                                    @endif
                                </div>
                                <small class="d-block text-center">{{ $assignment->emoji->name }}</small>
                                @if($assignment->message)
                                    <small class="d-block text-center text-muted">"{{ $assignment->message }}"</small>
                                @endif
                                <small class="d-block text-center text-muted">
                                    by {{ $assignment->assignedBy->name ?? 'Unknown' }}
                                </small>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>

<script>
$(document).ready(function() {
    // Emoji preview functionality
    $('#emojiSelect').on('change', function() {
        const selectedOption = $(this).find('option:selected');
        const type = selectedOption.data('type');
        const content = selectedOption.data('content');
        const name = selectedOption.text();
        
        if (type && content) {
            const previewContent = $('#previewContent');
            const previewName = $('#previewName');
            
            if (type === 'emoji') {
                previewContent.html(`<span style="font-size: 2rem;">${content}</span>`);
            } else {
                previewContent.html(`<img src="${content}" alt="${name}" style="max-height: 60px;">`);
            }
            
            previewName.text(name);
            $('#emojiPreview').show();
        } else {
            $('#emojiPreview').hide();
        }
    });
});
</script>
