@if($categories->isEmpty())
    <h4>No Categories Record to Show</h4>
@else
    <div class="col-lg-4">
        <div class="border rounded-3 p-3">
            <div class="text-center">
                <h4>Top 3 Categories</h4>
                <p class="p-small">This Rank is not confirm it changes accordingly <br>with respect
                    to points.</p>
            </div>
            <div class="d-flex align-items-end pt-6">
                <!-- for 2nd Position -->
                @php
                    $dep = $categories->firstWhere('rank', '2');
                @endphp
                <div class="leader-box-left position-relative leaderboard-item">
                    <div class="position-absolute text-center">
                        <div class="img-circle-area">
                            <img src="{{asset('assets/img/placeholder-img-2.png')}}" alt="" style="height: 100%" class="rounded-circle img-fluid">
                        </div>
                        <span>2</span>
                    </div>
                    <div class="text-center category-info">
                        <h6>{{$dep->category ?? 'N/A'}}</h6>
                        <div class="count">{{$dep->earned_points ?? 'N/A'}} pts</div>
                        <div class="u-name">{{$dep->name ?? 'N/A'}}</div>
                    </div>
                </div>

                <!-- for 1st Position -->
                @php
                    $dep = $categories->firstWhere('rank', '1');
                @endphp
                <div class="leader-box-middle position-relative leaderboard-item">
                    <div class="position-absolute text-center">
                        <img src="{{asset('assets')}}/img/crown.png" alt="" class="img-fluid mb-1">
                        <div class="img-circle-area">
                            <img src="{{asset('assets/img/placeholder-img-2.png')}}" alt="" style="height: 100%" class="rounded-circle img-fluid">
                        </div>
                        <span>1</span>
                    </div>
                    <div class="text-center category-info">
                        <h6>{{$dep->category ?? 'N/A'}}</h6>
                        <div class="count">{{$dep->earned_points ?? 'N/A'}} pts</div>
                        <div class="u-name">{{$dep->name ?? 'N/A'}}</div>
                    </div>
                </div>

                <!-- for 3rd Position -->
                @php
                    $dep = $categories->firstWhere('rank', '3');
                @endphp
                <div class="leader-box-right position-relative leaderboard-item">
                    <div class="position-absolute text-center">
                        <div class="img-circle-area">
                            <img src="{{asset('assets/img/placeholder-img-2.png')}}" alt="" style="height: 100%" class="rounded-circle img-fluid">
                        </div>
                        <span>3</span>
                    </div>
                    <div class="text-center category-info">
                        <h6>{{$dep->category ?? 'N/A'}}</h6>
                        <div class="count">{{$dep->earned_points ?? 'N/A'}} pts</div>
                        <div class="u-name">{{$dep->name ?? 'N/A'}}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="row">
            <div class="col-12">
                <div class="border p-3 rounded-3">
                    <div class="table-responsive">
                        <table class="table leader-table">
                            <thead>
                            <tr>
                                <th scope="col">Rank</th>
                                <th scope="col">Category</th>
                                <th scope="col">Department</th>
                                <th scope="col">Points Earn</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($categories as $dep)
                                <tr>
                                    <td class="align-middle">
                                        <div class="table-circle-no">{{$dep->rank}}</div>
                                    </td>
                                    <td class="align-middle">{{$dep->category}}</td>
                                    <td class="align-middle">{{$dep->name}}</td>
                                    <td class="align-middle">{{$dep->earned_points}} pts</td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
