@extends('highSuperAdmin.layout')
@section('title',"Videos")
@section('page-name',"Videos")
@section('page-detail',"Manage Videos")
@section('pagelink', 'youtubevideos')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <form class="serch">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i>
                                    </span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search videos"
                                           aria-label="serch" aria-describedby="basic-addon1">
                                </div>
                            </form>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a href="#" class="btn btn-primary px-3 me-2" data-bs-toggle="modal"
                                   data-bs-target="#videoModal"
                                   data-bs-whatever="@getbootstrap"><i class="fas fa-plus-circle text-white me-3"></i> Add New Video</a>
                            </div>
                        </div>
                    </div>
                    
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if($videos->isEmpty())
                        <h4>No Videos Added Yet!</h4>
                    @else
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="entryTable" class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">Video</th>
                                            <th scope="col">Channel</th>
                                            <!-- <th scope="col">Duration</th> -->
                                            <!-- <th scope="col">Added By</th> -->
                                            <th scope="col">Date Added</th>
                                            <!-- <th scope="col">Status</th> -->
                                            <th scope="col">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($videos as $video)
                                            <tr>
                                                <th class="align-middle">
                                                    <div class="d-flex align-items-center">
                                                        <div>
                                                            <img src="{{ $video->thumbnail_url }}" 
                                                                 alt="Thumbnail"
                                                                 style="height: 60px; width: 80px; object-fit: cover;"
                                                                 class="img-fluid rounded">
                                                        </div>
                                                        <div class="ms-2">
                                                            <h5 class="mb-0">{{ Str::limit($video->title, 50) }}</h5>
                                                            <small class="text-muted">{{ Str::limit($video->description, 60) }}</small>
                                                        </div>
                                                    </div>
                                                </th>
                                                <td class="align-middle">{{ $video->channel_name }}</td>
                                                <!-- <td class="align-middle">{{ $video->formatted_duration ?? $video->duration }}</td> -->
                                                <!-- <td class="align-middle">{{ $video->addedBy->name ?? 'N/A' }}</td> -->
                                                <td class="align-middle">{{ $video->created_at->format('m-d-y') }}</td>
                                                <!-- <td class="align-middle">
                                                    @if($video->is_active)
                                                        <a href="#" class="btn btn-active">Active</a>
                                                    @else
                                                        <a href="#" class="btn btn-inactive">Inactive</a>
                                                    @endif
                                                </td> -->
                                                <td class="align-middle">
                                                    <a href="{{ $video->youtube_url }}" target="_blank" title="View Video">
                                                        <i class="fas fa-eye px-1"></i>
                                                    </a>
                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#videoModal"
                                                       data-bs-whatever="@getbootstrap"
                                                       onclick="populateVideoForm({{ $video->toJson() }});" title="Edit Video">
                                                        <i class="fas fa-pen px-1"></i>
                                                    </a>
                                                    <a href="#" onclick="deleteVideo({{ $video->id }}, this); return false;" title="Delete Video">
                                                        <i class="fas fa-trash text-danger px-1"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                {{ $videos->links() }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- VIDEO MODAL -->
    <div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4 id="modalTitle">Add New Video</h4>
                    <hr>
                    <form id="videoForm">
                        @csrf
                        <input type="hidden" id="videoId" name="video_id">
                        <input type="hidden" id="method" name="_method" value="POST">
                        
                        <div class="row">
                            <!-- YouTube URL -->
                            <div class="col-12">
                                <div class="mb-md-4 mb-3">
                                    <label for="youtube_url" class="form-label">YouTube URL <span class="text-danger">*</span></label>
                                    <input type="url" name="youtube_url" class="form-control shadow-none"
                                           id="youtube_url" placeholder="https://www.youtube.com/watch?v=..." required>
                                    <small class="form-text text-muted">Enter a valid YouTube video URL</small>
                                </div>
                            </div>

                            <!-- Title (for edit mode) -->
                            <div class="col-12 d-none" id="titleField">
                                <div class="mb-md-4 mb-3">
                                    <label for="title" class="form-label">Title</label>
                                    <input type="text" name="title" class="form-control shadow-none"
                                           id="title" placeholder="Video title...">
                                </div>
                            </div>

                            <!-- Description (for edit mode) -->
                            <div class="col-12 d-none" id="descriptionField">
                                <div class="mb-md-4 mb-3">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" class="form-control shadow-none"
                                              id="description" rows="3" placeholder="Video description..."></textarea>
                                </div>
                            </div>

                            <!-- Status -->
                            <div class="col-12" id="statusField">
                                <div class="mb-md-4 mb-3">
                                    <label for="is_active" class="form-label">Status</label>
                                    <select name="is_active" id="is_active" class="form-select shadow-none">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel
                            </button>
                            <button type="submit" id="sub-btn" class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">
                                Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- MODAL END -->

@endsection

@section('custom-scripts')
<script>
    // Reset form when modal is closed
    $('#videoModal').on('hidden.bs.modal', function () {
        $('#videoForm')[0].reset();
        $('#videoId').val('');
        $('#method').val('POST');
        $('#modalTitle').text('Add New Video');
        $('#youtube_url').prop('readonly', false);
        $('#titleField, #descriptionField').addClass('d-none');
        $('#statusField').removeClass('d-none');
    });

    // Populate form for editing
    function populateVideoForm(video) {
        $('#modalTitle').text('Edit Video');
        $('#videoId').val(video.id);
        $('#method').val('PUT');
        $('#youtube_url').val(video.youtube_url).prop('readonly', true);
        $('#title').val(video.title);
        $('#description').val(video.description);
        $('#is_active').val(video.is_active ? 1 : 0);
        
        // Show edit-only fields
        $('#titleField, #descriptionField').removeClass('d-none');
    }

    // Submit form via AJAX
    $('#videoForm').on('submit', function(e) {
        e.preventDefault();
        
        var formData = new FormData(this);
        var videoId = $('#videoId').val();
        var url = videoId ? '{{ route("youtubevideos.update", ":id") }}'.replace(':id', videoId) : '{{ route("youtubevideos.store") }}';
        
        $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
            .prop('disabled', true);
        
        $.ajax({
            type: 'POST',
            url: url,
            data: formData,
            contentType: false,
            processData: false,
            success: function(res) {
                if (res.success || !res.Error) {
                    Swal.fire({
                        title: "Success!",
                        text: res.message || res.Message || 'Operation completed successfully!',
                        icon: 'success',
                        confirmButtonText: 'OK'
                    });
                    $('#videoModal').modal('hide');
                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                } else {
                    Swal.fire({
                        title: "Error!",
                        text: res.message || res.Message || 'An error occurred',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                }
                $('#sub-btn').html('Submit').prop('disabled', false);
            },
            error: function(xhr) {
                var errorMessage = 'An error occurred';
                if (xhr.responseJSON && xhr.responseJSON.errors) {
                    errorMessage = Object.values(xhr.responseJSON.errors)[0][0];
                } else if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                
                Swal.fire({
                    title: "Error!",
                    text: errorMessage,
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
                $('#sub-btn').html('Submit').prop('disabled', false);
            }
        });
    });

    // Delete video
    function deleteVideo(id, element) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: '{{ route("youtubevideos.destroy", ":id") }}'.replace(':id', id),
                    data: {
                        _token: '{{ csrf_token() }}',
                        _method: 'DELETE'
                    },
                    success: function(res) {
                        element.closest('tr').remove();
                        Swal.fire({
                            title: "Deleted!",
                            text: res.message || 'Video has been deleted.',
                            icon: 'success',
                            confirmButtonText: 'OK'
                        });
                        
                        // Check if table is empty and show message
                        if ($('#entryTable tbody tr').length === 0) {
                            location.reload();
                        }
                    },
                    error: function(xhr) {
                        Swal.fire({
                            title: "Error!",
                            text: 'Failed to delete the video',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                });
            }
        });
    }

    // Search functionality
    $('#searchInput').on('keyup', function() {
        var value = $(this).val().toLowerCase();
        $('#entryTable tbody tr').filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });
</script>

<style>
    .btn-active {
        background-color: #28a745;
        color: white;
        border: none;
        padding: 0.25rem 0.75rem;
        border-radius: 0.25rem;
        font-size: 0.875rem;
    }
    
    .btn-inactive {
        background-color: #dc3545;
        color: white;
        border: none;
        padding: 0.25rem 0.75rem;
        border-radius: 0.25rem;
        font-size: 0.875rem;
    }
    
    .btn-primary-white {
        background-color: white;
        color: #007bff;
        border: 1px solid #007bff;
    }
    
    .btn-primary-white:hover {
        background-color: #f8f9fa;
        color: #0056b3;
        border-color: #0056b3;
    }
    
    .border-radious-20 {
        border-radius: 20px;
    }
    
    .content-are-dashboard .card {
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    
    .table th {
        font-weight: 600;
        color: #495057;
    }
    
    .fas {
        color: #6c757d;
        cursor: pointer;
        transition: color 0.3s;
    }
    
    .fas:hover {
        color: #343a40;
    }
    
    .fas.text-danger:hover {
        color: #bd2130 !important;
    }
    
    .search-icon {
        color: #6c757d;
    }
</style>
@endsection