@extends('highSuperAdmin.layout')
@section('title',"Dashboard")
@section('page-name',"Dashboard")
@section('page-detail',"Welcome to SuperAdmin Panel")
@section('body')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Add New YouTube Video</h3>
                </div>
                
                <form action="{{ route('youtubevideos.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        @if($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="youtube_url">YouTube URL <span class="text-danger">*</span></label>
                            <input type="url"
                                   class="form-control @error('youtube_url') is-invalid @enderror"
                                   id="youtube_url"
                                   name="youtube_url"
                                   value="{{ old('youtube_url') }}"
                                   placeholder="https://www.youtube.com/watch?v=..."
                                   required>
                            <small class="form-text text-muted">
                                Enter a valid YouTube video URL
                            </small>
                            @error('youtube_url')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Add Video</button>
                        <a href="{{ route('youtubevideos.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection