@extends('highSuperAdmin.layout')
@section('title',"All Companies")
@section('page-name',"Companies Management")
@section('page-detail',"All Companies Information")
@section('body')
    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <div class="serch">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i></span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search Companies"
                                           aria-label="serch" aria-describedby="basic-addon1">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a href="#" class="btn btn-primary w-auto-fix" data-bs-toggle="modal"
                                   data-bs-target="#addTenantModal">
                                    <i class="fas fa-plus-circle me-3"></i>Add Companies
                                </a>
                            </div>
                        </div>
                    </div>

                    <hr>

                    @if($tenants->isEmpty())
                        <h4> No Companies Yet! </h4>
                    @else
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="entryTable" class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">Company Name</th>
                                            <th scope="col">Domain</th>
                                            <th scope="col">Plan</th>
                                            <th scope="col">Admins</th>
                                            <th scope="col">Employees</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Created Date</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($tenants as $tenant)
                                            <tr id="tenant-row-{{ $tenant->id }}">
                                                <td class="align-middle">{{ $tenant->name }}</td>
                                                <td class="align-middle">
                                                    <div class="d-flex align-items-center">
                                                        <span id="tenant-domain-text-{{ $tenant->id }}">
                                                            https://{{ $tenant->domain }}.platform.carismacar.org
                                                        </span>
                                                        <button class="btn btn-sm btn-light ms-2"
                                                            onclick="copyToClipboard('tenant-domain-text-{{ $tenant->id }}')">
                                                            <i class="fas fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                                <td class="align-middle">{{ ucfirst($tenant->plan ?? 'Basic') }}</td>
                                                <td class="align-middle">{{ $tenant->admins_count ?? 0 }}</td>
                                                <td class="align-middle">{{ $tenant->employees_count ?? 0 }}</td>
                                                <td class="align-middle">
                                                    <span class="badge {{ $tenant->active ? 'bg-success' : 'bg-danger' }}" id="status-badge-{{ $tenant->id }}">
                                                        {{ $tenant->active ? 'Active' : 'Inactive' }}
                                                    </span>
                                                </td>
                                                <td class="align-middle">{{ \Carbon\Carbon::parse($tenant->created_at)->format('m-d-y') }}</td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        <a href="#" onclick="viewTenantDetails({{$tenant->id}})" 
                                                           class="btn btn-primary btn-sm" data-bs-toggle="modal"
                                                           data-bs-target="#viewTenantModal">
                                                            <i class="fas fa-eye"></i> View
                                                        </a>
                                                        
                                                        <a href="#" onclick="editTenant({{$tenant->id}})" 
                                                           class="btn btn-warning btn-sm" data-bs-toggle="modal"
                                                           data-bs-target="#editTenantModal">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </a>
                                                        
                                                        <a href="#" onclick="toggleTenantStatus({{$tenant->id}}, $(this))" 
                                                           class="btn {{ $tenant->active ? 'btn-danger' : 'btn-success' }} btn-sm"
                                                           id="toggle-btn-{{ $tenant->id }}">
                                                            <i class="fas fa-power-off"></i> {{ $tenant->active ? 'Deactivate' : 'Activate' }}
                                                        </a>

                                                        <a href="#" onclick="deleteTenant({{$tenant->id}})" 
                                                           class="btn btn-dark btn-sm">
                                                            <i class="fas fa-trash"></i> Delete
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                
                                <!-- Pagination -->
                                <div class="d-flex justify-content-center mt-3">
                                    <nav aria-label="Page navigation">
                                        <ul class="pagination">
                                            @if ($tenants->onFirstPage())
                                                <li class="page-item disabled">
                                                    <span class="page-link">Previous</span>
                                                </li>
                                            @else
                                                <li class="page-item">
                                                    <a class="page-link" href="{{ $tenants->previousPageUrl() }}" aria-label="Previous">
                                                        <span aria-hidden="true">&laquo;</span>
                                                    </a>
                                                </li>
                                            @endif

                                            @foreach ($tenants->links()->elements[0] as $page => $url)
                                                <li class="page-item {{ $page == $tenants->currentPage() ? 'active' : '' }}">
                                                    <a class="page-link" href="{{ $url }}">{{ $page }}</a>
                                                </li>
                                            @endforeach

                                            @if ($tenants->hasMorePages())
                                                <li class="page-item">
                                                    <a class="page-link" href="{{ $tenants->nextPageUrl() }}" aria-label="Next">
                                                        <span aria-hidden="true">&raquo;</span>
                                                    </a>
                                                </li>
                                            @else
                                                <li class="page-item disabled">
                                                    <span class="page-link">Next</span>
                                                </li>
                                            @endif
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>

    <!-- View Tenant Details Modal -->
    <div class="modal fade" id="viewTenantModal" tabindex="-1" aria-labelledby="viewTenantModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content border-radious-20">
                <div class="modal-header">
                    <h4 class="modal-title" id="viewTenantModalLabel">Company Details</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                    <div id="tenantDetailsContent">
                        <div class="text-center">
                            <div class="spinner-border" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Tenant Modal -->
    <div class="modal fade" id="addTenantModal" tabindex="-1" aria-labelledby="addTenantModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Add New Company</h4>
                    <hr>
                    <form id="addTenantForm">
                        @csrf
                        <div class="row">
                            <!-- Tenant Name -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Company Name</label>
                                    <input name="name" type="text" class="form-control shadow-none" 
                                           placeholder="Company Name" required>
                                </div>
                            </div>

                            <!-- Domain -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Domain (subdomain only)</label>
                                    <div class="input-group">
                                        <input name="domain" type="text" class="form-control shadow-none" 
                                               placeholder="companyname" required>
                                        <span class="input-group-text">.platform.carismacar.org</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Phone -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Phone Number</label>
                                    <input name="phone" type="text" class="form-control shadow-none" 
                                           placeholder="Phone Number">
                                </div>
                            </div>

                            <!-- Plan -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Plan</label>
                                    <select name="plan" class="form-control" aria-label="Plan">
                                        <option value="basic">Basic</option>
                                        <option value="standard">Standard</option>
                                        <option value="premium">Premium</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Active Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Status</label>
                                    <select name="active" class="form-control" aria-label="Status">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Address -->
                            <div class="col-12">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Address</label>
                                    <textarea name="address" rows="3" class="form-control shadow-none"
                                              placeholder="Address"></textarea>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Cancel
                                </button>
                                <button type="submit" id="add-tenant-btn"
                                        class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Add Company
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Tenant Modal -->
    <div class="modal fade" id="editTenantModal" tabindex="-1" aria-labelledby="editTenantModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Edit Company</h4>
                    <hr>
                    <form id="editTenantForm">
                        @csrf
                        @method('PUT')
                        <input type="hidden" id="edit_tenant_id" name="tenant_id">
                        
                        <div class="row">
                            <!-- Tenant Name -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Company Name</label>
                                    <input name="name" id="edit_tenant_name" type="text" class="form-control shadow-none" 
                                           placeholder="Company Name" required>
                                </div>
                            </div>

                            <!-- Domain -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Domain (subdomain only)</label>
                                    <div class="input-group">
                                        <input name="domain" id="edit_tenant_domain" type="text" class="form-control shadow-none" 
                                               placeholder="companyname" required>
                                        <span class="input-group-text">.platform.carismacar.org</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Phone -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Phone Number</label>
                                    <input name="phone" id="edit_tenant_phone" type="text" class="form-control shadow-none" 
                                           placeholder="Phone Number">
                                </div>
                            </div>

                            <!-- Plan -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Plan</label>
                                    <select name="plan" id="edit_tenant_plan" class="form-control" aria-label="Plan">
                                        <option value="basic">Basic</option>
                                        <option value="standard">Standard</option>
                                        <option value="premium">Premium</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Active Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Status</label>
                                    <select name="active" id="edit_tenant_active" class="form-control" aria-label="Status">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Address -->
                            <div class="col-12">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Address</label>
                                    <textarea name="address" id="edit_tenant_address" rows="3" class="form-control shadow-none"
                                              placeholder="Address"></textarea>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Cancel
                                </button>
                                <button type="submit" id="update-tenant-btn"
                                        class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Update Company
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('custom-scripts')
    <script>
        // Search functionality
        $('#searchInput').on('keyup', function() {
            var value = $(this).val().toLowerCase();
            $("#entryTable tbody tr").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });

        // View Tenant Details
        function viewTenantDetails(tenantId) {
            $('#tenantDetailsContent').html(`
                <div class="text-center">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            `);

            $.ajax({
                type: 'GET',
                url: `/highsuperadmin/tenants/${tenantId}`,
                dataType: 'json',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                },
                success: function(tenant) {
                    let adminsList = '';
                    if (tenant.admins && tenant.admins.length > 0) {
                        adminsList = `
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h5>Company Admins (${tenant.admins.length})</h5>
                                    <hr>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Email</th>
                                                    <th>Created Date</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;
                        
                        tenant.admins.forEach(function(admin) {
                            adminsList += `
                                <tr>
                                    <td>${admin.email}</td>
                                    <td>${new Date(admin.created_at).toLocaleDateString()}</td>
                                </tr>`;
                        });
                        
                        adminsList += `
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>`;
                    }

                    let departmentsList = '';
                    if (tenant.departments && tenant.departments.length > 0) {
                        departmentsList = `
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h5>Departments (${tenant.departments.length})</h5>
                                    <hr>
                                    <ul class="list-group">`;
                        
                        tenant.departments.forEach(function(dept) {
                            departmentsList += `<li class="list-group-item">${dept.name || 'Unnamed Department'}</li>`;
                        });
                        
                        departmentsList += `
                                    </ul>
                                </div>
                            </div>`;
                    }

                    let detailsHtml = `
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Basic Information</h5>
                                <hr>
                                <p><strong>Name:</strong> ${tenant.name}</p>
                                <p><strong>Domain:</strong> 
                                    <span id="view-modal-domain-text">${tenant.domain}.platform.carismacar.org</span>
                                    <button class="btn btn-sm btn-light ms-2" onclick="copyToClipboard('view-modal-domain-text')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </p>
                                <p><strong>Plan:</strong> ${tenant.plan || 'Basic'}</p>
                                <p><strong>Phone:</strong> ${tenant.phone || 'N/A'}</p>
                                <p><strong>Address:</strong> ${tenant.address || 'N/A'}</p>
                                <p><strong>Status:</strong> <span class="badge ${tenant.active ? 'bg-success' : 'bg-danger'}">${tenant.active ? 'Active' : 'Inactive'}</span></p>
                                <p><strong>Created:</strong> ${new Date(tenant.created_at).toLocaleDateString()}</p>
                                ${tenant.trial_ends_at ? `<p><strong>Trial Ends:</strong> ${new Date(tenant.trial_ends_at).toLocaleDateString()}</p>` : ''}
                            </div>
                            
                            <div class="col-md-6">
                                <h5>Statistics</h5>
                                <hr>
                                <p><strong>Total Admins:</strong> ${tenant.admins_count || 0}</p>
                                <p><strong>Total Employees:</strong> ${tenant.employees_count || 0}</p>
                                <p><strong>Total Departments:</strong> ${tenant.departments_count || 0}</p>
                                <p><strong>Total Products:</strong> ${tenant.products_count || 0}</p>
                                <p><strong>Total Targets:</strong> ${tenant.targets_count || 0}</p>
                                ${tenant.stripe_customer_id ? `<p><strong>Stripe Customer:</strong> ${tenant.stripe_customer_id}</p>` : ''}
                            </div>
                        </div>
                        
                        ${adminsList}
                        ${departmentsList}
                        
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <button type="button" class="btn ${tenant.active ? 'btn-danger' : 'btn-success'}" 
                                            onclick="toggleTenantStatusFromModal(${tenant.id})">
                                        <i class="fas fa-power-off"></i> ${tenant.active ? 'Deactivate Tenant' : 'Activate Tenant'}
                                    </button>
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    `;
                    
                    $('#tenantDetailsContent').html(detailsHtml);
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                    $('#tenantDetailsContent').html(`
                        <div class="alert alert-danger">
                            <p><strong>Error loading tenant details</strong></p>
                            <p>Status: ${status}</p>
                            <p>Error: ${error}</p>
                        </div>
                    `);
                }
            });
        }

        // Edit Tenant
        function editTenant(tenantId) {
            // First fetch the tenant details
            $.ajax({
                url: `/highsuperadmin/tenants/${tenantId}`,
                type: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                },
                success: function (tenant) {
                    // Populate the edit form
                    $('#edit_tenant_id').val(tenant.id);
                    $('#edit_tenant_name').val(tenant.name);
                    $('#edit_tenant_domain').val(tenant.domain);
                    $('#edit_tenant_phone').val(tenant.phone || '');
                    $('#edit_tenant_plan').val(tenant.plan || 'basic');
                    $('#edit_tenant_active').val(tenant.active ? '1' : '0');
                    $('#edit_tenant_address').val(tenant.address || '');
                },
                error: function (xhr, status, error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Failed to load tenant details for editing.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                }
            });
        }

        // Toggle Tenant Status
        function toggleTenantStatus(tenantId, button) {
            const currentStatus = button.hasClass('btn-danger');
            const action = currentStatus ? 'deactivate' : 'activate';
            
            Swal.fire({
                title: 'Are you sure?',
                text: `Do you want to ${action} this tenant?`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: `Yes, ${action} it!`
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: `/highsuperadmin/tenants/${tenantId}/toggle-status`,
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function(res) {
                            if (res.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Updated!',
                                    text: res.message,
                                    timer: 2000,
                                    showConfirmButton: false
                                });
                                
                                // Update button appearance and status badge
                                const toggleBtn = $(`#toggle-btn-${tenantId}`);
                                const statusBadge = $(`#status-badge-${tenantId}`);
                                
                                if (res.active) {
                                    toggleBtn.removeClass('btn-success').addClass('btn-danger');
                                    toggleBtn.html('<i class="fas fa-power-off"></i> Deactivate');
                                    statusBadge.removeClass('bg-danger').addClass('bg-success').text('Active');
                                } else {
                                    toggleBtn.removeClass('btn-danger').addClass('btn-success');
                                    toggleBtn.html('<i class="fas fa-power-off"></i> Activate');
                                    statusBadge.removeClass('bg-success').addClass('bg-danger').text('Inactive');
                                }
                            }
                        },
                        error: function(e) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: 'Something went wrong. Please try again.',
                                timer: 2000,
                                showConfirmButton: false
                            });
                        }
                    });
                }
            });
        }

        // Delete Tenant
        function deleteTenant(tenantId) {
            Swal.fire({
                title: 'Are you sure?',
                text: "This will permanently delete the tenant and ALL related data (admins, employees, departments, etc.). This action cannot be undone!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete everything!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `/highsuperadmin/tenants/${tenantId}`,
                        type: 'DELETE',
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function (response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted!',
                                    text: response.message,
                                    timer: 3000,
                                    showConfirmButton: false
                                });
                                
                                // Remove the row from table
                                $(`#tenant-row-${tenantId}`).fadeOut(500, function() {
                                    $(this).remove();
                                });
                            }
                        },
                        error: function (xhr, status, error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: 'Failed to delete tenant. Please try again.',
                                timer: 2000,
                                showConfirmButton: false
                            });
                        }
                    });
                }
            });
        }

        // Toggle Tenant Status from Modal
        function toggleTenantStatusFromModal(tenantId) {
            const button = $(`#toggle-btn-${tenantId}`);
            toggleTenantStatus(tenantId, button);
            $('#viewTenantModal').modal('hide');
        }

        // Clear modals on close
        $('#addTenantModal, #editTenantModal').on('hidden.bs.modal', function() {
            $(this).find('form')[0].reset();
        });

        // Add Tenant Form Submission
        $('#addTenantForm').on('submit', function(e) {
            e.preventDefault();
            
            var formData = $(this).serialize();
            $('#add-tenant-btn').prop('disabled', true).text('Adding...');
            
            $.ajax({
                type: 'POST',
                url: '/highsuperadmin/tenants/create',
                data: formData,
                dataType: 'json',
                success: function(res) {
                    if (res.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: res.message,
                            timer: 2000,
                            showConfirmButton: false
                        });
                        $('#addTenantModal').modal('hide');
                        setTimeout(function() {
                            window.location.reload();
                        }, 2000);
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        var errors = xhr.responseJSON.errors;
                        var errorMessage = '';
                        $.each(errors, function(key, value) {
                            errorMessage += value[0] + '<br>';
                        });
                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            html: errorMessage
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Something went wrong. Please try again.'
                        });
                    }
                },
                complete: function () {
                    $('#add-tenant-btn').prop('disabled', false).text('Add Company');
                }
            });
        });

        // Edit Tenant Form Submission
        $('#editTenantForm').on('submit', function(e) {
            e.preventDefault();
            
            var tenantId = $('#edit_tenant_id').val();
            var formData = $(this).serialize();
            $('#update-tenant-btn').prop('disabled', true).text('Updating...');
            
            $.ajax({
                type: 'PUT',
                url: `/highsuperadmin/tenants/${tenantId}/update`,
                data: formData,
                dataType: 'json',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(res) {
                    if (res.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: res.message,
                            timer: 2000,
                            showConfirmButton: false
                        });
                        $('#editTenantModal').modal('hide');
                        setTimeout(function() {
                            window.location.reload();
                        }, 2000);
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        var errors = xhr.responseJSON.errors;
                        var errorMessage = '';
                        $.each(errors, function(key, value) {
                            errorMessage += value[0] + '<br>';
                        });
                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            html: errorMessage
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Something went wrong. Please try again.'
                        });
                    }
                },
                complete: function () {
                    $('#update-tenant-btn').prop('disabled', false).text('Update Company');
                }
            });
        });

        // Copy to clipboard function
        function copyToClipboard(elementId) {
            const textElement = document.getElementById(elementId);
            const text = textElement?.innerText || textElement?.textContent;

            if (text) {
                navigator.clipboard.writeText(text).then(() => {
                    Swal.fire({
                        icon: 'success',
                        title: 'Copied!',
                        text: 'Domain URL copied to clipboard.',
                        timer: 1500,
                        showConfirmButton: false
                    });
                }).catch(err => {
                    console.error('Copy failed', err);
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed!',
                        text: 'Unable to copy text.',
                        timer: 1500,
                        showConfirmButton: false
                    });
                });
            }
        }
    </script>
@endsection