<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>SuperAdmin Login</title>
    <link rel="icon" type="image/x-icon" href="{{ asset('assets') }}/img/favicon.webp">
    <!-- ===========STYLE================ -->
    <link rel="stylesheet" type="text/css" href="{{ asset('assets') }}/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets') }}/css/style.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets') }}/css/responsive.css">
    <!-- ===========font style=========== -->
    <link href="https://fonts.googleapis.com/css2?family=Lexend:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- ===========fontawsom icon=========== -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>

<body>

<style>
    .hand-wave {
        display: inline-block;
        animation: wave 3s ease-in-out infinite;
        transform-origin: 80% 80%;
    }
    .h-vh{
        height: 90vh;
    }

    @keyframes wave {
        0%, 60%, 100% {
            transform: rotate(0deg);
        }
        10%, 30%, 50%, 70% {
            transform: rotate(15deg);
        }
        20%, 40%, 80% {
            transform: rotate(-10deg);
        }
    }
    .img-login-box{
        background-color: #020F20;
        border-radius: 50px;
        height: 90vh;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        overflow: hidden;
    }
    .superadmin-badge {
        position: absolute;
        top: 30px;
        right: 30px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 10px 25px;
        border-radius: 50px;
        font-weight: 600;
        font-size: 14px;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }
    .superadmin-title {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        font-weight: 700;
        font-size: 2.5rem;
        margin-bottom: 10px;
    }
    .btn-superadmin {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        color: white;
        font-weight: 600;
        padding: 12px;
        transition: all 0.3s ease;
    }
    .btn-superadmin:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }
    .form-control:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }
</style>

<div class="container-fluid px-md-5 py-md-4 my-1">
    <div class="row align-items-center">
        <div class="col-lg-7 col-md-6 d-none d-md-block">
            <div class="text-center px-md-4 img-login-box">
                <span class="superadmin-badge">
                    <i class="fas fa-crown me-2"></i>SUPERADMIN ACCESS
                </span>
                <img src="{{ asset('assets') }}/img/crisma_logo_new.png" class="img-fluid px-md-5 w-100">
            </div>
        </div>
        <div class="col-lg-4 col-md-5 mx-auto">
            <div class="h-vh d-flex align-items-center">
                <div class="w-100">
                    <div class="mb-4">
                        <img src="{{ asset('assets') }}/img/logo.png" class="img-fluid">
                    </div>
                    <div class="text-center mb-4">
                        <h2 class="superadmin-title">SuperAdmin Portal</h2>
                        <p class="text-muted">Complete System Control Center</p>
                    </div>
                    <div class="d-flex mb-1">
                        <h3 class="mb-0">Welcome Back</h3>
                        <div class="ms-1">
                            <img src="{{ asset('assets') }}/img/login-hand.png" class="img-fluid mt-minus-1 hand-shake hand-wave">
                        </div>
                    </div>
                    <p class="p-light mb-4">Enter your superadmin credentials</p>
                    
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    <form id="superadmin-login-form" action="{{ route('superadmin.login.submit') }}" method="POST">
                        @csrf
                        <div class="form-floating mb-3">
                            <input type="email" name="email" class="form-control shadow-none @error('email') is-invalid @enderror" 
                                   id="floatingInput" placeholder="name@example.com" value="{{ old('email') }}" required>
                            <label for="floatingInput">Email address</label>
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-floating mb-3 position-relative">
                            <input type="password" name="password" class="form-control shadow-none password-input @error('password') is-invalid @enderror" 
                                   id="floatingPassword" placeholder="Password" required>
                            <label for="floatingPassword">Password</label>
                            <span class="password-toggle-icon position-absolute top-50 end-0 translate-middle-y me-3">
                                <i class="fa fa-eye-slash toggle-password"></i>
                            </span>
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-superadmin shadow-none w-100 mb-3 submitBtn">
                            <i class="fas fa-crown me-2"></i>Login as SuperAdmin
                        </button>
                    </form>
                    
                    <div class="text-center mt-4">
                        <small class="text-muted">
                            <i class="fas fa-shield-alt me-1"></i>
                            Secure SuperAdmin Access Portal
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="{{ asset('assets') }}/js/jquery-3.7.1.js"></script>
<script src="{{ asset('assets') }}/js/bootstrap.bundle.min.js"></script>
<script src="{{ asset('assets') }}/js/main.js"></script>
<script src="{{ asset('assets/js/sweetalert2.js')}}"></script>

<script>
    // Password toggle functionality
    $(document).on('click', '.toggle-password', function() {
        var passwordInput = $(this).closest('.position-relative').find('.password-input');
        var icon = $(this);
        
        if (passwordInput.attr('type') === 'password') {
            passwordInput.attr('type', 'text');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
        } else {
            passwordInput.attr('type', 'password');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
        }
    });

    $('#superadmin-login-form').on("submit", function(e) {
        e.preventDefault();
        var form = $('#superadmin-login-form')[0];
        var formdata = new FormData(form);

        $('.submitBtn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Authenticating...')
            .prop('disabled', true);

        $.ajax({
            type: 'POST',
            url: '{{ route('superadmin.login.submit') }}',
            dataType: 'json',
            data: formdata,
            contentType: false,
            processData: false,
            cache: false,
            mimeType: 'multipart/form-data',

            success: function(res) {
                if (res.success) {
                    // Success notification
                    Swal.fire({
                        title: "Welcome SuperAdmin!",
                        text: "Login successful. Redirecting to dashboard...",
                        icon: "success",
                        timer: 2000,
                        showConfirmButton: false
                    });

                    setTimeout(function() {
                        window.location.href = "{{ route('superadmin.dashboard') }}";
                    }, 2000);
                } else {
                    showErrorMsg(res.message || "Login failed. Please try again.");
                    $('.submitBtn').html('<i class="fas fa-crown me-2"></i>Login as SuperAdmin').prop('disabled', false);
                }
            },

            error: function(e) {
                var errorMsg = "Invalid credentials. Please check your email and password.";
                
                if (e.responseJSON) {
                    if (e.responseJSON.message) {
                        errorMsg = e.responseJSON.message;
                    } else if (e.responseJSON.errors) {
                        var firstError = Object.values(e.responseJSON.errors)[0];
                        errorMsg = Array.isArray(firstError) ? firstError[0] : firstError;
                    }
                }
                
                showErrorMsg(errorMsg);
                $('.submitBtn').html('<i class="fas fa-crown me-2"></i>Login as SuperAdmin').prop('disabled', false);
            }
        });
    });

    function showErrorMsg(msg) {
        Swal.fire({
            title: "Authentication Failed",
            icon: "error",
            text: msg,
            confirmButtonColor: "#667eea"
        });
    }

    // Show session flash messages as SweetAlert
    @if(session('error'))
        showErrorMsg("{{ session('error') }}");
    @endif

    @if(session('success'))
        Swal.fire({
            title: "Success!",
            icon: "success",
            text: "{{ session('success') }}",
            confirmButtonColor: "#667eea"
        });
    @endif
</script>
</body>
</html>