@extends('highSuperAdmin.layout')
@section('title',"Dashboard")
@section('page-name',"Dashboard")
@section('page-detail',"Welcome to SuperAdmin Panel")
@section('body')

    <div class="content-are-dashboard p-3">
        <!-- Statistics Cards Row -->
        <div class="row mb-4">
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 mb-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-2">Total Tenants</h6>
                                <h3 class="mb-0">{{ $data['totalTenants'] }}</h3>
                            </div>
                            <div class="icon-shape bg-primary text-white rounded-circle p-3">
                                <i class="fas fa-building fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 mb-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-2">Active Tenants</h6>
                                <h3 class="mb-0">{{ $data['activeTenants'] }}</h3>
                            </div>
                            <div class="icon-shape bg-success text-white rounded-circle p-3">
                                <i class="fas fa-check-circle fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 mb-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-2">Total Admins</h6>
                                <h3 class="mb-0">{{ $data['totalAdmins'] }}</h3>
                            </div>
                            <div class="icon-shape bg-info text-white rounded-circle p-3">
                                <i class="fas fa-users fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 mb-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-2">Inactive Tenants</h6>
                                <h3 class="mb-0">{{ $data['totalTenants'] - $data['activeTenants'] }}</h3>
                            </div>
                            <div class="icon-shape bg-warning text-white rounded-circle p-3">
                                <i class="fas fa-pause-circle fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Row -->
        <div class="row mb-4">
            <div class="col-lg-8 mb-3">
                <div class="card rounded-3">
                    <div class="card-body">
                        <h5 class="card-title mb-3">Tenant Growth Overview</h5>
                        <canvas id="tenantGrowthChart" height="100"></canvas>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4 mb-3">
                <div class="card rounded-3">
                    <div class="card-body">
                        <h5 class="card-title mb-3">Tenant Plans Distribution</h5>
                        <canvas id="planDistributionChart" height="200"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Tenants Table -->
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="mb-0">Recent Tenants</h5>
                        <a href="{{ route('superadmin.tenants') }}" class="btn btn-primary btn-sm">View All</a>
                    </div>
                    
                    <hr>
                    
                    @if($data['recentTenants']->isEmpty())
                        <p class="text-center">No tenants yet!</p>
                    @else
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th scope="col">Tenant Name</th>
                                        <th scope="col">Domain</th>
                                        <th scope="col">Plan</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Created Date</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($data['recentTenants'] as $tenant)
                                        <tr>
                                            <td class="align-middle">{{ $tenant->name }}</td>
                                            <td class="align-middle">{{ $tenant->domain }}</td>
                                            <td class="align-middle">
                                                <span class="badge bg-secondary">{{ ucfirst($tenant->plan ?? 'Basic') }}</span>
                                            </td>
                                            <td class="align-middle">
                                                @if($tenant->active)
                                                    <span class="badge bg-success">Active</span>
                                                @else
                                                    <span class="badge bg-danger">Inactive</span>
                                                @endif
                                            </td>
                                            <td class="align-middle">{{ \Carbon\Carbon::parse($tenant->created_at)->format('m-d-Y') }}</td>
                                            <td>
                                                <a href="#" onclick="quickViewTenant({{$tenant->id}})" 
                                                   class="btn btn-primary btn-sm" data-bs-toggle="modal"
                                                   data-bs-target="#quickViewModal">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Quick View Modal -->
    <div class="modal fade" id="quickViewModal" tabindex="-1" aria-labelledby="quickViewModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-header">
                    <h5 class="modal-title" id="quickViewModalLabel">Tenant Quick View</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                    <div id="quickViewContent">
                        <div class="text-center">
                            <div class="spinner-border" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('custom-scripts')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Tenant Growth Chart
        const growthCtx = document.getElementById('tenantGrowthChart').getContext('2d');
        const tenantGrowthChart = new Chart(growthCtx, {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                datasets: [{
                    label: 'Total Tenants',
                    data: [12, 19, 23, 25, 32, {{ $data['totalTenants'] }}],
                    borderColor: 'rgb(75, 192, 192)',
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    tension: 0.4
                }, {
                    label: 'Active Tenants',
                    data: [10, 15, 20, 22, 28, {{ $data['activeTenants'] }}],
                    borderColor: 'rgb(54, 162, 235)',
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // Plan Distribution Chart
        const planCtx = document.getElementById('planDistributionChart').getContext('2d');
        const planDistributionChart = new Chart(planCtx, {
            type: 'doughnut',
            data: {
                labels: ['Basic', 'Standard', 'Premium'],
                datasets: [{
                    data: [{{ rand(5, 15) }}, {{ rand(3, 10) }}, {{ rand(1, 5) }}],
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.8)',
                        'rgba(54, 162, 235, 0.8)',
                        'rgba(255, 206, 86, 0.8)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });

        // Quick View Function
        function quickViewTenant(tenantId) {
            $('#quickViewContent').html(`
                <div class="text-center">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            `);

            $.ajax({
                type: 'GET',
                url: `/highsuperadmin/tenants/${tenantId}`,
                dataType: 'json',
                success: function(tenant) {
                    let quickViewHtml = `
                        <div class="text-center mb-3">
                            <div class="avatar-lg mx-auto mb-3">
                                <span class="avatar-title bg-primary rounded-circle">
                                    ${tenant.name.charAt(0).toUpperCase()}
                                </span>
                            </div>
                            <h5>${tenant.name}</h5>
                            <p class="text-muted">${tenant.domain}</p>
                        </div>
                        <hr>
                        <div class="row text-center">
                            <div class="col-4">
                                <h6>${tenant.admins_count || 0}</h6>
                                <p class="text-muted mb-0">Admins</p>
                            </div>
                            <div class="col-4">
                                <h6>${tenant.employees_count || 0}</h6>
                                <p class="text-muted mb-0">Employees</p>
                            </div>
                            <div class="col-4">
                                <h6>${tenant.departments_count || 0}</h6>
                                <p class="text-muted mb-0">Departments</p>
                            </div>
                        </div>
                        <hr>
                        <div class="d-grid">
                            <a href="/highsuperadmin/tenants" class="btn btn-primary">View All Tenants</a>
                        </div>
                    `;
                    
                    $('#quickViewContent').html(quickViewHtml);
                },
                error: function(e) {
                    $('#quickViewContent').html('<p class="text-danger text-center">Error loading tenant details</p>');
                }
            });
        }

        // Add some CSS for icon shapes
        const style = document.createElement('style');
        style.innerHTML = `
            .icon-shape {
                width: 60px;
                height: 60px;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            .avatar-lg {
                width: 80px;
                height: 80px;
            }
            .avatar-title {
                width: 100%;
                height: 100%;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 2rem;
                font-weight: 600;
                color: white;
            }
        `;
        document.head.appendChild(style);
    </script>
@endsection