{{-- resources/views/chat/show.blade.php --}}
@extends('chat.layout')

@section('title', 'Carisma')
@section('page-name', 'Carisma')
@section('page-detail', $conversation->type === 'group' ? $conversation->name : 'Chat')

@section('custom-styles')
<style>
    /* WhatsApp Colors */
    :root {
        --wa-green: #25D366;
        --wa-dark-green: #075E54;
        --wa-light-green: #DCF8C6;
        --wa-teal: #128C7E;
        --wa-teal-green: #075E54;
        --wa-bg: #0B141A;
        --wa-chat-bg: #0B141A;
        --wa-incoming-bg: #202C33;
        --wa-outgoing-bg: #005C4B;
        --wa-gray: #8696A0;
        --wa-blue: #53BDEB;
    }

    /* Override default styles */
    body {
        background-color: var(--wa-bg);
    }
.main-content{
    padding: 0;
}
    .content-are-dashboard {
        
        padding: 0 !important;
        height: calc(100vh - 80px);
        overflow: hidden;
    }

    .card {
        height: 100%;
        margin: 0;
        border-radius: 0 !important;
        border: none;
        background: transparent;
    }

    .card-body {
        padding: 0 !important;
        height: 100%;
    }

    /* Chat Container */
    .wa-chat-container {
        /* height: 100vh; */
        height: calc(90vh);
        display: flex;
        flex-direction: column;
        background-color: var(--wa-bg);
    }

    /* Chat Header */
    .wa-chat-header {
        background-color: #202C33;
        padding: 10px 16px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        min-height: 59px;
        border-bottom: 1px solid #2A3942;
    }

    .wa-chat-header-left {
        display: flex;
        align-items: center;
        flex: 1;
    }

    .wa-back-btn {
        background: none;
        border: none;
        color: #E9EDEF;
        font-size: 24px;
        padding: 8px;
        margin-right: 0;
        cursor: pointer;
    }

    .wa-header-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background-color: #6B7C85;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 18px;
        margin-right: 15px;
        cursor: pointer;
    }

    .wa-header-avatar.group {
        background-color: #00A884;
    }
    
    .wa-header-avatar.admin {
        background-color: #7B68EE;
    }

    .wa-header-info {
        flex: 1;
        cursor: pointer;
    }

    .wa-header-name {
        color: #E9EDEF;
        font-size: 16px;
        font-weight: 500;
        margin: 0;
    }

    .wa-header-status {
        color: var(--wa-gray);
        font-size: 13px;
        margin: 0;
    }

    .wa-header-actions {
        display: flex;
        gap: 10px;
    }

    .wa-header-actions button {
        background: none;
        border: none;
        color: #AEBAC1;
        font-size: 20px;
        padding: 8px;
        cursor: pointer;
    }

    /* Messages Area */
    .wa-messages-container {
        flex: 1;
        overflow-y: auto;
        padding: 8px 0;
        background-color: #0B141A;
        background-image: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23040a0f' fill-opacity='0.4'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
    }

    .wa-messages-container::-webkit-scrollbar {
        width: 6px;
    }

    .wa-messages-container::-webkit-scrollbar-track {
        background: transparent;
    }

    .wa-messages-container::-webkit-scrollbar-thumb {
        background: #374045;
        border-radius: 3px;
    }

    /* Date Separator */
    .wa-date-separator {
        text-align: center;
        margin: 12px 0;
    }

    .wa-date-badge {
        display: inline-block;
        background-color: #182229;
        color: #8696A0;
        padding: 5px 12px;
        border-radius: 7px;
        font-size: 12.5px;
        box-shadow: 0 1px 0.5px rgba(0, 0, 0, 0.13);
    }

    /* Messages */
    .wa-message-row {
        display: flex;
        padding: 2px 9%;
        margin-bottom: 2px;
    }

    .wa-message-row.own {
        justify-content: flex-end;
    }

    .wa-message-bubble {
        max-width: 65%;
        position: relative;
        padding: 6px 7px 8px 9px;
        border-radius: 7.5px;
        box-shadow: 0 1px 0.5px rgba(0, 0, 0, 0.13);
        word-wrap: break-word;
    }

    .wa-message-row:not(.own) .wa-message-bubble {
        background-color: var(--wa-incoming-bg);
        color: #E9EDEF;
        border-top-left-radius: 0;
    }

    .wa-message-row.own .wa-message-bubble {
        background-color: var(--wa-outgoing-bg);
        color: #E9EDEF;
        border-top-right-radius: 0;
    }

    /* Message tail */
    .wa-message-bubble::before {
        content: '';
        position: absolute;
        top: 0;
        width: 0;
        height: 0;
    }

    .wa-message-row:not(.own) .wa-message-bubble::before {
        left: -8px;
        border-left: 8px solid transparent;
        border-right: 8px solid transparent;
        border-top: 8px solid var(--wa-incoming-bg);
        border-bottom: 0;
    }

    .wa-message-row.own .wa-message-bubble::before {
        right: -8px;
        border-left: 8px solid transparent;
        border-right: 8px solid transparent;
        border-top: 8px solid var(--wa-outgoing-bg);
        border-bottom: 0;
    }

    /* Message Content */
    .wa-message-sender {
        font-size: 12.5px;
        font-weight: 500;
        margin-bottom: 2px;
        display: block;
    }

    .wa-message-sender.own {
        color: #53BDEB;
    }

    .wa-message-sender:not(.own) {
        color: #F07167;
    }
    
    .wa-message-sender.admin {
        color: #7B68EE;
    }

    .wa-message-text {
        font-size: 14.2px;
        line-height: 19px;
        margin: 0;
        white-space: pre-wrap;
    }

    .wa-message-time {
        font-size: 11px;
        color: rgba(255, 255, 255, 0.6);
        float: right;
        margin: -2px -5px -5px 12px;
        position: relative;
        bottom: -4px;
    }

    .wa-message-status {
        display: inline-block;
        width: 16px;
        height: 11px;
        margin-left: 3px;
        vertical-align: middle;
    }

    .wa-message-status i {
        font-size: 16px;
        color: var(--wa-blue);
    }

    /* System Messages */
    .wa-system-message {
        text-align: center;
        margin: 8px 0;
    }

    .wa-system-badge {
        display: inline-block;
        background-color: #182229;
        color: #8696A0;
        padding: 5px 12px;
        border-radius: 7px;
        font-size: 12.5px;
    }

    /* Attachments */
    .wa-attachment {
        margin-top: 4px;
        padding-top: 4px;
    }

    .wa-attachment a {
        color: var(--wa-blue);
        text-decoration: none;
        font-size: 13px;
        display: inline-flex;
        align-items: center;
        gap: 5px;
    }

    .wa-attachment a:hover {
        text-decoration: underline;
    }

    /* Input Area */
    .wa-input-container {
        background-color: #202C33;
        padding: 5px 10px;
        display: flex;
        align-items: flex-end;
        gap: 8px;
        border-top: 1px solid #2A3942;
    }

    .wa-input-actions {
        display: flex;
        gap: 5px;
    }

    .wa-input-btn {
        background: none;
        border: none;
        color: #8696A0;
        font-size: 26px;
        padding: 5px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
    }

    .wa-input-btn:hover {
        color: #AEBAC1;
    }

    .wa-input-wrapper {
        flex: 1;
        position: relative;
    }

    .wa-message-input {
        width: 100%;
        background-color: #2A3942;
        border: none;
        border-radius: 21px;
        padding: 9px 12px 11px;
        color: #E9EDEF;
        font-size: 15px;
        resize: none;
        outline: none;
        max-height: 100px;
        scrollbar-width: thin;
    }

    .wa-message-input::placeholder {
        color: #8696A0;
    }

    .wa-send-btn {
        background: none;
        border: none;
        color: #8696A0;
        font-size: 24px;
        padding: 5px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        transition: transform 0.1s;
    }

    .wa-send-btn:hover {
        color: #AEBAC1;
    }

    .wa-send-btn.active {
        color: #00A884;
    }

    /* Participants Panel */
    .wa-participants-panel {
        background-color: #111B21;
        border-left: 1px solid #2A3942;
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    .wa-participants-header {
        background-color: #202C33;
        padding: 16px;
        border-bottom: 1px solid #2A3942;
    }

    .wa-participants-header h6 {
        color: #E9EDEF;
        margin: 0;
        font-size: 16px;
        font-weight: 500;
    }

    .wa-participants-list {
        flex: 1;
        overflow-y: auto;
        padding: 8px 0;
    }

    .wa-participant {
        display: flex;
        align-items: center;
        padding: 12px 16px;
        cursor: pointer;
        transition: background-color 0.1s;
    }

    .wa-participant:hover {
        background-color: #202C33;
    }

    .wa-participant-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background-color: #6B7C85;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 18px;
        margin-right: 13px;
    }
    
    .wa-participant-avatar.admin {
        background-color: #7B68EE;
    }

    .wa-participant-info {
        flex: 1;
    }

    .wa-participant-name {
        color: #E9EDEF;
        font-size: 16px;
        margin: 0;
    }

    .wa-participant-status {
        color: #8696A0;
        font-size: 13px;
        margin: 0;
    }

    .wa-participant-admin {
        color: #00A884;
        font-size: 12px;
        background-color: rgba(0, 168, 132, 0.1);
        padding: 2px 8px;
        border-radius: 3px;
    }

    /* Typing Indicator */
    .wa-typing-indicator {
        display: none;
        padding: 8px 20px;
        color: #00A884;
        font-size: 13px;
        font-style: italic;
    }

    /* Empty State */
    .wa-empty-chat {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        height: 100%;
        color: #8696A0;
        text-align: center;
        padding: 40px;
    }

    .wa-empty-chat i {
        font-size: 64px;
        opacity: 0.3;
        margin-bottom: 20px;
    }

    /* Dropdown Overrides */
    .dropdown-menu {
        background-color: #233138;
        border: none;
        box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);
    }

    .dropdown-item {
        color: #E9EDEF;
        padding: 13px 24px 13px 24px;
        font-size: 14.5px;
    }

    .dropdown-item:hover {
        background-color: #182229;
        color: #E9EDEF;
    }

    .dropdown-item i {
        width: 24px;
    }

    /* Modal Overrides */
    .modal-content {
        background-color: #202C33;
        color: #E9EDEF;
        border: none;
    }

    .modal-header {
        border-bottom: 1px solid #2A3942;
    }

    .modal-header .btn-close {
        filter: invert(1);
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .wa-message-bubble {
            max-width: 80%;
        }
        
        .wa-message-row {
            padding: 2px 3%;
        }
    }
</style>
@endsection

@section('body')
@php
    // Get the authenticated user and tenant from middleware-set attributes
    $authenticatedUser = request()->attributes->get('authenticated_user');
    $currentUserId = null;
    $currentUserType = null;
    
    if (get_class($authenticatedUser) === 'App\Models\Admin') {
        $currentUserId = $authenticatedUser->id;
        $currentUserType = 'admin';
    } else {
        $currentUserId = $authenticatedUser->employee_id ?? null;
        $currentUserType = 'employee';
    }
    
    $currentTenantId = request()->attributes->get('tenant_id');
@endphp

<div class="content-are-dashboard">
    <div class="card">
        <div class="card-body">
            <div class="row g-0 h-100">
                {{-- Chat Area --}}
                <div class="{{ $conversation->type === 'group' ? 'col-md-9' : 'col-12' }}">
                    <div class="wa-chat-container">
                        {{-- Chat Header --}}
                        <div class="wa-chat-header">
                            <div class="wa-chat-header-left">
                                <a href="{{ route('chat.index') }}" class="wa-back-btn">
                                    <i class="fas fa-arrow-left"></i>
                                </a>
                                
                                @if($conversation->type === 'group')
                                    <div class="wa-header-avatar group">
                                        <i class="fas fa-users"></i>
                                    </div>
                                    <div class="wa-header-info">
                                        <h5 class="wa-header-name">{{ $conversation->name }}</h5>
                                        <p class="wa-header-status">
                                            @php
                                                $allParticipants = $conversation->getAllParticipants();
                                            @endphp
                                            @foreach($allParticipants->take(3) as $participant)
                                                {{ $participant->participant_type === 'admin' ? 'Admin: ' . $participant->display_name : $participant->name }}@if(!$loop->last), @endif
                                            @endforeach
                                            @if($allParticipants->count() > 3)
                                                , +{{ $allParticipants->count() - 3 }} more
                                            @endif
                                        </p>
                                    </div>
                                @else
                                    @php
                                        // Find the other participant in personal chat
                                        $otherParticipant = null;
                                        $allParticipants = $conversation->getAllParticipants();
                                        
                                        foreach ($allParticipants as $participant) {
                                            if ($participant->participant_type === 'admin' && !($currentUserType === 'admin' && $participant->id == $currentUserId)) {
                                                $otherParticipant = $participant;
                                                break;
                                            } elseif ($participant->participant_type === 'employee' && !($currentUserType === 'employee' && $participant->employee_id == $currentUserId)) {
                                                $otherParticipant = $participant;
                                                break;
                                            }
                                        }
                                        
                                        $displayName = 'Unknown User';
                                        $avatarText = '?';
                                        $isAdmin = false;
                                        
                                        if ($otherParticipant) {
                                            if ($otherParticipant->participant_type === 'admin') {
                                                $displayName = 'Admin: ' . $otherParticipant->display_name;
                                                $avatarText = 'A';
                                                $isAdmin = true;
                                            } else {
                                                $displayName = $otherParticipant->name;
                                                $avatarText = strtoupper(substr($displayName, 0, 1));
                                            }
                                        }
                                    @endphp
                                    <div class="wa-header-avatar {{ $isAdmin ? 'admin' : '' }}">
                                        {{ $avatarText }}
                                    </div>
                                    <div class="wa-header-info">
                                        <h5 class="wa-header-name">{{ $displayName }}</h5>
                                        <p class="wa-header-status">online</p>
                                    </div>
                                @endif
                            </div>
                            
                            <div class="wa-header-actions">
                                <button data-bs-toggle="dropdown">
                                    <i class="fas fa-ellipsis-v"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li><a class="dropdown-item" href="#">
                                        <i class="fas fa-user"></i>Contact info
                                    </a></li>
                                    @if($conversation->type === 'group')
                                        <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#addMembersModal">
                                            <i class="fas fa-user-plus"></i>Add participants
                                        </a></li>
                                        <li><a class="dropdown-item" href="#" onclick="leaveGroup()">
                                            <i class="fas fa-sign-out-alt"></i>Exit group
                                        </a></li>
                                    @endif
                                    <li><a class="dropdown-item" href="#">
                                        <i class="fas fa-volume-mute"></i>Mute notifications
                                    </a></li>
                                    <li><a class="dropdown-item" href="#" onclick="clearChat()">
                                        <i class="fas fa-trash"></i>Clear messages
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                        
                        {{-- Messages Container --}}
                        <div class="wa-messages-container" id="messagesContainer">
                            @php
                                $lastDate = null;
                            @endphp
                            
                            @forelse($messages as $message)
                                @php
                                    $messageDate = $message->created_at->format('Y-m-d');
                                    $isSystemMessage = $message->type === 'system';
                                    $isToday = $message->created_at->isToday();
                                    $isYesterday = $message->created_at->isYesterday();
                                    
                                    // Determine if message is from current user
                                    $isOwnMessage = false;
                                    if ($currentUserType === 'admin' && $message->sender_admin_id == $currentUserId) {
                                        $isOwnMessage = true;
                                    } elseif ($currentUserType === 'employee' && $message->sender_id == $currentUserId) {
                                        $isOwnMessage = true;
                                    }
                                @endphp
                                
                                @if($lastDate !== $messageDate)
                                    <div class="wa-date-separator">
                                        <span class="wa-date-badge">
                                            @if($isToday)
                                                TODAY
                                            @elseif($isYesterday)
                                                YESTERDAY
                                            @else
                                                {{ strtoupper($message->created_at->format('F d, Y')) }}
                                            @endif
                                        </span>
                                    </div>
                                    @php $lastDate = $messageDate; @endphp
                                @endif
                                
                                @if($isSystemMessage)
                                    <div class="wa-system-message">
                                        <span class="wa-system-badge">
                                            {{ $message->content }}
                                        </span>
                                    </div>
                                @else
                                    <div class="wa-message-row {{ $isOwnMessage ? 'own' : '' }}" 
                                         data-message-id="{{ $message->id }}">
                                        <div class="wa-message-bubble {{ $message->type === 'deleted' ? 'deleted' : '' }}">
                                            @if($conversation->type === 'group' && !$isOwnMessage)
                                                <span class="wa-message-sender {{ $message->isFromAdmin() ? 'admin' : '' }}">
                                                    {{ $message->sender_name }}
                                                </span>
                                            @endif
                                            
                                            <span class="wa-message-text">{{ $message->content }}</span>
                                            
                                            @if($message->attachments && is_array($message->attachments))
                                                @foreach($message->attachments as $attachment)
                                                    <div class="wa-attachment">
                                                        <a href="{{ asset('storage/' . $attachment['path']) }}" target="_blank">
                                                            <i class="fas fa-paperclip"></i>
                                                            {{ $attachment['name'] ?? 'Attachment' }}
                                                        </a>
                                                    </div>
                                                @endforeach
                                            @endif
                                            
                                            <span class="wa-message-time">
                                                {{ $message->created_at->format('g:i A') }}
                                                @if($isOwnMessage)
                                                    <span class="wa-message-status">
                                                        <i class="fas fa-check-double"></i>
                                                    </span>
                                                @endif
                                            </span>
                                        </div>
                                    </div>
                                @endif
                            @empty
                                <div class="wa-empty-chat">
                                    <i class="fas fa-comments"></i>
                                    <p>No messages here yet...</p>
                                    <p>Send a message to start the conversation!</p>
                                </div>
                            @endforelse
                            
                            <div class="wa-typing-indicator" id="typingIndicator">
                                <span id="typingUser"></span> is typing...
                            </div>
                        </div>
                        
                        {{-- Input Area --}}
                        <div class="wa-input-container">
                            <div class="wa-input-actions">
                                <button class="wa-input-btn" data-bs-toggle="dropdown">
                                    <i class="fas fa-paperclip"></i>
                                </button>
                                <ul class="dropdown-menu dropup">
                                    <li>
                                        <a class="dropdown-item" href="#" onclick="$('#attachmentInput').click()">
                                            <i class="fas fa-file-alt"></i>Document
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#" onclick="$('#attachmentInput').click()">
                                            <i class="fas fa-image"></i>Photos & Videos
                                        </a>
                                    </li>
                                </ul>
                                <input type="file" id="attachmentInput" multiple style="display: none;" 
                                       accept="image/*,.pdf,.doc,.docx,.xls,.xlsx">
                            </div>
                            
                            <form class="wa-input-wrapper" id="messageForm">
                                @csrf
                                <textarea class="wa-message-input" id="messageInput" 
                                          placeholder="Type a message" rows="1"></textarea>
                            </form>
                            
                            <button type="submit" form="messageForm" class="wa-send-btn" id="sendBtn">
                                <i class="fas fa-paper-plane" id="sendIcon"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                {{-- Participants Panel (Group Chat Only) --}}
                @if($conversation->type === 'group')
                <div class="col-md-3">
                    <div class="wa-participants-panel">
                        <div class="wa-participants-header">
                            <h6>{{ $participants->count() }} participants</h6>
                        </div>
                        <div class="wa-participants-list">
                            @foreach($participants as $participant)
                                @php
                                    $isCurrentUser = false;
                                    $participantName = 'Unknown';
                                    $avatarText = '?';
                                    $isAdmin = false;
                                    
                                    if ($participant->participant_type === 'admin') {
                                        $participantName = 'Admin: ' . $participant->display_name;
                                        $avatarText = 'A';
                                        $isAdmin = true;
                                        $isCurrentUser = ($currentUserType === 'admin' && $participant->id == $currentUserId);
                                    } else {
                                        $participantName = $participant->name;
                                        $avatarText = strtoupper(substr($participantName, 0, 1));
                                        $isCurrentUser = ($currentUserType === 'employee' && $participant->employee_id == $currentUserId);
                                    }
                                @endphp
                                <div class="wa-participant">
                                    <div class="wa-participant-avatar {{ $isAdmin ? 'admin' : '' }}">
                                        {{ $avatarText }}
                                    </div>
                                    <div class="wa-participant-info">
                                        <p class="wa-participant-name">
                                            {{ $participantName }}
                                            @if($isCurrentUser)
                                                (You)
                                            @endif
                                        </p>
                                    </div>
                                    @if($participant->pivot && $participant->pivot->role === 'admin')
                                        <span class="wa-participant-admin">Group Admin</span>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

{{-- Add Members Modal (Group Chat Only) --}}
@if($conversation->type === 'group')
<div class="modal fade" id="addMembersModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add participants</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="addMembersForm">
                    @csrf
                    <div class="mb-3">
                        <input type="text" class="form-control" placeholder="Search name or number">
                    </div>
                    <div style="max-height: 300px; overflow-y: auto;">
                        @php
                            $existingParticipantIds = $participants->pluck('employee_id')->filter()->toArray();
                            $existingAdminIds = $participants->where('participant_type', 'admin')->pluck('id')->toArray();
                            
                            $availableEmployees = App\Models\Employee::where('tenant_id', $currentTenantId)
                                                                     ->whereNotIn('employee_id', $existingParticipantIds)
                                                                     ->orderBy('name')
                                                                     ->get();
                                                                     
                            $availableAdmins = App\Models\Admin::where('tenant_id', $currentTenantId)
                                                              ->whereNotIn('id', $existingAdminIds)
                                                              ->orderBy('email')
                                                              ->get();
                        @endphp
                        
                        @if($availableAdmins->count() > 0)
                            <h6 class="text-muted mb-2">Admins</h6>
                            @foreach($availableAdmins as $admin)
                                <div class="form-check py-2">
                                    <input class="form-check-input participant-checkbox" type="checkbox" 
                                           data-type="admin" data-id="{{ $admin->id }}" 
                                           id="addAdmin{{ $admin->id }}">
                                    <label class="form-check-label ms-3" for="addAdmin{{ $admin->id }}">
                                        Admin: {{ $admin->display_name }}
                                    </label>
                                </div>
                            @endforeach
                        @endif
                        
                        @if($availableEmployees->count() > 0)
                            <h6 class="text-muted mb-2 mt-3">Employees</h6>
                            @foreach($availableEmployees as $employee)
                                <div class="form-check py-2">
                                    <input class="form-check-input participant-checkbox" type="checkbox" 
                                           data-type="employee" data-id="{{ $employee->employee_id }}" 
                                           id="addEmp{{ $employee->employee_id }}">
                                    <label class="form-check-label ms-3" for="addEmp{{ $employee->employee_id }}">
                                        {{ $employee->name }}
                                    </label>
                                </div>
                            @endforeach
                        @endif
                        
                        @if($availableEmployees->count() == 0 && $availableAdmins->count() == 0)
                            <p class="text-muted text-center">No contacts available to add</p>
                        @endif
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="addMembers()">Add participants</button>
            </div>
        </div>
    </div>
</div>
@endif
@endsection
@section('head-scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
@endsection
@section('custom-scripts')
<script>
    // Auto-scroll to bottom on load
    function scrollToBottom() {
        const container = document.getElementById('messagesContainer');
        container.scrollTop = container.scrollHeight;
    }
    
    scrollToBottom();
    
    // Toggle send/mic button based on input
    $('#messageInput').on('input', function() {
        const hasText = $(this).val().trim().length > 0;
        if (hasText) {
            $('#sendBtn').addClass('active');
        } else {
            $('#sendBtn').removeClass('active');
        }
        
        // Auto-resize textarea
        this.style.height = 'auto';
        this.style.height = Math.min(this.scrollHeight, 100) + 'px';
    });
    
    // Send message
    $('#messageForm').on('submit', function(e) {
        e.preventDefault();
        
        const messageInput = $('#messageInput');
        const content = messageInput.val().trim();
        const attachmentInput = $('#attachmentInput')[0];
        
        if (!content && attachmentInput.files.length === 0) {
            return;
        }
        
        const formData = new FormData();
        formData.append('_token', '{{ csrf_token() }}');
        formData.append('content', content);
        
        // Add attachments if any
        for (let i = 0; i < attachmentInput.files.length; i++) {
            formData.append('attachments[]', attachmentInput.files[i]);
        }
        
        // Disable send button
        $('#sendBtn').prop('disabled', true);
        
        $.ajax({
            url: '{{ route("chat.send.message", $conversation) }}',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    messageInput.val('');
                    attachmentInput.value = '';
                    messageInput.trigger('input'); // Reset button state
                    location.reload(); // Reload to show new message
                }
            },
            error: function(xhr) {
                alert('Failed to send message');
            },
            complete: function() {
                $('#sendBtn').prop('disabled', false);
            }
        });
    });
    
    // Enter key to send (Shift+Enter for new line)
    $('#messageInput').on('keydown', function(e) {
        if (e.key === 'Enter' && !e.shiftKey) {
            e.preventDefault();
            $('#messageForm').submit();
        }
    });
    
    // Add members to group
    function addMembers() {
        const selectedParticipants = [];
        
        $('.participant-checkbox:checked').each(function() {
            selectedParticipants.push({
                type: $(this).data('type'),
                id: $(this).data('id')
            });
        });
        
        if (selectedParticipants.length === 0) {
            alert('Please select at least one participant');
            return;
        }
        
        $.ajax({
            url: '{{ route("chat.add.participants", $conversation) }}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                participants: selectedParticipants
            },
            success: function(response) {
                if (response.success) {
                    location.reload();
                }
            },
            error: function(xhr) {
                alert(xhr.responseJSON?.error || 'Failed to add participants');
            }
        });
    }
    
    // Leave group
    function leaveGroup() {
        if (!confirm('Exit group? Only group admins will be able to add you to the group again.')) {
            return;
        }
        
        $.ajax({
            url: '{{ route("chat.leave", $conversation) }}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.success) {
                    window.location.href = '{{ route("chat.index") }}';
                }
            },
            error: function(xhr) {
                alert('Failed to exit group');
            }
        });
    }
    
    // Clear chat
    function clearChat() {
        if (!confirm('Clear all messages from this chat?')) {
            return;
        }
        // Implement clear chat functionality
        alert('Messages cleared');
    }
    
    // Check for new messages periodically
    let lastMessageId = {{ $messages->last()->id ?? 0 }};
    
    setInterval(function() {
        // Check for new messages via AJAX
        // In production, use WebSocket for real-time updates
    }, 3000);
    
    // Mark messages as read when window gains focus
    $(window).on('focus', function() {
        $.ajax({
            url: '{{ route("chat.mark.read", $conversation) }}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}'
            }
        });
    });
    
    // Format message time
    function formatMessageTime(date) {
        return new Date(date).toLocaleTimeString('en-US', { 
            hour: 'numeric', 
            minute: '2-digit',
            hour12: true 
        }).toUpperCase();
    }
</script>
@endsection