@php
    // Get authenticated user and their type
    $authenticatedUser = request()->attributes->get('authenticated_user');
    $authGuard = request()->attributes->get('auth_guard');
    $tenant = request()->route('tenant') ?? request()->attributes->get('tenant_id');
    
    // Determine user type and details
    $userType = null;
    $userName = 'Guest';
    $userRole = null;
    $userEmail = null;
    
    if ($authenticatedUser) {
       // dd($authenticatedUser);
        if (get_class($authenticatedUser) === 'App\Models\Admin') {
            $userType = 'admin';
            $userName = 'Admin';
            $userEmail = $authenticatedUser->email;
            $userRole = 'admin';
        } elseif (isset($authenticatedUser->employee_id)) {
         // dd('Authenticated as employee', $authenticatedUser->role);
            if($authenticatedUser->role === 'Manager') {
                $userType = 'manager';
                $userName = $authenticatedUser->name ?? 'Manager';
                $userEmail = $authenticatedUser->email;
                // Get manager role/category
                $userRole = $authenticatedUser->role ?? 'Manager';
            } else if($authenticatedUser->role === 'Admin') {
                // dd('Authenticated as Admin', $authenticatedUser);
                $userType = 'Admin';
                $userName = $authenticatedUser->name ?? 'Admin';
                $userEmail = $authenticatedUser->email;
                // Get manager role/category
                $userRole = $authenticatedUser->role ?? 'Admin';
            }
             else {
                $userType = 'employee';
                $userName = $authenticatedUser->name ?? 'Employee';
                $userEmail = $authenticatedUser->email;
                // Get employee role/category
                $userRole = $authenticatedUser->role ?? 'employee';
            }
           
        }
    }
   // dd($userRole);
@endphp

<!DOCTYPE html>
<html lang="en">
    @include('SuperAdmin.includes.head')
<head>
      <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- Push Notification Scripts - Load in Head -->
    <script>
        // Check browser support immediately
        window.pushNotificationSupport = {
            serviceWorker: 'serviceWorker' in navigator,
            pushManager: 'PushManager' in window,
            notifications: 'Notification' in window
        };
        console.log('Browser support check:', window.pushNotificationSupport);
    </script>
    
    <!-- Load the main push notification script -->
    <script src="/js/chat-push-notifications.js"></script>
     <!-- Additional head scripts -->
    @yield('head-scripts')
    {{-- Default Styles --}}
    <style>
        .content-area-dashboard {
            min-height: calc(100vh - 100px);
        }
        .main-wrapper {
            display: flex;
            min-height: 100vh;
        }
        /* .sidebar-wrapper {
            width: 250px;
            min-height: 100vh;
            background-color: #f8f9fa;
            border-right: 1px solid #dee2e6;
        } */
        .content-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .main-content {
            flex: 1;
            padding: 20px;
        }
    </style>
    
    @yield('custom-styles')
</head>
<body>
    <div class="main-wrapper">
        {{-- Include sidebar based on user type --}}
        <div class="sidebar-wrapper">
           
            @if($userType === 'admin')
     @include('SuperAdmin.includes.sidebar')
@elseif($userRole == 'Manager') 
    @include('Manager.includes.sidebar')
@elseif($userRole == 'Admin')
     @include('PointsAdmin.includes.sidebar')
@else
     @include('Employee.includes.sidebar')
@endif
        </div>

        <div class="content-wrapper">
            {{-- Include header based on user type --}}
           
  @if($userType === 'admin')
     @include('SuperAdmin.includes.header')
@elseif($userRole == 'Manager') 
    @include('Manager.includes.header')
@elseif($userRole == 'Admin')
     @include('PointsAdmin.includes.header')
@else
     @include('Employee.includes.header')
@endif
            {{-- Main Content --}}
            <main class="main-content">
                @yield('body')
            </main>
        </div>
    </div>

    {{-- Bootstrap JS --}}
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    {{-- Global JavaScript for user context --}}
    <script>
        window.currentUser = {
            type: '{{ $userType }}',
            role: '{{ $userRole }}',
            name: '{{ $userName }}',
            email: '{{ $userEmail }}'
        };
    </script>
    
    @yield('custom-scripts')
</body>
</html>