{{-- resources/views/chat/index.blade.php --}}
@extends('chat.layout')
@section('title', 'Carisma')
@section('page-name', 'Carisma')
@section('custom-styles')
<style>
    /* WhatsApp Colors */
    :root {
        --wa-green: #25D366;
        --wa-dark-green: #075E54;
        --wa-light-green: #DCF8C6;
        --wa-bg: #E5DDD5;
        --wa-chat-bg: #F0F0F0;
        --wa-white: #FFFFFF;
        --wa-gray: #8696A0;
        --wa-blue: #34B7F1;
    }

    /* Override default styles */
    body {
        background-color: #111B21;
    }

    .content-are-dashboard {
        padding: 0 !important;
        height: calc(100vh - 200px);
        overflow: hidden;
    }

    .card {
        height: 100%;
        margin: 0;
        border-radius: 0 !important;
        border: none;
    }

    .card-body {
        padding: 0 !important;
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    /* WhatsApp Header */
    .wa-header {
        background-color: #202C33;
        color: white;
        padding: 10px 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-bottom: 1px solid #2A3942;
    }

    .wa-header h4 {
        margin: 0;
        font-size: 20px;
        font-weight: 500;
    }

    .wa-header-actions {
        display: flex;
        gap: 20px;
    }

    .wa-header-actions button {
        background: none;
        border: none;
        color: #AEBAC1;
        font-size: 20px;
        cursor: pointer;
        padding: 5px;
    }

    .wa-header-actions button:hover {
        color: white;
    }

    /* Search Container */
    .wa-search-container {
        background-color: #111B21;
        padding: 8px 12px;
        border-bottom: 1px solid #2A3942;
    }

    .wa-search-box {
        background-color: #202C33;
        border: none;
        border-radius: 8px;
        padding: 8px 32px 8px 65px;
        color: white;
        width: 100%;
        font-size: 14px;
        position: relative;
    }

    .wa-search-box::placeholder {
        color: #8696A0;
    }

    .wa-search-icon {
        position: absolute;
        left: 24px;
        top: 50%;
        transform: translateY(-50%);
        color: #8696A0;
        font-size: 14px;
        z-index: 1;
    }

    .wa-search-wrapper {
        position: relative;
    }

    /* Chat List */
    .wa-chat-list {
        flex: 1;
        overflow-y: auto;
        background-color: #111B21;
    }

    .wa-chat-list::-webkit-scrollbar {
        width: 6px;
    }

    .wa-chat-list::-webkit-scrollbar-track {
        background: transparent;
    }

    .wa-chat-list::-webkit-scrollbar-thumb {
        background: #374045;
        border-radius: 3px;
    }

    /* Conversation Item */
    .wa-conversation-item {
        display: flex;
        padding: 12px 16px;
        cursor: pointer;
        border-bottom: 1px solid #2A3942;
        transition: background-color 0.1s;
        text-decoration: none;
        color: inherit;
    }

    .wa-conversation-item:hover {
        background-color: #202C33;
        text-decoration: none;
        color: inherit;
    }

    .wa-conversation-item.active {
        background-color: #2A3942;
    }

    /* Avatar */
    .wa-avatar {
        width: 49px;
        height: 49px;
        border-radius: 50%;
        margin-right: 13px;
        background-color: #6B7C85;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: white;
        flex-shrink: 0;
    }

    .wa-avatar.group {
        background-color: #00A884;
    }

    /* Conversation Content */
    .wa-conversation-content {
        flex: 1;
        min-width: 0;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .wa-conversation-header {
        display: flex;
        justify-content: space-between;
        align-items: baseline;
        margin-bottom: 3px;
    }

    .wa-conversation-name {
        color: #E9EDEF;
        font-size: 17px;
        font-weight: 400;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        max-width: 200px;
    }

    .wa-conversation-time {
        color: #8696A0;
        font-size: 12px;
        margin-left: 8px;
    }

    .wa-last-message {
        display: flex;
        align-items: center;
        gap: 3px;
    }

    .wa-last-message-text {
        color: #8696A0;
        font-size: 14px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        flex: 1;
    }

    .wa-unread-badge {
        background-color: #00A884;
        color: #111B21;
        font-size: 12px;
        font-weight: 600;
        padding: 1px 6px;
        border-radius: 11px;
        min-width: 20px;
        text-align: center;
    }

    /* Message Status Icons */
    .wa-message-status {
        color: #53BDEB;
        font-size: 16px;
        margin-right: 3px;
    }

    /* Empty State */
    .wa-empty-state {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        height: 100%;
        color: #8696A0;
        padding: 40px;
        text-align: center;
    }

    .wa-empty-state i {
        font-size: 64px;
        margin-bottom: 20px;
        opacity: 0.5;
    }

    .wa-empty-state p {
        margin: 0;
        font-size: 14px;
        line-height: 20px;
    }

    /* New Chat FAB */
    .wa-fab {
        position: fixed;
        bottom: 20px;
        right: 20px;
        width: 56px;
        height: 56px;
        background-color: #00A884;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        cursor: pointer;
        transition: transform 0.2s;
        border: none;
        z-index: 1000;
    }

    .wa-fab:hover {
        transform: scale(1.05);
    }

    .wa-fab i {
        color: white;
        font-size: 24px;
    }

    /* Modal Overrides */
    .modal-content {
        background-color: #202C33;
        color: #E9EDEF;
        border: none;
    }

    .modal-header {
        border-bottom: 1px solid #2A3942;
    }

    .modal-header .btn-close {
        filter: invert(1);
    }

    .form-control, .form-select {
        background-color: #2A3942;
        border: 1px solid #3B4A54;
        color: #E9EDEF;
    }

    .form-control:focus, .form-select:focus {
        background-color: #2A3942;
        border-color: #00A884;
        color: #E9EDEF;
        box-shadow: 0 0 0 0.2rem rgba(0, 168, 132, 0.25);
    }

    .form-check-input {
        background-color: #2A3942;
        border-color: #3B4A54;
    }

    .form-check-input:checked {
        background-color: #00A884;
        border-color: #00A884;
    }

    .nav-tabs {
        border-bottom: 1px solid #2A3942;
    }

    .nav-link {
        color: #8696A0;
        border: none;
    }

    .nav-link.active {
        background-color: transparent;
        color: #00A884;
        border-bottom: 3px solid #00A884;
    }

    .btn-primary {
        background-color: #00A884;
        border-color: #00A884;
    }

    .btn-primary:hover {
        background-color: #017561;
        border-color: #017561;
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .wa-conversation-name {
            max-width: 150px;
        }
    }
</style>
@endsection

@section('body')
@php
    // Get the authenticated user and tenant from middleware-set attributes
    $authenticatedUser = request()->attributes->get('authenticated_user');
    $currentUserId = null;
    $currentUserType = null;
    
    if (get_class($authenticatedUser) === 'App\Models\Admin') {
        $currentUserId = $authenticatedUser->id;
        $currentUserType = 'admin';
    } else {
        $currentUserId = $authenticatedUser->employee_id ?? null;
        $currentUserType = 'employee';
    }
    // dd($currentUserType);
    $currentTenantId = request()->attributes->get('tenant_id');
@endphp

<div class="content-are-dashboard">
    <!-- <div class="wa-header">
    <h4>Carisma</h4>
    <div class="wa-header-actions">
        <button type="button" id="notificationToggle">
            <i class="fas fa-bell"></i>
        </button>
        <button type="button" data-bs-toggle="modal" data-bs-target="#newChatModal">
            <i class="fas fa-comment"></i>
        </button>
    </div>
</div> -->
    <div class="card">
        <div class="card-body">
            
            {{-- Conversations List --}}
            <div class="wa-chat-list">
                @if($conversations->count() > 0)
                    @foreach($conversations as $conversation)
                        @php
                            $isGroup = $conversation->type === 'group';
                            $displayName = '';
                            $avatarText = '';
                            
                            if ($isGroup) {
                                $displayName = $conversation->name;
                                $avatarText = strtoupper(substr($displayName, 0, 1));
                            } else {
                                // For personal chats, find the other participant
                                $otherParticipant = null;
                                
                                // Check employees
                                if ($currentUserType === 'employee') {
                                    $otherEmployee = $conversation->participantEmployees
                                        ->where('employee_id', '!=', $currentUserId)
                                        ->first();
                                    if ($otherEmployee) {
                                        $displayName = $otherEmployee->name;
                                        $avatarText = strtoupper(substr($displayName, 0, 1));
                                    }
                                }
                                
                                // Check for admin participants
                                if (!$displayName) {
                                    $otherAdmin = $conversation->participantAdmins->first();
                                    if ($otherAdmin && !($currentUserType === 'admin' && $otherAdmin->id == $currentUserId)) {
                                        $displayName = 'Admin: ' . $otherAdmin->display_name;
                                        $avatarText = 'A';
                                    }
                                }
                                
                                // If still no display name, check all participants
                                if (!$displayName) {
                                    $allParticipants = $conversation->getAllParticipants();
                                    foreach ($allParticipants as $participant) {
                                        if ($participant->participant_type === 'admin' && !($currentUserType === 'admin' && $participant->id == $currentUserId)) {
                                            $displayName = 'Admin: ' . $participant->display_name;
                                            $avatarText = 'A';
                                            break;
                                        } elseif ($participant->participant_type === 'employee' && !($currentUserType === 'employee' && $participant->employee_id == $currentUserId)) {
                                            $displayName = $participant->name;
                                            $avatarText = strtoupper(substr($displayName, 0, 1));
                                            break;
                                        }
                                    }
                                }
                                
                                if (!$displayName) {
                                    $displayName = 'Unknown User';
                                    $avatarText = '?';
                                }
                            }
                            
                            $lastMessage = $conversation->lastMessage;
                            $unreadCount = $conversation->unread_count ?? 0;
                        @endphp
                        
                        <a href="{{ route('chat.show', ['conversation' => $conversation->id]) }}" 
                           class="wa-conversation-item">
                            <div class="wa-avatar {{ $isGroup ? 'group' : '' }}">
                                @if($isGroup)
                                    <i class="fas fa-users"></i>
                                @else
                                    {{ $avatarText }}
                                @endif
                            </div>
                            
                            <div class="wa-conversation-content">
                                <div class="wa-conversation-header">
                                    <div class="wa-conversation-name">
                                        {{ $displayName }}
                                    </div>
                                    <div class="wa-conversation-time">
                                        @if($conversation->last_message_at)
                                            {{ $conversation->last_message_at->format('g:i A') }}
                                        @endif
                                    </div>
                                </div>
                                
                                <div class="wa-last-message">
                                    @if($lastMessage)
                                        <div class="wa-last-message-text">
                                            @php
                                                $isOwnMessage = false;
                                                if ($currentUserType === 'admin' && $lastMessage->sender_admin_id == $currentUserId) {
                                                    $isOwnMessage = true;
                                                } elseif ($currentUserType === 'employee' && $lastMessage->sender_id == $currentUserId) {
                                                    $isOwnMessage = true;
                                                }
                                            @endphp
                                            
                                            @if($isOwnMessage)
                                                <i class="fas fa-check-double wa-message-status"></i>
                                            @endif
                                            
                                            @if($lastMessage->type === 'system')
                                                <em>{{ $lastMessage->content }}</em>
                                            @else
                                                @if($isGroup && !$isOwnMessage)
                                                    {{ $lastMessage->sender_name }}: 
                                                @endif
                                                {{ Str::limit($lastMessage->content, 50) }}
                                            @endif
                                        </div>
                                    @else
                                        <div class="wa-last-message-text">
                                            <em>No messages yet</em>
                                        </div>
                                    @endif
                                    @if($unreadCount > 0)
                                        <div class="wa-unread-badge">{{ $unreadCount }}</div>
                                    @endif
                                </div>
                            </div>
                        </a>
                    @endforeach
                @else
                    <div class="wa-empty-state">
                        <i class="fas fa-comments"></i>
                        <p>No conversations yet</p>
                        <p>Tap the message button below to start chatting</p>
                    </div>
                @endif
            </div>
            
            {{-- Floating Action Button --}}
            <button class="wa-fab" data-bs-toggle="modal" data-bs-target="#newChatModal">
                <i class="fas fa-comment"></i>
            </button>
        </div>
    </div>
</div>

{{-- New Chat Modal --}}
<div class="modal fade" id="newChatModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">New chat</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <ul class="nav nav-tabs mb-3" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="personal-tab" data-bs-toggle="tab" 
                                data-bs-target="#personal" type="button">Personal</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="group-tab" data-bs-toggle="tab" 
                                data-bs-target="#group" type="button">Group</button>
                    </li>
                </ul>
                
                <div class="tab-content">
                    {{-- Personal Chat Tab --}}
                    <div class="tab-pane fade show active" id="personal" role="tabpanel">
                  <form action="{{ route('chat.create.personal') }}" method="POST" id="personalChatForm">
    @csrf

    <div class="mb-3">
        <label class="form-label">Select contact</label>
        <select name="contact_selection" class="form-select" required>
            <option value="">Choose contact...</option>
            @php
                $employees = App\Models\Employee::where('tenant_id', $currentTenantId)
                                                ->where('employee_id', '!=', $currentUserId)
                                                ->orderBy('name')
                                                ->get();
                $admins = App\Models\Admin::where('tenant_id', $currentTenantId)
                                          ->where('id', '!=', ($currentUserType === 'admin' ? $currentUserId : null))
                                          ->orderBy('email')
                                          ->get();
            @endphp

            @if($admins->count() > 0)
                <optgroup label="Admins">
                    @foreach($admins as $admin)
                        <option value="admin_{{ $admin->id }}">
                            {{ $admin->display_name }}
                        </option>
                    @endforeach
                </optgroup>
            @endif

            @if($employees->count() > 0)
                <optgroup label="Employees">
                    @foreach($employees as $employee)
                        <option value="employee_{{ $employee->employee_id }}">
                            {{ $employee->name }}
                            @if($employee->designation)
                                ({{ $employee->designation }})
                            @endif
                        </option>
                    @endforeach
                </optgroup>
            @endif
        </select>
    </div>

    {{-- Hidden fields that will be populated by JavaScript --}}
    <input type="hidden" name="recipient_type" id="recipient_type">
    <input type="hidden" name="recipient_id"   id="recipient_id">

    <button type="submit" class="btn btn-primary w-100">Start chat</button>
</form>


                    </div>
                    
                    {{-- Group Chat Tab --}}
                    <div class="tab-pane fade" id="group" role="tabpanel">
                        <form action="{{ route('chat.create.group') }}" method="POST">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label">Group subject</label>
                                <input type="text" name="name" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Description (optional)</label>
                                <textarea name="description" class="form-control" rows="2"></textarea>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Add participants</label>
                                <div style="max-height: 200px; overflow-y: auto; border: 1px solid #3B4A54; border-radius: 6px; padding: 10px;">
                                    @foreach($employees as $employee)
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" 
                                                   name="employee_ids[]" value="{{ $employee->employee_id }}" 
                                                   id="emp{{ $employee->employee_id }}">
                                            <label class="form-check-label" for="emp{{ $employee->employee_id }}">
                                                {{ $employee->name }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary w-100">Create group</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('custom-scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    
    $('#personalChatForm').on('submit', function(e) {
        e.preventDefault();

        const form      = $(this);
        const selectEl  = form.find('select[name="contact_selection"]');
        const selected  = selectEl.val(); // e.g. "admin_25" or "employee_42"

        // Prepare a fresh FormData (so we can override hidden inputs)
        const formData = new FormData(this);

        let recipientType = '';
        let recipientId   = '';

        if (selected) {
            // Split on the underscore: ["admin","25"] or ["employee","42"]
            const parts = selected.split('_');
            if (parts.length === 2) {
                recipientType = parts[0]; // "admin" or "employee"
                recipientId   = parts[1]; // e.g. "25" or "42"
            }
        }

        // Remove the old contact_selection field (we don't need to submit it)
        formData.delete('contact_selection');

        // Overwrite/add hidden inputs
        formData.set('recipient_type', recipientType);
        formData.set('recipient_id',   recipientId);

        // (Optional) Debug logs:
        console.log('DEBUG: selected      =', selected);
        console.log('DEBUG: recipientType =', recipientType);
        console.log('DEBUG: recipientId   =', recipientId);
        console.log('DEBUG: FormData entries:');
        for (let pair of formData.entries()) {
            console.log(pair[0] + ':', pair[1]);
        }

        // Submit via AJAX
        $.ajax({
            url: form.attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                console.log('DEBUG: AJAX success response:', response);
                // ◀︎ Instead of redirect, just reload the current page:
                location.reload();
            },
            error: function(xhr, status, error) {
                console.error('DEBUG: AJAX error:', status, error);
                console.error('DEBUG: Response text:', xhr.responseText);
                alert('An error occurred. Please check the console for details.');
            }
        });
    });
</script>


@endsection