<div class="card-container-juliana">
    <!-- Download Button -->
    <button id="downloadBtnJuliana" class="download-button-juliana" title="Download Business Card">
        <i class="fas fa-download"></i>
    </button>

    {{-- Template: Juliana Silva Style - Green Geometric Professional --}}
    <div class="juliana-silva-card" id="julianaBusinessCard">
        <!-- Geometric Background Elements -->
        <div class="geometric-container">
            <div class="geo-element element-1"></div>
            <div class="geo-element element-2"></div>
            <div class="geo-element element-3"></div>
            <div class="geo-element element-4"></div>
        </div>
        
        <!-- Content Container -->
        <div class="card-content">
            <!-- Left Section with Logo/Company -->
            <div class="left-section">
                @if($businessCard->company_logo)
                    <div class="company-logo-container">
                        <img src="{{ $businessCard->company_logo_url }}" alt="{{ $businessCard->company_name }}" class="company-logo">
                    </div>
                @else
                    <div class="default-company-logo">
                        <div class="logo-symbol">
                            <i class="fas fa-building"></i>
                        </div>
                    </div>
                @endif
                
                @if($businessCard->company_name)
                    <div class="company-name-section">
                        <h3 class="company-name">{{ strtoupper($businessCard->company_name) }}</h3>
                    </div>
                @endif
            </div>
            
            <!-- Right Section with Name and Contact -->
            <div class="right-section">
                <!-- Name Section -->
                <div class="name-section">
                    <h1 class="main-name">{{ $businessCard->name }}</h1>
                    @if($businessCard->title)
                        <div class="name-underline"></div>
                        <h2 class="job-title">{{ $businessCard->title }}</h2>
                    @endif
                </div>
                
                <!-- Contact Information -->
                <div class="contact-section">
                    @if($businessCard->phone)
                        <div class="contact-item">
                            <span class="contact-label">Phone</span>
                            <span class="contact-value">{{ $businessCard->phone }}</span>
                            <div class="contact-icon">
                                <i class="fas fa-phone-alt"></i>
                            </div>
                        </div>
                    @endif
                    
                    @if($businessCard->location)
                        <div class="contact-item">
                            <span class="contact-label">Address</span>
                            <span class="contact-value">{{ $businessCard->location }}</span>
                            <div class="contact-icon">
                                <i class="fas fa-home"></i>
                            </div>
                        </div>
                    @endif
                    
                    @if($businessCard->email)
                        <div class="contact-item">
                            <span class="contact-label">Email</span>
                            <span class="contact-value">{{ $businessCard->email }}</span>
                            <div class="contact-icon">
                                <i class="fas fa-envelope"></i>
                            </div>
                        </div>
                    @endif
                    
                    @if($businessCard->website)
                        <div class="contact-item">
                            <span class="contact-label">Website</span>
                            <span class="contact-value">{{ $businessCard->website }}</span>
                            <div class="contact-icon">
                                <i class="fas fa-globe"></i>
                            </div>
                        </div>
                    @endif
                </div>
                
                <!-- Additional Information -->
                @if($businessCard->bio)
                    <div class="bio-section">
                        <p class="bio-text">{{ $businessCard->bio }}</p>
                    </div>
                @endif
                
                <!-- Social Links -->
                @if($businessCard->linkedin || $businessCard->facebook || $businessCard->instagram || $businessCard->twitter)
                    <div class="social-section">
                        <div class="social-links">
                            @if($businessCard->linkedin)
                                <a href="{{ $businessCard->linkedin }}" target="_blank" class="social-link">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            @endif
                            @if($businessCard->facebook)
                                <a href="{{ $businessCard->facebook }}" target="_blank" class="social-link">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                            @endif
                            @if($businessCard->instagram)
                                <a href="{{ $businessCard->instagram }}" target="_blank" class="social-link">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            @endif
                            @if($businessCard->twitter)
                                <a href="{{ $businessCard->twitter }}" target="_blank" class="social-link">
                                    <i class="fab fa-twitter"></i>
                                </a>
                            @endif
                        </div>
                    </div>
                @endif

                <!-- QR Code Section -->
                <div class="qr-section">
                    <div class="qr-container">
                        <div class="qr-content">
                            <div id="julianaBusinessCardQR" class="qr-code"></div>
                            <div class="qr-info">
                                <p class="qr-label">Scan Contact</p>
                                <p class="qr-sublabel">Quick save</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Additional Notes -->
                @if($businessCard->additional_notes)
                    <div class="notes-section">
                        <p class="notes-text">{{ $businessCard->additional_notes }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- QR Code Libraries -->
<script src="https://cdn.jsdelivr.net/npm/qrious@4.0.2/dist/qrious.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode-generator/1.4.4/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode/1.5.3/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<style>
    body {
        margin: 0;
        padding: 20px;
        background: #f5f5f5;
        font-family: 'Arial', sans-serif;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .card-container-juliana {
        position: relative;
        display: inline-block;
    }

    /* Download Button Styles */
    .download-button-juliana {
        position: absolute;
        top: -60px;
        right: 0;
        background: linear-gradient(135deg, #0d9488, #14b8a6);
        border: none;
        border-radius: 12px;
        width: 50px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        color: white;
        font-size: 20px;
        box-shadow: 0 8px 25px rgba(13, 148, 136, 0.3);
        transition: all 0.3s ease;
        z-index: 1000;
    }

    .download-button-juliana:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 35px rgba(13, 148, 136, 0.4);
        background: linear-gradient(135deg, #14b8a6, #2dd4bf);
    }

    .download-button-juliana:active {
        transform: translateY(0);
        box-shadow: 0 6px 20px rgba(13, 148, 136, 0.3);
    }

    .download-button-juliana i {
        transition: transform 0.2s ease;
    }

    .download-button-juliana:hover i {
        transform: scale(1.1);
    }

    /* Loading state for download button */
    .download-button-juliana.loading {
        pointer-events: none;
        opacity: 0.7;
    }

    .download-button-juliana.loading i {
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }

    .juliana-silva-card {
        width: 100%;
        max-width: 850px;
        min-height: 500px;
        height: auto;
        background: linear-gradient(135deg, #2dd4bf, #0d9488, #134e4a);
        position: relative;
        overflow: hidden;
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
        margin: 0 auto;
        font-family: 'Arial', sans-serif;
    }

    /* Geometric Background Elements */
    .geometric-container {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        overflow: hidden;
        z-index: 1;
    }

    .geo-element {
        position: absolute;
        background: rgba(255, 255, 255, 0.1);
        transform-origin: center center;
    }

    /* Main diagonal element */
    .element-1 {
        top: -10%;
        left: 25%;
        width: 300px;
        height: 120%;
        background: linear-gradient(45deg, #0f766e, #14b8a6);
        transform: skew(-15deg);
        border-radius: 20px 0 20px 0;
    }

    /* Accent diagonal */
    .element-2 {
        top: -5%;
        left: 15%;
        width: 200px;
        height: 110%;
        background: linear-gradient(45deg, #134e4a, #0f766e);
        transform: skew(-20deg);
        opacity: 0.8;
    }

    /* Bottom geometric shape */
    .element-3 {
        bottom: -10%;
        left: -5%;
        width: 250px;
        height: 200px;
        background: linear-gradient(135deg, #0d9488, #14b8a6);
        transform: skew(15deg) rotate(10deg);
        border-radius: 50px 10px 50px 10px;
        opacity: 0.7;
    }

    /* Top accent shape */
    .element-4 {
        top: 10%;
        right: 15%;
        width: 150px;
        height: 80px;
        background: linear-gradient(45deg, #14b8a6, #2dd4bf);
        transform: skew(-10deg) rotate(25deg);
        border-radius: 20px;
        opacity: 0.6;
    }

    /* Content Container */
    .card-content {
        position: relative;
        z-index: 10;
        display: flex;
        min-height: 500px;
        color: white;
    }

    /* Left Section */
    .left-section {
        flex: 0 0 250px;
        padding: 50px 30px;
        display: flex;
        flex-direction: column;
        justify-content: flex-start;
        align-items: center;
        text-align: center;
    }

    .company-logo-container {
        margin-bottom: 20px;
    }

    .company-logo {
        height: 60px;
        width: auto;
        filter: brightness(0) invert(1);
    }

    .default-company-logo {
        margin-bottom: 20px;
    }

    .logo-symbol {
        width: 60px;
        height: 60px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
    }

    .company-name-section {
        margin-top: auto;
        margin-bottom: auto;
    }

    .company-name {
        font-size: clamp(18px, 4vw, 24px);
        font-weight: 700;
        color: white;
        margin: 0;
        letter-spacing: 1px;
        text-align: center;
        line-height: 1.2;
        transform: rotate(-90deg);
        white-space: nowrap;
    }

    /* Right Section */
    .right-section {
        flex: 1;
        padding: 50px 50px 50px 30px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        background: rgba(0, 0, 0, 0.1);
        backdrop-filter: blur(5px);
    }

    /* Name Section */
    .name-section {
        margin-bottom: 40px;
    }

    .main-name {
        font-size: clamp(32px, 6vw, 48px);
        font-weight: 300;
        color: white;
        margin-bottom: 15px;
        line-height: 1.1;
        letter-spacing: 1px;
    }

    .name-underline {
        width: 80px;
        height: 2px;
        background: white;
        margin-bottom: 15px;
    }

    .job-title {
        font-size: clamp(14px, 2.5vw, 18px);
        font-weight: 400;
        color: white;
        margin: 0;
        opacity: 0.9;
        line-height: 1.2;
    }

    /* Contact Section */
    .contact-section {
        display: flex;
        flex-direction: column;
        gap: 20px;
        margin-bottom: 30px;
    }

    .contact-item {
        display: flex;
        flex-direction: column;
        position: relative;
        padding-right: 60px;
    }

    .contact-label {
        font-size: clamp(12px, 2vw, 14px);
        font-weight: 600;
        color: white;
        margin-bottom: 3px;
        opacity: 0.8;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .contact-value {
        font-size: clamp(14px, 2.5vw, 16px);
        font-weight: 400;
        color: white;
        line-height: 1.3;
    }

    .contact-icon {
        position: absolute;
        top: 50%;
        right: 15px;
        transform: translateY(-50%);
        width: 35px;
        height: 35px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 14px;
    }

    /* Bio Section */
    .bio-section {
        margin-bottom: 25px;
    }

    .bio-text {
        font-size: clamp(12px, 2.2vw, 14px);
        color: white;
        opacity: 0.8;
        line-height: 1.5;
        margin: 0;
        font-style: italic;
    }

    /* Social Section */
    .social-section {
        margin-bottom: 20px;
    }

    .social-links {
        display: flex;
        gap: 10px;
    }

    .social-link {
        width: 35px;
        height: 35px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        text-decoration: none;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .social-link:hover {
        background: rgba(255, 255, 255, 0.3);
        transform: translateY(-2px);
    }

    /* QR Code Section */
    .qr-section {
        margin-bottom: 25px;
        max-width: 280px;
    }

    .qr-container {
        background: rgba(255, 255, 255, 0.15);
        border: 2px solid rgba(255, 255, 255, 0.3);
        border-radius: 12px;
        padding: 15px;
        transition: all 0.3s ease;
    }

    .qr-container:hover {
        background: rgba(255, 255, 255, 0.2);
        border-color: rgba(255, 255, 255, 0.4);
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }

    .qr-content {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .qr-code {
        width: 70px;
        height: 70px;
        flex-shrink: 0;
        background: white;
        border-radius: 8px;
        padding: 4px;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .qr-code canvas,
    .qr-code img {
        width: 100%;
        height: 100%;
        border-radius: 4px;
    }

    .qr-info {
        flex: 1;
    }

    .qr-label {
        font-size: clamp(12px, 2.2vw, 14px);
        font-weight: 600;
        color: white;
        margin: 0 0 2px 0;
        letter-spacing: 0.3px;
    }

    .qr-sublabel {
        font-size: clamp(10px, 1.8vw, 12px);
        color: white;
        margin: 0;
        opacity: 0.8;
        font-style: italic;
    }

    /* Notes Section */
    .notes-section {
    }

    .notes-text {
        font-size: clamp(11px, 2vw, 13px);
        color: white;
        opacity: 0.7;
        line-height: 1.4;
        margin: 0;
    }

    /* Responsive Design */
    @media (max-width: 1000px) {
        .download-button-juliana {
            top: -50px;
            width: 45px;
            height: 45px;
            font-size: 18px;
        }
    }

    @media (max-width: 900px) {
        .juliana-silva-card {
            max-width: 750px;
        }
        
        .left-section {
            flex: 0 0 150px;
            padding: 40px 15px;
        }
        
        .right-section {
            padding: 40px 40px 40px 20px;
        }
        
        .company-name {
            font-size: clamp(14px, 4vw, 20px);
        }

        .qr-code {
            width: 65px;
            height: 65px;
        }

        .download-button-juliana {
            top: -45px;
            width: 42px;
            height: 42px;
            font-size: 17px;
        }
    }

    @media (max-width: 700px) {
        .juliana-silva-card {
            max-width: 500px;
            min-height: 600px;
        }

        .card-content {
            flex-direction: column;
            min-height: auto;
        }

        .left-section {
            flex: 0 0 auto;
            padding: 30px 25px 20px 25px;
            flex-direction: row;
            justify-content: center;
            align-items: center;
            gap: 20px;
            order: 1;
        }

        .company-name-section {
            margin: 0;
        }

        .company-name {
            transform: rotate(0deg);
            font-size: clamp(18px, 5vw, 24px);
        }

        .right-section {
            order: 2;
            flex: 1;
            padding: 20px 25px 30px 25px;
            text-align: center;
        }

        .contact-item {
            text-align: left;
            padding-right: 50px;
        }

        .contact-icon {
            right: 10px;
            width: 30px;
            height: 30px;
            font-size: 12px;
        }

        .social-links {
            justify-content: center;
        }

        .qr-section {
            max-width: 100%;
            display: flex;
            justify-content: center;
        }

        .qr-container {
            max-width: 260px;
        }

        .qr-code {
            width: 70px;
            height: 70px;
        }

        /* Adjust geometric elements for mobile */
        .element-1 {
            left: 15%;
            width: 250px;
        }

        .element-2 {
            left: 5%;
            width: 150px;
        }

        .element-3 {
            bottom: -15%;
            left: -10%;
            width: 200px;
            height: 150px;
        }

        .element-4 {
            top: 5%;
            right: 10%;
            width: 120px;
            height: 60px;
        }

        .download-button-juliana {
            top: -40px;
            width: 40px;
            height: 40px;
            font-size: 16px;
        }
    }

    @media (max-width: 480px) {
        .juliana-silva-card {
            max-width: 400px;
            min-height: 550px;
        }

        .left-section {
            padding: 25px 20px 15px 20px;
        }

        .right-section {
            padding: 15px 20px 25px 20px;
        }

        .logo-symbol {
            width: 50px;
            height: 50px;
            font-size: 20px;
        }

        .company-logo {
            height: 50px;
        }

        .contact-icon {
            width: 28px;
            height: 28px;
            font-size: 11px;
        }

        .social-link {
            width: 30px;
            height: 30px;
            font-size: 12px;
        }

        .contact-item {
            padding-right: 45px;
        }

        .qr-container {
            padding: 12px;
        }

        .qr-content {
            flex-direction: column;
            text-align: center;
            gap: 8px;
        }

        .qr-code {
            width: 75px;
            height: 75px;
        }

        .download-button-juliana {
            top: -35px;
            width: 35px;
            height: 35px;
            font-size: 14px;
        }
    }

    /* Print Styles */
    @media print {
        .download-button-juliana {
            display: none;
        }
        
        .juliana-silva-card {
            width: 850px;
            height: auto;
            min-height: 500px;
            break-inside: avoid;
            box-shadow: none;
        }
        
        .social-link:hover {
            transform: none;
        }
    }
</style>

<script>
// Generate Contact Details QR Code for the Juliana Silva business card
function generateJulianaBusinessCardQR() {
    // Prepare contact details as plain text
    const contactData = generateJulianaContactDetailsText();
    
    const qrContainer = document.getElementById('julianaBusinessCardQR');
    if (!qrContainer) return;
    
    // Clear previous QR code
    qrContainer.innerHTML = '';
    
    // Try different QR generation methods
    try {
        // Method 1: Using QRious (most reliable)
        if (typeof QRious !== 'undefined') {
            generateQRWithQRious(contactData, qrContainer);
        }
        // Method 2: Using QRCode.js
        else if (typeof QRCode !== 'undefined') {
            generateQRWithQRCodeJS(contactData, qrContainer);
        }
        // Method 3: Using qrcode-generator
        else if (typeof qrcode !== 'undefined') {
            generateQRWithQRCodeGenerator(contactData, qrContainer);
        }
        // Fallback: Online service
        else {
            generateQRWithOnlineService(contactData, qrContainer);
        }
    } catch (error) {
        console.error('QR generation failed:', error);
        generateQRWithOnlineService(contactData, qrContainer);
    }
}

// Generate simple contact details as plain text (scannable format)
function generateJulianaContactDetailsText() {
    const name = '{{ $businessCard->name ?? "" }}';
    const title = '{{ $businessCard->title ?? "" }}';
    const company = '{{ $businessCard->company_name ?? "" }}';
    const phone = '{{ $businessCard->phone ?? "" }}';
    const email = '{{ $businessCard->email ?? "" }}';
    const website = '{{ $businessCard->website ?? "" }}';
    const location = '{{ $businessCard->location ?? "" }}';
    
    // Create simple contact information (no emojis, minimal formatting)
    let contactInfo = 'CONTACT DETAILS\n\n';
    
    if (name) {
        contactInfo += `Name: ${name}\n`;
    }
    
    if (title) {
        contactInfo += `Title: ${title}\n`;
    }
    
    if (company) {
        contactInfo += `Company: ${company}\n`;
    }
    
    if (phone) {
        contactInfo += `Phone: ${phone}\n`;
    }
    
    if (email) {
        contactInfo += `Email: ${email}\n`;
    }
    
    if (website) {
        contactInfo += `Website: ${website}\n`;
    }
    
    if (location) {
        contactInfo += `Location: ${location}\n`;
    }
    
    return contactInfo || 'Contact Information';
}

// Method 1: QRious
function generateQRWithQRious(data, container) {
    const canvas = document.createElement('canvas');
    const qr = new QRious({
        element: canvas,
        value: data,
        size: 200,
        level: 'M',
        foreground: '#000000',
        background: '#ffffff'
    });
    container.appendChild(canvas);
}

// Method 2: QRCode.js
function generateQRWithQRCodeJS(data, container) {
    QRCode.toCanvas(container, data, {
        width: 200,
        height: 200,
        colorDark: '#000000',
        colorLight: '#ffffff',
        correctLevel: QRCode.CorrectLevel.M,
        margin: 1
    }, function (error) {
        if (error) {
            console.error('QRCode.js failed:', error);
            generateQRWithOnlineService(data, container);
        }
    });
}

// Method 3: qrcode-generator
function generateQRWithQRCodeGenerator(data, container) {
    const qr = qrcode(0, 'M');
    qr.addData(data);
    qr.make();
    
    const canvas = document.createElement('canvas');
    const ctx = canvas.getContext('2d');
    const modules = qr.getModuleCount();
    const cellSize = 8;
    const margin = 8;
    
    canvas.width = canvas.height = modules * cellSize + margin * 2;
    
    // Fill background
    ctx.fillStyle = '#ffffff';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    
    // Draw QR modules
    ctx.fillStyle = '#000000';
    for (let row = 0; row < modules; row++) {
        for (let col = 0; col < modules; col++) {
            if (qr.isDark(row, col)) {
                ctx.fillRect(
                    col * cellSize + margin,
                    row * cellSize + margin,
                    cellSize,
                    cellSize
                );
            }
        }
    }
    
    container.appendChild(canvas);
}

// Fallback: Online service
function generateQRWithOnlineService(data, container) {
    const encodedData = encodeURIComponent(data);
    const qrApiUrl = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${encodedData}&ecc=M`;
    
    const img = document.createElement('img');
    img.src = qrApiUrl;
    img.alt = 'Contact QR Code';
    img.style.width = '100%';
    img.style.height = '100%';
    
    img.onload = function() {
        container.appendChild(img);
    };
    
    img.onerror = function() {
        container.innerHTML = '<div style="display:flex;align-items:center;justify-content:center;font-size:10px;color:#666;">QR Error</div>';
    };
}

// DOWNLOAD FUNCTIONALITY - Same as other templates
function downloadJulianaBusinessCard() {
    const downloadBtn = document.getElementById('downloadBtnJuliana');
    const businessCard = document.getElementById('julianaBusinessCard');
    
    if (!businessCard) {
        alert('Business card not found!');
        return;
    }

    // Add loading state
    downloadBtn.classList.add('loading');
    downloadBtn.innerHTML = '<i class="fas fa-spinner"></i>';
    
    // Temporarily hide the download button during capture
    downloadBtn.style.display = 'none';
    
    // Configure html2canvas options for high quality
    const options = {
        allowTaint: true,
        useCORS: true,
        backgroundColor: null,
        scale: 3, // Higher scale for better quality
        width: businessCard.scrollWidth,
        height: businessCard.scrollHeight,
        scrollX: 0,
        scrollY: 0,
        windowWidth: window.innerWidth,
        windowHeight: window.innerHeight,
        ignoreElements: function(element) {
            // Ignore any element with download-button class
            return element.classList && element.classList.contains('download-button-juliana');
        }
    };

    // Small delay to ensure button is hidden
    setTimeout(() => {
        // Capture only the business card element
        html2canvas(businessCard, options).then(canvas => {
            try {
                // Create download link using dynamic name
                const businessCardName = '{{ $businessCard->name ?? "juliana-silva" }}';
                const fileName = businessCardName.toLowerCase().replace(/\s+/g, '-').replace(/[^a-z0-9-]/g, '') + '-business-card.png';
                
                const link = document.createElement('a');
                link.download = fileName;
                link.href = canvas.toDataURL('image/png', 1.0);
                
                // Trigger download
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                
                // Show success feedback
                showJulianaDownloadSuccess();
                
            } catch (error) {
                console.error('Download failed:', error);
                alert('Download failed. Please try again.');
            } finally {
                // Show the download button again and reset state
                downloadBtn.style.display = 'flex';
                downloadBtn.classList.remove('loading');
                downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
            }
        }).catch(error => {
            console.error('html2canvas failed:', error);
            alert('Failed to capture business card. Please try again.');
            
            // Show the download button again and reset state
            downloadBtn.style.display = 'flex';
            downloadBtn.classList.remove('loading');
            downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
        });
    }, 50);
}

// Show download success feedback
function showJulianaDownloadSuccess() {
    const downloadBtn = document.getElementById('downloadBtnJuliana');
    
    // Temporarily show success icon
    downloadBtn.innerHTML = '<i class="fas fa-check"></i>';
    downloadBtn.style.background = 'linear-gradient(135deg, #4CAF50, #45a049)';
    
    // Reset after 2 seconds
    setTimeout(() => {
        downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
        downloadBtn.style.background = 'linear-gradient(135deg, #0d9488, #14b8a6)';
    }, 2000);
}

// Initialize QR code when document is ready
document.addEventListener('DOMContentLoaded', function() {
    // Small delay to ensure all libraries are loaded
    setTimeout(generateJulianaBusinessCardQR, 100);
    
    // Add download button event listener
    const downloadBtn = document.getElementById('downloadBtnJuliana');
    if (downloadBtn) {
        downloadBtn.addEventListener('click', downloadJulianaBusinessCard);
    }
});

// Also generate QR if the page is already loaded
if (document.readyState === 'complete') {
    setTimeout(generateJulianaBusinessCardQR, 100);
}
</script>