<div class="card-container-olivia">
    <!-- Download Button -->
    <button id="downloadBtnOlivia" class="download-button-olivia" title="Download Business Card">
        <i class="fas fa-download"></i>
    </button>

    {{-- Template: Olivia Wilson Style - Blue Professional with Wave Design --}}
    <div class="olivia-wilson-card" id="oliviaBusinessCard">
        <!-- Flowing Wave Background Elements -->
        <div class="wave-background">
            <div class="wave-shape wave-1"></div>
            <div class="wave-shape wave-2"></div>
            <div class="wave-shape wave-3"></div>
        </div>
        
        <!-- Main Content Container -->
        <div class="card-container">
            <!-- Left Content Section -->
            <div class="content-section">
                <!-- Company Logo Section -->
                @if($businessCard->company_logo)
                    <div class="company-logo-section">
                        <img src="{{ $businessCard->company_logo_url }}" alt="{{ $businessCard->company_name }}" class="company-logo">
                    </div>
                @endif

                <!-- Name and Title -->
                <div class="header-section">
                    <h1 class="main-name">{{ $businessCard->name }}</h1>
                    @if($businessCard->title)
                        <h2 class="main-title">{{ $businessCard->title }}</h2>
                    @endif
                    <div class="blue-underline"></div>
                </div>
                
                <!-- Contact Information -->
                <div class="contact-section">
                    @if($businessCard->phone)
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fas fa-phone-alt"></i>
                            </div>
                            <div class="contact-details">
                                <span class="contact-text">{{ $businessCard->phone }}</span>
                                @if($businessCard->whatsapp && $businessCard->whatsapp != $businessCard->phone)
                                    <span class="contact-text secondary">{{ $businessCard->whatsapp }}</span>
                                @endif
                            </div>
                        </div>
                    @endif
                    
                    @if($businessCard->website || $businessCard->email)
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fas fa-globe"></i>
                            </div>
                            <div class="contact-details">
                                @if($businessCard->website)
                                    <span class="contact-text">{{ $businessCard->website }}</span>
                                @endif
                                @if($businessCard->email)
                                    <span class="contact-text">{{ $businessCard->email }}</span>
                                @endif
                            </div>
                        </div>
                    @endif
                    
                    @if($businessCard->location)
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <div class="contact-details">
                                <span class="contact-text">{{ $businessCard->location }}</span>
                            </div>
                        </div>
                    @endif
                </div>
                
                <!-- Additional Information -->
                @if($businessCard->bio)
                    <div class="bio-section">
                        <p class="bio-text">{{ $businessCard->bio }}</p>
                    </div>
                @endif
                
                <!-- Company Information -->
                @if($businessCard->company_name)
                    <div class="company-section">
                        <p class="company-text">{{ $businessCard->company_name }}</p>
                    </div>
                @endif
                
                <!-- Social Links -->
                @if($businessCard->linkedin || $businessCard->facebook || $businessCard->instagram || $businessCard->twitter)
                    <div class="social-section">
                        <div class="social-links">
                            @if($businessCard->linkedin)
                                <a href="{{ $businessCard->linkedin }}" target="_blank" class="social-link">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            @endif
                            @if($businessCard->facebook)
                                <a href="{{ $businessCard->facebook }}" target="_blank" class="social-link">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                            @endif
                            @if($businessCard->instagram)
                                <a href="{{ $businessCard->instagram }}" target="_blank" class="social-link">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            @endif
                            @if($businessCard->twitter)
                                <a href="{{ $businessCard->twitter }}" target="_blank" class="social-link">
                                    <i class="fab fa-twitter"></i>
                                </a>
                            @endif
                        </div>
                    </div>
                @endif

                <!-- QR Code Section -->
                <div class="qr-section">
                    <div class="qr-container">
                        <div class="qr-content">
                            <div id="oliviaBusinessCardQR" class="qr-code"></div>
                            <div class="qr-info">
                                <p class="qr-label">Scan for Contact</p>
                                <p class="qr-sublabel">Quick access</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Additional Notes -->
                @if($businessCard->additional_notes)
                    <div class="notes-section">
                        <p class="notes-text">{{ $businessCard->additional_notes }}</p>
                    </div>
                @endif
            </div>
            
            <!-- Right Profile Section -->
            <div class="profile-section">
                @if($businessCard->profile_photo)
                    <div class="profile-photo-container">
                        <div class="profile-photo-border">
                            <img src="{{ $businessCard->profile_photo_url }}" alt="{{ $businessCard->name }}" class="profile-photo">
                        </div>
                    </div>
                @else
                    <div class="profile-photo-container">
                        <div class="profile-initials-container">
                            <div class="profile-initials">
                                {{ strtoupper(substr($businessCard->name, 0, 2)) }}
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- QR Code Libraries -->
<script src="https://cdn.jsdelivr.net/npm/qrious@4.0.2/dist/qrious.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode-generator/1.4.4/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode/1.5.3/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<style>
    body {
        margin: 0;
        padding: 20px;
        background: #f5f5f5;
        font-family: 'Arial', sans-serif;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .card-container-olivia {
        position: relative;
        display: inline-block;
    }

    /* Download Button Styles */
    .download-button-olivia {
        position: absolute;
        top: -60px;
        right: 0;
        background: linear-gradient(135deg, #2563eb, #3b82f6);
        border: none;
        border-radius: 12px;
        width: 50px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        color: white;
        font-size: 20px;
        box-shadow: 0 8px 25px rgba(37, 99, 235, 0.3);
        transition: all 0.3s ease;
        z-index: 1000;
    }

    .download-button-olivia:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 35px rgba(37, 99, 235, 0.4);
        background: linear-gradient(135deg, #3b82f6, #60a5fa);
    }

    .download-button-olivia:active {
        transform: translateY(0);
        box-shadow: 0 6px 20px rgba(37, 99, 235, 0.3);
    }

    .download-button-olivia i {
        transition: transform 0.2s ease;
    }

    .download-button-olivia:hover i {
        transform: scale(1.1);
    }

    /* Loading state for download button */
    .download-button-olivia.loading {
        pointer-events: none;
        opacity: 0.7;
    }

    .download-button-olivia.loading i {
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }

    .olivia-wilson-card {
        width: 100%;
        max-width: 850px;
        min-height: 500px;
        height: auto;
        background: #f8f9fa;
        position: relative;
        overflow: hidden;
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
        margin: 0 auto;
        font-family: 'Arial', sans-serif;
    }

    /* Wave Background Elements */
    .wave-background {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        overflow: hidden;
        z-index: 1;
    }

    .wave-shape {
        position: absolute;
        background: linear-gradient(135deg, #2563eb, #3b82f6);
        border-radius: 50px;
    }

    /* Main flowing wave from bottom */
    .wave-1 {
        bottom: -10%;
        left: -5%;
        width: 80%;
        height: 200px;
        background: linear-gradient(135deg, #1e40af, #2563eb);
        transform: rotate(-15deg);
        border-radius: 100px 100px 0 0;
    }

    /* Upper curved element */
    .wave-2 {
        top: -5%;
        right: 10%;
        width: 60%;
        height: 150px;
        background: linear-gradient(135deg, #3b82f6, #60a5fa);
        transform: rotate(20deg);
        border-radius: 0 0 100px 100px;
    }

    /* Accent wave */
    .wave-3 {
        top: 30%;
        right: -10%;
        width: 40%;
        height: 120px;
        background: linear-gradient(135deg, #60a5fa, #93c5fd);
        transform: rotate(-25deg);
        border-radius: 60px;
        opacity: 0.8;
    }

    /* Main Content Container */
    .card-container {
        position: relative;
        z-index: 10;
        display: flex;
        align-items: center;
        min-height: 500px;
        padding: 0;
    }

    /* Left Content Section */
    .content-section {
        flex: 1;
        padding: 50px 40px 50px 50px;
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        max-width: 60%;
    }

    /* Company Logo Section */
    .company-logo-section {
        margin-bottom: 20px;
        text-align: left;
    }

    .company-logo {
        height: 45px;
        width: auto;
        max-width: 200px;
        filter: brightness(0) saturate(100%) invert(25%) sepia(85%) saturate(1352%) hue-rotate(208deg) brightness(97%) contrast(91%);
        opacity: 0.9;
    }

    /* Header Section */
    .header-section {
        margin-bottom: 35px;
    }

    .main-name {
        font-size: clamp(32px, 5.5vw, 48px);
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 8px;
        line-height: 1.1;
        letter-spacing: -0.5px;
    }

    .main-title {
        font-size: clamp(16px, 3vw, 20px);
        font-weight: 400;
        color: #6b7280;
        margin-bottom: 15px;
        line-height: 1.2;
    }

    .blue-underline {
        width: 60px;
        height: 3px;
        background: linear-gradient(90deg, #2563eb, #3b82f6);
        border-radius: 2px;
    }

    /* Contact Section */
    .contact-section {
        display: flex;
        flex-direction: column;
        gap: 20px;
        margin-bottom: 30px;
    }

    .contact-item {
        display: flex;
        align-items: flex-start;
        gap: 15px;
    }

    .contact-icon {
        width: 45px;
        height: 45px;
        background: linear-gradient(135deg, #2563eb, #3b82f6);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
    }

    .contact-icon i {
        font-size: 16px;
        color: white;
    }

    .contact-details {
        display: flex;
        flex-direction: column;
        gap: 3px;
        padding-top: 5px;
    }

    .contact-text {
        font-size: clamp(14px, 2.5vw, 16px);
        color: #374151;
        font-weight: 500;
        line-height: 1.3;
    }

    .contact-text.secondary {
        font-size: clamp(13px, 2.3vw, 15px);
        color: #6b7280;
    }

    /* Bio Section */
    .bio-section {
        margin-bottom: 25px;
    }

    .bio-text {
        font-size: clamp(13px, 2.3vw, 15px);
        color: #6b7280;
        line-height: 1.5;
        margin: 0;
        font-style: italic;
    }

    /* Company Section */
    .company-section {
        margin-bottom: 25px;
    }

    .company-text {
        font-size: clamp(14px, 2.5vw, 16px);
        color: #374151;
        font-weight: 600;
        margin: 0;
    }

    /* Social Section */
    .social-section {
        margin-bottom: 20px;
    }

    .social-links {
        display: flex;
        gap: 12px;
    }

    .social-link {
        width: 35px;
        height: 35px;
        background: linear-gradient(135deg, #2563eb, #3b82f6);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        text-decoration: none;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .social-link:hover {
        background: linear-gradient(135deg, #1d4ed8, #2563eb);
        transform: translateY(-2px);
    }

    /* QR Code Section */
    .qr-section {
        margin-bottom: 25px;
        max-width: 280px;
    }

    .qr-container {
        background: linear-gradient(135deg, rgba(37, 99, 235, 0.05), rgba(59, 130, 246, 0.05));
        border: 2px solid rgba(37, 99, 235, 0.2);
        border-radius: 12px;
        padding: 15px;
        transition: all 0.3s ease;
    }

    .qr-container:hover {
        background: linear-gradient(135deg, rgba(37, 99, 235, 0.08), rgba(59, 130, 246, 0.08));
        border-color: rgba(37, 99, 235, 0.3);
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(37, 99, 235, 0.1);
    }

    .qr-content {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .qr-code {
        width: 70px;
        height: 70px;
        flex-shrink: 0;
        background: white;
        border-radius: 8px;
        padding: 4px;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .qr-code canvas,
    .qr-code img {
        width: 100%;
        height: 100%;
        border-radius: 4px;
    }

    .qr-info {
        flex: 1;
    }

    .qr-label {
        font-size: clamp(12px, 2.2vw, 14px);
        font-weight: 600;
        color: #2563eb;
        margin: 0 0 2px 0;
        letter-spacing: 0.3px;
    }

    .qr-sublabel {
        font-size: clamp(10px, 1.8vw, 12px);
        color: #6b7280;
        margin: 0;
        font-style: italic;
    }

    /* Notes Section */
    .notes-section {
    }

    .notes-text {
        font-size: clamp(12px, 2.1vw, 14px);
        color: #6b7280;
        line-height: 1.4;
        margin: 0;
    }

    /* Profile Section */
    .profile-section {
        flex: 0 0 350px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 50px 40px;
        position: relative;
    }

    .profile-photo-container {
        position: relative;
        z-index: 5;
    }

    .profile-photo-border {
        width: 250px;
        height: 250px;
        border-radius: 50%;
        padding: 8px;
        background: linear-gradient(135deg, #2563eb, #60a5fa);
        box-shadow: 0 20px 40px rgba(37, 99, 235, 0.3);
    }

    .profile-photo {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        object-fit: cover;
        background: white;
    }

    .profile-initials-container {
        width: 250px;
        height: 250px;
        border-radius: 50%;
        padding: 8px;
        background: linear-gradient(135deg, #2563eb, #60a5fa);
        box-shadow: 0 20px 40px rgba(37, 99, 235, 0.3);
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .profile-initials {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 72px;
        font-weight: 700;
        color: #2563eb;
    }

    /* Responsive Design */
    @media (max-width: 1000px) {
        .download-button-olivia {
            top: -50px;
            width: 45px;
            height: 45px;
            font-size: 18px;
        }
    }

    @media (max-width: 900px) {
        .olivia-wilson-card {
            max-width: 750px;
        }
        
        .content-section {
            padding: 40px 35px 40px 40px;
            max-width: 65%;
        }
        
        .profile-section {
            flex: 0 0 300px;
            padding: 40px 30px;
        }
        
        .profile-photo-border,
        .profile-initials-container {
            width: 220px;
            height: 220px;
        }
        
        .profile-initials {
            font-size: 64px;
        }

        .qr-code {
            width: 65px;
            height: 65px;
        }

        .download-button-olivia {
            top: -45px;
            width: 42px;
            height: 42px;
            font-size: 17px;
        }
    }

    @media (max-width: 700px) {
        .olivia-wilson-card {
            max-width: 500px;
            min-height: 600px;
        }

        .card-container {
            flex-direction: column;
            min-height: auto;
        }

        .content-section {
            order: 2;
            max-width: 100%;
            padding: 30px 25px 40px 25px;
            text-align: center;
        }

        .profile-section {
            order: 1;
            flex: 0 0 auto;
            padding: 30px 25px 20px 25px;
        }

        .profile-photo-border,
        .profile-initials-container {
            width: 180px;
            height: 180px;
        }

        .profile-initials {
            font-size: 54px;
        }

        .contact-item {
            justify-content: center;
        }

        .social-links {
            justify-content: center;
        }

        .qr-section {
            max-width: 100%;
            display: flex;
            justify-content: center;
        }

        .qr-container {
            max-width: 260px;
        }

        .qr-code {
            width: 70px;
            height: 70px;
        }

        /* Adjust wave shapes for mobile */
        .wave-1 {
            bottom: -15%;
            left: -10%;
            width: 90%;
            height: 150px;
        }

        .wave-2 {
            top: -10%;
            right: 5%;
            width: 70%;
            height: 120px;
        }

        .wave-3 {
            top: 25%;
            right: -15%;
            width: 50%;
            height: 100px;
        }

        .download-button-olivia {
            top: -40px;
            width: 40px;
            height: 40px;
            font-size: 16px;
        }
    }

    @media (max-width: 480px) {
        .olivia-wilson-card {
            max-width: 400px;
            min-height: 550px;
        }

        .content-section {
            padding: 25px 20px 35px 20px;
        }

        .profile-section {
            padding: 25px 20px 15px 20px;
        }

        .profile-photo-border,
        .profile-initials-container {
            width: 150px;
            height: 150px;
        }

        .profile-initials {
            font-size: 42px;
        }

        .contact-icon {
            width: 40px;
            height: 40px;
        }

        .contact-icon i {
            font-size: 14px;
        }

        .social-link {
            width: 30px;
            height: 30px;
            font-size: 12px;
        }

        .qr-container {
            padding: 12px;
        }

        .qr-content {
            flex-direction: column;
            text-align: center;
            gap: 8px;
        }

        .qr-code {
            width: 75px;
            height: 75px;
        }

        .download-button-olivia {
            top: -35px;
            width: 35px;
            height: 35px;
            font-size: 14px;
        }
    }

    /* Print Styles */
    @media print {
        .download-button-olivia {
            display: none;
        }
        
        .olivia-wilson-card {
            width: 850px;
            height: auto;
            min-height: 500px;
            break-inside: avoid;
            box-shadow: none;
        }
        
        .social-link:hover {
            transform: none;
        }
    }
</style>

<script>
// Generate Contact Details QR Code for the Olivia Wilson business card
function generateOliviaBusinessCardQR() {
    // Prepare contact details as plain text
    const contactData = generateOliviaContactDetailsText();
    
    const qrContainer = document.getElementById('oliviaBusinessCardQR');
    if (!qrContainer) return;
    
    // Clear previous QR code
    qrContainer.innerHTML = '';
    
    // Try different QR generation methods
    try {
        // Method 1: Using QRious (most reliable)
        if (typeof QRious !== 'undefined') {
            generateQRWithQRious(contactData, qrContainer);
        }
        // Method 2: Using QRCode.js
        else if (typeof QRCode !== 'undefined') {
            generateQRWithQRCodeJS(contactData, qrContainer);
        }
        // Method 3: Using qrcode-generator
        else if (typeof qrcode !== 'undefined') {
            generateQRWithQRCodeGenerator(contactData, qrContainer);
        }
        // Fallback: Online service
        else {
            generateQRWithOnlineService(contactData, qrContainer);
        }
    } catch (error) {
        console.error('QR generation failed:', error);
        generateQRWithOnlineService(contactData, qrContainer);
    }
}

// Generate simple contact details as plain text (scannable format)
function generateOliviaContactDetailsText() {
    const name = '{{ $businessCard->name ?? "" }}';
    const title = '{{ $businessCard->title ?? "" }}';
    const company = '{{ $businessCard->company_name ?? "" }}';
    const phone = '{{ $businessCard->phone ?? "" }}';
    const email = '{{ $businessCard->email ?? "" }}';
    const website = '{{ $businessCard->website ?? "" }}';
    const location = '{{ $businessCard->location ?? "" }}';
    
    // Create simple contact information (no emojis, minimal formatting)
    let contactInfo = 'CONTACT DETAILS\n\n';
    
    if (name) {
        contactInfo += `Name: ${name}\n`;
    }
    
    if (title) {
        contactInfo += `Title: ${title}\n`;
    }
    
    if (company) {
        contactInfo += `Company: ${company}\n`;
    }
    
    if (phone) {
        contactInfo += `Phone: ${phone}\n`;
    }
    
    if (email) {
        contactInfo += `Email: ${email}\n`;
    }
    
    if (website) {
        contactInfo += `Website: ${website}\n`;
    }
    
    if (location) {
        contactInfo += `Location: ${location}\n`;
    }
    
    return contactInfo || 'Contact Information';
}

// Method 1: QRious
function generateQRWithQRious(data, container) {
    const canvas = document.createElement('canvas');
    const qr = new QRious({
        element: canvas,
        value: data,
        size: 200,
        level: 'M',
        foreground: '#000000',
        background: '#ffffff'
    });
    container.appendChild(canvas);
}

// Method 2: QRCode.js
function generateQRWithQRCodeJS(data, container) {
    QRCode.toCanvas(container, data, {
        width: 200,
        height: 200,
        colorDark: '#000000',
        colorLight: '#ffffff',
        correctLevel: QRCode.CorrectLevel.M,
        margin: 1
    }, function (error) {
        if (error) {
            console.error('QRCode.js failed:', error);
            generateQRWithOnlineService(data, container);
        }
    });
}

// Method 3: qrcode-generator
function generateQRWithQRCodeGenerator(data, container) {
    const qr = qrcode(0, 'M');
    qr.addData(data);
    qr.make();
    
    const canvas = document.createElement('canvas');
    const ctx = canvas.getContext('2d');
    const modules = qr.getModuleCount();
    const cellSize = 8;
    const margin = 8;
    
    canvas.width = canvas.height = modules * cellSize + margin * 2;
    
    // Fill background
    ctx.fillStyle = '#ffffff';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    
    // Draw QR modules
    ctx.fillStyle = '#000000';
    for (let row = 0; row < modules; row++) {
        for (let col = 0; col < modules; col++) {
            if (qr.isDark(row, col)) {
                ctx.fillRect(
                    col * cellSize + margin,
                    row * cellSize + margin,
                    cellSize,
                    cellSize
                );
            }
        }
    }
    
    container.appendChild(canvas);
}

// Fallback: Online service
function generateQRWithOnlineService(data, container) {
    const encodedData = encodeURIComponent(data);
    const qrApiUrl = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${encodedData}&ecc=M`;
    
    const img = document.createElement('img');
    img.src = qrApiUrl;
    img.alt = 'Contact QR Code';
    img.style.width = '100%';
    img.style.height = '100%';
    
    img.onload = function() {
        container.appendChild(img);
    };
    
    img.onerror = function() {
        container.innerHTML = '<div style="display:flex;align-items:center;justify-content:center;font-size:10px;color:#666;">QR Error</div>';
    };
}

// DOWNLOAD FUNCTIONALITY - Same as other templates
function downloadOliviaBusinessCard() {
    const downloadBtn = document.getElementById('downloadBtnOlivia');
    const businessCard = document.getElementById('oliviaBusinessCard');
    
    if (!businessCard) {
        alert('Business card not found!');
        return;
    }

    // Add loading state
    downloadBtn.classList.add('loading');
    downloadBtn.innerHTML = '<i class="fas fa-spinner"></i>';
    
    // Temporarily hide the download button during capture
    downloadBtn.style.display = 'none';
    
    // Configure html2canvas options for high quality
    const options = {
        allowTaint: true,
        useCORS: true,
        backgroundColor: null,
        scale: 3, // Higher scale for better quality
        width: businessCard.scrollWidth,
        height: businessCard.scrollHeight,
        scrollX: 0,
        scrollY: 0,
        windowWidth: window.innerWidth,
        windowHeight: window.innerHeight,
        ignoreElements: function(element) {
            // Ignore any element with download-button class
            return element.classList && element.classList.contains('download-button-olivia');
        }
    };

    // Small delay to ensure button is hidden
    setTimeout(() => {
        // Capture only the business card element
        html2canvas(businessCard, options).then(canvas => {
            try {
                // Create download link using dynamic name
                const businessCardName = '{{ $businessCard->name ?? "olivia-wilson" }}';
                const fileName = businessCardName.toLowerCase().replace(/\s+/g, '-').replace(/[^a-z0-9-]/g, '') + '-business-card.png';
                
                const link = document.createElement('a');
                link.download = fileName;
                link.href = canvas.toDataURL('image/png', 1.0);
                
                // Trigger download
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                
                // Show success feedback
                showOliviaDownloadSuccess();
                
            } catch (error) {
                console.error('Download failed:', error);
                alert('Download failed. Please try again.');
            } finally {
                // Show the download button again and reset state
                downloadBtn.style.display = 'flex';
                downloadBtn.classList.remove('loading');
                downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
            }
        }).catch(error => {
            console.error('html2canvas failed:', error);
            alert('Failed to capture business card. Please try again.');
            
            // Show the download button again and reset state
            downloadBtn.style.display = 'flex';
            downloadBtn.classList.remove('loading');
            downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
        });
    }, 50);
}

// Show download success feedback
function showOliviaDownloadSuccess() {
    const downloadBtn = document.getElementById('downloadBtnOlivia');
    
    // Temporarily show success icon
    downloadBtn.innerHTML = '<i class="fas fa-check"></i>';
    downloadBtn.style.background = 'linear-gradient(135deg, #4CAF50, #45a049)';
    
    // Reset after 2 seconds
    setTimeout(() => {
        downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
        downloadBtn.style.background = 'linear-gradient(135deg, #2563eb, #3b82f6)';
    }, 2000);
}

// Initialize QR code when document is ready
document.addEventListener('DOMContentLoaded', function() {
    // Small delay to ensure all libraries are loaded
    setTimeout(generateOliviaBusinessCardQR, 100);
    
    // Add download button event listener
    const downloadBtn = document.getElementById('downloadBtnOlivia');
    if (downloadBtn) {
        downloadBtn.addEventListener('click', downloadOliviaBusinessCard);
    }
});

// Also generate QR if the page is already loaded
if (document.readyState === 'complete') {
    setTimeout(generateOliviaBusinessCardQR, 100);
}
</script>