<div class="card-container-dani">
    <!-- Download Button -->
    <button id="downloadBtnDani" class="download-button-dani" title="Download Business Card">
        <i class="fas fa-download"></i>
    </button>

    {{-- Template: Dani Martinez Style - Green Professional with QR Code --}}
    <div class="dani-martinez-card" id="daniBusinessCard">
        <!-- Geometric Background Shapes -->
        <div class="geometric-background">
            <div class="geo-shape shape-1"></div>
            <div class="geo-shape shape-2"></div>
            <div class="geo-shape shape-3"></div>
            <div class="geo-shape shape-4"></div>
            <div class="geo-shape shape-5"></div>
        </div>
        
        <!-- Main Content Container -->
        <div class="card-content">
            <!-- Company Logo Section -->
            <div class="company-header">
                @if($businessCard->company_logo)
                    <div class="company-logo">
                        <img src="{{ $businessCard->company_logo_url }}" alt="{{ $businessCard->company_name }}">
                    </div>
                @else
                    <div class="default-logo">
                        <div class="logo-circle">
                            <i class="fas fa-building"></i>
                        </div>
                    </div>
                @endif
                
                @if($businessCard->company_name)
                    <div class="company-text">
                        <span class="company-name">{{ strtoupper($businessCard->company_name) }}</span>
                    </div>
                @endif
            </div>
            
            <!-- Name and Title Section -->
            <div class="name-section">
                <h1 class="main-name">{{ strtoupper($businessCard->name) }}</h1>
                @if($businessCard->title)
                    <h2 class="main-title">{{ strtoupper($businessCard->title) }}</h2>
                @endif
            </div>
            
            <!-- Contact Information -->
            <div class="contact-section">
                @if($businessCard->phone)
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-phone-alt"></i>
                        </div>
                        <span class="contact-text">{{ $businessCard->phone }}</span>
                    </div>
                @endif
                
                @if($businessCard->website)
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-globe"></i>
                        </div>
                        <span class="contact-text">{{ $businessCard->website }}</span>
                    </div>
                @endif
                
                @if($businessCard->email)
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <span class="contact-text">{{ $businessCard->email }}</span>
                    </div>
                @endif
                
                @if($businessCard->location)
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <span class="contact-text">{{ $businessCard->location }}</span>
                    </div>
                @endif
            </div>
            
            <!-- Additional Information -->
            @if($businessCard->bio)
                <div class="bio-section">
                    <p class="bio-text">{{ $businessCard->bio }}</p>
                </div>
            @endif
            
            <!-- Social Links -->
            @if($businessCard->linkedin || $businessCard->facebook || $businessCard->instagram || $businessCard->twitter)
                <div class="social-section">
                    <div class="social-links">
                        @if($businessCard->linkedin)
                            <a href="{{ $businessCard->linkedin }}" target="_blank" class="social-link">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        @endif
                        @if($businessCard->facebook)
                            <a href="{{ $businessCard->facebook }}" target="_blank" class="social-link">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        @endif
                        @if($businessCard->instagram)
                            <a href="{{ $businessCard->instagram }}" target="_blank" class="social-link">
                                <i class="fab fa-instagram"></i>
                            </a>
                        @endif
                        @if($businessCard->twitter)
                            <a href="{{ $businessCard->twitter }}" target="_blank" class="social-link">
                                <i class="fab fa-twitter"></i>
                            </a>
                        @endif
                    </div>
                </div>
            @endif

            <!-- QR Code Section -->
            <div class="qr-section">
                <div class="qr-container">
                    <div class="qr-content">
                        <div id="daniBusinessCardQR" class="qr-code"></div>
                        <div class="qr-info">
                            <p class="qr-label">Scan for Contact Details</p>
                            <p class="qr-sublabel">Quick access to all info</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Additional Notes -->
            @if($businessCard->additional_notes)
                <div class="notes-section">
                    <p class="notes-text">{{ $businessCard->additional_notes }}</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- QR Code Libraries -->
<script src="https://cdn.jsdelivr.net/npm/qrious@4.0.2/dist/qrious.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode-generator/1.4.4/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode/1.5.3/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<style>
    body {
        margin: 0;
        padding: 20px;
        background: #f5f5f5;
        font-family: 'Arial', sans-serif;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .card-container-dani {
        position: relative;
        display: inline-block;
    }

    /* Download Button Styles */
    .download-button-dani {
        position: absolute;
        top: -60px;
        right: 0;
        background: linear-gradient(135deg, #16a34a, #22c55e);
        border: none;
        border-radius: 12px;
        width: 50px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        color: white;
        font-size: 20px;
        box-shadow: 0 8px 25px rgba(22, 163, 74, 0.3);
        transition: all 0.3s ease;
        z-index: 1000;
    }

    .download-button-dani:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 35px rgba(22, 163, 74, 0.4);
        background: linear-gradient(135deg, #22c55e, #4ade80);
    }

    .download-button-dani:active {
        transform: translateY(0);
        box-shadow: 0 6px 20px rgba(22, 163, 74, 0.3);
    }

    .download-button-dani i {
        transition: transform 0.2s ease;
    }

    .download-button-dani:hover i {
        transform: scale(1.1);
    }

    /* Loading state for download button */
    .download-button-dani.loading {
        pointer-events: none;
        opacity: 0.7;
    }

    .download-button-dani.loading i {
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }

    .dani-martinez-card {
        width: 100%;
        max-width: 850px;
        min-height: 500px;
        height: auto;
        background: #ffffff;
        position: relative;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        margin: 0 auto;
        font-family: 'Arial', sans-serif;
    }

    /* Geometric Background Shapes */
    .geometric-background {
        position: absolute;
        top: 0;
        right: 0;
        width: 100%;
        height: 100%;
        overflow: hidden;
        z-index: 1;
    }

    .geo-shape {
        position: absolute;
        background: #22c55e;
    }

    /* Shape 1 - Large diamond top right */
    .shape-1 {
        top: -15%;
        right: -8%;
        width: 200px;
        height: 200px;
        background: linear-gradient(135deg, #16a34a, #22c55e);
        transform: rotate(45deg);
        clip-path: polygon(50% 0%, 100% 50%, 50% 100%, 0% 50%);
    }

    /* Shape 2 - Medium diamond middle right */
    .shape-2 {
        top: 25%;
        right: 8%;
        width: 120px;
        height: 120px;
        background: linear-gradient(135deg, #22c55e, #4ade80);
        transform: rotate(45deg);
        clip-path: polygon(50% 0%, 100% 50%, 50% 100%, 0% 50%);
    }

    /* Shape 3 - Small diamond bottom right */
    .shape-3 {
        bottom: 10%;
        right: -5%;
        width: 150px;
        height: 150px;
        background: linear-gradient(135deg, #15803d, #16a34a);
        transform: rotate(45deg);
        clip-path: polygon(50% 0%, 100% 50%, 50% 100%, 0% 50%);
    }

    /* Shape 4 - Triangle top */
    .shape-4 {
        top: 0;
        right: 25%;
        width: 0;
        height: 0;
        border-left: 80px solid transparent;
        border-right: 80px solid transparent;
        border-bottom: 60px solid #4ade80;
        background: none;
    }

    /* Shape 5 - Small accent shape */
    .shape-5 {
        top: 40%;
        right: 20%;
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #4ade80, #86efac);
        transform: rotate(45deg);
        border-radius: 8px;
    }

    /* Main Content */
    .card-content {
        position: relative;
        z-index: 10;
        padding: 50px;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        background: rgba(255, 255, 255, 0.98);
    }

    /* Company Header */
    .company-header {
        display: flex;
        align-items: center;
        gap: 15px;
        margin-bottom: 40px;
    }

    .company-logo img {
        height: 50px;
        width: auto;
    }

    .default-logo {
        display: flex;
        align-items: center;
    }

    .logo-circle {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, #16a34a, #22c55e);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 20px;
    }

    .company-text {
        display: flex;
        flex-direction: column;
    }

    .company-name {
        font-size: clamp(16px, 3vw, 20px);
        font-weight: 700;
        color: #1f2937;
        line-height: 1.2;
        letter-spacing: 0.5px;
    }

    /* Name and Title Section */
    .name-section {
        margin-bottom: 35px;
        max-width: 60%;
    }

    .main-name {
        font-size: clamp(32px, 6vw, 48px);
        font-weight: 800;
        color: #16a34a;
        margin-bottom: 8px;
        line-height: 1.1;
        letter-spacing: 1px;
    }

    .main-title {
        font-size: clamp(16px, 3vw, 22px);
        font-weight: 400;
        color: #1f2937;
        font-style: italic;
        margin: 0;
        line-height: 1.2;
    }

    /* Contact Section */
    .contact-section {
        display: flex;
        flex-direction: column;
        gap: 15px;
        margin-bottom: 30px;
        max-width: 65%;
    }

    .contact-item {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .contact-icon {
        width: 20px;
        height: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .contact-icon i {
        font-size: 16px;
        color: #16a34a;
    }

    .contact-text {
        font-size: clamp(14px, 2.5vw, 16px);
        color: #374151;
        font-weight: 500;
        line-height: 1.3;
    }

    /* Bio Section */
    .bio-section {
        margin-bottom: 25px;
        max-width: 70%;
    }

    .bio-text {
        font-size: clamp(12px, 2.2vw, 14px);
        color: #6b7280;
        line-height: 1.5;
        margin: 0;
        font-style: italic;
    }

    /* Social Section */
    .social-section {
        margin-bottom: 25px;
    }

    .social-links {
        display: flex;
        gap: 12px;
    }

    .social-link {
        width: 35px;
        height: 35px;
        background: linear-gradient(135deg, #16a34a, #22c55e);
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        text-decoration: none;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .social-link:hover {
        background: linear-gradient(135deg, #22c55e, #4ade80);
        transform: translateY(-2px);
    }

    /* QR Code Section */
    .qr-section {
        margin-bottom: 25px;
        max-width: 300px;
    }

    .qr-container {
        background: linear-gradient(135deg, rgba(22, 163, 74, 0.05), rgba(34, 197, 94, 0.05));
        border: 2px solid rgba(22, 163, 74, 0.2);
        border-radius: 12px;
        padding: 20px;
        transition: all 0.3s ease;
    }

    .qr-container:hover {
        background: linear-gradient(135deg, rgba(22, 163, 74, 0.08), rgba(34, 197, 94, 0.08));
        border-color: rgba(22, 163, 74, 0.3);
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(22, 163, 74, 0.1);
    }

    .qr-content {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .qr-code {
        width: 80px;
        height: 80px;
        flex-shrink: 0;
        background: white;
        border-radius: 8px;
        padding: 4px;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .qr-code canvas,
    .qr-code img {
        width: 100%;
        height: 100%;
        border-radius: 4px;
    }

    .qr-info {
        flex: 1;
    }

    .qr-label {
        font-size: clamp(13px, 2.5vw, 16px);
        font-weight: 600;
        color: #16a34a;
        margin: 0 0 4px 0;
        letter-spacing: 0.3px;
    }

    .qr-sublabel {
        font-size: clamp(11px, 2vw, 13px);
        color: #6b7280;
        margin: 0;
        font-style: italic;
    }

    /* Notes Section */
    .notes-section {
        max-width: 70%;
    }

    .notes-text {
        font-size: clamp(11px, 2vw, 13px);
        color: #6b7280;
        line-height: 1.4;
        margin: 0;
        text-align: left;
    }

    /* Responsive Design */
    @media (max-width: 1000px) {
        .download-button-dani {
            top: -50px;
            width: 45px;
            height: 45px;
            font-size: 18px;
        }
    }

    @media (max-width: 900px) {
        .dani-martinez-card {
            max-width: 750px;
        }
        
        .card-content {
            padding: 40px;
        }
        
        .name-section,
        .contact-section,
        .bio-section,
        .notes-section {
            max-width: 75%;
        }

        .qr-section {
            max-width: 280px;
        }

        .qr-code {
            width: 75px;
            height: 75px;
        }

        .download-button-dani {
            top: -45px;
            width: 42px;
            height: 42px;
            font-size: 17px;
        }
    }

    @media (max-width: 700px) {
        .dani-martinez-card {
            max-width: 500px;
            min-height: 650px;
        }

        .card-content {
            padding: 30px 25px;
        }

        .company-header {
            margin-bottom: 30px;
        }

        .name-section {
            margin-bottom: 25px;
            max-width: 85%;
        }

        .contact-section {
            gap: 12px;
            margin-bottom: 25px;
            max-width: 85%;
        }

        .contact-item {
            gap: 10px;
        }

        .bio-section,
        .notes-section {
            max-width: 85%;
        }

        .qr-section {
            max-width: 100%;
            margin-bottom: 20px;
        }

        .qr-container {
            padding: 15px;
        }

        .qr-content {
            gap: 12px;
        }

        .qr-code {
            width: 70px;
            height: 70px;
        }

        /* Adjust geometric shapes for mobile */
        .shape-1 {
            top: -20%;
            right: -15%;
            width: 150px;
            height: 150px;
        }

        .shape-2 {
            top: 20%;
            right: 5%;
            width: 100px;
            height: 100px;
        }

        .shape-3 {
            bottom: 5%;
            right: -10%;
            width: 120px;
            height: 120px;
        }

        .shape-4 {
            right: 20%;
            border-left-width: 60px;
            border-right-width: 60px;
            border-bottom-width: 45px;
        }

        .shape-5 {
            width: 40px;
            height: 40px;
        }

        .download-button-dani {
            top: -40px;
            width: 40px;
            height: 40px;
            font-size: 16px;
        }
    }

    @media (max-width: 480px) {
        .dani-martinez-card {
            max-width: 400px;
            min-height: 600px;
        }

        .card-content {
            padding: 25px 20px;
        }

        .company-header {
            gap: 10px;
            margin-bottom: 25px;
        }

        .logo-circle {
            width: 40px;
            height: 40px;
            font-size: 16px;
        }

        .company-name {
            font-size: clamp(14px, 4vw, 18px);
        }

        .name-section {
            margin-bottom: 20px;
            max-width: 90%;
        }

        .contact-section {
            gap: 10px;
            margin-bottom: 20px;
            max-width: 90%;
        }

        .social-link {
            width: 30px;
            height: 30px;
            font-size: 12px;
        }

        .bio-section,
        .notes-section {
            max-width: 90%;
        }

        .qr-container {
            padding: 12px;
        }

        .qr-content {
            flex-direction: column;
            text-align: center;
            gap: 10px;
        }

        .qr-code {
            width: 80px;
            height: 80px;
        }

        /* Further adjust shapes for small screens */
        .shape-1 {
            width: 120px;
            height: 120px;
        }

        .shape-2 {
            width: 80px;
            height: 80px;
        }

        .shape-3 {
            width: 100px;
            height: 100px;
        }

        .download-button-dani {
            top: -35px;
            width: 35px;
            height: 35px;
            font-size: 14px;
        }
    }

    @media (max-width: 380px) {
        .qr-code {
            width: 70px;
            height: 70px;
        }

        .qr-container {
            padding: 10px;
        }
    }

    /* Print Styles */
    @media print {
        .download-button-dani {
            display: none;
        }
        
        .dani-martinez-card {
            width: 850px;
            height: auto;
            min-height: 500px;
            break-inside: avoid;
            box-shadow: none;
        }
        
        .social-link:hover,
        .qr-container:hover {
            transform: none;
        }
    }
</style>

<script>
// Generate Contact Details QR Code for the Dani Martinez business card
function generateDaniBusinessCardQR() {
    // Prepare contact details as plain text
    const contactData = generateDaniContactDetailsText();
    
    const qrContainer = document.getElementById('daniBusinessCardQR');
    if (!qrContainer) return;
    
    // Clear previous QR code
    qrContainer.innerHTML = '';
    
    // Try different QR generation methods
    try {
        // Method 1: Using QRious (most reliable)
        if (typeof QRious !== 'undefined') {
            generateQRWithQRious(data, qrContainer);
        }
        // Method 2: Using QRCode.js
        else if (typeof QRCode !== 'undefined') {
            generateQRWithQRCodeJS(contactData, qrContainer);
        }
        // Method 3: Using qrcode-generator
        else if (typeof qrcode !== 'undefined') {
            generateQRWithQRCodeGenerator(contactData, qrContainer);
        }
        // Fallback: Online service
        else {
            generateQRWithOnlineService(contactData, qrContainer);
        }
    } catch (error) {
        console.error('QR generation failed:', error);
        generateQRWithOnlineService(contactData, qrContainer);
    }
}

// Generate simple contact details as plain text (scannable format)
function generateDaniContactDetailsText() {
    const name = '{{ $businessCard->name ?? "" }}';
    const title = '{{ $businessCard->title ?? "" }}';
    const company = '{{ $businessCard->company_name ?? "" }}';
    const phone = '{{ $businessCard->phone ?? "" }}';
    const email = '{{ $businessCard->email ?? "" }}';
    const website = '{{ $businessCard->website ?? "" }}';
    const location = '{{ $businessCard->location ?? "" }}';
    
    // Create simple contact information (no emojis, minimal formatting)
    let contactInfo = 'CONTACT DETAILS\n\n';
    
    if (name) {
        contactInfo += `Name: ${name}\n`;
    }
    
    if (title) {
        contactInfo += `Title: ${title}\n`;
    }
    
    if (company) {
        contactInfo += `Company: ${company}\n`;
    }
    
    if (phone) {
        contactInfo += `Phone: ${phone}\n`;
    }
    
    if (email) {
        contactInfo += `Email: ${email}\n`;
    }
    
    if (website) {
        contactInfo += `Website: ${website}\n`;
    }
    
    if (location) {
        contactInfo += `Location: ${location}\n`;
    }
    
    return contactInfo || 'Contact Information';
}

// Method 1: QRious
function generateQRWithQRious(data, container) {
    const canvas = document.createElement('canvas');
    const qr = new QRious({
        element: canvas,
        value: data,
        size: 200,
        level: 'M',
        foreground: '#000000',
        background: '#ffffff'
    });
    container.appendChild(canvas);
}

// Method 2: QRCode.js
function generateQRWithQRCodeJS(data, container) {
    QRCode.toCanvas(container, data, {
        width: 200,
        height: 200,
        colorDark: '#000000',
        colorLight: '#ffffff',
        correctLevel: QRCode.CorrectLevel.M,
        margin: 1
    }, function (error) {
        if (error) {
            console.error('QRCode.js failed:', error);
            generateQRWithOnlineService(data, container);
        }
    });
}

// Method 3: qrcode-generator
function generateQRWithQRCodeGenerator(data, container) {
    const qr = qrcode(0, 'M');
    qr.addData(data);
    qr.make();
    
    const canvas = document.createElement('canvas');
    const ctx = canvas.getContext('2d');
    const modules = qr.getModuleCount();
    const cellSize = 8;
    const margin = 8;
    
    canvas.width = canvas.height = modules * cellSize + margin * 2;
    
    // Fill background
    ctx.fillStyle = '#ffffff';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    
    // Draw QR modules
    ctx.fillStyle = '#000000';
    for (let row = 0; row < modules; row++) {
        for (let col = 0; col < modules; col++) {
            if (qr.isDark(row, col)) {
                ctx.fillRect(
                    col * cellSize + margin,
                    row * cellSize + margin,
                    cellSize,
                    cellSize
                );
            }
        }
    }
    
    container.appendChild(canvas);
}

// Fallback: Online service
function generateQRWithOnlineService(data, container) {
    const encodedData = encodeURIComponent(data);
    const qrApiUrl = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${encodedData}&ecc=M`;
    
    const img = document.createElement('img');
    img.src = qrApiUrl;
    img.alt = 'Contact QR Code';
    img.style.width = '100%';
    img.style.height = '100%';
    
    img.onload = function() {
        container.appendChild(img);
    };
    
    img.onerror = function() {
        container.innerHTML = '<div style="display:flex;align-items:center;justify-content:center;font-size:10px;color:#666;">QR Error</div>';
    };
}

// DOWNLOAD FUNCTIONALITY - Same as other templates
function downloadDaniBusinessCard() {
    const downloadBtn = document.getElementById('downloadBtnDani');
    const businessCard = document.getElementById('daniBusinessCard');
    
    if (!businessCard) {
        alert('Business card not found!');
        return;
    }

    // Add loading state
    downloadBtn.classList.add('loading');
    downloadBtn.innerHTML = '<i class="fas fa-spinner"></i>';
    
    // Temporarily hide the download button during capture
    downloadBtn.style.display = 'none';
    
    // Configure html2canvas options for high quality
    const options = {
        allowTaint: true,
        useCORS: true,
        backgroundColor: null,
        scale: 3, // Higher scale for better quality
        width: businessCard.scrollWidth,
        height: businessCard.scrollHeight,
        scrollX: 0,
        scrollY: 0,
        windowWidth: window.innerWidth,
        windowHeight: window.innerHeight,
        ignoreElements: function(element) {
            // Ignore any element with download-button class
            return element.classList && element.classList.contains('download-button-dani');
        }
    };

    // Small delay to ensure button is hidden
    setTimeout(() => {
        // Capture only the business card element
        html2canvas(businessCard, options).then(canvas => {
            try {
                // Create download link using dynamic name
                const businessCardName = '{{ $businessCard->name ?? "dani-martinez" }}';
                const fileName = businessCardName.toLowerCase().replace(/\s+/g, '-').replace(/[^a-z0-9-]/g, '') + '-business-card.png';
                
                const link = document.createElement('a');
                link.download = fileName;
                link.href = canvas.toDataURL('image/png', 1.0);
                
                // Trigger download
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                
                // Show success feedback
                showDaniDownloadSuccess();
                
            } catch (error) {
                console.error('Download failed:', error);
                alert('Download failed. Please try again.');
            } finally {
                // Show the download button again and reset state
                downloadBtn.style.display = 'flex';
                downloadBtn.classList.remove('loading');
                downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
            }
        }).catch(error => {
            console.error('html2canvas failed:', error);
            alert('Failed to capture business card. Please try again.');
            
            // Show the download button again and reset state
            downloadBtn.style.display = 'flex';
            downloadBtn.classList.remove('loading');
            downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
        });
    }, 50);
}

// Show download success feedback
function showDaniDownloadSuccess() {
    const downloadBtn = document.getElementById('downloadBtnDani');
    
    // Temporarily show success icon
    downloadBtn.innerHTML = '<i class="fas fa-check"></i>';
    downloadBtn.style.background = 'linear-gradient(135deg, #4CAF50, #45a049)';
    
    // Reset after 2 seconds
    setTimeout(() => {
        downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
        downloadBtn.style.background = 'linear-gradient(135deg, #16a34a, #22c55e)';
    }, 2000);
}

// Initialize QR code when document is ready
document.addEventListener('DOMContentLoaded', function() {
    // Small delay to ensure all libraries are loaded
    setTimeout(generateDaniBusinessCardQR, 100);
    
    // Add download button event listener
    const downloadBtn = document.getElementById('downloadBtnDani');
    if (downloadBtn) {
        downloadBtn.addEventListener('click', downloadDaniBusinessCard);
    }
});

// Also generate QR if the page is already loaded
if (document.readyState === 'complete') {
    setTimeout(generateDaniBusinessCardQR, 100);
}
</script>