<div class="card-container-alfredo">
    <!-- Download Button -->
    <button id="downloadBtnAlfredo" class="download-button-alfredo" title="Download Business Card">
        <i class="fas fa-download"></i>
    </button>

    {{-- Template: Alfredo Torres Style - Blue Professional with QR Code --}}
    <div class="alfredo-torres-card" id="alfredoBusinessCard">
        <!-- Geometric Background Shapes -->
        <div class="geometric-shapes">
            <div class="shape shape-1"></div>
            <div class="shape shape-2"></div>
            <div class="shape shape-3"></div>
            <div class="shape shape-4"></div>
        </div>
        
        <!-- Contact Sidebar -->
        <div class="contact-sidebar">
            @if($businessCard->phone)
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-phone-alt"></i>
                    </div>
                    <span class="contact-text">{{ $businessCard->phone }}</span>
                </div>
            @endif
            
            @if($businessCard->email)
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <span class="contact-text">{{ $businessCard->email }}</span>
                </div>
            @endif
            
            @if($businessCard->website)
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-globe"></i>
                    </div>
                    <span class="contact-text">{{ $businessCard->website }}</span>
                </div>
            @endif
            
            @if($businessCard->location)
                <div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <span class="contact-text">{{ $businessCard->location }}</span>
                </div>
            @endif

            <!-- QR Code in Sidebar -->
            <div class="qr-section-sidebar">
                <div class="qr-container-sidebar">
                    <div id="alfredoBusinessCardQR" class="qr-code-sidebar"></div>
                    <p class="qr-label-sidebar">Scan for Contact</p>
                </div>
            </div>
        </div>
        
        <!-- Main Content Area -->
        <div class="main-content">
            <!-- Company Logo Section -->
            @if($businessCard->company_logo)
                <div class="company-logo-section">
                    <img src="{{ $businessCard->company_logo_url }}" alt="{{ $businessCard->company_name }}" class="company-logo">
                </div>
            @endif

            <!-- Header Section with Name and Title -->
            <div class="header-section">
                <h1 class="main-name">{{ strtoupper($businessCard->name) }}</h1>
                @if($businessCard->title)
                    <h2 class="main-title">{{ $businessCard->title }}</h2>
                @endif
                <div class="blue-divider"></div>
                @if($businessCard->company_name)
                    <p class="company-name">{{ $businessCard->company_name }}</p>
                @endif
            </div>
            
            <!-- Profile Section -->
            @if($businessCard->profile_photo || $businessCard->bio)
                <div class="profile-section">
                    @if($businessCard->profile_photo)
                        <div class="profile-image-container">
                            <img src="{{ $businessCard->profile_photo_url }}" alt="{{ $businessCard->name }}" class="profile-image">
                        </div>
                    @endif
                    
                    @if($businessCard->bio)
                        <div class="bio-section">
                            <p class="bio-text">{{ $businessCard->bio }}</p>
                        </div>
                    @endif
                </div>
            @endif
            
            <!-- Additional Info Section -->
            @if($businessCard->years_experience || $businessCard->specialties)
                <div class="additional-info">
                    @if($businessCard->years_experience)
                        <div class="info-item">
                            <span class="info-number">{{ $businessCard->years_experience }}+</span>
                            <span class="info-label">Years Experience</span>
                        </div>
                    @endif
                    
                    @if($businessCard->specialties)
                        <div class="specialties-section">
                            <h3 class="section-title">Expertise</h3>
                            <div class="specialties-tags">
                                @foreach(array_slice($businessCard->specialties, 0, 4) as $specialty)
                                    <span class="specialty-tag">{{ $specialty }}</span>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            @endif
            
            <!-- Social Links -->
            @if($businessCard->linkedin || $businessCard->facebook || $businessCard->instagram || $businessCard->twitter)
                <div class="social-section">
                    <div class="social-links">
                        @if($businessCard->linkedin)
                            <a href="{{ $businessCard->linkedin }}" target="_blank" class="social-link">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        @endif
                        @if($businessCard->facebook)
                            <a href="{{ $businessCard->facebook }}" target="_blank" class="social-link">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        @endif
                        @if($businessCard->instagram)
                            <a href="{{ $businessCard->instagram }}" target="_blank" class="social-link">
                                <i class="fab fa-instagram"></i>
                            </a>
                        @endif
                        @if($businessCard->twitter)
                            <a href="{{ $businessCard->twitter }}" target="_blank" class="social-link">
                                <i class="fab fa-twitter"></i>
                            </a>
                        @endif
                    </div>
                </div>
            @endif

            <!-- QR Code in Main Content (Mobile) -->
            <div class="qr-section-main">
                <div class="qr-container-main">
                    <div id="alfredoBusinessCardQRMain" class="qr-code-main"></div>
                    <p class="qr-label-main">Scan to View Contact Details</p>
                </div>
            </div>
            
            <!-- Additional Notes -->
            @if($businessCard->additional_notes)
                <div class="notes-section">
                    <p class="notes-text">{{ $businessCard->additional_notes }}</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- QR Code Libraries -->
<script src="https://cdn.jsdelivr.net/npm/qrious@4.0.2/dist/qrious.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode-generator/1.4.4/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode/1.5.3/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<style>
    body {
        margin: 0;
        padding: 20px;
        background: #f5f5f5;
        font-family: 'Arial', sans-serif;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .card-container-alfredo {
        position: relative;
        display: inline-block;
    }

    /* Download Button Styles */
    .download-button-alfredo {
        position: absolute;
        top: -60px;
        right: 0;
        background: linear-gradient(135deg, #3b82f6, #60a5fa);
        border: none;
        border-radius: 12px;
        width: 50px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        color: white;
        font-size: 20px;
        box-shadow: 0 8px 25px rgba(59, 130, 246, 0.3);
        transition: all 0.3s ease;
        z-index: 1000;
    }

    .download-button-alfredo:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 35px rgba(59, 130, 246, 0.4);
        background: linear-gradient(135deg, #60a5fa, #3b82f6);
    }

    .download-button-alfredo:active {
        transform: translateY(0);
        box-shadow: 0 6px 20px rgba(59, 130, 246, 0.3);
    }

    .download-button-alfredo i {
        transition: transform 0.2s ease;
    }

    .download-button-alfredo:hover i {
        transform: scale(1.1);
    }

    /* Loading state for download button */
    .download-button-alfredo.loading {
        pointer-events: none;
        opacity: 0.7;
    }

    .download-button-alfredo.loading i {
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }

    .alfredo-torres-card {
        width: 100%;
        max-width: 850px;
        min-height: 500px;
        height: auto;
        background: #ffffff;
        position: relative;
        overflow: hidden;
        display: flex;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
        margin: 0 auto;
        font-family: 'Arial', sans-serif;
    }

    /* Geometric Background Shapes */
    .geometric-shapes {
        position: absolute;
        top: 0;
        right: 0;
        width: 60%;
        height: 100%;
        overflow: hidden;
        z-index: 1;
    }

    .shape {
        position: absolute;
        background: linear-gradient(135deg, #3498db, #2980b9);
        /* opacity: 0.8; */
    }

    .shape-1 {
        top: -10%;
        right: -5%;
        width: 200px;
        height: 300px;
        transform: skew(-15deg) rotate(25deg);
        background: linear-gradient(135deg, #87ceeb, #4682b4);
    }

    .shape-2 {
        top: 20%;
        right: 15%;
        width: 150px;
        height: 200px;
        transform: skew(-20deg) rotate(-15deg);
        background: linear-gradient(135deg, #1e3a8a, #1e40af);
        /* opacity: 0.9; */
    }

    .shape-3 {
        bottom: -5%;
        right: -10%;
        width: 180px;
        height: 250px;
        transform: skew(10deg) rotate(35deg);
        background: linear-gradient(135deg, #60a5fa, #3b82f6);
        /* opacity: 0.7; */
    }

    .shape-4 {
        bottom: 30%;
        right: 25%;
        width: 100px;
        height: 120px;
        transform: skew(-10deg) rotate(-25deg);
        background: linear-gradient(135deg, #93c5fd, #60a5fa);
        /* opacity: 0.6; */
    }

    /* Contact Sidebar */
    .contact-sidebar {
        flex: 0 0 240px;
        background: linear-gradient(135deg, #1e40af, #1e3a8a);
        padding: 40px 20px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        gap: 20px;
        position: relative;
        z-index: 10;
    }

    .contact-item {
        display: flex;
        align-items: center;
        gap: 10px;
        color: white;
    }

    .contact-icon {
        width: 30px;
        height: 30px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .contact-icon i {
        font-size: 12px;
        color: white;
    }

    .contact-text {
        font-size: 12px;
        font-weight: 500;
        line-height: 1.3;
        word-break: break-word;
    }

    /* QR Code in Sidebar */
    .qr-section-sidebar {
        margin-top: 20px;
        display: flex;
        justify-content: center;
    }

    .qr-container-sidebar {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 8px;
        padding: 15px;
        background: rgba(255, 255, 255, 0.1);
        border: 2px solid rgba(255, 255, 255, 0.2);
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .qr-container-sidebar:hover {
        background: rgba(255, 255, 255, 0.15);
        border-color: rgba(255, 255, 255, 0.3);
        transform: scale(1.02);
    }

    .qr-code-sidebar {
        width: 80px;
        height: 80px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: white;
        border-radius: 8px;
        padding: 4px;
    }

    .qr-code-sidebar canvas,
    .qr-code-sidebar img {
        width: 100%;
        height: 100%;
        border-radius: 4px;
    }

    .qr-label-sidebar {
        font-size: 10px;
        color: white;
        font-weight: 500;
        text-align: center;
        margin: 0;
        opacity: 0.9;
        letter-spacing: 0.3px;
        text-transform: uppercase;
    }

    /* QR Code in Main Content (Hidden by default, shown on mobile) */
    .qr-section-main {
        margin: 25px 0;
        display: none;
        justify-content: center;
    }

    .qr-container-main {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 10px;
        padding: 20px;
        background: rgba(30, 64, 175, 0.05);
        border: 2px solid rgba(30, 64, 175, 0.2);
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .qr-container-main:hover {
        background: rgba(30, 64, 175, 0.1);
        border-color: rgba(30, 64, 175, 0.3);
        transform: scale(1.02);
    }

    .qr-code-main {
        width: 100px;
        height: 100px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: white;
        border-radius: 8px;
        padding: 4px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .qr-code-main canvas,
    .qr-code-main img {
        width: 100%;
        height: 100%;
        border-radius: 4px;
    }

    .qr-label-main {
        font-size: 12px;
        color: #1e40af;
        font-weight: 600;
        text-align: center;
        margin: 0;
        letter-spacing: 0.3px;
        text-transform: uppercase;
    }

    /* Main Content Area */
    .main-content {
        flex: 1;
        padding: 50px 60px 50px 40px;
        position: relative;
        z-index: 5;
        display: flex;
        flex-direction: column;
        justify-content: center;
        background: rgba(255, 255, 255, 0.95);
    }

    /* Company Logo Section */
    .company-logo-section {
        margin-bottom: 15px;
        text-align: left;
    }

    .company-logo {
        height: 45px;
        width: auto;
        max-width: 200px;
        filter: brightness(0) saturate(100%) invert(25%) sepia(85%) saturate(1352%) hue-rotate(208deg) brightness(97%) contrast(91%);
        opacity: 0.9;
    }

    /* Header Section */
    .header-section {
        margin-bottom: 30px;
    }

    .main-name {
        font-size: clamp(28px, 5vw, 42px);
        font-weight: 800;
        color: #1e40af;
        margin-bottom: 8px;
        line-height: 1.1;
        letter-spacing: 1px;
    }

    .main-title {
        font-size: clamp(16px, 3vw, 20px);
        font-weight: 400;
        color: #374151;
        margin-bottom: 15px;
        line-height: 1.2;
    }

    .blue-divider {
        width: 80px;
        height: 3px;
        background: linear-gradient(90deg, #3b82f6, #60a5fa);
        margin-bottom: 15px;
    }

    .company-name {
        font-size: clamp(14px, 2.5vw, 18px);
        color: #6b7280;
        font-weight: 500;
        margin: 0;
    }

    /* Profile Section */
    .profile-section {
        margin-bottom: 25px;
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
    }

    .profile-image-container {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        overflow: hidden;
        margin-bottom: 15px;
        border: 3px solid #3b82f6;
    }

    .profile-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .bio-section {
        max-width: 400px;
    }

    .bio-text {
        font-size: clamp(12px, 2.2vw, 14px);
        color: #6b7280;
        line-height: 1.5;
        font-style: italic;
        margin: 0;
    }

    /* Additional Info */
    .additional-info {
        margin-bottom: 25px;
    }

    .info-item {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 20px;
    }

    .info-number {
        font-size: 24px;
        font-weight: 700;
        color: #1e40af;
    }

    .info-label {
        font-size: 12px;
        color: #6b7280;
        text-transform: uppercase;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    .section-title {
        font-size: 14px;
        font-weight: 600;
        color: #1e40af;
        margin-bottom: 10px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .specialties-tags {
        display: flex;
        flex-wrap: wrap;
        gap: 8px;
    }

    .specialty-tag {
        background: linear-gradient(135deg, #3b82f6, #60a5fa);
        color: white;
        padding: 6px 12px;
        border-radius: 15px;
        font-size: 11px;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }

    /* Social Section */
    .social-section {
        margin-bottom: 20px;
    }

    .social-links {
        display: flex;
        gap: 12px;
    }

    .social-link {
        width: 36px;
        height: 36px;
        background: linear-gradient(135deg, #1e40af, #1e3a8a);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        text-decoration: none;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .social-link:hover {
        background: linear-gradient(135deg, #3b82f6, #60a5fa);
        transform: scale(1.1);
    }

    /* Notes Section */
    .notes-section {
        border-top: 1px solid #e5e7eb;
        padding-top: 15px;
    }

    .notes-text {
        font-size: clamp(10px, 2vw, 12px);
        color: #6b7280;
        line-height: 1.4;
        margin: 0;
        text-align: center;
    }

    /* Responsive Design */
    @media (max-width: 1000px) {
        .download-button-alfredo {
            top: -50px;
            width: 45px;
            height: 45px;
            font-size: 18px;
        }
    }

    @media (max-width: 900px) {
        .alfredo-torres-card {
            max-width: 750px;
        }
        
        .contact-sidebar {
            flex: 0 0 220px;
            padding: 35px 18px;
            gap: 20px;
        }
        
        .main-content {
            padding: 40px 40px 40px 30px;
        }

        .qr-code-sidebar {
            width: 75px;
            height: 75px;
        }

        .download-button-alfredo {
            top: -45px;
            width: 42px;
            height: 42px;
            font-size: 17px;
        }
    }

    @media (max-width: 700px) {
        .alfredo-torres-card {
            flex-direction: column;
            max-width: 500px;
            min-height: 650px;
        }

        .contact-sidebar {
            flex: 0 0 auto;
            padding: 25px 20px;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: center;
            gap: 15px;
            order: 2;
        }

        .contact-item {
            flex-direction: column;
            text-align: center;
            gap: 8px;
            min-width: 120px;
        }

        .contact-icon {
            width: 35px;
            height: 35px;
        }

        .contact-text {
            font-size: 12px;
        }

        /* Hide sidebar QR, show main content QR */
        .qr-section-sidebar {
            display: none;
        }

        .qr-section-main {
            display: flex;
        }

        .main-content {
            order: 1;
            padding: 30px 25px;
            background: white;
        }

        .geometric-shapes {
            width: 100%;
            height: 40%;
            top: 0;
        }

        .shape-1 {
            top: -20%;
            right: -15%;
            width: 150px;
            height: 200px;
        }

        .shape-2 {
            top: 10%;
            right: 20%;
            width: 100px;
            height: 150px;
        }

        .shape-3 {
            display: none;
        }

        .shape-4 {
            bottom: 60%;
            right: 30%;
            width: 80px;
            height: 100px;
        }

        .download-button-alfredo {
            top: -40px;
            width: 40px;
            height: 40px;
            font-size: 16px;
        }
    }

    @media (max-width: 480px) {
        .alfredo-torres-card {
            max-width: 400px;
            min-height: 600px;
        }

        .contact-sidebar {
            padding: 20px 15px;
            gap: 12px;
        }

        .contact-item {
            min-width: 100px;
        }

        .main-content {
            padding: 25px 20px;
        }

        .main-name {
            font-size: clamp(22px, 6vw, 32px);
        }

        .main-title {
            font-size: clamp(14px, 3.5vw, 18px);
        }

        .social-link {
            width: 32px;
            height: 32px;
            font-size: 12px;
        }

        .qr-code-main {
            width: 90px;
            height: 90px;
        }

        .qr-container-main {
            padding: 15px;
        }

        .qr-label-main {
            font-size: 11px;
        }

        .download-button-alfredo {
            top: -35px;
            width: 35px;
            height: 35px;
            font-size: 14px;
        }
    }

    @media (max-width: 380px) {
        .qr-code-main {
            width: 80px;
            height: 80px;
        }

        .qr-container-main {
            padding: 12px;
        }

        .qr-label-main {
            font-size: 10px;
        }
    }

    /* Print Styles */
    @media print {
        .download-button-alfredo {
            display: none;
        }
        
        .alfredo-torres-card {
            width: 850px;
            height: auto;
            min-height: 500px;
            break-inside: avoid;
            box-shadow: none;
        }
        
        .social-link:hover {
            transform: none;
        }
    }
</style>

<script>
// Generate Contact Details QR Code for the Alfredo Torres business card
function generateAlfredoBusinessCardQR() {
    // Prepare contact details as plain text
    const contactData = generateAlfredoContactDetailsText();
    
    const qrContainerSidebar = document.getElementById('alfredoBusinessCardQR');
    const qrContainerMain = document.getElementById('alfredoBusinessCardQRMain');
    
    // Generate QR for sidebar
    if (qrContainerSidebar) {
        generateQRInContainer(contactData, qrContainerSidebar);
    }
    
    // Generate QR for main content (mobile)
    if (qrContainerMain) {
        generateQRInContainer(contactData, qrContainerMain);
    }
}

// Generate simple contact details as plain text (scannable format)
function generateAlfredoContactDetailsText() {
    const name = '{{ $businessCard->name ?? "" }}';
    const title = '{{ $businessCard->title ?? "" }}';
    const company = '{{ $businessCard->company_name ?? "" }}';
    const phone = '{{ $businessCard->phone ?? "" }}';
    const email = '{{ $businessCard->email ?? "" }}';
    const website = '{{ $businessCard->website ?? "" }}';
    const location = '{{ $businessCard->location ?? "" }}';
    
    // Create simple contact information (no emojis, minimal formatting)
    let contactInfo = 'CONTACT DETAILS\n\n';
    
    if (name) {
        contactInfo += `Name: ${name}\n`;
    }
    
    if (title) {
        contactInfo += `Title: ${title}\n`;
    }
    
    if (company) {
        contactInfo += `Company: ${company}\n`;
    }
    
    if (phone) {
        contactInfo += `Phone: ${phone}\n`;
    }
    
    if (email) {
        contactInfo += `Email: ${email}\n`;
    }
    
    if (website) {
        contactInfo += `Website: ${website}\n`;
    }
    
    if (location) {
        contactInfo += `Location: ${location}\n`;
    }
    
    return contactInfo || 'Contact Information';
}

// Generate QR code in specified container
function generateQRInContainer(data, container) {
    // Clear previous QR code
    container.innerHTML = '';
    
    // Try different QR generation methods
    try {
        // Method 1: Using QRious (most reliable)
        if (typeof QRious !== 'undefined') {
            generateQRWithQRious(data, container);
        }
        // Method 2: Using QRCode.js
        else if (typeof QRCode !== 'undefined') {
            generateQRWithQRCodeJS(data, container);
        }
        // Method 3: Using qrcode-generator
        else if (typeof qrcode !== 'undefined') {
            generateQRWithQRCodeGenerator(data, container);
        }
        // Fallback: Online service
        else {
            generateQRWithOnlineService(data, container);
        }
    } catch (error) {
        console.error('QR generation failed:', error);
        generateQRWithOnlineService(data, container);
    }
}

// Method 1: QRious
function generateQRWithQRious(data, container) {
    const canvas = document.createElement('canvas');
    const qr = new QRious({
        element: canvas,
        value: data,
        size: 200,
        level: 'M',
        foreground: '#000000',
        background: '#ffffff'
    });
    container.appendChild(canvas);
}

// Method 2: QRCode.js
function generateQRWithQRCodeJS(data, container) {
    QRCode.toCanvas(container, data, {
        width: 200,
        height: 200,
        colorDark: '#000000',
        colorLight: '#ffffff',
        correctLevel: QRCode.CorrectLevel.M,
        margin: 1
    }, function (error) {
        if (error) {
            console.error('QRCode.js failed:', error);
            generateQRWithOnlineService(data, container);
        }
    });
}

// Method 3: qrcode-generator
function generateQRWithQRCodeGenerator(data, container) {
    const qr = qrcode(0, 'M');
    qr.addData(data);
    qr.make();
    
    const canvas = document.createElement('canvas');
    const ctx = canvas.getContext('2d');
    const modules = qr.getModuleCount();
    const cellSize = 8;
    const margin = 8;
    
    canvas.width = canvas.height = modules * cellSize + margin * 2;
    
    // Fill background
    ctx.fillStyle = '#ffffff';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    
    // Draw QR modules
    ctx.fillStyle = '#000000';
    for (let row = 0; row < modules; row++) {
        for (let col = 0; col < modules; col++) {
            if (qr.isDark(row, col)) {
                ctx.fillRect(
                    col * cellSize + margin,
                    row * cellSize + margin,
                    cellSize,
                    cellSize
                );
            }
        }
    }
    
    container.appendChild(canvas);
}

// Fallback: Online service
function generateQRWithOnlineService(data, container) {
    const encodedData = encodeURIComponent(data);
    const qrApiUrl = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${encodedData}&ecc=M`;
    
    const img = document.createElement('img');
    img.src = qrApiUrl;
    img.alt = 'Contact QR Code';
    img.style.width = '100%';
    img.style.height = '100%';
    
    img.onload = function() {
        container.appendChild(img);
    };
    
    img.onerror = function() {
        container.innerHTML = '<div style="display:flex;align-items:center;justify-content:center;font-size:10px;color:#666;">QR Error</div>';
    };
}

// DOWNLOAD FUNCTIONALITY - Same as Harper Russo template
function downloadAlfredoBusinessCard() {
    const downloadBtn = document.getElementById('downloadBtnAlfredo');
    const businessCard = document.getElementById('alfredoBusinessCard');
    
    if (!businessCard) {
        alert('Business card not found!');
        return;
    }

    // Add loading state
    downloadBtn.classList.add('loading');
    downloadBtn.innerHTML = '<i class="fas fa-spinner"></i>';
    
    // Temporarily hide the download button during capture
    downloadBtn.style.display = 'none';
    
    // Configure html2canvas options for high quality
    const options = {
        allowTaint: true,
        useCORS: true,
        backgroundColor: null,
        scale: 3, // Higher scale for better quality
        width: businessCard.scrollWidth,
        height: businessCard.scrollHeight,
        scrollX: 0,
        scrollY: 0,
        windowWidth: window.innerWidth,
        windowHeight: window.innerHeight,
        ignoreElements: function(element) {
            // Ignore any element with download-button class
            return element.classList && element.classList.contains('download-button-alfredo');
        }
    };

    // Small delay to ensure button is hidden
    setTimeout(() => {
        // Capture only the business card element
        html2canvas(businessCard, options).then(canvas => {
            try {
                // Create download link using dynamic name
                const businessCardName = '{{ $businessCard->name ?? "alfredo-torres" }}';
                const fileName = businessCardName.toLowerCase().replace(/\s+/g, '-').replace(/[^a-z0-9-]/g, '') + '-business-card.png';
                
                const link = document.createElement('a');
                link.download = fileName;
                link.href = canvas.toDataURL('image/png', 1.0);
                
                // Trigger download
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                
                // Show success feedback
                showAlfredoDownloadSuccess();
                
            } catch (error) {
                console.error('Download failed:', error);
                alert('Download failed. Please try again.');
            } finally {
                // Show the download button again and reset state
                downloadBtn.style.display = 'flex';
                downloadBtn.classList.remove('loading');
                downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
            }
        }).catch(error => {
            console.error('html2canvas failed:', error);
            alert('Failed to capture business card. Please try again.');
            
            // Show the download button again and reset state
            downloadBtn.style.display = 'flex';
            downloadBtn.classList.remove('loading');
            downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
        });
    }, 50);
}

// Show download success feedback
function showAlfredoDownloadSuccess() {
    const downloadBtn = document.getElementById('downloadBtnAlfredo');
    
    // Temporarily show success icon
    downloadBtn.innerHTML = '<i class="fas fa-check"></i>';
    downloadBtn.style.background = 'linear-gradient(135deg, #4CAF50, #45a049)';
    
    // Reset after 2 seconds
    setTimeout(() => {
        downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
        downloadBtn.style.background = 'linear-gradient(135deg, #3b82f6, #60a5fa)';
    }, 2000);
}

// Initialize QR code when document is ready
document.addEventListener('DOMContentLoaded', function() {
    // Small delay to ensure all libraries are loaded
    setTimeout(generateAlfredoBusinessCardQR, 100);
    
    // Add download button event listener
    const downloadBtn = document.getElementById('downloadBtnAlfredo');
    if (downloadBtn) {
        downloadBtn.addEventListener('click', downloadAlfredoBusinessCard);
    }
});

// Also generate QR if the page is already loaded
if (document.readyState === 'complete') {
    setTimeout(generateAlfredoBusinessCardQR, 100);
}
</script>