@extends('chat.layout')
@section('title',"Business Card Preview")
@section('page-name',"Business Card Preview")
@section('page-detail',"Preview and manage your business card")
@section('body')

<div class="content-are-dashboard p-3">
    <div class="card">
        <div class="card-body">
            <!-- Header Actions -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center border rounded-3 p-3 bg-light">
                        <div>
                            <h4 class="mb-1">
                                <i class="fas fa-eye me-2 text-primary"></i>
                                Business Card Preview
                            </h4>
                            <p class="text-muted mb-0">{{ $businessCard->template_name }} Template</p>
                        </div>
                        <div class="btn-group">
                            <a href="{{ route('business-cards.index') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left me-2"></i>Back to Cards
                            </a>
                            <a href="{{ route('business-cards.edit', $businessCard) }}" class="btn btn-primary">
                                <i class="fas fa-edit me-2"></i>Edit Card
                            </a>
                            <div class="dropdown">
                                <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                    <i class="fas fa-cog"></i>
                                </button>
                                <ul class="dropdown-menu">
                                    <li>
                                        <button class="dropdown-item" onclick="copyToClipboard('{{ $businessCard->public_url }}')">
                                            <i class="fas fa-copy me-2"></i>Copy Public Link
                                        </button>
                                    </li>
                                    <!-- <li>
                                        <a class="dropdown-item" href="{{ route('business-cards.download-vcard', $businessCard) }}">
                                            <i class="fas fa-download me-2"></i>Download vCard
                                        </a>
                                    </li> -->
                                    <li><hr class="dropdown-divider"></li>
                                    <li>
                                        <button class="dropdown-item" onclick="toggleStatus()">
                                            <i class="fas fa-{{ $businessCard->is_active ? 'eye-slash' : 'eye' }} me-2"></i>
                                            {{ $businessCard->is_active ? 'Deactivate' : 'Activate' }}
                                        </button>
                                    </li>
                                    <li>
                                        <button class="dropdown-item text-danger" onclick="deleteCard()">
                                            <i class="fas fa-trash me-2"></i>Delete Card
                                        </button>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Card Status Info -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="info-card {{ $businessCard->is_active ? 'active' : 'inactive' }}">
                        <div class="info-icon">
                            <i class="fas fa-{{ $businessCard->is_active ? 'eye' : 'eye-slash' }}"></i>
                        </div>
                        <div class="info-content">
                            <h6 class="info-title">Card Status</h6>
                            <p class="info-text">{{ $businessCard->is_active ? 'Active' : 'Inactive' }}</p>
                            <small class="info-subtitle">
                                {{ $businessCard->is_active ? 'Visible to everyone with the link' : 'Not visible to public' }}
                            </small>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-card stats">
                        <div class="info-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div class="info-content">
                            <h6 class="info-title">Card Analytics</h6>
                            <p class="info-text">{{ $businessCard->view_count }} Views</p>
                            <small class="info-subtitle">
                                @if($businessCard->last_viewed_at)
                                    Last viewed {{ $businessCard->last_viewed_at->diffForHumans() }}
                                @else
                                    Never viewed yet
                                @endif
                            </small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Public Link Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="link-section border rounded-3 p-3">
                        <h5 class="mb-3">
                            <i class="fas fa-link me-2 text-primary"></i>
                            Public Share Link
                        </h5>
                        <div class="input-group">
                            <input type="text" class="form-control" id="publicUrl" value="{{ $businessCard->public_url }}" readonly>
                            <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('{{ $businessCard->public_url }}')">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                        <div class="mt-3" style="display: flex;">
                            <a href="{{ $businessCard->public_url }}" target="_blank" class="btn btn-primary me-2 w-50" style="">
                                <i class="fas fa-external-link-alt me-2"></i>View Public Card
                            </a>
                            <button class="btn btn-outline-primary w-50" onclick="generateQRCode()">
                                <i class="fas fa-qrcode me-2"></i>Generate QR Code
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Card Preview Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="preview-section">
                        <h5 class="mb-3">
                            <i class="fas fa-desktop me-2 text-primary"></i>
                            Card Preview
                        </h5>
                        
                        <!-- Device Mockup Tabs -->
                        <ul class="nav nav-pills justify-content-center mb-3" id="deviceTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="desktop-tab" data-bs-toggle="pill" data-bs-target="#desktop" type="button" role="tab">
                                    <i class="fas fa-desktop me-2"></i>Desktop
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="mobile-tab" data-bs-toggle="pill" data-bs-target="#mobile" type="button" role="tab">
                                    <i class="fas fa-mobile-alt me-2"></i>Mobile
                                </button>
                            </li>
                        </ul>

                        <!-- Device Preview Content -->
                        <div class="tab-content" id="deviceTabContent">
                            <!-- Desktop Preview -->
                            <div class="tab-pane fade show active" id="desktop" role="tabpanel">
                                <div class="device-mockup desktop-mockup">
                                    <div class="mockup-frame">
                                        <div class="mockup-header">
                                            <div class="mockup-buttons">
                                                <span class="btn-close-mockup"></span>
                                                <span class="btn-minimize-mockup"></span>
                                                <span class="btn-maximize-mockup"></span>
                                            </div>
                                            <div class="mockup-address-bar">{{ $businessCard->public_url }}</div>
                                        </div>
                                        <div class="mockup-content">
                                            <iframe src="{{ $businessCard->public_url }}" frameborder="0" style="width: 100%; height: 600px; border-radius: 0 0 10px 10px;"></iframe>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Mobile Preview -->
                            <div class="tab-pane fade" id="mobile" role="tabpanel">
                                <div class="device-mockup mobile-mockup">
                                    <div class="phone-frame">
                                        <div class="phone-header">
                                            <div class="phone-speaker"></div>
                                        </div>
                                        <div class="phone-screen">
                                            <iframe src="{{ $businessCard->public_url }}" frameborder="0" style="width: 100%; height: 100%;"></iframe>
                                        </div>
                                        <div class="phone-button"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Card Details Summary -->
            <div class="row">
                <div class="col-lg-8">
                    <div class="card-details border rounded-3 p-3">
                        <h5 class="mb-3">
                            <i class="fas fa-info-circle me-2 text-primary"></i>
                            Card Information
                        </h5>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="detail-group mb-3">
                                    <label class="detail-label">Name</label>
                                    <p class="detail-value">{{ $businessCard->name }}</p>
                                </div>
                                <div class="detail-group mb-3">
                                    <label class="detail-label">Title</label>
                                    <p class="detail-value">{{ $businessCard->title }}</p>
                                </div>
                                <div class="detail-group mb-3">
                                    <label class="detail-label">Company</label>
                                    <p class="detail-value">{{ $businessCard->company_name }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="detail-group mb-3">
                                    <label class="detail-label">Phone</label>
                                    <p class="detail-value">{{ $businessCard->phone }}</p>
                                </div>
                                <div class="detail-group mb-3">
                                    <label class="detail-label">Email</label>
                                    <p class="detail-value">{{ $businessCard->email }}</p>
                                </div>
                                @if($businessCard->location)
                                    <div class="detail-group mb-3">
                                        <label class="detail-label">Location</label>
                                        <p class="detail-value">{{ $businessCard->location }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>

                        @if($businessCard->specialties)
                            <div class="detail-group mb-3">
                                <label class="detail-label">Specialties</label>
                                <div class="specialties-display">
                                    @foreach($businessCard->specialties as $specialty)
                                        <span class="badge bg-primary me-1 mb-1">{{ $specialty }}</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif

                        @if($businessCard->brands_worked_with)
                            <div class="detail-group mb-3">
                                <label class="detail-label">Brand Experience</label>
                                <p class="detail-value">{{ $businessCard->formatted_brands }}</p>
                            </div>
                        @endif

                        @if($businessCard->bio)
                            <div class="detail-group mb-3">
                                <label class="detail-label">Bio</label>
                                <p class="detail-value">{{ $businessCard->bio }}</p>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="quick-actions border rounded-3 p-3">
                        <h5 class="mb-3">
                            <i class="fas fa-bolt me-2 text-primary"></i>
                            Quick Actions
                        </h5>
                        
                        <div class="action-list">
                            <button class="action-item" onclick="copyToClipboard('{{ $businessCard->public_url }}')">
                                <i class="fas fa-copy"></i>
                                <div>
                                    <span class="action-title">Copy Link</span>
                                    <small class="action-subtitle">Share with others</small>
                                </div>
                            </button>

                            <a href="{{ $businessCard->public_url }}" target="_blank" class="action-item">
                                <i class="fas fa-external-link-alt"></i>
                                <div>
                                    <span class="action-title">View Public</span>
                                    <small class="action-subtitle">See how others see it</small>
                                </div>
                            </a>

                            <button class="action-item" onclick="generateQRCode()">
                                <i class="fas fa-qrcode"></i>
                                <div>
                                    <span class="action-title">QR Code</span>
                                    <small class="action-subtitle">For easy sharing</small>
                                </div>
                            </button>

                            <!-- <a href="{{ route('business-cards.download-vcard', $businessCard) }}" class="action-item">
                                <i class="fas fa-download"></i>
                                <div>
                                    <span class="action-title">Download vCard</span>
                                    <small class="action-subtitle">For contacts app</small>
                                </div>
                            </a> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Enhanced QR Code Modal -->
<div class="modal fade" id="qrModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-qrcode me-2"></i>
                    QR Code for Business Card
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center">
                <div id="qrcode" class="mb-3"></div>
                <div id="qrLoading" class="text-center" style="display: none;">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Generating QR Code...</span>
                    </div>
                    <p class="mt-2">Generating QR Code...</p>
                </div>
                <p class="text-muted">Scan this QR code with your phone to view the business card</p>
                <div class="alert alert-info" role="alert">
                    <i class="fas fa-info-circle me-2"></i>
                    <small>Point your phone's camera at the QR code or use any QR scanner app</small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="downloadQRCode()" id="downloadBtn">
                    <i class="fas fa-download me-2"></i>Download QR
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Form -->
<form id="deleteForm" method="POST" action="{{ route('business-cards.destroy', $businessCard) }}" style="display: none;">
    @csrf
    @method('DELETE')
</form>

@endsection

@section('custom-scripts')

<style>
.info-card {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 20px;
    border-radius: 10px;
    border: 2px solid #e9ecef;
    transition: all 0.3s ease;
    height: 100%;
}

.info-card.active {
    border-color: #28a745;
    background: rgba(40, 167, 69, 0.05);
}

.info-card.inactive {
    border-color: #6c757d;
    background: rgba(108, 117, 125, 0.05);
}

.info-card.stats {
    border-color: #007bff;
    background: rgba(0, 123, 255, 0.05);
}

.info-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
}

.info-card.active .info-icon {
    background: #28a745;
}

.info-card.inactive .info-icon {
    background: #6c757d;
}

.info-card.stats .info-icon {
    background: #007bff;
}

.info-content {
    flex: 1;
}

.info-title {
    margin: 0 0 5px;
    font-size: 14px;
    font-weight: 600;
    color: #666;
    text-transform: uppercase;
}

.info-text {
    margin: 0 0 5px;
    font-size: 18px;
    font-weight: 700;
    color: #333;
}

.info-subtitle {
    color: #666;
    font-size: 12px;
}

.link-section {
    background: #f8f9fa;
}

.device-mockup {
    display: flex;
    justify-content: center;
    padding: 20px 0;
}

.desktop-mockup .mockup-frame {
    width: 800px;
    max-width: 100%;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.mockup-header {
    background: #e9ecef;
    height: 40px;
    display: flex;
    align-items: center;
    padding: 0 15px;
    gap: 15px;
}

.mockup-buttons {
    display: flex;
    gap: 8px;
}

.btn-close-mockup,
.btn-minimize-mockup,
.btn-maximize-mockup {
    width: 12px;
    height: 12px;
    border-radius: 50%;
}

.btn-close-mockup {
    background: #ff5f56;
}

.btn-minimize-mockup {
    background: #ffbd2e;
}

.btn-maximize-mockup {
    background: #27ca3f;
}

.mockup-address-bar {
    flex: 1;
    background: white;
    padding: 5px 10px;
    border-radius: 4px;
    font-size: 12px;
    color: #666;
}

.mobile-mockup .phone-frame {
    width: 440px;
    height: 600px;
    background: #333;
    border-radius: 25px;
    padding: 15px;
    position: relative;
}

.phone-header {
    height: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
}

.phone-speaker {
    width: 60px;
    height: 4px;
    background: #666;
    border-radius: 2px;
}

.phone-screen {
    background: white;
    border-radius: 15px;
    height: calc(100% - 40px);
    overflow: hidden;
}

.phone-button {
    position: absolute;
    bottom: 8px;
    left: 50%;
    transform: translateX(-50%);
    width: 40px;
    height: 4px;
    background: #666;
    border-radius: 2px;
}

.detail-label {
    font-size: 12px;
    font-weight: 600;
    color: #666;
    text-transform: uppercase;
    margin-bottom: 5px;
}

.detail-value {
    font-size: 14px;
    color: #333;
    margin: 0;
    line-height: 1.4;
}

.action-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.action-item {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 15px;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    background: white;
    text-decoration: none;
    color: #333;
    transition: all 0.3s ease;
    cursor: pointer;
}

.action-item:hover {
    border-color: #007bff;
    background: rgba(0, 123, 255, 0.05);
    color: #007bff;
    transform: translateY(-1px);
}

.action-item i {
    font-size: 20px;
    width: 30px;
    text-align: center;
}

.action-title {
    display: block;
    font-weight: 600;
    font-size: 14px;
}

.action-subtitle {
    color: #666;
    font-size: 11px;
}

.bg-light {
    background: linear-gradient(135deg, #f8f9ff 0%, #f0f4ff 100%) !important;
}

#qrcode {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 200px;
}

#qrcode canvas,
#qrcode img {
    max-width: 100%;
    height: auto;
    border: 1px solid #dee2e6;
    border-radius: 8px;
    padding: 10px;
    background: white;
}

.qr-error {
    color: #dc3545;
    font-size: 14px;
}

.toast-container {
    z-index: 1055;
}

@media (max-width: 768px) {
    .desktop-mockup .mockup-frame {
        width: 100%;
    }
    
    .mobile-mockup .phone-frame {
        width: 250px;
        height: 500px;
    }
    
    .d-flex.justify-content-between {
        flex-direction: column;
        gap: 15px;
    }
    
    .btn-group {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }
}
</style>

<!-- Enhanced QR Code Libraries -->
<script src="https://cdn.jsdelivr.net/npm/qrious@4.0.2/dist/qrious.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode-generator/1.4.4/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode/1.5.3/qrcode.min.js"></script>

<script>
// Global variable to store the current QR code URL
let currentQRUrl = '';

// Copy to clipboard function
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        showToast('Link copied to clipboard!', 'success');
    }, function() {
        // Fallback for older browsers
        const textArea = document.createElement('textarea');
        textArea.value = text;
        document.body.appendChild(textArea);
        textArea.focus();
        textArea.select();
        try {
            document.execCommand('copy');
            showToast('Link copied to clipboard!', 'success');
        } catch (err) {
            showToast('Failed to copy link', 'error');
        }
        document.body.removeChild(textArea);
    });
}

// Toggle card status
function toggleStatus() {
    fetch(`{{ route('business-cards.toggle-status', $businessCard) }}`, {
        method: 'PATCH',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast(data.message, 'success');
            setTimeout(() => {
                location.reload();
            }, 1500);
        } else {
            showToast('Failed to update status', 'error');
        }
    })
    .catch(error => {
        showToast('An error occurred', 'error');
    });
}

// Delete card
function deleteCard() {
    if (confirm('Are you sure you want to delete this business card? This action cannot be undone.')) {
        document.getElementById('deleteForm').submit();
    }
}

// Enhanced Generate QR Code with multiple fallback methods
function generateQRCode() {
    const businessCardUrl = '{{ $businessCard->public_url }}';
    currentQRUrl = businessCardUrl;
    
    const qrContainer = document.getElementById('qrcode');
    const loadingDiv = document.getElementById('qrLoading');
    const downloadBtn = document.getElementById('downloadBtn');
    
    // Clear previous content and show loading
    qrContainer.innerHTML = '';
    loadingDiv.style.display = 'block';
    downloadBtn.disabled = true;
    
    // Show modal first
    const modal = new bootstrap.Modal(document.getElementById('qrModal'));
    modal.show();
    
    // Try different QR code generation methods
    setTimeout(() => {
        try {
            // Method 1: Using QRious (most reliable)
            if (typeof QRious !== 'undefined') {
                generateWithQRious(businessCardUrl, qrContainer, loadingDiv, downloadBtn);
            }
            // Method 2: Using qrcode library
            else if (typeof QRCode !== 'undefined') {
                generateWithQRCodeJS(businessCardUrl, qrContainer, loadingDiv, downloadBtn);
            }
            // Method 3: Using qrcode-generator
            else if (typeof qrcode !== 'undefined') {
                generateWithQRCodeGenerator(businessCardUrl, qrContainer, loadingDiv, downloadBtn);
            }
            // Method 4: Fallback to online service
            else {
                generateWithOnlineService(businessCardUrl, qrContainer, loadingDiv, downloadBtn);
            }
        } catch (error) {
            console.error('Primary QR generation failed:', error);
            // Fallback to online service
            generateWithOnlineService(businessCardUrl, qrContainer, loadingDiv, downloadBtn);
        }
    }, 500);
}

// Method 1: Using QRious library
function generateWithQRious(url, container, loading, downloadBtn) {
    try {
        const canvas = document.createElement('canvas');
        const qr = new QRious({
            element: canvas,
            value: url,
            size: 300,
            level: 'H', // High error correction
            foreground: '#000000',
            background: '#ffffff'
        });
        
        loading.style.display = 'none';
        container.appendChild(canvas);
        downloadBtn.disabled = false;
        
        console.log('QR Code generated successfully with QRious');
        showToast('QR Code generated successfully!', 'success');
        
    } catch (error) {
        console.error('QRious failed:', error);
        generateWithQRCodeJS(url, container, loading, downloadBtn);
    }
}

// Method 2: Using QRCode.js library
function generateWithQRCodeJS(url, container, loading, downloadBtn) {
    try {
        QRCode.toCanvas(container, url, {
            width: 300,
            height: 300,
            colorDark: '#000000',
            colorLight: '#ffffff',
            correctLevel: QRCode.CorrectLevel.H,
            margin: 2
        }, function (error) {
            loading.style.display = 'none';
            if (error) {
                console.error('QRCode.js failed:', error);
                generateWithQRCodeGenerator(url, container, loading, downloadBtn);
            } else {
                downloadBtn.disabled = false;
                console.log('QR Code generated successfully with QRCode.js');
                showToast('QR Code generated successfully!', 'success');
            }
        });
    } catch (error) {
        console.error('QRCode.js failed:', error);
        generateWithQRCodeGenerator(url, container, loading, downloadBtn);
    }
}

// Method 3: Using qrcode-generator library
function generateWithQRCodeGenerator(url, container, loading, downloadBtn) {
    try {
        const qr = qrcode(0, 'H');
        qr.addData(url);
        qr.make();
        
        // Create canvas and draw QR code
        const canvas = document.createElement('canvas');
        const ctx = canvas.getContext('2d');
        const modules = qr.getModuleCount();
        const cellSize = 10;
        const margin = 20;
        
        canvas.width = canvas.height = modules * cellSize + margin * 2;
        
        // Fill background
        ctx.fillStyle = '#ffffff';
        ctx.fillRect(0, 0, canvas.width, canvas.height);
        
        // Draw QR modules
        ctx.fillStyle = '#000000';
        for (let row = 0; row < modules; row++) {
            for (let col = 0; col < modules; col++) {
                if (qr.isDark(row, col)) {
                    ctx.fillRect(
                        col * cellSize + margin,
                        row * cellSize + margin,
                        cellSize,
                        cellSize
                    );
                }
            }
        }
        
        loading.style.display = 'none';
        container.appendChild(canvas);
        downloadBtn.disabled = false;
        
        console.log('QR Code generated successfully with qrcode-generator');
        showToast('QR Code generated successfully!', 'success');
        
    } catch (error) {
        console.error('qrcode-generator failed:', error);
        generateWithOnlineService(url, container, loading, downloadBtn);
    }
}

// Method 4: Fallback to online QR service
function generateWithOnlineService(url, container, loading, downloadBtn) {
    try {
        const encodedUrl = encodeURIComponent(url);
        const qrApiUrl = `https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=${encodedUrl}&ecc=H`;
        
        const img = document.createElement('img');
        img.src = qrApiUrl;
        img.alt = 'QR Code for Business Card';
        img.style.maxWidth = '300px';
        img.style.height = 'auto';
        
        img.onload = function() {
            loading.style.display = 'none';
            container.appendChild(img);
            downloadBtn.disabled = false;
            console.log('QR Code generated successfully with online service');
            showToast('QR Code generated successfully!', 'success');
        };
        
        img.onerror = function() {
            loading.style.display = 'none';
            container.innerHTML = `
                <div class="alert alert-danger qr-error" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Failed to generate QR Code</strong><br>
                    <small>Please check your internet connection and try again.</small>
                </div>
            `;
            showToast('Failed to generate QR code', 'error');
        };
        
    } catch (error) {
        console.error('Online service failed:', error);
        loading.style.display = 'none';
        container.innerHTML = `
            <div class="alert alert-danger qr-error" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <strong>Failed to generate QR Code</strong><br>
                <small>All methods failed. Please try again later.</small>
            </div>
        `;
        showToast('Failed to generate QR code', 'error');
    }
}

// Enhanced Download QR Code function
function downloadQRCode() {
    try {
        const container = document.getElementById('qrcode');
        const canvas = container.querySelector('canvas');
        const img = container.querySelector('img');
        
        if (canvas) {
            // Download canvas as PNG
            const link = document.createElement('a');
            link.download = '{{ Str::slug($businessCard->name ?? 'business-card') }}-qr-code.png';
            link.href = canvas.toDataURL('image/png');
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            showToast('QR code downloaded successfully!', 'success');
            
        } else if (img) {
            // Convert image to canvas and download
            const canvas = document.createElement('canvas');
            const ctx = canvas.getContext('2d');
            canvas.width = img.naturalWidth || 300;
            canvas.height = img.naturalHeight || 300;
            
            ctx.drawImage(img, 0, 0);
            
            const link = document.createElement('a');
            link.download = '{{ Str::slug($businessCard->name ?? 'business-card') }}-qr-code.png';
            link.href = canvas.toDataURL('image/png');
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            showToast('QR code downloaded successfully!', 'success');
            
        } else {
            showToast('No QR code available to download', 'warning');
        }
    } catch (error) {
        console.error('Download failed:', error);
        showToast('Failed to download QR code', 'error');
    }
}

// Enhanced Show toast notification
function showToast(message, type) {
    const toastHTML = `
        <div class="toast align-items-center text-white bg-${type === 'success' ? 'success' : type === 'warning' ? 'warning' : 'danger'} border-0" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body">
                    <i class="fas fa-${type === 'success' ? 'check-circle' : type === 'warning' ? 'exclamation-triangle' : 'times-circle'} me-2"></i>
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>
    `;
    
    let toastContainer = document.querySelector('.toast-container');
    if (!toastContainer) {
        toastContainer = document.createElement('div');
        toastContainer.className = 'toast-container position-fixed top-0 end-0 p-3';
        toastContainer.style.zIndex = '1055';
        document.body.appendChild(toastContainer);
    }
    
    toastContainer.insertAdjacentHTML('beforeend', toastHTML);
    
    const toastElement = toastContainer.lastElementChild;
    const toast = new bootstrap.Toast(toastElement, {
        autohide: true,
        delay: type === 'error' ? 5000 : 3000
    });
    toast.show();
    
    toastElement.addEventListener('hidden.bs.toast', function() {
        toastElement.remove();
    });
}

// Initialize when document is ready
document.addEventListener('DOMContentLoaded', function() {
    console.log('Enhanced QR Code system initialized');
    currentQRUrl = '{{ $businessCard->public_url }}';
});
</script>

@endsection