<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description"
        content="{{ $businessCard->name }} - {{ $businessCard->title }} at {{ $businessCard->company_name }}">
    <meta name="keywords"
        content="business card, {{ $businessCard->name }}, {{ $businessCard->company_name }}, automotive, car dealership">

    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="{{ $businessCard->name }} - {{ $businessCard->title }}">
    <meta property="og:description"
        content="{{ $businessCard->bio ?: $businessCard->name . ' at ' . $businessCard->company_name }}">
    <meta property="og:image" content="{{ $businessCard->profile_photo_url }}">
    <meta property="og:url" content="{{ $businessCard->public_url }}">
    <meta property="og:type" content="profile">

    <title>{{ $businessCard->name }} - {{ $businessCard->title }}</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Playfair+Display:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <!-- HTML2Canvas for Download -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

    <style>
        :root {
            --primary-color: {{ $businessCard->primary_color }};
            --secondary-color: {{ $businessCard->secondary_color }};
            --font-family: {{ $businessCard->font_style == 'classic' ? 'Playfair Display' : ($businessCard->font_style == 'elegant' ? 'Montserrat' : 'Inter') }}, sans-serif;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: var(--font-family);
            line-height: 1.6;
            color: #333;
            background: var(--primary-color);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
        }

        .page-container {
            width: 100%;
            max-width: 900px;
            margin: 0 auto;
            position: relative;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        /* Download Button Styles */
        .download-button {
            position: absolute;
            top: -70px;
            right: 0;
            background: linear-gradient(135deg, #ffffff, #f8f9fa);
            border: 2px solid #dee2e6;
            border-radius: 12px;
            width: 60px;
            height: 60px;
            display: flex !important;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            color: #495057;
            font-size: 22px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            transition: all 0.3s ease;
            z-index: 1000;
            visibility: visible !important;
        }

        .download-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(0, 0, 0, 0.2);
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            border-color: #adb5bd;
            color: #212529;
        }

        .download-button:active {
            transform: translateY(-1px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
        }

        .download-button i {
            transition: transform 0.2s ease;
        }

        .download-button:hover i {
            transform: scale(1.1);
        }

        /* Loading state for download button */
        .download-button.loading {
            pointer-events: none;
            opacity: 0.7;
        }

        .download-button.loading i {
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

        /* Success state */
        .download-button.success {
            background: linear-gradient(135deg, #d4edda, #c3e6cb);
            border-color: #b8daff;
            color: #155724;
        }

        .business-card-container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            position: relative;
        }

        .business-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            position: relative;
            transform: translateY(0);
            transition: all 0.3s ease;
        }

        .business-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.15);
        }

        /* Dark background compatibility */
        @media (prefers-color-scheme: dark) {
            .download-button {
                background: linear-gradient(135deg, #343a40, #495057);
                border-color: #6c757d;
                color: #f8f9fa;
            }
            
            .download-button:hover {
                background: linear-gradient(135deg, #495057, #6c757d);
                border-color: #adb5bd;
                color: #ffffff;
            }
        }

        /* Responsive Design for Download Button */
        @media (max-width: 768px) {
            .download-button {
                top: -60px;
                width: 50px;
                height: 50px;
                font-size: 18px;
            }
        }

        @media (max-width: 480px) {
            .download-button {
                top: -50px;
                width: 45px;
                height: 45px;
                font-size: 16px;
            }
            
            .page-container {
                padding-top: 60px;
            }
        }

        /* Hide download button on print */
        @media print {
            .download-button {
                display: none !important;
            }
            
            body {
                background: white !important;
            }
        }

        /* Template Specific Styles */
    </style>
</head>

<body>
    <div class="page-container">
        <!-- Download Button -->
        <!-- <button id="downloadBtn" class="download-button" title="Download Business Card">
            <i class="fas fa-download"></i>
        </button> -->

        <div class="business-card-container">
            <div>
                <!-- Include the specific template -->
                {{-- @include('business-cards.templates.template-' . $businessCard->template_id) --}}
                
                <!-- For demo purposes - replace this with your actual template include -->
                <div style="padding: 40px; text-align: center;">
                    <p style="margin-top: 20px; font-style: italic;">
                        Your business card template content will be included here via:<br>
                        <code>@include('business-cards.templates.template-' . $businessCard->template_id)</code>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Download vCard Button -->
    <!-- <a href="{{ route('business-cards.download-vcard', $businessCard) }}" class="download-vcard">
        <i class="fas fa-download me-2"></i>Save Contact
    </a> -->

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Download functionality
        function downloadBusinessCard() {
            const downloadBtn = document.getElementById('downloadBtn');
            const businessCard = document.getElementById('businessCard');
            
            if (!businessCard) {
                alert('Business card not found!');
                return;
            }

            // Add loading state
            downloadBtn.classList.add('loading');
            downloadBtn.innerHTML = '<i class="fas fa-spinner"></i>';
            
            // Configure html2canvas options for high quality
            const options = {
                allowTaint: true,
                useCORS: true,
                backgroundColor: '#ffffff',
                scale: 2,
                width: businessCard.scrollWidth,
                height: businessCard.scrollHeight,
                scrollX: 0,
                scrollY: 0,
                windowWidth: window.innerWidth,
                windowHeight: window.innerHeight
            };

            // Capture the business card as image
            html2canvas(businessCard, options).then(canvas => {
                try {
                    // Create download link
                    const businessCardName = '{{ $businessCard->name ?? "business-card" }}';
                    const fileName = businessCardName.toLowerCase().replace(/\s+/g, '-').replace(/[^a-z0-9-]/g, '') + '-business-card.png';
                    
                    const link = document.createElement('a');
                    link.download = fileName;
                    link.href = canvas.toDataURL('image/png', 1.0);
                    
                    // Trigger download
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);
                    
                    // Show success feedback
                    showDownloadSuccess();
                    
                } catch (error) {
                    console.error('Download failed:', error);
                    alert('Download failed. Please try again.');
                } finally {
                    // Reset button state
                    resetDownloadButton();
                }
            }).catch(error => {
                console.error('html2canvas failed:', error);
                alert('Failed to capture business card. Please try again.');
                
                // Reset button state
                resetDownloadButton();
            });
        }

        // Show download success feedback
        function showDownloadSuccess() {
            const downloadBtn = document.getElementById('downloadBtn');
            
            // Show success state
            downloadBtn.classList.remove('loading');
            downloadBtn.classList.add('success');
            downloadBtn.innerHTML = '<i class="fas fa-check"></i>';
            
            // Reset after 2 seconds
            setTimeout(() => {
                resetDownloadButton();
            }, 2000);
        }

        // Reset download button to default state
        function resetDownloadButton() {
            const downloadBtn = document.getElementById('downloadBtn');
            downloadBtn.classList.remove('loading', 'success');
            downloadBtn.innerHTML = '<i class="fas fa-download"></i>';
        }

        // Add animation on load
        document.addEventListener('DOMContentLoaded', function () {
            const card = document.querySelector('.business-card');
            card.style.opacity = '0';
            card.style.transform = 'translateY(50px)';

            setTimeout(() => {
                card.style.transition = 'all 0.8s ease';
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, 100);

            // Add download button event listener
            const downloadBtn = document.getElementById('downloadBtn');
            if (downloadBtn) {
                downloadBtn.addEventListener('click', downloadBusinessCard);
            }
        });

        // Smooth scroll for internal links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth'
                    });
                }
            });
        });

        // Analytics - track interactions
        document.querySelectorAll('.contact-btn, .social-link').forEach(link => {
            link.addEventListener('click', function () {
                // You can add analytics tracking here
                console.log('Contact interaction:', this.className, this.href);
            });
        });
    </script>
</body>

</html>