@extends('chat.layout')
@section('title', "Edit Business Card")
@section('page-name', "Edit Business Card")
@section('page-detail', "Update your professional digital business card")
@section('body')

<div class="content-are-dashboard p-3">
    <div class="card">
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Please fix the following errors:</strong>
                    <ul class="mb-0 mt-2">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <form method="POST" action="{{ route('business-cards.update', $businessCard) }}" enctype="multipart/form-data" id="businessCardForm">
                @csrf
                @method('PUT')

                <!-- Template Selection -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="border rounded-3 p-3">
                            <h5 class="mb-3">
                                <i class="fas fa-palette me-2 text-primary"></i>
                                Choose Your Template
                            </h5>
                            <div class="row">
                                @foreach($templates as $template)
                                    <div class="col-lg-2 col-md-4 col-6 mb-3">
                                        <div class="template-option {{ $businessCard->template_id == $template['id'] ? 'selected' : '' }}" 
                                             onclick="selectTemplate({{ $template['id'] }})">
                                            <input type="radio" name="template_id" value="{{ $template['id'] }}" 
                                                   {{ $businessCard->template_id == $template['id'] ? 'checked' : '' }}
                                                   style="display: none;">
                                            <!-- <div class="template-preview">
                                                <div class="template-mockup template-{{ $template['id'] }}">
                                                    <div class="mockup-header"></div>
                                                    <div class="mockup-body">
                                                        <div class="mockup-avatar"></div>
                                                        <div class="mockup-text">
                                                            <div class="mockup-line"></div>
                                                            <div class="mockup-line short"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> -->
                                             <img src="/assets/preview{{ $loop->index + 1 }}.png" height="80px" class="mb-3" alt="Preview {{ $loop->index + 1 }}">
                                            <div class="template-name">{{ $template['name'] }}</div>
                                            <small class="template-desc">{{ $template['description'] }}</small>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Left Column -->
                    <div class="col-lg-6">
                        
                        <!-- Basic Information -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-user me-2 text-primary"></i>
                                Basic Information
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="name" class="form-label">Full Name *</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" 
                                           value="{{ old('name', $businessCard->name) }}" 
                                           required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label">Job Title *</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" 
                                           id="title" name="title" 
                                           value="{{ old('title', $businessCard->title) }}" 
                                           placeholder="Sales Manager, Service Advisor, etc." required>
                                    @error('title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="company_name" class="form-label">Company Name *</label>
                                <input type="text" class="form-control @error('company_name') is-invalid @enderror" 
                                       id="company_name" name="company_name" 
                                       value="{{ old('company_name', $businessCard->company_name) }}" 
                                       required>
                                @error('company_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="phone" class="form-label">Phone Number *</label>
                                    <input type="tel" class="form-control @error('phone') is-invalid @enderror" 
                                           id="phone" name="phone" 
                                           value="{{ old('phone', $businessCard->phone) }}" 
                                           required>
                                    @error('phone')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email Address *</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                           id="email" name="email" 
                                           value="{{ old('email', $businessCard->email) }}" 
                                           required>
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="website" class="form-label">Website</label>
                                    <input type="url" class="form-control @error('website') is-invalid @enderror" 
                                           id="website" name="website" 
                                           value="{{ old('website', $businessCard->website) }}" 
                                           placeholder="https://yourwebsite.com">
                                    @error('website')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="location" class="form-label">Location</label>
                                    <input type="text" class="form-control @error('location') is-invalid @enderror" 
                                           id="location" name="location" 
                                           value="{{ old('location', $businessCard->location) }}" 
                                           placeholder="City, State">
                                    @error('location')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="bio" class="form-label">Professional Bio</label>
                                <textarea class="form-control @error('bio') is-invalid @enderror" 
                                          id="bio" name="bio" rows="3" 
                                          placeholder="Brief description of your expertise and what you offer...">{{ old('bio', $businessCard->bio) }}</textarea>
                                <small class="form-text text-muted">Maximum 500 characters</small>
                                @error('bio')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Automotive Expertise -->
                        <!-- <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-car me-2 text-primary"></i>
                                Automotive Expertise
                            </h5>

                            <div class="mb-3">
                                <label class="form-label">Specialties</label>
                                <div class="specialty-checkboxes">
                                    @foreach($availableSpecialties as $specialty)
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="checkbox" name="specialties[]" 
                                                   value="{{ $specialty }}" id="specialty_{{ $loop->index }}"
                                                   {{ (old('specialties') && in_array($specialty, old('specialties'))) || 
                                                      (is_array($businessCard->specialties) && in_array($specialty, $businessCard->specialties)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="specialty_{{ $loop->index }}">
                                                {{ $specialty }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Car Brands Experience</label>
                                <select class="form-select" name="brands_worked_with[]" multiple id="brandsSelect">
                                    @foreach($availableBrands as $brand)
                                        <option value="{{ $brand }}" 
                                                {{ (old('brands_worked_with') && in_array($brand, old('brands_worked_with'))) || 
                                                   (is_array($businessCard->brands_worked_with) && in_array($brand, $businessCard->brands_worked_with)) ? 'selected' : '' }}>
                                            {{ $brand }}
                                        </option>
                                    @endforeach
                                </select>
                                <small class="form-text text-muted">Hold Ctrl (Cmd on Mac) to select multiple brands</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Certifications</label>
                                <div class="certification-checkboxes">
                                    @foreach($availableCertifications as $cert)
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="certifications[]" 
                                                   value="{{ $cert }}" id="cert_{{ $loop->index }}"
                                                   {{ (old('certifications') && in_array($cert, old('certifications'))) || 
                                                      (is_array($businessCard->certifications) && in_array($cert, $businessCard->certifications)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="cert_{{ $loop->index }}">
                                                {{ $cert }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="years_experience" class="form-label">Years of Experience</label>
                                    <select class="form-select @error('years_experience') is-invalid @enderror" 
                                            id="years_experience" name="years_experience">
                                        <option value="">Select...</option>
                                        @for($i = 1; $i <= 30; $i++)
                                            <option value="{{ $i }}" 
                                                    {{ old('years_experience', $businessCard->years_experience) == $i ? 'selected' : '' }}>
                                                {{ $i }} {{ $i == 1 ? 'year' : 'years' }}
                                            </option>
                                        @endfor
                                        <option value="30" {{ old('years_experience', $businessCard->years_experience) >= 30 ? 'selected' : '' }}>30+ years</option>
                                    </select>
                                    @error('years_experience')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="languages_spoken" class="form-label">Languages Spoken</label>
                                    <input type="text" class="form-control @error('languages_spoken') is-invalid @enderror" 
                                           id="languages_spoken" name="languages_spoken" 
                                           value="{{ old('languages_spoken', $businessCard->languages_spoken) }}" 
                                           placeholder="English, Spanish, French...">
                                    @error('languages_spoken')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="services_offered" class="form-label">Services Offered</label>
                                <textarea class="form-control @error('services_offered') is-invalid @enderror" 
                                          id="services_offered" name="services_offered" rows="3"
                                          placeholder="New vehicle sales, trade-in evaluations, financing options...">{{ old('services_offered', $businessCard->services_offered) }}</textarea>
                                @error('services_offered')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div> -->

                    </div>

                    <!-- Right Column -->
                    <div class="col-lg-6">
                        
                        <!-- Media Upload -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-image me-2 text-primary"></i>
                                Photos & Images
                            </h5>

                            <div class="mb-3">
                                <label for="profile_photo" class="form-label">Profile Photo</label>
                                <input type="file" class="form-control @error('profile_photo') is-invalid @enderror" 
                                       id="profile_photo" name="profile_photo" accept="image/*">
                                <small class="form-text text-muted">JPG, PNG. Max size: 2MB</small>
                                @if($businessCard->profile_photo)
                                    <div class="mt-2">
                                        <img src="{{ asset($businessCard->profile_photo) }}" alt="Current profile photo" 
                                             class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                                        <small class="d-block text-muted">Current photo (leave empty to keep this photo)</small>
                                    </div>
                                @endif
                                @error('profile_photo')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="company_logo" class="form-label">Company Logo</label>
                                <input type="file" class="form-control @error('company_logo') is-invalid @enderror" 
                                       id="company_logo" name="company_logo" accept="image/*">
                                <small class="form-text text-muted">JPG, PNG. Max size: 2MB</small>
                                @if($businessCard->company_logo)
                                    <div class="mt-2">
                                        <img src="{{ asset($businessCard->company_logo) }}" alt="Current company logo" 
                                             class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                                        <small class="d-block text-muted">Current logo (leave empty to keep this logo)</small>
                                    </div>
                                @endif
                                @error('company_logo')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- <div class="mb-3">
                                <label for="background_image" class="form-label">Background Image</label>
                                <input type="file" class="form-control @error('background_image') is-invalid @enderror" 
                                       id="background_image" name="background_image" accept="image/*">
                                <small class="form-text text-muted">JPG, PNG. Max size: 2MB</small>
                                @if($businessCard->background_image)
                                    <div class="mt-2">
                                        <img src="{{ asset($businessCard->background_image) }}" alt="Current background image" 
                                             class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                                        <small class="d-block text-muted">Current background (leave empty to keep this image)</small>
                                    </div>
                                @endif
                                @error('background_image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div> -->
                        </div>

                        <!-- Social Media & Contact -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-share-alt me-2 text-primary"></i>
                                Social Media & Contact
                            </h5>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="whatsapp" class="form-label">WhatsApp</label>
                                    <input type="text" class="form-control @error('whatsapp') is-invalid @enderror" 
                                           id="whatsapp" name="whatsapp" 
                                           value="{{ old('whatsapp', $businessCard->whatsapp) }}" 
                                           placeholder="+1234567890">
                                    @error('whatsapp')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="linkedin" class="form-label">LinkedIn</label>
                                    <input type="url" class="form-control @error('linkedin') is-invalid @enderror" 
                                           id="linkedin" name="linkedin" 
                                           value="{{ old('linkedin', $businessCard->linkedin) }}" 
                                           placeholder="https://linkedin.com/in/yourprofile">
                                    @error('linkedin')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="facebook" class="form-label">Facebook</label>
                                    <input type="url" class="form-control @error('facebook') is-invalid @enderror" 
                                           id="facebook" name="facebook" 
                                           value="{{ old('facebook', $businessCard->facebook) }}" 
                                           placeholder="https://facebook.com/yourpage">
                                    @error('facebook')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="instagram" class="form-label">Instagram</label>
                                    <input type="url" class="form-control @error('instagram') is-invalid @enderror" 
                                           id="instagram" name="instagram" 
                                           value="{{ old('instagram', $businessCard->instagram) }}" 
                                           placeholder="https://instagram.com/youraccount">
                                    @error('instagram')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="twitter" class="form-label">Twitter/X</label>
                                <input type="url" class="form-control @error('twitter') is-invalid @enderror" 
                                       id="twitter" name="twitter" 
                                       value="{{ old('twitter', $businessCard->twitter) }}" 
                                       placeholder="https://twitter.com/youraccount">
                                @error('twitter')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Customization -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-paint-brush me-2 text-primary"></i>
                                Customization
                            </h5>

                            <div class="row">
                                <div class="col-6 mb-3">
                                    <label for="primary_color" class="form-label">Background Color</label>
                                    @php
                                        // Handle custom_colors whether it's already an array or JSON string
                                        $customColors = is_array($businessCard->custom_colors) 
                                            ? $businessCard->custom_colors 
                                            : ($businessCard->custom_colors ? json_decode($businessCard->custom_colors, true) : null);
                                        $primaryColor = old('primary_color', $customColors['primary'] ?? '#007bff');
                                    @endphp
                                    <input type="color" class="form-control form-control-color" 
                                           id="primary_color" name="primary_color" 
                                           value="{{ $primaryColor }}">
                                </div>
                            </div>

                        </div>

                        <!-- Status Settings -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-cog me-2 text-primary"></i>
                                Card Settings
                            </h5>

                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1"
                                       {{ old('is_active', $businessCard->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Card is Active
                                </label>
                                <small class="form-text text-muted d-block">Inactive cards cannot be viewed publicly</small>
                            </div>

                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="is_public" id="is_public" value="1"
                                       {{ old('is_public', $businessCard->is_public) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_public">
                                    Card is Public
                                </label>
                                <small class="form-text text-muted d-block">Public cards can be viewed by anyone with the link</small>
                            </div>
                        </div>

                        <!-- Additional Notes -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-sticky-note me-2 text-primary"></i>
                                Additional Information
                            </h5>

                            <div class="mb-3">
                                <label for="additional_notes" class="form-label">Additional Notes</label>
                                <textarea class="form-control @error('additional_notes') is-invalid @enderror" 
                                          id="additional_notes" name="additional_notes" rows="3"
                                          placeholder="Any additional information you'd like to share...">{{ old('additional_notes', $businessCard->additional_notes) }}</textarea>
                                @error('additional_notes')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="row">
                    <div class="col-12">
                        <div class="border rounded-3 p-3 bg-light">
                            <div class="d-flex justify-content-between align-items-center">
                                <a href="{{ route('business-cards.show', $businessCard) }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-2"></i>Back to Preview
                                </a>
                                <div>
                                    @if($businessCard->is_public && $businessCard->is_active && isset($businessCard->unique_slug))
                                        <a href="{{ route('business-card.public', $businessCard->unique_slug) }}" target="_blank" class="btn btn-outline-primary me-2">
                                            <i class="fas fa-eye me-2"></i>Preview Public View
                                        </a>
                                    @endif
                                    <button type="submit" class="btn btn-primary btn-lg">
                                        <i class="fas fa-save me-2"></i>Update Business Card
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('custom-scripts')

<style>
.template-option {
    border: 2px solid #e9ecef;
    border-radius: 10px;
    padding: 15px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: center;
    background: white;
}

.template-option:hover {
    border-color: #007bff;
    box-shadow: 0 2px 8px rgba(0,123,255,0.15);
}

.template-option.selected {
    border-color: #007bff;
    background: #f8f9ff;
    box-shadow: 0 0 0 2px rgba(0,123,255,0.25);
}

.template-mockup {
    width: 100%;
    height: 80px;
    border-radius: 8px;
    margin-bottom: 10px;
    overflow: hidden;
    position: relative;
}

.template-1 { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
.template-2 { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
.template-3 { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); }
.template-4 { background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); }
.template-5 { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); }

.mockup-header {
    height: 20px;
    background: rgba(255,255,255,0.2);
    margin-bottom: 8px;
}

.mockup-body {
    display: flex;
    align-items: center;
    padding: 0 10px;
}

.mockup-avatar {
    width: 25px;
    height: 25px;
    background: rgba(255,255,255,0.3);
    border-radius: 50%;
    margin-right: 8px;
}

.mockup-text {
    flex: 1;
}

.mockup-line {
    height: 4px;
    background: rgba(255,255,255,0.4);
    border-radius: 2px;
    margin-bottom: 4px;
}

.mockup-line.short {
    width: 60%;
}

.template-name {
    font-weight: bold;
    font-size: 14px;
    color: #495057;
    margin-bottom: 5px;
}

.template-desc {
    color: #6c757d;
    font-size: 11px;
    line-height: 1.2;
}

.specialty-checkboxes, .certification-checkboxes {
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 15px;
}

.specialty-checkboxes .form-check-inline {
    margin-right: 20px;
    margin-bottom: 10px;
}

.certification-checkboxes .form-check {
    margin-bottom: 8px;
}

.form-control-color {
    width: 100%;
    height: 40px;
}

.bg-light {
    background: linear-gradient(135deg, #f8f9ff 0%, #f0f4ff 100%) !important;
}

.btn-primary {
    background: linear-gradient(45deg, #007bff, #0056b3);
    border: none;
}

.btn-primary:hover {
    background: linear-gradient(45deg, #0056b3, #004085);
    transform: translateY(-1px);
}

#brandsSelect {
    height: 120px;
}

#brandsSelect option:checked {
    background-color: #007bff;
    color: white;
}

.alert {
    border-radius: 10px;
}

.img-thumbnail {
    border-radius: 8px;
}
</style>

<script>
// Template selection
function selectTemplate(templateId) {
    // Remove selected class from all templates
    document.querySelectorAll('.template-option').forEach(option => {
        option.classList.remove('selected');
    });
    
    // Add selected class to clicked template
    event.currentTarget.classList.add('selected');
    
    // Check the radio button
    document.querySelector(`input[name="template_id"][value="${templateId}"]`).checked = true;
}

// Form validation
document.getElementById('businessCardForm').addEventListener('submit', function(e) {
    let isValid = true;
    
    // Check required fields
    const requiredFields = ['name', 'title', 'company_name', 'phone', 'email'];
    requiredFields.forEach(field => {
        const input = document.getElementById(field);
        if (!input.value.trim()) {
            input.classList.add('is-invalid');
            isValid = false;
        } else {
            input.classList.remove('is-invalid');
        }
    });
    
    if (!isValid) {
        e.preventDefault();
        // Show error message
        const errorAlert = `
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Please fill in all required fields.
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        `;
        document.querySelector('.card-body').insertAdjacentHTML('afterbegin', errorAlert);
        
        // Scroll to top
        window.scrollTo({ top: 0, behavior: 'smooth' });
    }
});

// File input preview
['profile_photo', 'company_logo', 'background_image'].forEach(inputId => {
    const input = document.getElementById(inputId);
    if (input) {
        input.addEventListener('change', function(e) {
            previewImage(e.target, `${inputId}_preview`);
        });
    }
});

function previewImage(input, containerId) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            let preview = document.getElementById(containerId);
            if (!preview) {
                preview = document.createElement('div');
                preview.id = containerId;
                preview.className = 'mt-2';
                input.parentNode.appendChild(preview);
            }
            preview.innerHTML = `
                <img src="${e.target.result}" alt="Preview" class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                <small class="d-block text-success">New image selected</small>
            `;
        }
        reader.readAsDataURL(input.files[0]);
    }
}

// Character count for bio
const bioField = document.getElementById('bio');
if (bioField) {
    bioField.addEventListener('input', function() {
        const maxLength = 500;
        const currentLength = this.value.length;
        const remaining = maxLength - currentLength;
        
        let counter = this.parentNode.querySelector('.char-counter');
        if (!counter) {
            counter = document.createElement('small');
            counter.className = 'form-text text-muted char-counter';
            this.parentNode.appendChild(counter);
        }
        
        counter.textContent = `${currentLength}/${maxLength} characters`;
        counter.className = remaining < 50 ? 'form-text text-warning char-counter' : 'form-text text-muted char-counter';
        
        if (currentLength > maxLength) {
            this.value = this.value.substring(0, maxLength);
            counter.textContent = `${maxLength}/${maxLength} characters`;
            counter.className = 'form-text text-danger char-counter';
        }
    });

    // Initialize character counter
    bioField.dispatchEvent(new Event('input'));
}

// Auto-dismiss success alerts after 5 seconds
setTimeout(function() {
    const alerts = document.querySelectorAll('.alert-success');
    alerts.forEach(alert => {
        if (bootstrap && bootstrap.Alert) {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }
    });
}, 5000);
</script>

@endsection