@extends('chat.layout')
@section('title', isset($businessCard) ? "Edit Business Card" : "Create Business Card")
@section('page-name', isset($businessCard) ? "Edit Business Card" : "Create New Business Card")
@section('page-detail', isset($businessCard) ? "Update your professional digital business card" : "Create your professional digital business card")
@section('body')

<div class="content-are-dashboard p-3">
    <div class="card">
        <div class="card-body">
            <form method="POST" 
                  action="{{ isset($businessCard) ? route('business-cards.update', $businessCard) : route('business-cards.store') }}" 
                  enctype="multipart/form-data" 
                  id="businessCardForm">
                @csrf
                @if(isset($businessCard))
                    @method('PUT')
                @endif

                <!-- Template Selection -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="border rounded-3 p-3">
                            <h5 class="mb-3">
                                <i class="fas fa-palette me-2 text-primary"></i>
                                Choose Your Template
                            </h5>
                            <div class="row">
                              @foreach($templates as $template)
    <div class="col-lg-2 col-md-4 col-6 mb-3">
        <div class="template-option {{ (isset($businessCard) && $businessCard->template_id == $template['id']) ? 'selected' : '' }}" 
             onclick="selectTemplate({{ $template['id'] }})">
            <input type="radio" name="template_id" value="{{ $template['id'] }}" 
                   {{ (isset($businessCard) && $businessCard->template_id == $template['id']) || (!isset($businessCard) && $template['id'] == 1) ? 'checked' : '' }}
                   style="display: none;">
            
            <img src="/assets/preview{{ $loop->index + 1 }}.png" height="80px" class="mb-3" alt="Preview {{ $loop->index + 1 }}">
            
            <div class="template-name">{{ $template['name'] }}</div>
            <small class="template-desc">{{ $template['description'] }}</small>
        </div>
    </div>
@endforeach

                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Left Column -->
                    <div class="col-lg-6">
                        
                        <!-- Basic Information -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-user me-2 text-primary"></i>
                                Basic Information
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="name" class="form-label">Full Name *</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" 
                                           value="{{ old('name', isset($businessCard) ? $businessCard->name : ($defaultData['name'] ?? '')) }}" 
                                           required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label">Job Title *</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" 
                                           id="title" name="title" 
                                           value="{{ old('title', isset($businessCard) ? $businessCard->title : '') }}" 
                                           placeholder="Sales Manager, Service Advisor, etc." required>
                                    @error('title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="company_name" class="form-label">Company Name *</label>
                                <input type="text" class="form-control @error('company_name') is-invalid @enderror" 
                                       id="company_name" name="company_name" 
                                       value="{{ old('company_name', isset($businessCard) ? $businessCard->company_name : ($defaultData['company_name'] ?? '')) }}" 
                                       required>
                                @error('company_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="phone" class="form-label">Phone Number *</label>
                                    <input type="tel" class="form-control @error('phone') is-invalid @enderror" 
                                           id="phone" name="phone" 
                                           value="{{ old('phone', isset($businessCard) ? $businessCard->phone : ($defaultData['phone'] ?? '')) }}" 
                                           required>
                                    @error('phone')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email Address *</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                           id="email" name="email" 
                                           value="{{ old('email', isset($businessCard) ? $businessCard->email : ($defaultData['email'] ?? '')) }}" 
                                           required>
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="website" class="form-label">Website</label>
                                    <input type="url" class="form-control @error('website') is-invalid @enderror" 
                                           id="website" name="website" 
                                           value="{{ old('website', isset($businessCard) ? $businessCard->website : '') }}" 
                                           placeholder="https://yourwebsite.com">
                                    @error('website')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="location" class="form-label">Location</label>
                                    <input type="text" class="form-control @error('location') is-invalid @enderror" 
                                           id="location" name="location" 
                                           value="{{ old('location', isset($businessCard) ? $businessCard->location : ($defaultData['location'] ?? '')) }}" 
                                           placeholder="City, State">
                                    @error('location')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="bio" class="form-label">Professional Bio</label>
                                <textarea class="form-control @error('bio') is-invalid @enderror" 
                                          id="bio" name="bio" rows="3" 
                                          placeholder="Brief description of your expertise and what you offer...">{{ old('bio', isset($businessCard) ? $businessCard->bio : '') }}</textarea>
                                <small class="form-text text-muted">Maximum 500 characters</small>
                                @error('bio')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Car Dealership Specific -->
                        <!-- <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-car me-2 text-primary"></i>
                                Automotive Expertise
                            </h5>

                            <div class="mb-3">
                                <label class="form-label">Specialties</label>
                                <div class="specialty-checkboxes">
                                    @foreach($availableSpecialties as $specialty)
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="checkbox" name="specialties[]" 
                                                   value="{{ $specialty }}" id="specialty_{{ $loop->index }}"
                                                   {{ (old('specialties') && in_array($specialty, old('specialties'))) || (isset($businessCard) && in_array($specialty, $businessCard->specialties ?? [])) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="specialty_{{ $loop->index }}">
                                                {{ $specialty }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Car Brands Experience</label>
                                <select class="form-select" name="brands_worked_with[]" multiple id="brandsSelect">
                                    @foreach($availableBrands as $brand)
                                        <option value="{{ $brand }}" 
                                                {{ (old('brands_worked_with') && in_array($brand, old('brands_worked_with'))) || (isset($businessCard) && in_array($brand, $businessCard->brands_worked_with ?? [])) ? 'selected' : '' }}>
                                            {{ $brand }}
                                        </option>
                                    @endforeach
                                </select>
                                <small class="form-text text-muted">Hold Ctrl (Cmd on Mac) to select multiple brands</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Certifications</label>
                                <div class="certification-checkboxes">
                                    @foreach($availableCertifications as $cert)
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="certifications[]" 
                                                   value="{{ $cert }}" id="cert_{{ $loop->index }}"
                                                   {{ (old('certifications') && in_array($cert, old('certifications'))) || (isset($businessCard) && in_array($cert, $businessCard->certifications ?? [])) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="cert_{{ $loop->index }}">
                                                {{ $cert }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="years_experience" class="form-label">Years of Experience</label>
                                    <select class="form-select @error('years_experience') is-invalid @enderror" 
                                            id="years_experience" name="years_experience">
                                        <option value="">Select...</option>
                                        @for($i = 1; $i <= 30; $i++)
                                            <option value="{{ $i }}" 
                                                    {{ old('years_experience', isset($businessCard) ? $businessCard->years_experience : '') == $i ? 'selected' : '' }}>
                                                {{ $i }} {{ $i == 1 ? 'year' : 'years' }}
                                            </option>
                                        @endfor
                                        <option value="30" {{ old('years_experience', isset($businessCard) ? $businessCard->years_experience : '') >= 30 ? 'selected' : '' }}>30+ years</option>
                                    </select>
                                    @error('years_experience')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="languages_spoken" class="form-label">Languages Spoken</label>
                                    <input type="text" class="form-control @error('languages_spoken') is-invalid @enderror" 
                                           id="languages_spoken" name="languages_spoken" 
                                           value="{{ old('languages_spoken', isset($businessCard) ? $businessCard->languages_spoken : '') }}" 
                                           placeholder="English, Spanish, French...">
                                    @error('languages_spoken')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="services_offered" class="form-label">Services Offered</label>
                                <textarea class="form-control @error('services_offered') is-invalid @enderror" 
                                          id="services_offered" name="services_offered" rows="3"
                                          placeholder="New vehicle sales, trade-in evaluations, financing options...">{{ old('services_offered', isset($businessCard) ? $businessCard->services_offered : '') }}</textarea>
                                @error('services_offered')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div> -->

                    </div>

                    <!-- Right Column -->
                    <div class="col-lg-6">
                        
                        <!-- Media Upload -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-image me-2 text-primary"></i>
                                Photos & Images
                            </h5>

                            <div class="mb-3">
                                <label for="profile_photo" class="form-label">Profile Photo</label>
                                <input type="file" class="form-control @error('profile_photo') is-invalid @enderror" 
                                       id="profile_photo" name="profile_photo" accept="image/*">
                                <small class="form-text text-muted">JPG, PNG. Max size: 2MB</small>
                                @if(isset($businessCard) && $businessCard->profile_photo)
                                    <div class="mt-2">
                                        <img src="{{ $businessCard->profile_photo_url }}" alt="Current profile photo" 
                                             class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                                    </div>
                                @endif
                                @error('profile_photo')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="company_logo" class="form-label">Company Logo</label>
                                <input type="file" class="form-control @error('company_logo') is-invalid @enderror" 
                                       id="company_logo" name="company_logo" accept="image/*">
                                <small class="form-text text-muted">JPG, PNG. Max size: 2MB</small>
                                @if(isset($businessCard) && $businessCard->company_logo)
                                    <div class="mt-2">
                                        <img src="{{ $businessCard->company_logo_url }}" alt="Current company logo" 
                                             class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                                    </div>
                                @endif
                                @error('company_logo')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Social Media & Contact -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-share-alt me-2 text-primary"></i>
                                Social Media & Contact
                            </h5>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="whatsapp" class="form-label">WhatsApp</label>
                                    <input type="text" class="form-control @error('whatsapp') is-invalid @enderror" 
                                           id="whatsapp" name="whatsapp" 
                                           value="{{ old('whatsapp', isset($businessCard) ? $businessCard->whatsapp : '') }}" 
                                           placeholder="+1234567890">
                                    @error('whatsapp')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="linkedin" class="form-label">LinkedIn</label>
                                    <input type="url" class="form-control @error('linkedin') is-invalid @enderror" 
                                           id="linkedin" name="linkedin" 
                                           value="{{ old('linkedin', isset($businessCard) ? $businessCard->linkedin : '') }}" 
                                           placeholder="https://linkedin.com/in/yourprofile">
                                    @error('linkedin')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="facebook" class="form-label">Facebook</label>
                                    <input type="url" class="form-control @error('facebook') is-invalid @enderror" 
                                           id="facebook" name="facebook" 
                                           value="{{ old('facebook', isset($businessCard) ? $businessCard->facebook : '') }}" 
                                           placeholder="https://facebook.com/yourpage">
                                    @error('facebook')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="instagram" class="form-label">Instagram</label>
                                    <input type="url" class="form-control @error('instagram') is-invalid @enderror" 
                                           id="instagram" name="instagram" 
                                           value="{{ old('instagram', isset($businessCard) ? $businessCard->instagram : '') }}" 
                                           placeholder="https://instagram.com/youraccount">
                                    @error('instagram')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="twitter" class="form-label">Twitter/X</label>
                                <input type="url" class="form-control @error('twitter') is-invalid @enderror" 
                                       id="twitter" name="twitter" 
                                       value="{{ old('twitter', isset($businessCard) ? $businessCard->twitter : '') }}" 
                                       placeholder="https://twitter.com/youraccount">
                                @error('twitter')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Customization -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-paint-brush me-2 text-primary"></i>
                                Customization
                            </h5>

                            <div class="row">
                                <div class="col-6 mb-3">
                                    <label for="primary_color" class="form-label">Background Color</label>
                                    <input type="color" class="form-control form-control-color" 
                                           id="primary_color" name="primary_color" 
                                           value="{{ old('primary_color', isset($businessCard) ? $businessCard->primary_color : '#007bff') }}">
                                </div>
                                <!-- <div class="col-6 mb-3">
                                    <label for="secondary_color" class="form-label">Secondary Color</label>
                                    <input type="color" class="form-control form-control-color" 
                                           id="secondary_color" name="secondary_color" 
                                           value="{{ old('secondary_color', isset($businessCard) ? $businessCard->secondary_color : '#6c757d') }}">
                                </div> -->
                            </div>

                            <!-- <div class="mb-3">
                                <label for="font_style" class="form-label">Font Style</label>
                                <select class="form-select @error('font_style') is-invalid @enderror" 
                                        id="font_style" name="font_style">
                                    <option value="modern" {{ old('font_style', isset($businessCard) ? $businessCard->font_style : 'modern') == 'modern' ? 'selected' : '' }}>Modern</option>
                                    <option value="classic" {{ old('font_style', isset($businessCard) ? $businessCard->font_style : '') == 'classic' ? 'selected' : '' }}>Classic</option>
                                    <option value="elegant" {{ old('font_style', isset($businessCard) ? $businessCard->font_style : '') == 'elegant' ? 'selected' : '' }}>Elegant</option>
                                </select>
                                @error('font_style')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div> -->
                        </div>

                        @if(isset($businessCard))
                        <!-- Status Settings -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-cog me-2 text-primary"></i>
                                Card Settings
                            </h5>

                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="is_active" id="is_active" 
                                       {{ old('is_active', $businessCard->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Card is Active
                                </label>
                                <small class="form-text text-muted d-block">Inactive cards cannot be viewed publicly</small>
                            </div>

                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="is_public" id="is_public" 
                                       {{ old('is_public', $businessCard->is_public) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_public">
                                    Card is Public
                                </label>
                                <small class="form-text text-muted d-block">Public cards can be viewed by anyone with the link</small>
                            </div>
                        </div>
                        @endif

                        <!-- Additional Notes -->
                        <div class="border rounded-3 p-3 mb-4">
                            <h5 class="mb-3">
                                <i class="fas fa-sticky-note me-2 text-primary"></i>
                                Additional Information
                            </h5>

                            <div class="mb-3">
                                <label for="additional_notes" class="form-label">Additional Notes</label>
                                <textarea class="form-control @error('additional_notes') is-invalid @enderror" 
                                          id="additional_notes" name="additional_notes" rows="3"
                                          placeholder="Any additional information you'd like to share...">{{ old('additional_notes', isset($businessCard) ? $businessCard->additional_notes : '') }}</textarea>
                                @error('additional_notes')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="row">
                    <div class="col-12">
                        <div class="border rounded-3 p-3 bg-light">
                            <div class="d-flex justify-content-between align-items-center">
                                <a href="{{ route('business-cards.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-2"></i>Back to Cards
                                </a>
                                <div>
                                    <button type="submit" class="btn btn-primary btn-lg">
                                        <i class="fas fa-save me-2"></i>
                                        {{ isset($businessCard) ? 'Update' : 'Create' }} Business Card
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('custom-scripts')

<style>
.template-option {
    border: 2px solid #e9ecef;
    border-radius: 10px;
    padding: 15px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: center;
    background: white;
}

.template-option:hover {
    border-color: #007bff;
    box-shadow: 0 2px 8px rgba(0,123,255,0.15);
}

.template-option.selected {
    border-color: #007bff;
    background: #f8f9ff;
    box-shadow: 0 0 0 2px rgba(0,123,255,0.25);
}

.template-mockup {
    width: 100%;
    height: 80px;
    border-radius: 8px;
    margin-bottom: 10px;
    overflow: hidden;
    position: relative;
}

.template-1 { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
.template-2 { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
.template-3 { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); }
.template-4 { background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); }
.template-5 { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); }

.mockup-header {
    height: 20px;
    background: rgba(255,255,255,0.2);
    margin-bottom: 8px;
}

.mockup-body {
    display: flex;
    align-items: center;
    padding: 0 10px;
}

.mockup-avatar {
    width: 25px;
    height: 25px;
    background: rgba(255,255,255,0.3);
    border-radius: 50%;
    margin-right: 8px;
}

.mockup-text {
    flex: 1;
}

.mockup-line {
    height: 4px;
    background: rgba(255,255,255,0.4);
    border-radius: 2px;
    margin-bottom: 4px;
}

.mockup-line.short {
    width: 60%;
}

.template-name {
    font-weight: bold;
    font-size: 14px;
    color: #495057;
    margin-bottom: 5px;
}

.template-desc {
    color: #6c757d;
    font-size: 11px;
    line-height: 1.2;
}

.specialty-checkboxes, .certification-checkboxes {
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 15px;
}

.specialty-checkboxes .form-check-inline {
    margin-right: 20px;
    margin-bottom: 10px;
}

.certification-checkboxes .form-check {
    margin-bottom: 8px;
}

.form-control-color {
    width: 100%;
    height: 40px;
}

.bg-light {
    background: linear-gradient(135deg, #f8f9ff 0%, #f0f4ff 100%) !important;
}

.btn-primary {
    background: linear-gradient(45deg, #007bff, #0056b3);
    border: none;
}

.btn-primary:hover {
    background: linear-gradient(45deg, #0056b3, #004085);
    transform: translateY(-1px);
}

#brandsSelect {
    height: 120px;
}

#brandsSelect option:checked {
    background-color: #007bff;
    color: white;
}
</style>

<script>
// Template selection
function selectTemplate(templateId) {
    // Remove selected class from all templates
    document.querySelectorAll('.template-option').forEach(option => {
        option.classList.remove('selected');
    });
    
    // Add selected class to clicked template
    event.currentTarget.classList.add('selected');
    
    // Check the radio button
    document.querySelector(`input[name="template_id"][value="${templateId}"]`).checked = true;
}

// Form validation
document.getElementById('businessCardForm').addEventListener('submit', function(e) {
    let isValid = true;
    
    // Check required fields
    const requiredFields = ['name', 'title', 'company_name', 'phone', 'email'];
    requiredFields.forEach(field => {
        const input = document.getElementById(field);
        if (!input.value.trim()) {
            input.classList.add('is-invalid');
            isValid = false;
        } else {
            input.classList.remove('is-invalid');
        }
    });
    
    if (!isValid) {
        e.preventDefault();
        // Show error message
        const errorAlert = `
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Please fill in all required fields.
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        `;
        document.querySelector('.card-body').insertAdjacentHTML('afterbegin', errorAlert);
        
        // Scroll to top
        window.scrollTo({ top: 0, behavior: 'smooth' });
    }
});

// File input preview
document.getElementById('profile_photo').addEventListener('change', function(e) {
    previewImage(e.target, 'profile_preview');
});

document.getElementById('company_logo').addEventListener('change', function(e) {
    previewImage(e.target, 'logo_preview');
});

function previewImage(input, containerId) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            let preview = document.getElementById(containerId);
            if (!preview) {
                preview = document.createElement('div');
                preview.id = containerId;
                preview.className = 'mt-2';
                input.parentNode.appendChild(preview);
            }
            preview.innerHTML = `<img src="${e.target.result}" alt="Preview" class="img-thumbnail" style="max-width: 100px; max-height: 100px;">`;
        }
        reader.readAsDataURL(input.files[0]);
    }
}

// Character count for bio
document.getElementById('bio').addEventListener('input', function() {
    const maxLength = 500;
    const currentLength = this.value.length;
    const remaining = maxLength - currentLength;
    
    let counter = this.parentNode.querySelector('.char-counter');
    if (!counter) {
        counter = document.createElement('small');
        counter.className = 'form-text text-muted char-counter';
        this.parentNode.appendChild(counter);
    }
    
    counter.textContent = `${currentLength}/${maxLength} characters`;
    counter.className = remaining < 50 ? 'form-text text-warning char-counter' : 'form-text text-muted char-counter';
    
    if (currentLength > maxLength) {
        this.value = this.value.substring(0, maxLength);
        counter.textContent = `${maxLength}/${maxLength} characters`;
        counter.className = 'form-text text-danger char-counter';
    }
});

// Initialize character counter if editing
if (document.getElementById('bio').value) {
    document.getElementById('bio').dispatchEvent(new Event('input'));
}
</script>

@endsection