@extends('SuperAdmin.layout.layout')
@section('title',"SubAdmin")
@section('page-name',"SubAdmins")
@section('page-detail',"All SubAdmins Information")
@section('pagelink', 'subadmins')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <form class="serch">
                                <div class="input-group mb-3">
                      <span class="input-group-text bg-transparent" id="basic-addon1">
                        <i class="fas fa-search search-icon"></i>
                      </span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search"
                                           aria-label="serch" aria-describedby="basic-addon1">
                                </div>
                            </form>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a href="#" class="btn btn-primary px-3 me-2" data-bs-toggle="modal"
                                   data-bs-target="#addModal"
                                   data-bs-whatever="@getbootstrap"><i class="fas fa-plus-circle me-3"></i> Add New
                                    SubAdmin</a>
                            </div>
                        </div>
                    </div>
                    @if($admins->isEmpty())
                        <h4>No SubAdmin Created Yet!</h4>
                    @else
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="entryTable" class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">SubAdmin Name</th>
                                            <th scope="col">Email</th>
                                            <!-- <th scope="col">Department</th>
                                            <th scope="col">Category</th>
                                            <th scope="col">Join Date</th>
                                            <th scope="col">Status</th> -->
                                            <th scope="col">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($admins as $admin)
                                            <tr>
                                                <th class="align-middle">
                                                    <div class="d-flex align-items-center">
                                                        <div>
                                                            @if (!empty($admin->image))
                                                                <img src="{{ asset($admin->image) }}"
                                                                     alt="Admin Image"
                                                                     style="height: 50px; width: 50px"
                                                                     class="img-fluid rounded-circle">
                                                            @else
                                                                <span class="initials-container">
                                                                {{ strtoupper(implode('', array_merge(array_map(fn($part) => is_numeric($part) ? $part : $part[0], array_slice(explode(' ', $admin->name ?? 'Unknown'), 0, 2)),preg_match('/\d/', $admin->name ?? '', $matches) ? [$matches[0]] : []))) }}
                                                            </span>
                                                            @endif
                                                        </div>
                                                        <div class="ms-2">
                                                            <h5 class="mb-0">{{$admin->name}}</h5>
                                                        </div>
                                                    </div>
                                                </th>
                                                <td class="align-middle">{{$admin->email}}</td>
                                                

                                             
                                                <td class="align-middle">
                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#addModal"
                                                       data-bs-whatever="@getbootstrap"
                                                       onclick="populateForm({{ json_encode($admin) }});">
                                                        <i class="fas fa-pen px-1"></i></a>

                                                    <a href="#"
                                                       onclick="deleteSubAdmin('{{$admin->id}}', $(this));">
                                                        <i class="fas fa-trash px-1"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- MODAL -->

    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4 id="modal-title">Create New SubAdmin</h4>
                    <hr>
                    <form id="subAdminForm">
                        @csrf
                        <input type="hidden" id="admin_id" name="admin_id">
                        <div class="row">
                            <!-- SubAdmin Name -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input type="text" name="name" class="form-control shadow-none"
                                           id="name" placeholder="SubAdmin Name" required>
                                </div>
                            </div> -->

                            <!-- Email -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input type="email" name="email" class="form-control shadow-none"
                                           id="email" placeholder="Email Address" required>
                                </div>
                            </div>

                            <!-- Password -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input type="password" name="password" class="form-control shadow-none"
                                           id="password" placeholder="Password">
                                    <small class="text-muted" id="password-help">Leave blank to keep current password when editing</small>
                                </div>
                            </div>

                            <!-- Dropdown to add Department -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="department" name="department" class="form-control"
                                            aria-label="Department"
                                            onchange="populateCategory({{$departments}})" required>
                                        <option selected disabled>--- Select Department ---</option>
                                        @foreach($departments as $department)
                                            <option value="{{$department->id}}">{{$department->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div> -->

                            <!-- Dropdown to Add Category -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="category" name="category" class="form-control" aria-label="category" required>
                                        <option selected disabled>--- Select category ---</option>
                                    </select>
                                </div>
                            </div> -->

                            <!-- SubAdmin Status -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="status" name="status" class="form-control"
                                            aria-label="Status of SubAdmin" required>
                                        <option selected disabled>--- Select Status ---</option>
                                        <option value="2">Active</option>
                                        <option value="0">Pending</option>
                                        <option value="1">Inactive</option>
                                    </select>
                                </div>
                            </div> -->

                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel
                            </button>
                            <button type="submit" id="sub-btn" class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">
                                Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- MODAL END -->

@endsection
@section('custom-scripts')

    <script>

        //Reset all form values
        $('#addModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset(); // Resets all form inputs
            $('#admin_id').val(''); // Clear hidden admin ID
            $('#modal-title').text('Create New SubAdmin');
            $('#password').prop('required', true);
            $('#password-help').hide();
        });

        // Show modal for creating new subadmin
        $('#addModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            // If no specific admin data is being passed, it's a new creation
            if (!button.attr('onclick') || !button.attr('onclick').includes('populateForm')) {
                $('#modal-title').text('Create New SubAdmin');
                $('#password').prop('required', true);
                $('#password-help').hide();
            }
        });

        // Function to Populate Category
        function populateCategory(departments) {
            let depid = $('#department').val();
            $('#category').empty();
            $('#category').append('<option selected disabled>--- Select category ---</option>')
            if (depid != null) {
                let cate = [];
                if(Array.isArray(departments) && departments.length > 0)
                {
                    departments.forEach(function (department) {
                        if (depid == department.id) {
                            cate = JSON.parse(department.categories);
                        }
                    });

                    for (let i = 0; i < cate.length; i++) {
                        $('#category').append('<option value="' + cate[i] + '">' + cate[i] + '</option>');
                    }
                }
            }
        }

        //This Function populate the Modal for editing
        function populateForm(admin) {
            //Empties the form
            $('form')[0].reset();
            
            // Set modal for editing
            $('#modal-title').text('Edit SubAdmin');
            $('#admin_id').val(admin.id);
            $('#name').val(admin.name);
            $('#email').val(admin.email);
            $('#password').prop('required', false);
            $('#password-help').show();
            
            // Set department and trigger change to populate categories
            $('#department').val(admin.department_id).trigger('change');
            
            // Set category after a brief delay to ensure categories are populated
            setTimeout(function() {
                $('#category').val(admin.category);
            }, 100);
            
            $('#status').val(admin.status);
        }

        //Script to Add/Update SubAdmin
        $('#subAdminForm').on("submit", function (e) {
            e.preventDefault()

            var form = $('#subAdminForm')[0];
            var formdata = new FormData(form);
            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('subadmin.add') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({             // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{asset('assets/img/WelcomebackFabiana.png')}}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 100);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#sub-btn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    if (e.responseJSON && e.responseJSON.errors) {
                        $.each(e.responseJSON.errors, function (index, item) {
                            if (count == 0) {
                                first_error = item[0];
                            }
                            count++;
                        });
                    } else {
                        first_error = 'An error occurred. Please try again.';
                    }
                    swirlmsg(first_error);
                    $('#sub-btn').html('Submit').prop('disabled', false);
                }

            });
        });

        //Function and AJAX to Delete SubAdmin
        function deleteSubAdmin(admin_id, element) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('subadmin.delete') }}',
                        data: {
                            id: admin_id,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function (res) {
                            if (res.Error === false) {
                                element.parent().parent().remove();
                                Swal.fire({ // Swirl Success MSG
                                    title: "Deleted!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function (e) {
                            let first_error = 'An unknown error occurred.';
                            if (e.responseJSON && e.responseJSON.errors) {
                                first_error = Object.values(e.responseJSON.errors)[0][0];
                            }
                            swirlmsg(first_error);
                        }
                    });
                }
            })
        }

    </script>
@endsection