@extends('SuperAdmin.layout.layout')
@section('title',"Employee")
@section('page-name',"Employee")
@section('page-detail',"All Employees Information")
@section('pagelink', 'employee')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <div class="serch">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i></span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search"
                                           aria-label="search" aria-describedby="basic-addon1">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a type="button" class="btn btn-primary px-3 me-2" data-bs-toggle="modal"
                                   data-bs-target="#addModal" data-bs-whatever="@getbootstrap" onclick="e_id()"><i
                                            class="fas fa-plus-circle me-3"></i> Add New Employee</a>
                                {{--                                <a href="#" class="btn btn-primary-white px-4"><i class="fa-solid rounded-3 fa-sliders me-2"></i> Filter</a> --}}
                            </div>
                        </div>
                    </div>

                    @if($employees->isEmpty())
                        <h4>No Employees Yet!</h4>
                    @else
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="entryTable" class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">Employee Name</th>
                                            <th scope="col">Employee ID</th>
                                            <th scope="col">Department</th>
                                            <th scope="col">Role</th>
                                            <th scope="col">Category</th>
                                            <th scope="col">Assigned Emojis</th>
                                            <th scope="col">Join Date</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($employees as $employee)
                                            <tr>
                                                <th class="align-middle">
                                                    <div class="d-flex align-items-center">
                                                        <div class="position-relative">
                                                            @if (!empty($employee->image))
                                                                <img src="{{ asset($employee->image) }}"
                                                                     alt="Employee Image"
                                                                     style="height: 50px; width: 50px"
                                                                     class="img-fluid rounded-circle">
                                                            @else
                                                                <span class="initials-container">
                                                                    {{ strtoupper(implode('', array_merge(array_map(fn($part) => is_numeric($part) ? $part : $part[0], array_slice(explode(' ', $employee->name), 0, 2)),preg_match('/\d/', $employee->name, $matches) ? [$matches[0]] : []))) }}
                                                                </span>
                                                            @endif
                                                            @php
                                                                $latestEmoji = \App\Models\EmojiAssignment::with('emoji')
                                                                    ->where('assignable_id', $employee->employee_id)
                                                                    ->where('assignable_type', 'App\Models\Employee')
                                                                    ->where('tenant_id', $employee->tenant_id)
                                                                    ->orderBy('created_at', 'desc')
                                                                    ->first();
                                                            @endphp
                                                            @if($latestEmoji)
                                                                <div class="custom-emoji-badge position-absolute" 
                                                                     style="bottom: -2px; right: -2px; font-size: 16px; 
                                                                            background: white; border-radius: 50%; 
                                                                            padding: 2px; line-height: 1; min-width: 24px; min-height: 24px; display: flex; align-items: center; justify-content: center;">
                                                                    @if($latestEmoji->emoji->type === 'emoji')
                                                                        <span style="font-size: 14px;">{{ $latestEmoji->emoji->emoji_text }}</span>
                                                                    @else
                                                                        <img src="{{ asset($latestEmoji->emoji->file_path) }}" 
                                                                             alt="{{ $latestEmoji->emoji->name }}" 
                                                                             style="height: 16px; width: 16px; object-fit: cover; border-radius: 50%;">
                                                                    @endif
                                                                </div>
                                                            @endif
                                                        </div>
                                                        <div class="ms-2">
                                                            <h5 class="mb-0">{{ Str::limit($employee->name, 15) }}</h5>
                                                        </div>
                                                    </div>
                                                </th>
                                                <td class="align-middle">{{$employee->employee_id}}</td>
                                          <!-- Displays Department -->
                                                @if($employee->department === null)
                                                    <td class="align-middle">{{"Unspecfied"}}</td>
                                                @else
                                                    <td class="align-middle">{{$employee->department->name ?? 'N/A'}}</td>
                                                @endif
                                          <!-- Displays Roles -->
                                                @if($employee->role === null)
                                                    <td class="align-middle">{{"Unspecfied"}}</td>
                                                @else
                                                    <td class="align-middle">{{$employee->role ?? 'N/A'}}</td>
                                                @endif
                                          <!-- Displays Category -->
                                                @if($employee->category === null)
                                                    <td class="align-middle">{{"Unspecfied"}}</td>
                                                @else
                                                    <td class="align-middle">{{ Str::limit($employee->category ?? 'N/A', 15) }}</td>
                                                @endif
                                                
                                                <!-- Assigned Emojis Column -->
                                                <td class="align-middle">
                                                    <div class="assigned-emojis-container" id="emojis-{{ $employee->employee_id }}">
                                                        @php
                                                            $assignedEmojis = \App\Models\EmojiAssignment::with('emoji')
                                                                ->where('assignable_id', $employee->employee_id)
                                                                ->where('assignable_type', 'App\Models\Employee')
                                                                ->where('tenant_id', $employee->tenant_id)
                                                                ->orderBy('created_at', 'desc')
                                                                ->take(3)
                                                                ->get();
                                                        @endphp
                                                        
                                                        @if($assignedEmojis->count() > 0)
                                                            <div class="d-flex align-items-center">
                                                                @foreach($assignedEmojis as $assignment)
                                                                    <div class="me-1" title="{{ $assignment->emoji->name }}">
                                                                        @if($assignment->emoji->type === 'emoji')
                                                                            <span style="font-size: 1.2rem;">{{ $assignment->emoji->emoji_text }}</span>
                                                                        @else
                                                                            <img src="{{ asset($assignment->emoji->file_path) }}" 
                                                                                 alt="{{ $assignment->emoji->name }}" 
                                                                                 style="height: 20px; width: 20px; object-fit: cover;">
                                                                        @endif
                                                                    </div>
                                                                @endforeach
                                                                @if($assignedEmojis->count() >= 3)
                                                                    <small class="text-muted">+{{ \App\Models\EmojiAssignment::where('assignable_id', $employee->employee_id)->where('assignable_type', 'App\Models\Employee')->where('tenant_id', $employee->tenant_id)->count() - 3 }}</small>
                                                                @endif
                                                            </div>
                                                        @else
                                                            <span class="text-muted">None</span>
                                                        @endif
                                                    </div>
                                                </td>

                                                <td class="align-middle">{{ $employee->created_at->format('m-d-y') }}</td>
                                                <td class="align-middle">
                                                    @if($employee->status === '2')
                                                        <a href="#" class="btn btn-active">Active</a>
                                                    @elseif($employee->status === '1')
                                                        <a href="#" class="btn btn-inactive">Inactive</a>
                                                    @else
                                                        <a href="#" class="btn btn-pending">Pending</a>
                                                    @endif
                                                </td>
                                                <td class="align-middle">
                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#addModal"
                                                       data-bs-whatever="@getbootstrap"
                                                       onclick="populateForm({{ json_encode($employee) }}, true)">
                                                        <i class="fas fa-eye px-1" title="View"></i></a>

                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#addModal"
                                                       data-bs-whatever="@getbootstrap"
                                                       onclick="populateForm({{ json_encode($employee) }}, false)">
                                                        <i class="fas fa-pen px-1" title="Edit"></i></a>

                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#emojiAssignmentModal"
                                                       onclick="openEmojiAssignmentModal('{{ $employee->employee_id }}', '{{ $employee->name }}')">
                                                        <i class="fas fa-smile px-1" title="Assign Emoji/GIF"></i></a>

                                                    <a href="#"
                                                       onclick="deleteEmployee('{{ $employee->employee_id }}', $(this));">
                                                        <i class="fas fa-trash px-1" title="Delete"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- ========================================= -->
    <!-- MODAL -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Employee</h4>
                    <hr>
                    <form id="addForm">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 d-none">
                                <div class="mb-md-4 mb-3">
                                    <input name="employee_id" type="number" readonly
                                           class="form-control shadow-none" id="employee_id"
                                           placeholder="Employee ID (auto)">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <!-- Name -->
                                    <input id="name" name="name" type="text" maxlength="50"
                                           class="form-control shadow-none" placeholder="Name (Required)" required>
                                    <small class="form-text" style="font-size: small;">Limit: 50 characters</small>
                                </div>
                                <!-- Email -->
                                <div class="mb-md-4 mb-3">
                                    <input id="email" name="email" type="email" class="form-control shadow-none"
                                           placeholder="Email (Required)" required>
                                </div>
                            </div>

                            <!-- Image -->
                            <div class="col-md-5 justify-content-end">
                                <div class="mb-md-4 mb-3 text-center position-relative">
                                    <img onclick="$(this).siblings('input[type=file]').click()"
                                         id="addimage"
                                         style="height: 100%; width: 145px; object-fit: fill; cursor: pointer;"
                                         src="{{ asset('assets/img/placeholder-img-2.png') }}"
                                         alt="Employee Image Preview">
                                    <!-- <input id="addimage" onchange="displaySelectedImage(this, 'addimage')" type="file"
                                           class="d-none" name="image" accept="image/*"> -->
                                             <input id="addimage" 
       onchange="displaySelectedImage(this, 'addimage')" 
       type="file" 
       class="d-none" 
       name="image" 
       accept="image/jpeg,image/png,image/jpg,image/gif">
                                      <div>Max 5MB</div>
                                    <!-- Custom Emoji Badge on Image (will be populated by JavaScript) -->
                                    <div id="custom-emoji-badge" class="position-absolute" 
                                         style="bottom: 10px; right: 20px; font-size: 20px; 
                                                background: white; border-radius: 50%; 
                                                padding: 4px; line-height: 1; 
                                                box-shadow: 0 2px 4px rgba(0,0,0,0.1); min-width: 32px; min-height: 32px; display: flex; align-items: center; justify-content: center;">
                                        <!-- Will be populated by JavaScript based on latest assignment -->
                                    </div>
                                </div>
                            </div>

                            <!-- Password -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="password" name="password" type="password" maxlength="50"
                                           class="form-control shadow-none" placeholder="Password (Required)" required>
                                </div>
                            </div>

                            <!-- Date of Birth -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3 text-left">
                                    <input id="dob" name="dob" type="date" class="form-control shadow-none"
                                           placeholder="Date of Birth" max="{{ date('Y-m-d') }}" value="">
                                </div>
                            </div>

                            <!-- Mobile Number -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="phn" name="phn" type="tel" maxlength="15" pattern="[0-9+\-\(\)\s]*"
                                           class="form-control shadow-none" placeholder="Mobile Number" value="">
                                </div>
                            </div>

                            <!-- Gender -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="gender" name="gender" class="form-control" aria-label="Gender">
                                        <option selected disabled value="">--- Select Gender ---</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                            </div> -->

                            <!-- Marital Status -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="marital" name="marital" class="form-control"
                                            aria-label="Marital Status">
                                        <option selected disabled value="">--- Select Marital Status ---</option>
                                        <option value="Married">Married</option>
                                        <option value="Unmarried">Unmarried</option>
                                    </select>
                                </div>
                            </div> -->

                            <!-- Employee Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="status" name="status" class="form-control"
                                            aria-label="Status of Employee">
                                        <option selected disabled value="">--- Select Status of Employee ---</option>
                                        <option value="2">Active</option>
                                        <option value="1">Inactive</option>
                                        <option value="0">Pending</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to add Department -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="department" name="department" class="form-control"
                                            aria-label="Department"
                                            onchange="populateCategory({{$departments}})" required>
                                        <option selected disabled>--- Select Department ---</option>
                                        @foreach($departments as $department)
                                            <option value="{{$department->id}}">{{$department->name}}</option>
                                        @endforeach
                                        <option value="" >Unspecified</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Role of Employee -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="role" name="role" class="form-control"
                                            onchange="mngrRestrict()" aria-label="role" required>
                                        <option disabled >--- Select category ---</option>
                                        <option value="Manager">Manager</option>
                                        <option value="Admin">Admin</option>
                                        <option selected value="Employee">Employee</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to Add Category -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="category" name="category" class="form-control" aria-label="category" required>
                                        <option selected disabled >--- Select category ---</option>
                                        <option value="">Unspecified</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Nationality -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="nationality" name="nationality" type="text" maxlength="15"
                                           class="form-control shadow-none" placeholder="Nationality">
                                </div>
                            </div> -->

                            <!-- Zip Code -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="zip" name="zip" type="number" maxlength="15"
                                           class="form-control shadow-none" placeholder="Zip Code">
                                </div>
                            </div>

                            <!-- State -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="state" name="state" type="text" maxlength="15"
                                           class="form-control shadow-none" placeholder="State">
                                </div>
                            </div>

                            <!-- City -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="city" name="city" type="text" maxlength="30"
                                           class="form-control shadow-none" placeholder="City">
                                </div>
                            </div>


                            <!-- Address -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <textarea id="address" name="address" type="text" rows="3" maxlength="100"
                                              class="form-control shadow-none" placeholder="Address"></textarea>
                                    <small class="form-text" style="font-size: small;">Limit: 100 characters</small>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button id="cancelBtn" type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel</button>

                            <button type="submit" id="sub-btn"
                                    class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    

    <!-- Emoji Assignment Modal -->
    <div class="modal fade" id="emojiAssignmentModal" tabindex="-1" aria-labelledby="emojiAssignmentModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="emojiAssignmentModalLabel">Assign Emoji/GIF to Employee</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Employee</label>
                                <input type="text" class="form-control" id="assignmentEmployeeName" readonly>
                                <input type="hidden" id="assignmentEmployeeId">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Select Emoji/GIF</label>
                                <select class="form-control" id="assignmentEmojiSelect" name="emoji_id">
                                    <option value="">Choose an emoji or GIF</option>
                                    @if(isset($availableEmojis) && $availableEmojis->count() > 0)
                                        @foreach($availableEmojis as $emoji)
                                            <option value="{{ $emoji->id }}" data-type="{{ $emoji->type }}" data-content="{{ $emoji->type === 'emoji' ? $emoji->emoji_text : $emoji->url }}">
                                                {{ $emoji->name }} ({{ ucfirst($emoji->type) }})
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Message (Optional)</label>
                        <textarea class="form-control" id="assignmentMessage" name="message" rows="3" placeholder="Enter a message with the emoji/GIF"></textarea>
                    </div>

                    <!-- Preview Section -->
                    <div id="assignmentPreview" class="mt-3 text-center" style="display: none;">
                        <div class="border rounded p-3 bg-light">
                            <div id="assignmentPreviewContent" style="font-size: 2rem; min-height: 60px; display: flex; align-items: center; justify-content: center;"></div>
                            <small class="text-muted" id="assignmentPreviewName"></small>
                        </div>
                    </div>

                    <!-- Current Assignments Section -->
                    <div class="mt-4">
                        <h6>Current Assignments</h6>
                        <div id="currentAssignments" class="row">
                            <!-- Current assignments will be loaded here -->
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" onclick="assignEmojiToEmployee()">
                        <i class="fas fa-plus me-2"></i>Assign Emoji/GIF
                    </button>
                </div>
            </div>
        </div>
    </div>
    <!-- ========================================= -->
@endsection
@section('custom-scripts')

    <script>
          function displaySelectedImage(input, imageId) {
        const maxSize = 5 * 1024 * 1024; // 5MB in bytes
        const file = input.files[0];
        
        if (file) {
            // Check file size
            if (file.size > maxSize) {
                Swal.fire({
                    icon: 'error',
                    title: 'File too large',
                    text: 'Please select an image smaller than 5MB'
                });
                input.value = ''; // Clear the input
                return;
            }
            
            // Check if it's an image
            if (!file.type.match('image.*')) {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid file type',
                    text: 'Please select an image file (JPEG, PNG, etc.)'
                });
                input.value = ''; // Clear the input
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                $('#' + imageId).attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
    }


        // Emoji preview functionality
        $(document).ready(function() {
            // Emoji preview functionality
            $('#emojiSelect').on('change', function() {
                const selectedOption = $(this).find('option:selected');
                const type = selectedOption.data('type');
                const content = selectedOption.data('content');
                const name = selectedOption.text();
                
                if (type && content) {
                    const previewContent = $('#previewContent');
                    const previewName = $('#previewName');
                    
                    if (type === 'emoji') {
                        previewContent.html(`<span style="font-size: 2rem;">${content}</span>`);
                    } else {
                        previewContent.html(`<img src="${content}" alt="${name}" style="max-height: 60px;">`);
                    }
                    
                    previewName.text(name);
                    $('#emojiPreview').show();
                } else {
                    $('#emojiPreview').hide();
                }
            });
        });

        //script to Populate Fields using Zip code
        $(document).ready(function () {
            let debounceTimeout;

            $('#zip').on('input', function () {
                clearTimeout(debounceTimeout); // Clear the previous timeout

                debounceTimeout = debounceTimeout = setTimeout(() => {

                    const zipCode = $(this).val().trim(); // Example ZIP code
                    const country = "US"; //Filter on the basis of Country
                    const searchUrl = `https://nominatim.openstreetmap.org/search?postalcode=${zipCode}&country=${country}&format=json`;

                    $.getJSON(searchUrl, function (data) {
                        if (data.length > 0) {
                            const lat = data[0].lat;
                            const lon = data[0].lon;

                            // Proceed to reverse geocode for detailed address
                            const reverseUrl = `https://nominatim.openstreetmap.org/reverse?lat=${lat}&lon=${lon}&format=json`;

                            $.getJSON(reverseUrl, function (reverseData) {
                                if (reverseData.address) {
                                    // Extract city, state, and address from the response
                                    const city = reverseData.address.city || reverseData.address.town || reverseData.address.village || "";
                                    const state = reverseData.address.state || "";
                                    const rawAddress = reverseData.display_name || "";

                                    // Function to trim redundant fields from the address
                                    function trimAddress(rawAddress, city, state) {
                                        // Convert raw address into an array of parts
                                        let addressParts = rawAddress.split(",").map(part => part.trim());

                                        // Filter out the city and state from the address parts
                                        addressParts = addressParts.filter(part => part !== city && part !== state);

                                        // Remove country if necessary (optional)
                                        addressParts = addressParts.filter(part => part !== "United States");

                                        // Join the remaining parts back into a single address string
                                        return addressParts.join(", ");
                                    }

                                    // Trim the raw address
                                    const trimmedAddress = trimAddress(rawAddress, city, state);

                                    // Populate the fields with the extracted and refined values
                                    $('#address').val(trimmedAddress);
                                    $('#city').val(city);
                                    $('#state').val(state);
                                } else {
                                    console.log("No detailed address found.");
                                }

                            }).fail(function () {
                                console.error("Failed to fetch reverse geocode data.");
                            });
                        } else {
                            console.log("No results found for the given ZIP code.");
                        }
                    }).fail(function () {
                        console.error("Failed to fetch search data.");
                    });
                }, 500);
            });
            // Function to clear the fields
            function clearFields() {
                $('#address').val('');
                $('#city').val('');
                $('#state').val('');
            }
        });


        //Script to clear Modal everytime it is closed
        $('#addModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset(); // Resets all form inputs
            $(this).find('img').attr('src', "{{ asset('assets/img/placeholder-img-2.png') }}");
            
            // Reset emoji assignment section
            $('#emojiSelect').val('');
            $('#emojiMessage').val('');
            $('#emojiPreview').hide();
            $('#currentEmojiAssignments').hide();
            $('#currentAssignmentsList').empty();
            $('#currentAssignmentDisplay').hide();
            $('#assignmentForm').show();
            window.currentAssignment = null;
            hideCustomEmojiBadge();
            
            reading(false);
        });

        //Function to Populate Form
        function populateForm(employee, read) {
            // Reset the form
            $('form')[0].reset();
            // Populate the input fields with employee data
            $('#employee_id').val(employee.employee_id);
            $('#name').val(employee.name);
            $('#email').val(employee.email);
            $('#password').removeAttr('required');
            $('#status').val(employee.status);
            $('#addimage').attr('src', employee.image ? '{{ asset('') }}' + employee.image : '{{ asset('assets/img/placeholder-img-2.png') }}');
            $('#dob').val(employee.dob);
            $('#phn').val(employee.phn);
            $('#gender').val(employee.gender);
            $('#marital').val(employee.marital);
            $('#nationality').val(employee.nationality);
            $('#city').val(employee.city);
            $('#state').val(employee.state);
            $('#zip').val(employee.zip);
            $('#address').val(employee.address);
            $('#department').val(employee.department_id).trigger('change');
            $('#role').val(employee.role);
            
            // Handle emoji
            if (employee.emoji) {
                $('#emoji').val(employee.emoji);
                $('#emoji-badge').text(employee.emoji);
            } else {
                $('#emoji').val('😊');
                $('#emoji-badge').text('😊');
            }

            // Handle emoji assignment - fetch current assignments for this employee
            if (!read) {
                window.currentEmployeeId = employee.employee_id; // Store for later use
                fetchEmployeeEmojiAssignments(employee.employee_id);
            } else {
                // Hide current assignments section in read mode
                $('#currentEmojiAssignments').hide();
            }

            if (employee.role === 'Manager') {
                $('#category').val("").prop('disabled', true); // Disable interaction
            } else {
                $('#category').val(employee.category).prop('disabled', false);
            }
            reading(read); // Set the form to Readonly

        }

    // Function to fetch employee emoji assignments
    function fetchEmployeeEmojiAssignments(employeeId) {
        console.log('Fetching emoji assignments for employee:', employeeId);
        
        $.ajax({
            url: '/super-admin/employee/emoji-assignments/' + employeeId,
            method: 'GET',
            success: function(response) {
                console.log('Emoji assignments response:', response);
                
                if (response.success) {
                    console.log('Assignments found:', response.assignments);
                    displayCurrentAssignmentsInForm(response.assignments);
                } else {
                    console.log('No assignments found or error:', response.message);
                    // Reset to default
                    $('#emojiSelect').val('');
                    $('#emojiMessage').val('');
                    $('#emojiPreview').hide();
                    $('#currentEmojiAssignments').hide();
                }
            },
            error: function(xhr, status, error) {
                console.error('Error fetching emoji assignments:', error);
                console.error('XHR response:', xhr.responseText);
                // Reset to default on error
                $('#emojiSelect').val('');
                $('#emojiMessage').val('');
                $('#emojiPreview').hide();
                $('#currentEmojiAssignments').hide();
            }
        });
    }

    // Display current assignments in the form
    function displayCurrentAssignmentsInForm(assignments) {
        console.log('Displaying assignments in form:', assignments);
        
        const container = $('#currentAssignmentsList');
        const section = $('#currentEmojiAssignments');
        const currentDisplay = $('#currentAssignmentDisplay');
        const assignmentForm = $('#assignmentForm');
        
        if (assignments.length === 0) {
            console.log('No assignments to display');
            // Hide current assignment display
            currentDisplay.hide();
            assignmentForm.show();
            
            // Hide custom emoji badge
            hideCustomEmojiBadge();
            
            // Show "no assignments" message in the history section
            container.html('<div class="col-12"><p class="text-muted">No emojis/GIFs assigned yet</p></div>');
            section.show();
            return;
        }

        // Show the most recent assignment as current
        const latestAssignment = assignments[0];
        displayCurrentAssignment(latestAssignment);
        
        // Show assignment history
        displayAssignmentHistory(assignments.slice(1));
    }

    // Display the current assignment
    function displayCurrentAssignment(assignment) {
        const currentDisplay = $('#currentAssignmentDisplay');
        const assignmentForm = $('#assignmentForm');
        const preview = $('#currentAssignmentPreview');
        const name = $('#currentAssignmentName');
        const message = $('#currentAssignmentMessage');
        
        const emoji = assignment.emoji;
        
        // Display the emoji/GIF
        if (emoji.type === 'emoji') {
            preview.html(`<span style="font-size: 2rem;">${emoji.emoji_text}</span>`);
        } else {
            preview.html(`<img src="${emoji.file_path}" alt="${emoji.name}" style="height: 40px; width: 40px; object-fit: cover;">`);
        }
        
        // Display name and message
        name.text(emoji.name);
        message.text(assignment.message || 'No message');
        
        // Show current assignment display and hide form
        currentDisplay.show();
        assignmentForm.hide();
        
        // Store current assignment data for change functionality
        window.currentAssignment = assignment;
        
        // Update the custom emoji badge on the image
        updateCustomEmojiBadge(emoji);
    }

    // Update the custom emoji badge on the image
    function updateCustomEmojiBadge(emoji) {
        const badge = $('#custom-emoji-badge');
        
        if (emoji.type === 'emoji') {
            badge.html(`<span style="font-size: 18px;">${emoji.emoji_text}</span>`);
        } else {
            badge.html(`<img src="${emoji.file_path}" alt="${emoji.name}" style="height: 24px; width: 24px; object-fit: cover; border-radius: 50%;">`);
        }
        badge.show();
    }

    // Hide custom emoji badge
    function hideCustomEmojiBadge() {
        $('#custom-emoji-badge').hide();
    }

    // Display assignment history
    function displayAssignmentHistory(assignments) {
        const container = $('#currentAssignmentsList');
        const section = $('#currentEmojiAssignments');
        
        if (assignments.length === 0) {
            container.html('<div class="col-12"><p class="text-muted">No previous assignments</p></div>');
            section.show();
            return;
        }

        let html = '';
        assignments.forEach(function(assignment) {
            const emoji = assignment.emoji;
            const content = emoji.type === 'emoji' ? emoji.emoji_text : `<img src="${emoji.file_path}" alt="${emoji.name}" style="height: 30px; width: 30px; object-fit: cover;">`;
            
            html += `
                <div class="col-md-4 mb-3">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body text-center p-2">
                            <div class="mb-2" style="min-height: 40px; display: flex; align-items: center; justify-content: center;">
                                ${emoji.type === 'emoji' ? `<span style="font-size: 1.5rem;">${content}</span>` : content}
                            </div>
                            <h6 class="card-title mb-1 small">${emoji.name}</h6>
                            ${assignment.message ? `<p class="card-text text-muted small mb-1">${assignment.message}</p>` : ''}
                            <small class="text-muted">${new Date(assignment.created_at).toLocaleDateString()}</small>
                            <div class="mt-2">
                                <button class="btn btn-sm btn-outline-danger" onclick="removeEmojiAssignmentFromForm(${assignment.id}, '${assignment.assignable_id}')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        });
        
        container.html(html);
        section.show();
    }

    // Remove emoji assignment from form
    function removeEmojiAssignmentFromForm(assignmentId, employeeId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This will remove the emoji assignment from the employee",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '/super-admin/employee/remove-emoji-assignment',
                    method: 'POST',
                    data: {
                        assignment_id: assignmentId,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Removed!',
                                text: response.message
                            });
                            
                            // Reload current assignments in the form
                            fetchEmployeeEmojiAssignments(employeeId);
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: response.message
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Failed to remove emoji assignment'
                        });
                    }
                });
            }
        });
    }

    // Show change assignment form
    function showChangeAssignmentForm() {
        const currentDisplay = $('#currentAssignmentDisplay');
        const assignmentForm = $('#assignmentForm');
        
        // Hide current assignment display and show form
        currentDisplay.hide();
        assignmentForm.show();
        
        // Pre-populate form with current assignment data
        if (window.currentAssignment) {
            const assignment = window.currentAssignment;
            $('#emojiSelect').val(assignment.emoji_id);
            $('#emojiMessage').val(assignment.message || '');
            
            // Trigger preview update
            $('#emojiSelect').trigger('change');
        }
    }

    // Hide change assignment form (show current assignment)
    function hideChangeAssignmentForm() {
        const currentDisplay = $('#currentAssignmentDisplay');
        const assignmentForm = $('#assignmentForm');
        
        // Show current assignment display and hide form
        currentDisplay.show();
        assignmentForm.hide();
        
        // Reset form
        $('#emojiSelect').val('');
        $('#emojiMessage').val('');
        $('#emojiPreview').hide();
    }

    // Update existing emoji assignment
    function updateExistingAssignment(assignmentId, emojiId, message) {
        $.ajax({
            url: '/super-admin/employee/update-emoji-assignment',
            method: 'POST',
            data: {
                assignment_id: assignmentId,
                emoji_id: emojiId,
                message: message,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Updated!',
                        text: response.message
                    });
                    
                    // Update the current assignment display
                    if (response.assignment) {
                        displayCurrentAssignment(response.assignment);
                    }
                    
                    // Hide the form and show current assignment
                    hideChangeAssignmentForm();
                    
                    // Refresh the assignment history
                    if (window.currentEmployeeId) {
                        fetchEmployeeEmojiAssignments(window.currentEmployeeId);
                    }
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: response.message
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'Failed to update emoji assignment'
                });
            }
        });
    }

        //Function to set the Modal to Readonly
        function reading(read) {
            $('#addModal input').prop('readonly', read);
            $('#addModal select, #addModal textarea').css('pointer-events', read ? 'none' : 'auto');
            $('#addModal img').css('pointer-events', read ? 'none' : 'auto');
            $('#emoji-badge').css('pointer-events', read ? 'none' : 'auto'); // Disable emoji picker in read mode
            
            if(read)
            {
                $('#sub-btn').addClass('d-none');
                $('#cancelBtn').addClass('btn-primary').removeClass('btn-primary-white').html('Back');
            }
            else
            {
                $('#sub-btn').removeClass('d-none');
                $('#cancelBtn').removeClass('btn-primary').addClass('btn-primary-white').html('Cancel');
            }
        }

        //Generates Employee ID
        function e_id() {
            //Employee-ID Auto Generate
            var timestamp = Date.now().toString();
            var randomNum = Math.floor(Math.random() * (999 - 100 + 1)) + 100;
            var empid = (timestamp + randomNum).slice(-9); // Take the last 7-9 digits
            $('#employee_id').val(empid);
            
            
            // Reset emoji assignment section for new employee
            $('#emojiSelect').val('');
            $('#emojiMessage').val('');
            $('#emojiPreview').hide();
            $('#currentEmojiAssignments').hide();
            $('#currentAssignmentsList').empty();
            $('#currentAssignmentDisplay').hide();
            $('#assignmentForm').show();
            window.currentAssignment = null;
            hideCustomEmojiBadge();
        }

        //Restrict user not to choose category for manager
        function mngrRestrict() {
            let choose = $('#role').val();
            if (choose === 'Manager') {
                $('#category').val("").prop('disabled', true); // Disable interaction
            } else {
                $('#category').prop('disabled', false).attr('require', true); // Enable interaction and Required
            }
        }

        // Function to Populate Category
        function populateCategory(departments) {
            let depid = $('#department').val();
            $('#category').empty();
            $('#category').append('<option selected disabled>--- Select category ---</option>')
            if (depid != null) {
                let cate = [];
                if(Array.isArray(departments) && departments.length > 0)
                {
                    departments.forEach(function (department) {
                        if (depid == department.id) {
                            cate = JSON.parse(department.categories);
                        }
                    });

                    for (let i = 0; i < cate.length; i++) {
                        $('#category').append('<option value="' + cate[i] + '">' + cate[i] + '</option>');
                    }
                }
            }
            if($('#role').val() === 'Manager' || depid === "")
            {
                $('#category').append('<option value="">Unspecified</option>');
            }
        }

        //AJAX to Add/Update  Employee
        $('#addModal').on("submit", function (e) {
            e.preventDefault()

            // Check if we're updating an existing emoji assignment
            if (window.currentAssignment && $('#emojiSelect').val()) {
                updateExistingAssignment(window.currentAssignment.id, $('#emojiSelect').val(), $('#emojiMessage').val());
                return; // Don't submit the main form
            }

            var form = $('#addForm')[0];
            var formdata = new FormData(form);
            
            // Add emoji assignment data if provided
            if ($('#emojiSelect').val()) {
                formdata.append('emoji_id', $('#emojiSelect').val());
                formdata.append('emoji_message', $('#emojiMessage').val() || '');
            }
            
            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('employee.add') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 100);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#sub-btn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#sub-btn').html('Submit').prop('disabled', false);
                }

            });
        });

        //Function and AJAX to Delete Employee
        function deleteEmployee(id, element) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('employee.delete') }}',
                        data: {
                            id: id,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function (res) {
                            if (res.Error === false) {
                                element.parent().parent().remove();
                                Swal.fire({ // Swirl Success MSG
                                    title: "Deleted!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function (e) {
                            let first_error = 'An unknown error occurred.';
                            if (e.responseJSON && e.responseJSON.errors) {
                                first_error = Object.values(e.responseJSON.errors)[0][0];
                            }
                            swirlmsg(first_error);
                        }
                    });
                }
            })
        }
 function displaySelectedImage(input, imageId) {
        const maxSize = 5 * 1024 * 1024; // 5MB in bytes
        const file = input.files[0];
        
        if (file) {
            // Check file size
            if (file.size > maxSize) {
                Swal.fire({
                    icon: 'error',
                    title: 'File too large',
                    text: 'Please select an image smaller than 5MB'
                });
                input.value = ''; // Clear the input
                return;
            }
            
            // Check if it's an image
            if (!file.type.match('image.*')) {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid file type',
                    text: 'Please select an image file (JPEG, PNG, etc.)'
                });
                input.value = ''; // Clear the input
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                $('#' + imageId).attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
    }

    // =========================================
    // EMOJI ASSIGNMENT FUNCTIONS
    // =========================================

    // Open emoji assignment modal
    function openEmojiAssignmentModal(employeeId, employeeName) {
        $('#assignmentEmployeeId').val(employeeId);
        $('#assignmentEmployeeName').val(employeeName);
        
        // Reset form
        $('#assignmentEmojiSelect').val('');
        $('#assignmentMessage').val('');
        $('#assignmentPreview').hide();
        
        // Load current assignments
        loadCurrentAssignments(employeeId);
    }

    // Load current emoji assignments for the employee
    function loadCurrentAssignments(employeeId) {
        $.ajax({
            url: '/super-admin/employee/emoji-assignments/' + employeeId,
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    displayCurrentAssignments(response.assignments);
                } else {
                    $('#currentAssignments').html('<p class="text-muted">No assignments found</p>');
                }
            },
            error: function(xhr, status, error) {
                console.error('Error loading assignments:', error);
                $('#currentAssignments').html('<p class="text-danger">Error loading assignments</p>');
            }
        });
    }

    // Display current assignments
    function displayCurrentAssignments(assignments) {
        const container = $('#currentAssignments');
        
        if (assignments.length === 0) {
            container.html('<p class="text-muted">No emojis/GIFs assigned yet</p>');
            return;
        }

        let html = '';
        assignments.forEach(function(assignment) {
            const emoji = assignment.emoji;
            const content = emoji.type === 'emoji' ? emoji.emoji_text : `<img src="${emoji.file_path}" alt="${emoji.name}" style="height: 30px; width: 30px; object-fit: cover;">`;
            
            html += `
                <div class="col-md-4 mb-3">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body text-center p-2">
                            <div class="mb-2" style="min-height: 40px; display: flex; align-items: center; justify-content: center;">
                                ${emoji.type === 'emoji' ? `<span style="font-size: 1.5rem;">${content}</span>` : content}
                            </div>
                            <h6 class="card-title mb-1 small">${emoji.name}</h6>
                            ${assignment.message ? `<p class="card-text text-muted small mb-1">${assignment.message}</p>` : ''}
                            <small class="text-muted">${new Date(assignment.created_at).toLocaleDateString()}</small>
                            <div class="mt-2">
                                <button class="btn btn-sm btn-outline-danger" onclick="removeEmojiAssignment(${assignment.id}, '${assignment.assignable_id}')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        });
        
        container.html(html);
    }

    // Assign emoji to employee
    function assignEmojiToEmployee() {
        const employeeId = $('#assignmentEmployeeId').val();
        const emojiId = $('#assignmentEmojiSelect').val();
        const message = $('#assignmentMessage').val();

        if (!emojiId) {
            Swal.fire({
                icon: 'warning',
                title: 'No Emoji Selected',
                text: 'Please select an emoji or GIF to assign'
            });
            return;
        }

        // Show loading
        const assignBtn = $('button[onclick="assignEmojiToEmployee()"]');
        const originalText = assignBtn.html();
        assignBtn.html('<i class="fas fa-spinner fa-spin me-2"></i>Assigning...').prop('disabled', true);

        $.ajax({
            url: '/super-admin/employee/assign-emoji',
            method: 'POST',
            data: {
                employee_id: employeeId,
                emoji_id: emojiId,
                message: message,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message
                    });
                    
                    // Reload current assignments
                    loadCurrentAssignments(employeeId);
                    
                    // Reset form
                    $('#assignmentEmojiSelect').val('');
                    $('#assignmentMessage').val('');
                    $('#assignmentPreview').hide();
                    
                    // Update the table display
                    updateEmployeeEmojiDisplay(employeeId);
                    
                    // Close modal
                    $('#emojiAssignmentModal').modal('hide');
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: response.message
                    });
                }
            },
            error: function(xhr, status, error) {
                let errorMessage = 'An error occurred while assigning the emoji';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }
                
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: errorMessage
                });
            },
            complete: function() {
                assignBtn.html(originalText).prop('disabled', false);
            }
        });
    }

    // Remove emoji assignment
    function removeEmojiAssignment(assignmentId, employeeId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This will remove the emoji assignment from the employee",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '/super-admin/employee/remove-emoji-assignment',
                    method: 'POST',
                    data: {
                        assignment_id: assignmentId,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Removed!',
                                text: response.message
                            });
                            
                            // Reload current assignments
                            loadCurrentAssignments(employeeId);
                            
                            // Update the table display
                            updateEmployeeEmojiDisplay(employeeId);
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: response.message
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Failed to remove emoji assignment'
                        });
                    }
                });
            }
        });
    }

    // Update employee emoji display in the table
    function updateEmployeeEmojiDisplay(employeeId) {
        $.ajax({
            url: '/super-admin/employee/emoji-assignments/' + employeeId,
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    const container = $('#emojis-' + employeeId);
                    let html = '';
                    
                    if (response.assignments.length > 0) {
                        html = '<div class="d-flex align-items-center">';
                        response.assignments.slice(0, 3).forEach(function(assignment) {
                            const emoji = assignment.emoji;
                            if (emoji.type === 'emoji') {
                                html += `<div class="me-1" title="${emoji.name}"><span style="font-size: 1.2rem;">${emoji.emoji_text}</span></div>`;
                            } else {
                                html += `<div class="me-1" title="${emoji.name}"><img src="${emoji.file_path}" alt="${emoji.name}" style="height: 20px; width: 20px; object-fit: cover;"></div>`;
                            }
                        });
                        
                        if (response.assignments.length > 3) {
                            html += `<small class="text-muted">+${response.assignments.length - 3}</small>`;
                        }
                        html += '</div>';
                    } else {
                        html = '<span class="text-muted">None</span>';
                    }
                    
                    container.html(html);
                }
            },
            error: function(xhr, status, error) {
                console.error('Error updating emoji display:', error);
            }
        });
    }

    // Preview emoji selection
    $(document).ready(function() {
        $('#assignmentEmojiSelect').on('change', function() {
            const selectedOption = $(this).find('option:selected');
            const type = selectedOption.data('type');
            const content = selectedOption.data('content');
            const name = selectedOption.text();

            if (type && content) {
                const previewContent = $('#assignmentPreviewContent');
                const previewName = $('#assignmentPreviewName');

                if (type === 'emoji') {
                    previewContent.html(`<span style="font-size: 2rem;">${content}</span>`);
                } else {
                    previewContent.html(`<img src="${content}" alt="${name}" style="max-height: 60px;">`);
                }

                previewName.text(name);
                $('#assignmentPreview').show();
            } else {
                $('#assignmentPreview').hide();
            }
        });

        // Clear assignment modal when closed
        $('#emojiAssignmentModal').on('hidden.bs.modal', function() {
            $('#assignmentEmojiSelect').val('');
            $('#assignmentMessage').val('');
            $('#assignmentPreview').hide();
            $('#currentAssignments').empty();
        });
    });
    </script>

@endsection