@extends('SuperAdmin.layout.layout')
@section('title', $department->name . ' Department')
@section('page-name', 'Departments')
@section('sub-page-name', 'Service Department')
@section('pagelink', 'departments')
@section('body')
    <style>
        tags {
            height: auto !important;
        }
    </style>
    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center">
                                <div class="ms-4">
                                    <h3>{{ $department->name }} Department</h3>
                                    <p class="p-small mb-1"><span><i class="fas fa-briefcase me-2"></i></span> Manger:
                                        {{ $manager_count }}
                                    </p>
                                    <p class="p-small mb-1"><span><i class="fas fa-users me-2"></i></span> Admins:
                                        {{ $admin_count }}</p>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-6 mt-auto">
                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary w-auto-fix" data-bs-toggle="modal"
                                    data-bs-target="#editModal" data-bs-whatever="@getbootstrap"
                                    onclick="oldManagr({{ $employees }}, {{ $department->id }})">
                                    <i class="fas fa-pen me-2"></i> Edit Department </button>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-md-3">
                            <!-- Nav Tabs -->
                            <div class="s-department">
                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    @foreach ($categories as $index => $category)
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link {{ $index === 0 ? 'active' : '' }}" data-bs-toggle="tab"
                                                href="#{{ strtolower(str_replace(' ', '-', $category)) }}" role="tab"
                                                aria-controls="{{ strtolower(str_replace(' ', '-', $category)) }}"
                                                aria-selected="{{ $index === 0 ? 'true' : 'false' }}"
                                                style="{{ $index === 0 ? 'border-radius: 10px 10px 0px 0px !important;' : '' }}">
                                                <i class="fas fa-user"></i> {{ $category }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>

                        <div class="col-md-9">
                            <!-- Tab Content -->
                            <div class="tab-content" id="myTabContent">
                                @foreach ($categories as $index => $category)
                                    @if($index === 0)
                                        <div class="tab-pane fade {{ $index === 0 ? 'show active' : '' }}"
                                             id="{{ strtolower(str_replace(' ', '-', $category)) }}" role="tabpanel"
                                             aria-labelledby="{{ strtolower(str_replace(' ', '-', $category)) }}-tab">
                                            <!-- Enter Manager Code Here -->
                                            <div class="row">
                                                @php
                                                    if($category == 'Manager')
                                                    {
                                                        $catemployees = $employees->where('role', $category)->where('department_id', $department->id)->all();
                                                        $catemployees = array_values($catemployees);

                                                        // Initialize variables to keep track of current index
                                                        $currentIndex = request()->input('current', 0); // Default to 0
                                                        $totalManagers = count($catemployees) == 0 ? 1 : count($catemployees);
                                                        $currentIndex = $currentIndex % $totalManagers; // Wrap around if out of bounds
                                                    
                                                    }
                                                @endphp

                                                <div class="col-md-7">
                                                    <div class="row">
                                                        <div class="d-flex justify-content-between align-items-center w-100">
                                                            <h4 class="mb-3">
                                                                <span><i class="fas fa-user me-2"></i></span> Personal Information
                                                            </h4>
                                                            @if($totalManagers > 1)
                                                                {{-- Navigation buttons --}}
                                                                <div>
                                                                    {{-- Next Button --}}
                                                                    <form method="GET">
                                                                        <input type="hidden" name="current" value="{{ ($currentIndex + 1) % $totalManagers }}">
                                                                        <button type="submit" class="btn btn-outline-primary">Next</button>
                                                                    </form>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>

                                                    {{-- Display current manager based on the index --}}
                                                    @foreach($catemployees as $index => $employee)
                                                        @if($index == $currentIndex)
                                                            <div class="manager-container">
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">Name</p>
                                                                        <h5>{{$employee->name ?? 'N/A'}}</h5>
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">Mobile Number</p>
                                                                        <h5>{{$employee->phn ?? 'N/A'}}</h5>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">Email Address</p>
                                                                        <h5>{{$employee->email ?? 'N/A'}}</h5>
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">Date of Birth</p>
                                                                        <h5>{{\Carbon\Carbon::parse($employee->dob)->format('M d, Y') ?? 'N/A'}}</h5>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">Marital Status</p>
                                                                        <h5>{{$employee->marital ?? 'N/A'}}</h5>
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">Gender</p>
                                                                        <h5>{{$employee->gender ?? 'N/A'}}</h5>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">Nationality</p>
                                                                        <h5>{{$employee->nationality ?? 'N/A'}}</h5>
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">Address</p>
                                                                        <h5>{{$employee->address ?? 'N/A'}}</h5>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">City</p>
                                                                        <h5>{{$employee->city ?? 'N/A'}}</h5>
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">State</p>
                                                                        <h5>{{$employee->state ?? 'N/A'}}</h5>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <p class="p-light">Zip Code</p>
                                                                        <h5>{{$employee->zip ?? 'N/A'}}</h5>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endif
                                                    @endforeach
                                                </div>
                                                <!-- Targets Side-Pane -->
                                                <div class="col-md-5">
                                                    <div class="card">
                                                        <div class="card-body border rounded-3">
                                                            <h4 class="mb-3">Task and Point Tabel</h4>

                                                            @foreach($categories as $category)
                                                                @if($category != 'Admin' && $category != 'Manager')
                                                                    <div class="mb-3">
                                                                        <div class="d-flex align-items-center justify-content-between mb-3">
                                                                            <h5>Category: {{$category}}</h5>
                                                                            {{--                                                                        <i class="fas fa-ellipsis-v"></i>--}}
                                                                        </div>
                                                                        @foreach($targets as $lowTarget)
                                                                            @if($lowTarget->category == $category)
                                                                                <div class="d-flex align-items-center mb-3">
                                                                                    <div class="pe-3">
                                                                                        <h4 class="text-nowrap">1 Point</h4>
                                                                                    </div>
                                                                                    @if($lowTarget->product_id == null)
                                                                                        <div class="ps-3 b-left-line">
                                                                                            <h4 class="text-dark mb-2">{{$lowTarget->custom}}</h4>
                                                                                            <p>Will Get 1 Point</p>
                                                                                        </div>
                                                                                    @else
                                                                                        <div class="ps-3 b-left-line">
                                                                                            <h4 class="text-dark mb-2">Sell {{$lowTarget->product}}</h4>
                                                                                            <p>Will Get 1 Point</p>
                                                                                        </div>
                                                                                    @endif
                                                                                </div>
                                                                            @endif
                                                                        @endforeach
                                                                    </div>
                                                                @endif
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    @else
                                        <div class="tab-pane fade {{ $index === 0 ? 'show active' : '' }}"
                                             id="{{ strtolower(str_replace(' ', '-', $category)) }}" role="tabpanel"
                                             aria-labelledby="{{ strtolower(str_replace(' ', '-', $category)) }}-tab">

                                            <!-- Your employee listing and search/filter form as in the code you provided -->
{{--                                            <div class="row mb-3">--}}
{{--                                                <div class="col-md-5 col-lg-4">--}}
{{--                                                    <form class="search">--}}
{{--                                                        <div class="input-group mb-3">--}}
{{--                                                        <span class="input-group-text bg-transparent" id="basic-addon1">--}}
{{--                                                            <i class="fas fa-search search-icon"></i>--}}
{{--                                                        </span>--}}
{{--                                                            <input id="searchInput" type="text" class="form-control shadow-none"--}}
{{--                                                                   placeholder="Search" aria-label="search"--}}
{{--                                                                   aria-describedby="basic-addon1">--}}
{{--                                                        </div>--}}
{{--                                                    </form>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}

                                            <!-- Table displaying employees by category -->
                                            <div class="table-responsive">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col">Employee Name</th>
                                                        <th scope="col">Employee ID</th>
                                                        <th scope="col">Type</th>
                                                        @if($category == 'Admin')
                                                            <th scope="col">Category</th>
                                                        @endif
                                                        <th scope="col">Status</th>
                                                        {{--                                                        <th scope="col">Action</th>--}}
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @php
                                                        if ($category == 'Admin')
                                                        {
                                                            $catemployees = $employees->where('role', $category)->where('department_id', $department->id)->all();
                                                        }
                                                        else
                                                        {
                                                            $catemployees = $employees->where('category', $category)->where('department_id', $department->id)->all();
                                                        }
                                                    @endphp
                                                    @foreach ($catemployees as $employee)
                                                        <!-- Condition to display Employees -->
                                                        @if($employee->category == $category && $employee->role == 'Employee')
                                                            <tr>
                                                                <td class="align-middle">
                                                                    @if (!empty($employee->image))
                                                                        <img src="{{ asset($employee->image) }}"
                                                                             alt="Employee Image"
                                                                             style="height: 50px; width: 50px"
                                                                             class="img-fluid rounded-circle">
                                                                    @else
                                                                        <span class="initials-container">
                                                                    {{ strtoupper(implode('', array_merge(array_map(fn($part) => is_numeric($part) ? $part : $part[0], array_slice(explode(' ', $employee->name), 0, 2)),preg_match('/\d/', $employee->name, $matches) ? [$matches[0]] : []))) }}
                                                                </span>
                                                                    @endif {{ $employee->name }}
                                                                </td>

                                                                <td class="align-middle">{{ $employee->employee_id }}</td>
                                                                <td class="align-middle">
                                                                    {{ $employee->role }}
                                                                </td>
                                                                <td class="align-middle">
                                                                    @if ($employee->status == 0)
                                                                        <span class="btn btn-pending">Pending</span>
                                                                    @elseif($employee->status == 1)
                                                                        <span class="btn btn-inactive">Inactive</span>
                                                                    @elseif($employee->status == 2)
                                                                        <span class="btn btn-active">Active</span>
                                                                    @endif
                                                                </td>
                                                            </tr>
                                                            <!-- Condition to display Admins -->
                                                        @elseif($employee->role == $category && $employee->department_id == $department->id)
                                                            <tr>
                                                                <td class="align-middle">
                                                                    @if (!empty($employee->image))
                                                                        <img src="{{ asset($employee->image) }}"
                                                                             alt="Employee Image"
                                                                             style="height: 50px; width: 50px"
                                                                             class="img-fluid rounded-circle">
                                                                    @else
                                                                        <span class="initials-container">
                                                                    {{ strtoupper(implode('', array_merge(array_map(fn($part) => is_numeric($part) ? $part : $part[0], array_slice(explode(' ', $employee->name), 0, 2)),preg_match('/\d/', $employee->name, $matches) ? [$matches[0]] : []))) }}
                                                                </span>
                                                                    @endif
                                                                    &nbsp;&nbsp;
                                                                    {{ $employee->name }}</td>

                                                                <td class="align-middle">{{ $employee->employee_id }}</td>
                                                                <td class="align-middle">{{ $employee->role }}</td>
                                                                <td class="align-middle">{{ $employee->category }}</td>
                                                                <td class="align-middle">
                                                                    @if ($employee->status == 0)
                                                                        <span class="btn btn-pending">Pending</span>
                                                                    @elseif($employee->status == 1)
                                                                        <span class="btn btn-inactive">Inactive</span>
                                                                    @elseif($employee->status == 2)
                                                                        <span class="btn btn-active">Active</span>
                                                                    @endif
                                                                </td>
                                                                {{--                                                                <td class="align-middle">--}}
                                                                {{--                                                                    <a onclick="showEmployeeDetails('{{ $employee->employee_id }}' , '{{ $employee->name }}' , '{{ $employee->email }}' , '{{ asset($employee->image) }}' , '{{ $employee->dob }}' , '{{ $employee->phn }}' , '{{ $employee->gender }}' , '{{ $employee->marital }}' , '{{ $employee->status }}' , '{{ $employee->department_id }}' , '{{ $employee->role }}' , '{{ $employee->category }}' , '{{ $employee->nationality }}' , '{{ $employee->state }}' , '{{ $employee->zip }}' , '{{ $employee->city }}' , '{{ $employee->address }}')"--}}
                                                                {{--                                                                       href="" data-bs-toggle="modal"--}}
                                                                {{--                                                                       data-bs-target="#employeeModal"--}}
                                                                {{--                                                                       data-bs-whatever="@getbootstrap"><i--}}
                                                                {{--                                                                            class="fas fa-eye px-1"></i></a>--}}
                                                                {{--                                                                </td>--}}
                                                            </tr>
                                                        @endif
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ========================================= -->

    <!-- MODAL -->
    <div class="modal fade" id="employeeModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Employee</h4>
                    <hr>
                    <form id="addForm">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 d-none">
                                <div class="mb-md-4 mb-3">
                                    <input name="employee_id" type="number" readonly class="form-control shadow-none"
                                        id="employee_id" placeholder="Employee ID (auto)">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <!-- Name -->
                                    <input id="name" name="name" type="text" maxlength="20"
                                        class="form-control shadow-none" placeholder="Name of Employees" required>
                                    <small class="form-text" style="font-size: small;">Limit: 20 characters</small>
                                </div>
                                <!-- Email -->
                                <div class="mb-md-4 mb-3">
                                    <input id="email" name="email" type="email" class="form-control shadow-none"
                                        placeholder="Enter Email" required>
                                </div>
                            </div>


                            <div class="col-md-5 justify-content-end">
                                <div class="mb-md-4 mb-3 text-center">
                                    <img onclick="$(this).siblings('input[type=file]').click()" id="addimage"
                                        style="height: 100%; width: 145px; object-fit: fill; cursor: pointer;"
                                        src="{{ asset('assets/img/placeholder-img-2.png') }}"
                                        alt="Employee Image Preview">
                                    <input disabled id="addimage" onchange="displaySelectedImage(this, 'addimage')"
                                        type="file" class="d-none" name="image" accept="image/*">
                                </div>
                            </div>


                            <!-- Password -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="password" name="password" type="password" maxlength="50"
                                        class="form-control shadow-none" placeholder="Password" required>
                                </div>
                            </div>

                            <!-- Date of Birth -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3 text-left">
                                    <input id="dob" name="dob" type="date" class="form-control shadow-none"
                                        placeholder="Date of Birth" max="{{ date('Y-m-d') }}" required>
                                </div>
                            </div>

                            <!-- Mobile Number -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="phn" name="phn" type="tel" maxlength="15"
                                        pattern="[0-9+\-\(\)\s]*" class="form-control shadow-none"
                                        placeholder="Mobile Number" required>
                                </div>
                            </div>

                            <!-- Gender -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="gender" name="gender" class="form-control" aria-label="Gender"
                                        required>
                                        <option selected disabled value="">--- Select Gender ---</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Marital Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="marital" name="marital" class="form-control"
                                        aria-label="Marital Status" required>
                                        <option selected disabled value="">--- Select Marital Status ---</option>
                                        <option value="Married">Married</option>
                                        <option value="Unmarried">Unmarried</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Employee Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="status" name="status" class="form-control"
                                        aria-label="Status of Employee" required>
                                        <option selected disabled value="">--- Select Status of Employee ---</option>
                                        <option value="2">Active</option>
                                        <option value="1">Inactive</option>
                                        <option value="0">Pending</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to add Department -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="department" name="department" class="form-control"
                                        aria-label="Department" onchange="populateRoles(this.value)" required>
                                        <option value="" disabled selected>Select a Department</option>
                                        @foreach ($departments as $depart)
                                            <option readonly value="{{ $depart->id }}">{{ $depart->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Role of Employee -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="role_id" name="role" class="form-control" aria-label="Role">
                                        <option selected value="">Select Role</option>
                                        @foreach ($employees as $employee)
                                            <option readonly>{{ $employee->role }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to Add Category -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="category" name="category" class="form-control" aria-label="category">
                                        <option selected disabled>--- Select category ---</option>
                                        <option value="">Unspecified</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Nationality -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="nationality" name="nationality" type="text" maxlength="15"
                                        class="form-control shadow-none" placeholder="Nationality" required>
                                </div>
                            </div>

                            <!-- State -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="state" name="state" type="text" maxlength="15"
                                        class="form-control shadow-none" placeholder="State" required>
                                </div>
                            </div>

                            <!-- Zip Code -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="zip" name="zip" type="number" maxlength="15"
                                        class="form-control shadow-none" placeholder="Zip Code" required>
                                </div>
                            </div>

                            <!-- City -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="city" name="city" type="text" maxlength="30"
                                        class="form-control shadow-none" placeholder="City" required>
                                </div>
                            </div>

                            <!-- Address -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <textarea id="address" name="address" type="text" rows="3" maxlength="100"
                                        class="form-control shadow-none" required>Address</textarea>
                                    <small class="form-text" style="font-size: small;">Limit: 100 characters</small>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                data-bs-dismiss="modal" aria-label="Close">Cancel
                            </button>
                            <button type="submit" id="sub-btn"
                                class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Task and Point Table -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Edit Department Details</h4>
                    <hr>
                    <form id="editDepartment">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <input type="hidden" name="id" value="{{ $department->id }}">
                                <input id="oldMngr" type="hidden" name="oldMngr" value="">
                                <div class="mb-md-4 mb-3">
                                    <input value="{{ $department->name }}" name="name" type="text" maxlength="50"
                                        class="form-control shadow-none"
                                        placeholder="Enter Department Name">
                                    <small class="form-text" style="font-size: small;">Limit: 50 characters</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <select name="manager" class="form-control" aria-label="Department" required>
                                    <option value="" disabled selected>--- Add Manager ---</option>
                                    @foreach ($employees as $employee)
                                        <option value="{{ $employee->employee_id }}"
                                            @if (isset($department) && $department->id == $employee->department_id && $employee->role == 'Manager') selected @endif>{{ $employee->name }}
                                        </option>
                                    @endforeach
                                </select>


                            </div>
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input value="{{ $department->no_of_emp }}" id="no_of_emp" name="no_of_emp"
                                        type="number" class="form-control shadow-none"
                                        placeholder="Number of Employees">
                                    <small class="form-text" style="font-size: small;">
                                        Current Number of Employees in Department</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input value="{{ $department->role }}" name="role" type="text" maxlength="50"
                                        class="form-control shadow-none" placeholder="Department Role">
                                    <small class="form-text" style="font-size: small;">Limit: 50 characters</small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input value="{{ $department->categories }}" name="category" type="text"
                                        class="form-control shadow-none" placeholder="Category">
                                </div>
                            </div>

                        </div>

                        <div class="d-flex justify-content-end">

                            <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                data-bs-dismiss="modal" aria-label="Close">Cancel</button>

                            <button type="submit" class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- ========================================= -->

@endsection
@section('custom-scripts')
    <script>

        let oldCategory = [];
        let newCategory = [];
        let delCategory = [];

        function showEmployeeDetails(employee_id, name, email, image, dob, phn, gender, marital, status, department_id,
            role, category, nationality, state, zip, city, address) {
            $('#addForm').css('pointer-event', 'none');
            $('#employee_id').val(employee_id);
            $('#name').val(name);
            $('#email').val(email);
            $('#addimage').attr('src', image);
            $('#dob').val(dob);
            $('#phn').val(phn);
            $('#gender').val(gender);
            $('#marital').val(marital);
            $('#status').val(status);
            $('#department').val(department_id);
            $('#role_id').val(role);
            $('#category').val(category);
            $('#nationality').val(nationality);
            $('#state').val(state);
            $('#zip').val(zip);
            $('#city').val(city);
            $('#address').val(address);

        }

        function oldManagr(employees, id) {
            employees.forEach(function(employee) {
                if (employee.department_id == id && employee.role == 'Manager') {
                    $('#oldMngr').val(employee.employee_id);
                }
            })
        }

        $(document).ready(function(){
            // The DOM element you wish to replace with Tagify
            var input = document.querySelector('input[name=category]');
            // initialize Tagify on the above input node reference
            var tagify = new Tagify(input);

            // Listen for the start of editing a tag
            tagify.on('edit:start', function(e) {
                oldCategory.push(e.detail.data.value); // Store the original value
            });

            // Listen for tag edits
            tagify.on('edit:updated', function(e) {
                newCategory.push(e.detail.data.value);
            });

            // Listen for removed tags
            tagify.on('remove', function(e) {
                delCategory.push(e.detail.data.value);
            });
        });

        //add deparment ajax
        $('#editModal').on("submit", function(e) {
            e.preventDefault();
            var form = $('#editDepartment')[0];
            var formdata = new FormData(form);

            formdata.append("oldCategories", JSON.stringify(oldCategory));
            formdata.append("newCategories", JSON.stringify(newCategory));
            formdata.append("delCategories", JSON.stringify(delCategory));

            // Change button text to "Processing" and disable it
            $('.submitBtn2').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('edit.department') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function(res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#editModal').modal('hide');

                        // Keep button in "Processing" state and reload page after 3 seconds
                        setTimeout(function() {
                            window.location.reload();
                        }, 10); // Increased time before the page reloads (3 seconds)
                    } else {
                        swirlmsg(res.Message);

                        // Re-enable button and revert text on error
                        $('.submitBtn2').html('Save').prop('disabled', false);
                    }
                },
                error: function(e) {
                    var first_error = '';
                    var count = 0;

                    // Capture and display first error message
                    $.each(e.responseJSON.errors, function(index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });

                    swirlmsg(first_error);

                    // Re-enable button and revert text on error
                    $('.submitBtn2').html('Save').prop('disabled', false);
                }
            });
        });
    </script>
@endsection
