@extends('SuperAdmin.layout.layout')
@section('title',"Department")
@section('page-name',"Departments")
@section('page-detail',"All Departments Information")
@section('pagelink', 'departments')

@section('custom-head')
    <style>
        tags {
            height: auto !important;
        }
    </style>
@endsection

@section('body')
    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <form class="serch">
                                <div class="input-group mb-3">
                      <span class="input-group-text bg-transparent" id="basic-addon1">
                        <i class="fas fa-search search-icon"></i>
                      </span>
                                    <input id="searchDepartment" type="text" class="form-control shadow-none" placeholder="Search"
                                           aria-label="search" aria-describedby="basic-addon1">
                                </div>
                            </form>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal"
                                        data-bs-whatever="@getbootstrap"><i class="fas fa-plus-circle me-3"></i>
                                    Add New Department</button>
                            </div>
                        </div>
                    </div>
                    @if($departments->isEmpty())
                        <h4>No Department Yet!</h4>
                    @else

                        <div class="row">
                            @foreach($departments as $department)
                            @php
                            $departEmployees = $employees->where('department_id' , $department->id);
                            $no_of_emp = $departEmployees->count();
                            @endphp
                                <div class="col-md-6 mb-4 department-card" data-department="{{ strtolower($department->name) }}">
                                    <div class="card border rounded-3">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div>
                                                    <h4 class="mb-1">{{$department->name}}</h4>
                                                    <p class="mb-0 p-light-2">{{$no_of_emp}}&nbsp;Members</p>
                                                </div>
                                                <div>
                                                    <a href="{{route('serviceDepart', ['slug' => $department->slug])}}"
                                                       class="theme-text-cp">View All</a>
                                                </div>
                                            </div>
                                            <hr>
                                            <div>
                                                @foreach ($departEmployees as $departEmployee )
                                                    @if($departEmployee->role != 'Employee')
                                                        <div class="d-flex align-items-center justify-content-between mb-3">
                                                            <div class="d-flex align-items-center">
                                                                <div>
                                                                    @if (!empty($departEmployee->image))
                                                                        <img src="{{ asset($departEmployee->image) }}"
                                                                             alt="Employee Image"
                                                                             style="height: 50px; width: 50px"
                                                                             class="img-fluid rounded-circle">
                                                                    @else
                                                                        <span class="initials-container">
                                                                    {{ strtoupper(implode('', array_merge(array_map(fn($part) => is_numeric($part) ? $part : $part[0], array_slice(explode(' ', $departEmployee->name), 0, 2)),preg_match('/\d/', $departEmployee->name, $matches) ? [$matches[0]] : []))) }}
                                                                </span>
                                                                    @endif
                                                                </div>
                                                                <div class="ms-2">
                                                                    <h5>{{$departEmployee->name}}</h5>
                                                                    <p class="p-small mb-0">{{$departEmployee->role}}</p>
                                                                </div>
                                                            </div>
{{--                                                            <a href="#" class="p-2">--}}
{{--                                                                <i class="fas fa-angle-right"></i>--}}
{{--                                                            </a>--}}
                                                        </div>
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>


    <!-- ========================================= -->

    <!-- MODAL -->
    <!-- Edit Task and Point Table -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Add Department Tables</h4>
                    <hr>
                    <form id='add_department'>
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input name="name" type="text" maxlength="50"
                                           class="form-control shadow-none" id="" placeholder="Enter Department Name">
                                    <small class="form-text" style="font-size: small;">Limit: 50 characters</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select name="manager" class="form-control" aria-label="Manager">
                                        <option selected disabled >--- Add Managers ---</option>
                                        <option value="">Unspecified</option>
                                        @foreach($employees as $employee)
                                            @if($employee->role != 'Manager')
                                                <option value="{{ $employee->employee_id }}">{{ $employee->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input name="no_of_emp" type="number" min="0"
                                           class="form-control shadow-none" id="" placeholder="Number of Employees">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input name="role" type="text" maxlength="50"
                                           class="form-control shadow-none" placeholder="Department Role">
                                    <small class="form-text" style="font-size: small;">Limit: 50 characters</small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input name="category" type="text" class="form-control shadow-none"
                                           placeholder="Enter Category like BDC, Service etc" style="min-height: 50px; width: 100%; overflow: hidden; white-space: nowrap;">
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel
                            </button>
                            <button type="submit" class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- ========================================= -->

@endsection
@section('custom-scripts')
    <script>
        //add deparment ajax
        $('#add_department').on("submit", function (e) {
            e.preventDefault();
            var form = $('#add_department')[0];
            var formdata = new FormData(form);

            // Change button text to "Processing" and disable it
            $('.submitBtn2').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('post.department') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({             // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{asset('assets/img/WelcomebackFabiana.png')}}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');

                        // Keep button in "Processing" state and reload page after 3 seconds
                        setTimeout(function () {
                            window.location.reload();
                        }, 1000); // Increased time before the page reloads (3 seconds)
                    } else {
                        swirlmsg(res.Message);

                        // Re-enable button and revert text on error
                        $('.submitBtn2').html('Save').prop('disabled', false);
                    }
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;

                    // Capture and display first error message
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });

                    swirlmsg(first_error);

                    // Re-enable button and revert text on error
                    $('.submitBtn2').html('Save').prop('disabled', false);
                }
            });
        });

        // The DOM element you wish to replace with Tagify
        var input = document.querySelector('input[name=category]');
        var tagify = new Tagify(input);

        //Search Department
        document.getElementById('searchDepartment').addEventListener('input', function () {
            let filter = this.value.toLowerCase();
            let cards = document.querySelectorAll('.department-card');

            cards.forEach(card => {
                let departmentName = card.getAttribute('data-department');
                if (departmentName.includes(filter)) {
                    card.style.display = ''; // Show the card
                } else {
                    card.style.display = 'none'; // Hide the card
                }
            });
        });

    </script>
@endsection

