@extends('SuperAdmin.layout.layout')
@section('title',"CARISMA")
@section('page-name',"Dashboard")
{{--@section('page-detail',"All Departments Information")--}}
@section('pagelink', 'dashboard')
@section('body')
    <div class="content-are-dashboard p-3">
        <!-- Assigned Emojis/GIFs Section -->
        @if(isset($assignedEmojis) && $assignedEmojis->count() > 0)
        <div class="row mb-4">
            <div class="col-12">
                <div class="border rounded-3 p-4 bg-primary bg-opacity-10">
                    <div class="d-flex align-items-center mb-3">
                        <div class="me-3">
                            <i class="fas fa-gift text-primary" style="font-size: 1.5rem;"></i>
                        </div>
                        <div>
                            <h5 class="mb-1 text-primary">Your Assigned Emojis & GIFs</h5>
                            <small class="text-muted">Special emojis and GIFs assigned to you</small>
                        </div>
                    </div>
                    <div class="row">
                        @foreach($assignedEmojis as $assignment)
                            <div class="col-md-4 col-sm-6 mb-3">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-body text-center p-3">
                                        <div class="mb-2" style="min-height: 60px; display: flex; align-items: center; justify-content: center;">
                                            @if($assignment->emoji->type === 'emoji')
                                                <span style="font-size: 2.5rem;">{{ $assignment->emoji->emoji_text }}</span>
                                            @else
                                                <img src="{{ asset($assignment->emoji->file_path) }}" 
                                                     alt="{{ $assignment->emoji->name }}" 
                                                     style="max-height: 60px; max-width: 100%;">
                                            @endif
                                        </div>
                                        <h6 class="card-title mb-1">{{ $assignment->emoji->name }}</h6>
                                        @if($assignment->message)
                                            <p class="card-text text-muted small mb-0">{{ $assignment->message }}</p>
                                        @endif
                                        <small class="text-muted">{{ $assignment->created_at->format('M d, Y') }}</small>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        @endif

        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <!-- Line Chart -->
                        <div class="col-md-8">
                            <div class=" border rounded-3 p-3">
                                <div class="d-flex mb-4 justify-content-between align-items-center">
                                    <h4 class="mb-0" id="redeemedPoints">Redeemed Points : </h4>
                                    <div class="col-md-4">
                                        <select class="form-select shadow-none" id="filter" onchange="updateChart()">
{{--                                        <option selected ><i class="fas fa-search search-icon"></i> Filters </option>--}}
                                            <option value="today">Today</option>
                                            <option value="week">This Week</option>
                                            <option value="month">This Month</option>
                                            <option value="quarter">This Quarter</option>
                                            <option value="6_months">Last 6 Months</option>
                                            <option value="year">This Year</option>
                                        </select>
                                    </div>
                                </div>
                                <canvas id="lineChart"></canvas>
                            </div>
                        </div>
                        <!-- Pie Chart -->
                        <div class="col-md-4">
                            <div class=" border rounded-3 p-3">
                                <div class="text-center">
                                  <h4 class="mb-4">Overall Points</h4>
                                </div>
                                <div class="d-flex justify-content-center">
                                  <div class="d-flex align-items-center px-2">
                                    <div class="me-1" style="background-color: #6EA0F9; width: 15px; height: 15px; border-radius: 50px;"></div>
                                    <p class="p-small mb-0">Redeemed Points</p>
                                  </div>
                                  <div class="d-flex align-items-center px-2">
                                    <div class="me-1" style="background-color: #1a1a2e; width: 15px; height: 15px; border-radius: 50px;"></div>
                                      <p class="p-small mb-0">Pending Points</p>
                                  </div>
                                </div>
                                <canvas id="overallPointsChart" class="px-3"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        @foreach($departments as $department)
                            <!-- Line Chart -->
                            <div class="col-md-6 mt-4">
                                <div class=" border rounded-3 p-3">
                                    <div class="d-flex justify-content-between align-items-center mb-4">
{{--                                        <h4 class="">{{$department['name']}} Department :</h4>--}}
                                        <h4 id="depPoints{{$department['id']}}"></h4>
                                        <div class="col-md-4">
                                            <select class="form-select shadow-none" id="filter{{ $department['id'] }}" onchange="depLineChart({{ $department['id'] }}, '{{$department['name']}}' )">
                                                <option value="today">Today</option>
                                                <option value="week">This Week</option>
                                                <option selected value="month">This Month</option>
                                                <option value="quarter">This Quarter</option>
                                                <option value="6_months">Last 6 Months</option>
                                                <option value="year">This Year</option>
                                            </select>
                                        </div>
                                    </div>
                                    <canvas id="department{{ $department['id'] }}"></canvas>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('custom-scripts')

    <script>

        window.onload = function () {

            // Initialize the chart with "Today" filter
            updateChart(); //Line Chart with Filters

            //Fill Data in Array to Plot Pie Chart
            const redeemedPoints = {!! json_encode(calculatePercentage($piePoints->redeemed ?? 0, $piePoints->total_points ?? 0)) !!}.value;
            const pieData = [
                redeemedPoints, // Add the redeemed value
                100 - redeemedPoints,  // Add the pending value
            ];
            createPieChart(pieData);

            //Fill Data in Array to Plot Line Chart for Departments
            @foreach($departments as $department)
                depLineChart({{$department['id']}}, "{{$department['name']}}" );
            @endforeach
        };

        // Plot Pie Chart for All the Redeemed and Pending Points
        function createPieChart(chartData) {
            const ctxPie = document.getElementById('overallPointsChart').getContext('2d');
            new Chart(ctxPie, {
                type: 'doughnut',
                data: {
                    // labels: ['Redeemed Points', 'Pending Points'],
                    datasets: [{
                        data: chartData, // Example data (in percentages)
                        backgroundColor: ['#6EA0F9', '#1a1a2e'],
                        hoverOffset: 4,
                        borderWidth: 15,
                        borderColor: '#EEF0FA' // White border for separation
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%', // Creates a thicker donut appearance
                    plugins: {
                        legend: {
                            display: true,
                            position: 'bottom',
                            labels: {
                                color: '#000',
                                font: {
                                    family: 'Montserrat', // Ensure Montserrat is included in your CSS
                                    size: 14
                                }
                            }
                        },
                        tooltip: {
                            backgroundColor: '#ffffff',
                            bodyColor: '#1a1a2e',
                            titleColor: '#1a1a2e',
                            borderColor: 'var(--primary-color)',
                            borderWidth: 1,
                            padding: 10,
                            callbacks: {
                                label: function(tooltipItem) {
                                    return `${tooltipItem.label}: ${tooltipItem.raw}%`;
                                }
                            }
                        }
                    }
                }
            });
        }

        let lineChart;
        let depChart = {}; // Store the chart instance

        //Filtered Line-Chart for Departments
        function depLineChart(depID, depName)
        {
            const filter = document.getElementById('filter' + depID).value;
            const params = new URLSearchParams({
                filter: document.getElementById('filter' + depID).value,
                depID: depID
            });

            fetch(`getDepPointsData?${params.toString()}`)
                .then(response => response.json())
                .then(data => {
                    console.log("department : " + depID);
                    console.log(data);
                    const currentDate = new Date();
                    let labels = [];
                    let fullData = [];

                    // Generate labels and initialize data
                    if (filter === 'today') {

                        // Generate labels for 24 hours in the format "HH:00"
                        labels = Array.from({ length: 24 }, (_, i) => {
                            const hour = i % 12 || 12; // Convert to 12-hour format, where 0 becomes 12
                            const period = i < 12 ? "AM" : "PM"; // Determine AM or PM
                            return `${hour} ${period}`;
                        });

                        // Initialize the data array for 24 hours
                        fullData = new Array(24).fill(0);

                        // Populate the data array with points
                        data.data.forEach(item => {
                            const hour = parseInt(item.time_group, 10); // Parse the hour from the time_group
                            if (hour >= 0 && hour < 24) { // Ensure the hour is within a valid range
                                fullData[hour] = parseInt(item.total_points, 10); // Add total_points at the corresponding hour index
                            }
                        });
                    }
                    else if (filter === 'week') {

                        // Assuming currentDate is today's date
                        const currentDate = new Date();
                        currentDate.setHours(0, 0, 0, 0); // Normalize currentDate to midnight

                        // Create labels for the last 7 days, including today
                        labels = Array.from({ length: 7 }, (_, i) => {
                            const day = new Date(currentDate); // Copy currentDate
                            day.setDate(currentDate.getDate() - i); // Subtract i days to get the past 7 days
                            return day.toLocaleDateString("en-US", { weekday: 'short' });
                        }).reverse(); // Reverse so the most recent day comes first

                        fullData = new Array(7).fill(0);

                        // Process your data and sum points per day
                        data.data.forEach(item => {
                            // Parse time_group to Date (item.time_group is a string like "2024-12-04")
                            const itemDate = new Date(item.time_group);
                            itemDate.setHours(0, 0, 0, 0); // Normalize to midnight

                            // Calculate the difference in days between currentDate and itemDate
                            const dayIndex = (currentDate - itemDate) / (1000 * 60 * 60 * 24);

                            // Map dayIndex to corresponding position in labels array
                            const labelIndex = 6 - dayIndex; // This will map 0 to Sunday, 1 to Monday, etc.

                            // Ensure that dayIndex is within the last 7 days (0 to 6)
                            if (labelIndex >= 0 && labelIndex < 7) {
                                fullData[labelIndex] += parseInt(item.total_points); // Add points for the corresponding day
                            }
                        });

                    }
                    else if (filter === 'month') {
                        const daysInMonth = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, 0).getDate();
                        labels = Array.from({ length: daysInMonth }, (_, i) => `${i + 1}`); // Day of the month
                        fullData = new Array(daysInMonth).fill(0);
                        data.data.forEach(item => {
                            const date = new Date(item.time_group).getDate();
                            fullData[date - 1] = item.total_points; // Map points to the specific date
                        });
                    }
                    else if (filter === 'quarter') {

                        // Get current date without modifying it
                        const currentDate = new Date();
                        const currentMonth = currentDate.getMonth(); // 0-based index (Jan = 0, Feb = 1, ...)

                        // Determine the start and end months of the current quarter
                        let quarterStartMonth = currentMonth - (currentMonth % 3); // Start of the quarter (0, 3, 6, 9)
                        let quarterLabels = ["Jan", "Feb", "Mar"]; // Default Q1 labels

                        if (quarterStartMonth === 3) {
                            quarterLabels = ["Apr", "May", "Jun"]; // Q2
                        } else if (quarterStartMonth === 6) {
                            quarterLabels = ["Jul", "Aug", "Sep"]; // Q3
                        } else if (quarterStartMonth === 9) {
                            quarterLabels = ["Oct", "Nov", "Dec"]; // Q4
                        }

                        // Set labels for the current quarter
                        labels = quarterLabels;

                        // Initialize the data array for the quarter (3 months)
                        fullData = new Array(3).fill(0);

                        // Iterate through the provided data
                        data.data.forEach(item => {
                            // Parse the month from item.time_group (assuming it contains month number)
                            const itemMonth = parseInt(item.time_group, 10) - 1; // Convert 1-based month to 0-based

                            // Check if the item belongs to the current quarter
                            if (itemMonth >= quarterStartMonth && itemMonth < quarterStartMonth + 3) {
                                const index = itemMonth - quarterStartMonth; // Get index within the quarter
                                fullData[index] += parseInt(item.total_points, 10); // Add total_points to the correct index
                            }
                        });

                    }
                    else if (filter === '6_months') {

                        // Get current date without modifying it
                        const currentDate = new Date();

                        // Generate labels for the last 6 months
                        labels = Array.from({ length: 6 }, (_, i) => {
                            const tempDate = new Date(currentDate); // Clone the date to avoid mutation
                            tempDate.setMonth(tempDate.getMonth() - i); // Subtract i months
                            return tempDate.toLocaleString("en-US", { month: 'short' });
                        }).reverse(); // Reverse to display from oldest to latest

                        // Initialize the data array for 6 months
                        fullData = new Array(6).fill(0);

                        // Iterate through the provided data
                        data.data.forEach(item => {
                            // Parse the time_group into a Date object
                            const itemDate = new Date(`${item.time_group} 01`); // Adding `01` as day to parse correctly

                            // Calculate the difference in months
                            const monthDiff =
                                (currentDate.getFullYear() - itemDate.getFullYear()) * 12 +
                                (currentDate.getMonth() - itemDate.getMonth());

                            // If the monthDiff is within the last 6 months
                            if (monthDiff >= 0 && monthDiff < 6) {
                                fullData[5 - monthDiff] += parseInt(item.total_points, 10); // Add total_points to the correct index
                            }
                        });

                    }
                    else if (filter === 'year') {
                        const currentDate = new Date(); // Get the current date
                        labels = Array.from({ length: 12 }, (_, i) => {
                            // Create a new Date object for each month (from Jan to Dec)
                            const month = new Date(currentDate.getFullYear(), i, 1); // Year is current, month is i (0 to 11)
                            return month.toLocaleString("en-US", { month: 'short' });
                        });

                        fullData = new Array(12).fill(0); // Initialize array with 12 zeros for 12 months

                        data.data.forEach(item => {
                            // Parse the time_group (assuming it's in "Dec 2024" format)
                            const itemDate = new Date(item.time_group + " 1"); // Add "1" to make it a valid date (e.g., "Dec 2024" -> "Dec 1 2024")
                            const month = itemDate.getMonth(); // Get the month index (0-11)
                            fullData[month] += parseInt(item.total_points); // Add points for that month
                        });

                    }

                    // Prepare dataset: replace 0 with null to skip in chart but keep labels
                    const dataToPlot = fullData.map(value => (value === 0 ? null : value));

                    // Update or create the chart
                    if (depChart[depID]) {
                        depChart[depID].data.labels = labels;
                        depChart[depID].data.datasets[0].data = dataToPlot;
                        depChart[depID].update();
                    }
                    else {
                        const ctx = document.getElementById('department'+ depID).getContext('2d');
                        depChart[depID] = new Chart(ctx, {
                            type: 'line',
                            data: {
                                labels: labels,
                                datasets: [{
                                    data: dataToPlot, // Points for y-axis (same as before)
                                    borderColor: '#4b5fea',
                                    backgroundColor: 'rgba(75, 95, 234, 0.1)',
                                    fill: true,
                                    tension: 0.4,
                                    spanGaps: true, // Skip null values
                                    pointBackgroundColor: '#4b5fea',
                                    pointBorderColor: '#ffffff',
                                    pointHoverBackgroundColor: '#ffffff',
                                    pointHoverBorderColor: '#4b5fea',
                                    pointRadius: 5,
                                    pointHoverRadius: 5,
                                    hitRadius: 1
                                }]
                            },
                            options: {
                                responsive: true,
                                maintainAspectRatio: false,
                                scales: {
                                    y: {
                                        beginAtZero: true, // Start the y-axis at 0
                                        grid: {
                                            color: '#e6e6e6',
                                            drawBorder: true,
                                            borderDash: [5, 5], // Dashed grid lines
                                        }
                                    },
                                    x: {
                                        grid: {
                                            display: false // Hide the x-axis grid
                                        },
                                    }
                                },
                                plugins: {
                                    legend: {
                                        display: true,
                                        labels: {
                                            color: '#000',
                                            usePointStyle: true
                                        }
                                    },
                                    tooltip: {
                                        backgroundColor: '#f9f9f9',
                                        titleColor: '#4b5fea',
                                        bodyColor: '#333',
                                        borderColor: '#4b5fea',
                                        borderWidth: 1,
                                        padding: 10,
                                        displayColors: false,
                                        intersect: true,
                                        mode: 'nearest',
                                        callbacks: {
                                            label: function(tooltipItem) {
                                                return tooltipItem.raw + ' pts'; // Tooltip format
                                            }
                                        }
                                    }
                                },
                                elements: {
                                    point: {
                                        radius: 5,
                                        hoverRadius: 5,
                                        hitRadius: 0
                                    },
                                    line: {
                                        borderWidth: 2 // Line width for the chart
                                    }
                                },
                                layout: {
                                    padding: {
                                        top: 10,
                                        bottom: 10
                                    }
                                }
                            }
                        });
                    }
                    let depPoints = depName+" department : "+data.total_sum+" pts";
                    $('#depPoints'+depID).text(depPoints);
                })
                .catch(error => console.error('Error fetching data:', error));
        }

        // Filtered Line-Chart
        function updateChart() {
            const filter = document.getElementById('filter').value;

            fetch(`getPointsData?filter=${filter}`)
                .then(response => response.json())
                .then(data => {
                    const currentDate = new Date();
                    let labels = [];
                    let fullData = [];

                    // Generate labels and initialize data
                    if (filter === 'today') {

                        // Generate labels for 24 hours in the format "HH:00"
                        labels = Array.from({ length: 24 }, (_, i) => {
                            const hour = i % 12 || 12; // Convert to 12-hour format, where 0 becomes 12
                            const period = i < 12 ? "AM" : "PM"; // Determine AM or PM
                            return `${hour} ${period}`;
                        });

                        // Initialize the data array for 24 hours
                        fullData = new Array(24).fill(0);

                        // Populate the data array with points
                        data.data.forEach(item => {
                            const hour = parseInt(item.time_group, 10); // Parse the hour from the time_group
                            if (hour >= 0 && hour < 24) { // Ensure the hour is within a valid range
                                fullData[hour] = parseInt(item.total_points, 10); // Add total_points at the corresponding hour index
                            }
                        });

                    } else if (filter === 'week') {

                        // Assuming currentDate is today's date
                        const currentDate = new Date();
                        currentDate.setHours(0, 0, 0, 0); // Normalize currentDate to midnight

                        // Create labels for the last 7 days, including today
                        labels = Array.from({ length: 7 }, (_, i) => {
                            const day = new Date(currentDate); // Copy currentDate
                            day.setDate(currentDate.getDate() - i); // Subtract i days to get the past 7 days
                            return day.toLocaleDateString("en-US", { weekday: 'short' });
                        }).reverse(); // Reverse so the most recent day comes first

                        fullData = new Array(7).fill(0);

                        // Process your data and sum points per day
                        data.data.forEach(item => {
                            // Parse time_group to Date (item.time_group is a string like "2024-12-04")
                            const itemDate = new Date(item.time_group);
                            itemDate.setHours(0, 0, 0, 0); // Normalize to midnight

                            // Calculate the difference in days between currentDate and itemDate
                            const dayIndex = (currentDate - itemDate) / (1000 * 60 * 60 * 24);

                            // Map dayIndex to corresponding position in labels array
                            const labelIndex = 6 - dayIndex; // This will map 0 to Sunday, 1 to Monday, etc.

                            // Ensure that dayIndex is within the last 7 days (0 to 6)
                            if (labelIndex >= 0 && labelIndex < 7) {
                                fullData[labelIndex] += parseInt(item.total_points); // Add points for the corresponding day
                            }
                        });

                    }
                    else if (filter === 'month') {
                        const daysInMonth = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, 0).getDate();
                        labels = Array.from({ length: daysInMonth }, (_, i) => `${i + 1}`); // Day of the month
                        fullData = new Array(daysInMonth).fill(0);
                        data.data.forEach(item => {
                            const date = new Date(item.time_group).getDate();
                            fullData[date - 1] = item.total_points; // Map points to the specific date
                        });
                    } else if (filter === 'quarter') {

                        // Get current date without modifying it
                        const currentDate = new Date();
                        const currentMonth = currentDate.getMonth(); // 0-based index (Jan = 0, Feb = 1, ...)

                        // Determine the start and end months of the current quarter
                        let quarterStartMonth = currentMonth - (currentMonth % 3); // Start of the quarter (0, 3, 6, 9)
                        let quarterLabels = ["Jan", "Feb", "Mar"]; // Default Q1 labels

                        if (quarterStartMonth === 3) {
                            quarterLabels = ["Apr", "May", "Jun"]; // Q2
                        } else if (quarterStartMonth === 6) {
                            quarterLabels = ["Jul", "Aug", "Sep"]; // Q3
                        } else if (quarterStartMonth === 9) {
                            quarterLabels = ["Oct", "Nov", "Dec"]; // Q4
                        }

                        // Set labels for the current quarter
                        labels = quarterLabels;

                        // Initialize the data array for the quarter (3 months)
                        fullData = new Array(3).fill(0);

                        // Iterate through the provided data
                        data.data.forEach(item => {
                            // Parse the month from item.time_group (assuming it contains month number)
                            const itemMonth = parseInt(item.time_group, 10) - 1; // Convert 1-based month to 0-based

                            // Check if the item belongs to the current quarter
                            if (itemMonth >= quarterStartMonth && itemMonth < quarterStartMonth + 3) {
                                const index = itemMonth - quarterStartMonth; // Get index within the quarter
                                fullData[index] += parseInt(item.total_points, 10); // Add total_points to the correct index
                            }
                        });

                    } else if (filter === '6_months') {

                        // Get current date without modifying it
                        const currentDate = new Date();

                        // Generate labels for the last 6 months
                        labels = Array.from({ length: 6 }, (_, i) => {
                            const tempDate = new Date(currentDate); // Clone the date to avoid mutation
                            tempDate.setMonth(tempDate.getMonth() - i); // Subtract i months
                            return tempDate.toLocaleString("en-US", { month: 'short' });
                        }).reverse(); // Reverse to display from oldest to latest

                        // Initialize the data array for 6 months
                        fullData = new Array(6).fill(0);

                        // Iterate through the provided data
                        data.data.forEach(item => {
                            // Parse the time_group into a Date object
                            const itemDate = new Date(`${item.time_group} 01`); // Adding `01` as day to parse correctly

                            // Calculate the difference in months
                            const monthDiff =
                                (currentDate.getFullYear() - itemDate.getFullYear()) * 12 +
                                (currentDate.getMonth() - itemDate.getMonth());

                            // If the monthDiff is within the last 6 months
                            if (monthDiff >= 0 && monthDiff < 6) {
                                fullData[5 - monthDiff] += parseInt(item.total_points, 10); // Add total_points to the correct index
                            }
                        });

                    } else if (filter === 'year') {
                        const currentDate = new Date(); // Get the current date
                        labels = Array.from({ length: 12 }, (_, i) => {
                            // Create a new Date object for each month (from Jan to Dec)
                            const month = new Date(currentDate.getFullYear(), i, 1); // Year is current, month is i (0 to 11)
                            return month.toLocaleString("en-US", { month: 'short' });
                        });

                        fullData = new Array(12).fill(0); // Initialize array with 12 zeros for 12 months

                        data.data.forEach(item => {
                            // Parse the time_group (assuming it's in "Dec 2024" format)
                            const itemDate = new Date(item.time_group + " 1"); // Add "1" to make it a valid date (e.g., "Dec 2024" -> "Dec 1 2024")
                            const month = itemDate.getMonth(); // Get the month index (0-11)
                            fullData[month] += parseInt(item.total_points); // Add points for that month
                        });

                    }

                    // Prepare dataset: replace 0 with null to skip in chart but keep labels
                    const dataToPlot = fullData.map(value => (value === 0 ? null : value));

                    // Update or create the chart
                    if (lineChart) {
                        lineChart.data.labels = labels;
                        lineChart.data.datasets[0].data = dataToPlot;
                        lineChart.update();
                    } else {
                        createChart(labels, dataToPlot, filter);
                    }

                    let totalPoints = "Redeemed Points : " + data.total_sum;
                    $('#redeemedPoints').text(totalPoints);
                })
                .catch(error => console.error('Error fetching data:', error));
        }

        function createChart( data) {
            const ctx = document.getElementById('lineChart').getContext('2d');

            lineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    // labels: labels, // Labels for x-axis (same as before)
                    datasets: [{
                        // label: 'Points Redeemed',
                        data: data, // Points for y-axis (same as before)
                        borderColor: '#4b5fea',
                        backgroundColor: 'rgba(75, 95, 234, 0.1)',
                        fill: true,
                        tension: 0.4,
                        spanGaps: true, // Skip null values
                        pointBackgroundColor: '#4b5fea',
                        pointBorderColor: '#ffffff',
                        pointHoverBackgroundColor: '#ffffff',
                        pointHoverBorderColor: '#4b5fea',
                        pointRadius: 5,
                        pointHoverRadius: 5,
                        hitRadius: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true, // Start the y-axis at 0
                            grid: {
                                color: '#e6e6e6',
                                drawBorder: true,
                                borderDash: [5, 5], // Dashed grid lines
                            }
                        },
                        x: {
                            grid: {
                                display: false // Hide the x-axis grid
                            },
                        }
                    },
                    plugins: {
                        legend: {
                            display: true,
                            labels: {
                                color: '#000',
                                usePointStyle: true
                            }
                        },
                        tooltip: {
                            backgroundColor: '#f9f9f9',
                            titleColor: '#4b5fea',
                            bodyColor: '#333',
                            borderColor: '#4b5fea',
                            borderWidth: 1,
                            padding: 10,
                            displayColors: false,
                            intersect: true,
                            mode: 'nearest',
                            callbacks: {
                                label: function(tooltipItem) {
                                    return tooltipItem.raw + ' pts'; // Tooltip format
                                }
                            }
                        }
                    },
                    elements: {
                        point: {
                            radius: 5,
                            hoverRadius: 5,
                            hitRadius: 0
                        },
                        line: {
                            borderWidth: 2 // Line width for the chart
                        }
                    },
                    layout: {
                        padding: {
                            top: 10,
                            bottom: 10
                        }
                    }
                }
            });
        }


    </script>

@endsection
