<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Reset Password</title>
    <link rel="icon" type="image/x-icon" href="{{ asset('assets') }}/img/favicon.webp">
    <!-- ===========STYLE================ -->
    <link rel="stylesheet" type="text/css" href="{{ asset('assets') }}/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets') }}/css/style.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets') }}/css/responsive.css">
    <!-- ===========font style=========== -->
    <link href="https://fonts.googleapis.com/css2?family=Lexend:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- ===========fontawsom icon=========== -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>

<body>
<div class="container-fluid px-md-5 py-md-5 my-2">
    <div class="row align-items-center">
        <div class="col-lg-7 col-md-6">
            <div class="text-center">
                <img src="{{ asset('assets') }}/img/login-left.png" class="img-fluid">
            </div>
        </div>
        <div class="col-lg-4 col-md-5 mx-auto">
            <div class="mb-4">
                <a href="#" onclick="previousPage()">
                    <span><i class="fa fa-angle-left me-1"></i> </span>Back
                </a>
            </div>
            <div class="d-flex mb-1">
                <h3 class="mb-0">Reset Password</h3>
            </div>
            <p class="p-light mb-4">Create a new password by entering it below and confirming it for verification.</p>
            <form id="login-form">
                @csrf
                <div class="form-floating mb-3 position-relative">
                    <input type="hidden" name="email" value="{{$email}}">
                    <input name="newPass" type="password" class="form-control shadow-none password-input" placeholder="New Password">
                    <label>New Password</label>
                    <span class="password-toggle-icon position-absolute top-50 end-0 translate-middle-y me-3">
              <i class="fa fa-eye-slash toggle-password"></i>
            </span>
                </div>
                <div class="form-floating mb-3 position-relative">
                    <input name="cnfrmPass" type="password" class="form-control shadow-none password-input" placeholder="Confirm Password">
                    <label>Reset Password</label>
                    <span class="password-toggle-icon position-absolute top-50 end-0 translate-middle-y me-3">
              <i class="fa fa-eye-slash toggle-password"></i>
            </span>
                </div>
                <button type="submit" class="submitBtn2 btn btn-primary shadow-none w-100 mb-3">Reset</button>
            </form>
        </div>
    </div>
</div>


<script src="{{ asset('assets') }}/js/jquery-3.7.1.js"></script>
<script src="{{ asset('assets') }}/js/bootstrap.bundle.min.js"></script>
<script src="{{ asset('assets') }}/js/main.js"></script>
<script src="{{ asset('assets/js/sweetalert2.js')}}"></script>
<script>

    //Function to go back to the correct previous Page
    function previousPage()
    {
        window.location.href = document.referrer;
    }

    $('#login-form').on("submit", function(e) {
        e.preventDefault();
        var form = $('#login-form')[0];
        var formdata = new FormData(form);

        $('.submitBtn2').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
            .prop('disabled', true);

        $.ajax({
            type: 'POST',
            url: '{{ route('auth.attempt.password.reset') }}',
            dataType: 'json',
            data: formdata,
            contentType: false,
            processData: false,
            cache: false,
            mimeType: 'multipart/form-data',

            success: function(res) {
                if (res.Error == false) {
                    // Swirl MSG
                    Swal.fire({
                        title: "Success!",
                        text: res.Message,
                        imageUrl: "{{asset('assets/img/WelcomebackFabiana.png')}}",
                        imageWidth: 100,
                        imageHeight: 100,
                        imageAlt: "Party Image"
                    });

                    setTimeout(function() {
                        const role = res.role;
                        console.log(role);
                        if(role === 'Manager')
                        {
                            window.location.href = "{{route('mngr.login')}}"
                        }
                        else if(role === 'Admin')
                        {
                            window.location.href = "{{route('pAdmin.login')}}"
                        }
                        else
                        {
                            window.location.href = "{{route('emp.login')}}"
                        }

                    }, 100);
                } else {
                    swirlmsg(res.Message);
                }
            },

            error: function(e) {
                var first_error = '';
                var count = 0;

                // Check if responseJSON and errors exist in the response
                if (e.responseJSON && e.responseJSON.errors) {
                    $.each(e.responseJSON.errors, function(index, item) {
                        if (count === 0) {
                            first_error = item[0]; // Capture the first error message
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                } else {
                    swirlmsg("Invalid Email");
                }

                $('.submitBtn2').html('Verify').prop('disabled', false);
            }
        });
    });

    function swirlmsg(msg)
    {
        Swal.fire({
            title: "Error!",
            icon: "error",
            text: msg
        });
    }

</script>
</body>
</html>
