<!DOCTYPE html>
<html lang="en">
@section('title','OTP')
@include('SuperAdmin.includes.head')
</head>
<body>

<div class="container-fluid px-md-5 py-md-5 my-2">
    <div class="row align-items-center">
        <div class="col-lg-7 col-md-6">
            <div class="text-center">
                <img src="{{asset('assets')}}/img/login-left.png" class="img-fluid">
            </div>
        </div>
        <div class="col-lg-4 col-md-5 mx-auto">
            <div class="mb-4">
                <a href="#" onclick="previousPage()">
                    <span><i class="fa fa-angle-left me-1"></i> </span>Back
                </a>
            </div>
            <div class="d-flex mb-1">
                <h3 class="mb-0">Enter OTP</h3>
            </div>
            <p class="p-light mb-4">We have share a code of your registered email address robertallen@example.com</p>
            <form id="login-form">
                @csrf
                <div class="mb-3 otp-input d-flex justify-content-between">
                    <input type="hidden" name="email" value="{{$email}}">
                    <input name="code[]" type="text" class="form-control shadow-none otp-field" maxlength="1"
                           oninput="moveToNext(this)" placeholder="0">
                    <input name="code[]" type="text" class="form-control shadow-none otp-field" maxlength="1"
                           oninput="moveToNext(this)" placeholder="0">
                    <input name="code[]" type="text" class="form-control shadow-none otp-field" maxlength="1"
                           oninput="moveToNext(this)" placeholder="0">
                    <input name="code[]" type="text" class="form-control shadow-none otp-field" maxlength="1"
                           oninput="moveToNext(this)" placeholder="0">
                    <input name="code[]" type="text" class="form-control shadow-none otp-field" maxlength="1"
                           oninput="moveToNext(this)" placeholder="0">
                </div>
                <button type="submit" class="submitBtn2 btn btn-primary shadow-none w-100 mb-3">Verify</button>
            </form>
        </div>
    </div>
</div>
@include('SuperAdmin.includes.script')
{{--<script src="{{ asset('assets/js/sweetalert2.js')}}"></script>--}}
<script>
    //Function to go back to the correct previous Page
    function previousPage()
    {
        window.location.href = document.referrer;
    }

    $('#login-form').on("submit", function(e) {
        e.preventDefault();
        var form = $('#login-form')[0];
        var formdata = new FormData(form);

        $('.submitBtn2').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
            .prop('disabled', true);

        $.ajax({
            type: 'POST',
            url: '{{ route('auth.otp.verify') }}',
            dataType: 'json',
            data: formdata,
            contentType: false,
            processData: false,
            cache: false,
            mimeType: 'multipart/form-data',

            success: function(res) {
                if (res.Error == false) {
                    // Swirl MSG
                    Swal.fire({
                        title: "Success!",
                        text: res.Message,
                        imageUrl: "{{asset('assets/img/WelcomebackFabiana.png')}}",
                        imageWidth: 100,
                        imageHeight: 100,
                        imageAlt: "Party Image"
                    });

                    setTimeout(function() {
                        const email = "{{$email}}";
                        window.location.href = "{{ route('auth.password.reset', ':email') }}".replace(':email', encodeURIComponent(email));
                    }, 100);
                } else {
                    swirlmsg(res.Message);
                }
            },

            error: function(e) {
                var first_error = '';
                var count = 0;

                // Check if responseJSON and errors exist in the response
                if (e.responseJSON && e.responseJSON.errors) {
                    $.each(e.responseJSON.errors, function(index, item) {
                        if (count === 0) {
                            first_error = item[0]; // Capture the first error message
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                } else {
                    swirlmsg("Invalid Email");
                }

                $('.submitBtn2').html('Verify').prop('disabled', false);
            }
        });
    });

    function swirlmsg(msg)
    {
        Swal.fire({
            title: "Error!",
            icon: "error",
            text: msg
        });
    }

</script>

</body>
</html>
