@extends('SuperAdmin.layout.layout')
@section('title',"SubAdmin")
@section('page-name',"SubAdmins")
@section('page-detail',"All SubAdmins Information")
@section('pagelink', 'admins')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <form class="serch">
                                <div class="input-group mb-3">
                      <span class="input-group-text bg-transparent" id="basic-addon1">
                        <i class="fas fa-search search-icon"></i>
                      </span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search"
                                           aria-label="serch" aria-describedby="basic-addon1">
                                </div>
                            </form>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a href="#" class="btn btn-primary px-3 me-2" data-bs-toggle="modal"
                                   data-bs-target="#addModal"
                                   data-bs-whatever="@getbootstrap"><i class="fas fa-plus-circle me-3"></i> Add New
                                    Admin</a>
                            </div>
                        </div>
                    </div>
                    @if($employees->isEmpty())
                        <h4>No Admin Assign Yet!</h4>
                    @else
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="entryTable" class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">Admin Name</th>
                                            <th scope="col">Employee ID</th>
                                            <th scope="col">Department</th>
                                            <th scope="col">Category</th>
                                            <th scope="col">Join Date</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($employees as $employee)
                                            @if($employee->role == 'Admin')
                                                <tr>
                                                    <th class="align-middle">
                                                        <div class="d-flex align-items-center">
                                                            <div>
                                                                @if (!empty($employee->image))
                                                                    <img src="{{ asset($employee->image) }}"
                                                                         alt="Employee Image"
                                                                         style="height: 50px; width: 50px"
                                                                         class="img-fluid rounded-circle">
                                                                @else
                                                                    <span class="initials-container">
                                                                    {{ strtoupper(implode('', array_merge(array_map(fn($part) => is_numeric($part) ? $part : $part[0], array_slice(explode(' ', $employee->name), 0, 2)),preg_match('/\d/', $employee->name, $matches) ? [$matches[0]] : []))) }}
                                                                </span>
                                                                @endif
                                                            </div>
                                                            <div class="ms-2">
                                                                <h5 class="mb-0">{{$employee->name}}</h5>
                                                            </div>
                                                        </div>
                                                    </th>
                                                    <td class="align-middle">{{$employee->employee_id}}</td>
                                                    <td class="align-middle">{{$employee->department->name}}</td>
                                                    <td class="align-middle">{{$employee->category}}</td>
                                                    <td class="align-middle">{{ $employee->created_at->format('m-d-y') }}</td>

                                                    <td class="align-middle">
                                                        @if($employee->status === '2')
                                                            <a href="#" class="btn btn-active">Active</a>
                                                        @elseif($employee->status === '1')
                                                            <a href="#" class="btn btn-inactive">Inactive</a>
                                                        @else
                                                            <a href="#" class="btn btn-pending">Pending</a>
                                                        @endif
                                                    </td>
                                                    <td class="align-middle">
                                                        {{--                                                    <a href="#"><i class="fas fa-eye px-1"></i></a>--}}
                                                        <a href="#" data-bs-toggle="modal" data-bs-target="#addModal"
                                                           data-bs-whatever="@getbootstrap"
                                                           onclick="populateForm({{ $employee }});">
                                                            <i class="fas fa-pen px-1"></i></a>

                                                        <a href="#"
                                                           onclick="deleteAdmin({{$employee->employee_id}}, $(this));">
                                                            <i class="fas fa-trash px-1"></i></a>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- MODAL -->

    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Admin</h4>
                    <hr>
                    <form id="adminForm">
                        @csrf
                        <div class="row">
                            <!-- Select Employee -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="selectEmployee" class="form-control"
                                            aria-label="Employees"
                                            onchange="employeeId(this)" required>
                                        <option selected value="">Select Employee</option>
                                        @foreach($employees as $employee)
                                            <option value="{{$employee->employee_id}}">{{$employee->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Employee ID -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input type="text" name="employee_id" readonly class="form-control shadow-none"
                                           id="empid" placeholder="Employee ID (auto)">
                                </div>
                            </div>

                            <!-- Dropdown to add Department -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="department" name="department" class="form-control"
                                            aria-label="Department"
                                            onchange="populateCategory({{$departments}})" required>
                                        <option selected disabled>--- Select Department ---</option>
                                        @foreach($departments as $department)
                                            <option value="{{$department->id}}">{{$department->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to Add Category -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="category" name="category" class="form-control" aria-label="category">
                                        <option selected disabled >--- Select category ---</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Employee Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="status" name="status" class="form-control"
                                            aria-label="Status of Employee" required>
                                        <option selected disabled>--- Select Status of Employee ---</option>
                                        <option value="2">Active</option>
                                        <option value="0">Pending</option>
                                        <option disabled id="disOption" value="1">Inactive</option>
                                    </select>
                                </div>
                            </div>

                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel
                            </button>
                            <button type="submit" id="sub-btn" class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">
                                Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- MODAL END -->

@endsection
@section('custom-scripts')

    <script>

        //Reset all form values
        $('#addModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset(); // Resets all form inputs
            $('#selectEmployee').css('pointer-events', 'auto');
            $('#disOption').attr('disabled', true);
        });

        //Populates Employee ID
        function employeeId(selectElement) {
            var selectedId = $(selectElement).val();
            $('#empid').empty();
            @foreach($employees as $employee)
            if ('{{ $employee->employee_id }}' === selectedId) {
                $('#empid').val('{{ $employee->employee_id }}');
            }
            @endforeach
        }

        // Function to Populate Category
        function populateCategory(departments) {
            let depid = $('#department').val();
            $('#category').empty();
            $('#category').append('<option selected disabled>--- Select category ---</option>')
            if (depid != null) {
                let cate = [];
                if(Array.isArray(departments) && departments.length > 0)
                {
                    departments.forEach(function (department) {
                        if (depid == department.id) {
                            cate = JSON.parse(department.categories);
                        }
                    });

                    for (let i = 0; i < cate.length; i++) {
                        $('#category').append('<option value="' + cate[i] + '">' + cate[i] + '</option>');
                    }
                }
            }
        }

        //This Function populate the Modal
        function populateForm(employee) {
            //Empties the form
            $('form')[0].reset();
            //Fills the form
            $('#department').val(employee.department_id).trigger('change');
            $('#category').val(employee.category);
            $('#status').val(employee.status);
            $('#selectEmployee').val(employee.employee_id).trigger('change').css('pointer-events', 'none');
            $('#disOption').removeAttr('disabled');
        }

        //Script to Add/Update ManagerMiddleware
        $('#addModal').on("submit", function (e) {
            e.preventDefault()

            if ($('#role-div').hasClass('d-none')) {
                console.log('inside if for div')
                $('#role').val('Admin');
            }

            var form = $('#adminForm')[0];
            var formdata = new FormData(form);
            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('admin.add') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({             // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{asset('assets/img/WelcomebackFabiana.png')}}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 100);
                    } else {
                        swirlmsg(res.Message);
                    }
                    //$('#sub-btn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#sub-btn').html('Submit').prop('disabled', false);
                }

            });
        });

        //Function and AJAX to Delete Admin
        function deleteAdmin(id, element) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('admin.delete') }}',
                        data: {
                            id: id,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function (res) {
                            if (res.Error === false) {
                                element.parent().parent().remove();
                                Swal.fire({ // Swirl Success MSG
                                    title: "Deleted!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function (e) {
                            let first_error = 'An unknown error occurred.';
                            if (e.responseJSON && e.responseJSON.errors) {
                                first_error = Object.values(e.responseJSON.errors)[0][0];
                            }
                            swirlmsg(first_error);
                        }
                    });
                }
            })
        }

    </script>
@endsection
