@extends('PointsAdmin.layout')
@section('title',"Requested Points")
@section('page-name',"Requested Point")
@section('page-detail',"All Requested Points Information")
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <div class="serch">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i></span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search"
                                           aria-label="serch" aria-describedby="basic-addon1">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a href="#" class="btn btn-primary w-auto-fix" data-bs-toggle="modal"
                                   data-bs-target="#addModal" data-bs-whatever="@getbootstrap">
                                    <i class="fas fa-plus-circle me-3"></i>Add Points
                                </a>
                            </div>
                        </div>
                    </div>

                    <hr>

                    @if($points->isEmpty())
                        <h4> No Points Yet! </h4>
                    @else
                        <!-- Bulk Actions Section -->
                        <div class="row mb-3" id="bulkActionsRow" style="display: none;">
                            <div class="col-12">
                                <div class="d-flex align-items-center gap-2 p-3 bg-light rounded">
                                    <span id="selectedCount" class="badge bg-primary">0 selected</span>
                                    <button type="button" class="btn btn-success btn-sm" id="approveSelectedBtn">
                                        <i class="fas fa-check"></i> Approve Selected
                                    </button>
                                    <button type="button" class="btn btn-danger btn-sm" id="rejectSelectedBtn">
                                        <i class="fas fa-times"></i> Reject Selected
                                    </button>
                                    <button type="button" class="btn btn-secondary btn-sm" id="clearSelectionBtn">
                                        <i class="fas fa-times-circle"></i> Clear Selection
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!--------- Start Loop ------------>
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="entryTable" class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col" style="width: 50px;">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="selectAllCheckbox">
                                                    <label class="form-check-label" for="selectAllCheckbox">
                                                        All
                                                    </label>
                                                </div>
                                            </th>
                                            <th scope="col">Employee</th>
                                            <th scope="col">VIN#</th>
                                            <th scope="col">Target/Product</th>
                                            <th scope="col">Points</th>
                                            <th scope="col">Claimed Date</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($points as $point)
                                            <tr>
                                                <td class="align-middle">
                                                    <div class="form-check">
                                                        <input class="form-check-input row-checkbox" type="checkbox" 
                                                               value="{{ $point->id }}" id="checkbox_{{ $point->id }}"
                                                               data-status="{{ $point->status }}">
                                                    </div>
                                                </td>
                                                <td class="align-middle">{{ $point->e_name }}</td>
                                                <td class="align-middle">{{ $point->vin_no }}</td>
                                                @if($point->prod)
                                                    @php
                                                        $pName = $products->firstWhere('id', $point->prod)->name;
                                                    @endphp
                                                    <td class="align-middle">{{ $pName }}</td>
                                                @else
                                                    <td class="align-middle">{{ Str::limit($point->custom ?? 'No Custom', 20) }}</td>
                                                @endif
                                                <td class="align-middle justify-content-center">{{ $point->points }}</td>
                                                <td class="align-middle">{{ \Carbon\Carbon::parse($point->created_at)->format('m-d-y') }}</td>
                                                <td class="align-middle">
                                                    @if($point->status === 'Redeemed')
                                                        <span class="badge bg-success">Approved</span>
                                                    @elseif($point->status === 'Rejected')
                                                        <span class="badge bg-danger">Rejected</span>
                                                    @elseif($point->status === 'Pending')
                                                        <span class="badge bg-warning">Pending</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="d-flex gap-1 flex-wrap">
                                                        @if($point->status === 'Pending')
                                                            <a href="#" onclick="approvePoints({{$point->id}}, $(this))" class="btn btn-success btn-sm">
                                                                <i class="fas fa-check"></i> Approve
                                                            </a>
                                                            <a href="#" class="btn btn-danger btn-sm" onclick="fillEmployeeId({{$point->id}})" data-bs-toggle="modal"
                                                               data-bs-target="#rejectModal" data-bs-whatever="@getbootstrap">
                                                                <i class="fas fa-times"></i> Reject
                                                            </a>
                                                        @elseif($point->status === 'Redeemed')
                                                            <a href="#" class="btn btn-warning btn-sm" onclick="reverseApprovedPoints({{$point->id}})" title="Reverse Approval">
                                                                <i class="fas fa-undo"></i> Reverse
                                                            </a>
                                                        @elseif($point->status === 'Rejected')
                                                            <a href="#" class="btn btn-info btn-sm" onclick="reprocessRejectedPoints({{$point->id}})" title="Reprocess">
                                                                <i class="fas fa-redo"></i> Reprocess
                                                            </a>
                                                        @endif
                                                        
                                                        <!-- Edit button for all statuses -->
                                                        <a href="#" class="btn btn-outline-primary btn-sm" onclick="editPoints({{$point->id}})" 
                                                           data-bs-toggle="modal" data-bs-target="#editModal" title="Edit Points">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <!--------- End Loop ------------>
                    @endif

                </div>
            </div>
        </div>
    </div>

    <!--------- Start Modal ------------>

    <!-- Modal To Give Points To an Employee Directly -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Claim Points</h4>
                    <hr>
                    <form id="pointsForm">
                        @csrf
                        <div class="row">

                            <!-- Employee Name -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="selectEmployee" name="employee_id" class="form-control"
                                            aria-label="Product" required>
                                        <option selected disabled value="">--- Select Employee ---</option>
                                        @foreach($employees as $employee)
                                            @if($employee->category == $admin['category'])
                                                <option value="{{$employee->employee_id}}">{{$employee->name}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Vehicle Number -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="vin_no" name="vin_no" type="text"
                                           class="form-control shadow-none" value="" placeholder="Enter VIN#" required>
                                </div>
                            </div>

                            <!-- Dropdown to Select Target -->
                            <div class="col-md-6" id="divTarget">
                                <div class="mb-md-4 mb-3">
                                    <select id="selectTarget" name="target_id[]" class="form-control duplicated-div" aria-label="Product" required>
                                        <option selected disabled value="">--- Select Target ---</option>
                                        @foreach($targets as $target)
                                            @if($target->status == '2')
                                                @if($target->product_id)
                                                    @php
                                                        $name = $products->firstWhere('id', $target->product_id)->name;
                                                    @endphp
                                                    <option value="{{$target->id}}">{{$name}}</option>
                                                @else
                                                    <option value="{{$target->id}}">{{$target->custom}}</option>
                                                @endif
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Add More Button -->
                            <div class="col-md-6 " id="addMoreBtn">
                                <div class="mb-md-4 mb-3">
                                    <button type="button" class="btn btn-primary mb-3 px-5"
                                            onclick="addMore()">Add More</button>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Cancel
                                </button>

                                <button type="submit" id="sub-btn"
                                        class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal To Edit Points -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Edit Points</h4>
                    <hr>
                    <form id="editPointsForm">
                        @csrf
                        <input type="hidden" id="editPointId" name="point_id" value="">
                        
                        <div class="row">
                            <!-- Employee Name -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Employee</label>
                                    <select id="editSelectEmployee" name="employee_id" class="form-control" required>
                                        <option value="">--- Select Employee ---</option>
                                        @foreach($employees as $employee)
                                            @if($employee->category == $admin['category'])
                                                <option value="{{$employee->employee_id}}">{{$employee->name}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Vehicle Number -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">VIN#</label>
                                    <input id="editVinNo" name="vin_no" type="text"
                                           class="form-control shadow-none" placeholder="Enter VIN#" required>
                                </div>
                            </div>

                            <!-- Target/Product -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Target/Product</label>
                                    <select id="editSelectTarget" name="target_id" class="form-control" required>
                                        <option value="">--- Select Target ---</option>
                                        @foreach($targets as $target)
                                            @if($target->status == '2')
                                                @if($target->product_id)
                                                    @php
                                                        $name = $products->firstWhere('id', $target->product_id)->name;
                                                    @endphp
                                                    <option value="{{$target->id}}">{{$name}}</option>
                                                @else
                                                    <option value="{{$target->id}}">{{$target->custom}}</option>
                                                @endif
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Points -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Points</label>
                                    <input id="editPoints" name="points" type="number" min="1"
                                           class="form-control shadow-none" placeholder="Enter Points" required>
                                </div>
                            </div>

                            <!-- Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Status</label>
                                    <select id="editStatus" name="status" class="form-control" required>
                                        <option value="Pending">Pending</option>
                                        <option value="Redeemed">Approved</option>
                                        <option value="Rejected">Rejected</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Rejection Reason (shown when status is Rejected) -->
                            <div class="col-md-6" id="editRejectionReasonDiv" style="display: none;">
                                <div class="mb-md-4 mb-3">
                                    <label class="form-label">Rejection Reason</label>
                                    <textarea id="editRejectionReason" name="rejection_reason" rows="3" 
                                              class="form-control shadow-none" maxlength="250"
                                              placeholder="Enter reason for rejection"></textarea>
                                </div>
                            </div>

                            <!-- Current Status Info -->
                            <div class="col-12">
                                <div class="alert alert-info mb-3" id="editStatusInfo">
                                    <strong>Current Status:</strong> <span id="currentStatusText"></span>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Cancel
                                </button>

                                <button type="submit" id="edit-btn"
                                        class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal To Reject Points -->
    <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Reject Reason</h4>
                    <hr>
                    <form id="rejectForm">
                        @csrf
                        <div class="row">
                            <input type="hidden" id="targetID" name="id" value="">

                            <!-- Reject Reason -->
                            <div class="mb-md-4 mb-3">
                                <textarea id="detail" name="details" rows="5" class="form-control shadow-none"
                                          style="height: 100px" maxlength="250"
                                          placeholder="Enter Reason of Rejection" required></textarea>
                                <small>Limit : 250 Characters</small>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Cancel
                                </button>

                                <button type="submit" id="rejectBtn"
                                        class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for Bulk Reject -->
    <div class="modal fade" id="bulkRejectModal" tabindex="-1" aria-labelledby="bulkRejectModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Bulk Reject Reason</h4>
                    <hr>
                    <form id="bulkRejectForm">
                        @csrf
                        <div class="row">
                            <input type="hidden" id="bulkRejectIds" name="ids" value="">
                            
                            <div class="mb-md-4 mb-3">
                                <p>You are about to reject <span id="bulkRejectCount" class="fw-bold text-danger">0</span> selected points.</p>
                            </div>

                            <!-- Reject Reason -->
                            <div class="mb-md-4 mb-3">
                                <textarea id="bulkRejectDetails" name="details" rows="5" class="form-control shadow-none"
                                          style="height: 100px" maxlength="250"
                                          placeholder="Enter Reason for Bulk Rejection" required></textarea>
                                <small>Limit : 250 Characters</small>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Cancel
                                </button>

                                <button type="submit" id="bulkRejectBtn"
                                        class="btn btn-danger shadow-none mb-3 px-5 ms-md-3">
                                    <i class="fas fa-times"></i> Reject Selected
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!--------- End Modal ------------>

@endsection

@section('custom-scripts')
    <script>
        let selectedOptions = new Set(); // To keep track of selected options globally

        // Employee selection change handler
        $(document).ready(function() {
            // Handle edit status change
            $('#editStatus').on('change', function() {
                const status = $(this).val();
                if (status === 'Rejected') {
                    $('#editRejectionReasonDiv').show();
                    $('#editRejectionReason').attr('required', true);
                } else {
                    $('#editRejectionReasonDiv').hide();
                    $('#editRejectionReason').attr('required', false);
                }
            });

            // Handle individual checkbox change
            $(document).on('change', '.row-checkbox', function() {
                updateBulkActionsVisibility();
                updateSelectAllCheckbox();
            });

            // Handle select all checkbox
            $('#selectAllCheckbox').on('change', function() {
                const isChecked = $(this).prop('checked');
                $('.row-checkbox').prop('checked', isChecked);
                updateBulkActionsVisibility();
            });

            // Handle approve selected (enhanced to work with rejected items too)
            $('#approveSelectedBtn').on('click', function() {
                const validIds = getSelectedIds(['Pending', 'Rejected']);
                
                if (validIds.length === 0) {
                    swirlmsg('Please select at least one item to approve.');
                    return;
                }

                const rejectedCount = getSelectedIds(['Rejected']).length;
                const pendingCount = getSelectedIds(['Pending']).length;
                
                let confirmText = "You won't be able to revert this action!";
                if (rejectedCount > 0) {
                    confirmText += ` This will reprocess ${rejectedCount} previously rejected items.`;
                }
                
                Swal.fire({
                    title: `Approve ${validIds.length} Selected Points?`,
                    text: confirmText,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, Approve All!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        bulkApprovePointsEnhanced(validIds);
                    }
                });
            });

            // Handle reject selected (enhanced to work with approved items too)
            $('#rejectSelectedBtn').on('click', function() {
                const validIds = getSelectedIds(['Pending', 'Redeemed']);
                
                if (validIds.length === 0) {
                    swirlmsg('Please select at least one item to reject.');
                    return;
                }

                const approvedCount = getSelectedIds(['Redeemed']).length;
                const pendingCount = getSelectedIds(['Pending']).length;
                
                // Show bulk reject modal with enhanced message
                $('#bulkRejectIds').val(validIds.join(','));
                $('#bulkRejectCount').text(validIds.length);
                
                // Update modal message
                let modalMessage = `You are about to reject <span id="bulkRejectCount" class="fw-bold text-danger">${validIds.length}</span> selected points.`;
                if (approvedCount > 0) {
                    modalMessage += ` This includes ${approvedCount} previously approved points that will be reversed.`;
                }
                $('#bulkRejectModal .mb-md-4.mb-3 p').html(modalMessage);
                
                $('#bulkRejectModal').modal('show');
            });

            // Handle clear selection
            $('#clearSelectionBtn').on('click', function() {
                $('.row-checkbox').prop('checked', false);
                $('#selectAllCheckbox').prop('checked', false);
                updateBulkActionsVisibility();
            });
        });

        // Function to get selected IDs
        function getSelectedIds(statuses = null) {
            const selectedIds = [];
            $('.row-checkbox:checked').each(function() {
                if (!statuses) {
                    selectedIds.push($(this).val());
                } else {
                    const status = $(this).data('status');
                    if (Array.isArray(statuses) ? statuses.includes(status) : status === statuses) {
                        selectedIds.push($(this).val());
                    }
                }
            });
            return selectedIds;
        }

        // Function to update bulk actions visibility
        function updateBulkActionsVisibility() {
            const selectedCount = $('.row-checkbox:checked').length;
            const pendingCount = getSelectedIds(['Pending']).length;
            const approvedCount = getSelectedIds(['Redeemed']).length;
            const rejectedCount = getSelectedIds(['Rejected']).length;
            
            $('#selectedCount').text(selectedCount + ' selected');
            
            if (selectedCount > 0) {
                $('#bulkActionsRow').show();
                
                // Show/hide appropriate buttons based on selection
                const canApprove = (pendingCount + rejectedCount) > 0;
                const canReject = (pendingCount + approvedCount) > 0;
                
                // Update button states and text
                if (canApprove) {
                    $('#approveSelectedBtn').show();
                    if (rejectedCount > 0 && pendingCount > 0) {
                        $('#approveSelectedBtn').html('<i class="fas fa-check"></i> Approve/Reprocess Selected');
                    } else if (rejectedCount > 0) {
                        $('#approveSelectedBtn').html('<i class="fas fa-redo"></i> Reprocess Selected');
                    } else {
                        $('#approveSelectedBtn').html('<i class="fas fa-check"></i> Approve Selected');
                    }
                } else {
                    $('#approveSelectedBtn').hide();
                }
                
                if (canReject) {
                    $('#rejectSelectedBtn').show();
                    if (approvedCount > 0 && pendingCount > 0) {
                        $('#rejectSelectedBtn').html('<i class="fas fa-times"></i> Reject/Reverse Selected');
                    } else if (approvedCount > 0) {
                        $('#rejectSelectedBtn').html('<i class="fas fa-undo"></i> Reverse Selected');
                    } else {
                        $('#rejectSelectedBtn').html('<i class="fas fa-times"></i> Reject Selected');
                    }
                } else {
                    $('#rejectSelectedBtn').hide();
                }
            } else {
                $('#bulkActionsRow').hide();
            }
        }

        // Function to update select all checkbox state
        function updateSelectAllCheckbox() {
            const totalCheckboxes = $('.row-checkbox').length;
            const checkedCheckboxes = $('.row-checkbox:checked').length;
            
            if (checkedCheckboxes === 0) {
                $('#selectAllCheckbox').prop('indeterminate', false);
                $('#selectAllCheckbox').prop('checked', false);
            } else if (checkedCheckboxes === totalCheckboxes) {
                $('#selectAllCheckbox').prop('indeterminate', false);
                $('#selectAllCheckbox').prop('checked', true);
            } else {
                $('#selectAllCheckbox').prop('indeterminate', true);
            }
        }

        // Function to edit points
        function editPoints(pointId) {
            // Fetch point details
            $.ajax({
                type: 'GET',
                url: '{{ route('pAdmin.points.get') }}',
                data: { id: pointId },
                dataType: 'json',
                success: function(res) {
                    if (res.Error === false) {
                        const point = res.data;
                        
                        // Populate the edit form
                        $('#editPointId').val(point.id);
                        $('#editSelectEmployee').val(point.employee_id);
                        $('#editVinNo').val(point.vin_no);
                        $('#editSelectTarget').val(point.target_id);
                        $('#editPoints').val(point.points);
                        $('#editStatus').val(point.status);
                        
                        // Handle rejection reason
                        if (point.status === 'Rejected') {
                            $('#editRejectionReasonDiv').show();
                            $('#editRejectionReason').val(point.detail || '').attr('required', true);
                        } else {
                            $('#editRejectionReasonDiv').hide();
                            $('#editRejectionReason').attr('required', false);
                        }
                        
                        // Update status info
                        $('#currentStatusText').text(point.status);
                        
                    } else {
                        swirlmsg(res.Message);
                    }
                },
                error: function() {
                    swirlmsg('Failed to load point details.');
                }
            });
        }

        // Function to reverse approved points
        function reverseApprovedPoints(pointId) {
            Swal.fire({
                title: 'Reverse Approved Points?',
                text: "This will change the status back to pending and adjust target progress.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#f39c12',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Reverse!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('pAdmin.points.reverse') }}',
                        data: {
                            id: pointId,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function(res) {
                            if (res.Error === false) {
                                Swal.fire({
                                    title: "Success!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                                setTimeout(function() {
                                    window.location.reload();
                                }, 1000);
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function() {
                            swirlmsg('Failed to reverse points.');
                        }
                    });
                }
            });
        }

        // Function to reprocess rejected points
        function reprocessRejectedPoints(pointId) {
            Swal.fire({
                title: 'Reprocess Rejected Points?',
                text: "This will change the status back to pending for review.",
                icon: 'info',
                showCancelButton: true,
                confirmButtonColor: '#17a2b8',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Reprocess!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('pAdmin.points.reprocess') }}',
                        data: {
                            id: pointId,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function(res) {
                            if (res.Error === false) {
                                Swal.fire({
                                    title: "Success!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                                setTimeout(function() {
                                    window.location.reload();
                                }, 1000);
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function() {
                            swirlmsg('Failed to reprocess points.');
                        }
                    });
                }
            });
        }

        // Function to bulk approve points (enhanced to handle rejected items too)
        function bulkApprovePointsEnhanced(selectedIds) {
            $.ajax({
                type: 'POST',
                url: '{{ route('pAdmin.points.bulk.approve.enhanced') }}',
                data: {
                    ids: selectedIds,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function (res) {
                    if (res.Error === false) {
                        Swal.fire({
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        setTimeout(function () {
                            window.location.reload();
                        }, 1000);
                    } else {
                        swirlmsg(res.Message);
                    }
                },
                error: function (e) {
                    let first_error = 'An unknown error occurred.';
                    if (e.responseJSON && e.responseJSON.errors) {
                        first_error = Object.values(e.responseJSON.errors)[0][0];
                    }
                    swirlmsg(first_error);
                }
            });
        }

        // Function to bulk approve points (original - for backward compatibility)
        function bulkApprovePoints(selectedIds) {
            return bulkApprovePointsEnhanced(selectedIds);
        }

        // Edit points form submission
        $('#editPointsForm').on('submit', function(e) {
            e.preventDefault();
            
            var form = $('#editPointsForm')[0];
            var formdata = new FormData(form);
            $('#edit-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Updating')
                .prop('disabled', true);
                
            $.ajax({
                type: 'POST',
                url: '{{ route('pAdmin.points.update') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',
                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#editModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 1000);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#edit-btn').html('Update').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#edit-btn').html('Update').prop('disabled', false);
                }
            });
        });

        // Bulk reject form submission
        $('#bulkRejectForm').on('submit', function(e) {
            e.preventDefault();
            
            const selectedIds = $('#bulkRejectIds').val().split(',');
            const details = $('#bulkRejectDetails').val();
            
            $('#bulkRejectBtn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            
            $.ajax({
                type: 'POST',
                url: '{{ route('pAdmin.points.bulk.reject') }}',
                data: {
                    ids: selectedIds,
                    details: details,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function (res) {
                    if (res.Error === false) {
                        Swal.fire({
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#bulkRejectModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 1000);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#bulkRejectBtn').html('<i class="fas fa-times"></i> Reject Selected').prop('disabled', false);
                },
                error: function (e) {
                    let first_error = 'An unknown error occurred.';
                    if (e.responseJSON && e.responseJSON.errors) {
                        first_error = Object.values(e.responseJSON.errors)[0][0];
                    }
                    swirlmsg(first_error);
                    $('#bulkRejectBtn').html('<i class="fas fa-times"></i> Reject Selected').prop('disabled', false);
                }
            });
        });

        // Function to handle dropdown changes
        function updateDropdowns() {
            // Get all dropdowns with the 'duplicated-div' class
            const allDropdowns = $('.duplicated-div');

            // Loop through each dropdown and update its options
            allDropdowns.each(function () {
                const currentDropdown = $(this);
                const currentValue = currentDropdown.val(); // Preserve current value

                // Save the dropdown's original options
                const originalOptions = currentDropdown.data('originalOptions') || currentDropdown.html();

                // Update the dropdown options to exclude selected options
                currentDropdown.html(originalOptions); // Reset to original options
                selectedOptions.forEach(selectedValue => {
                    if (selectedValue !== currentValue) {
                        currentDropdown.find(`option[value="${selectedValue}"]`).remove();
                    }
                });

                // Preserve the current value if still valid
                if (currentValue) {
                    currentDropdown.val(currentValue);
                }
            });
        }

        // Function for Add More
        function addMore() {
            const newDropdown = $('#divTarget').clone();
            const newSelect = newDropdown.find('#selectTarget');

            newSelect.val(''); // Reset the new dropdown's value
            newSelect.addClass('dup-div');

            // Save the original options in the new dropdown
            if (!newSelect.data('originalOptions')) {
                newSelect.data('originalOptions', newSelect.html());
            }

            // Add a change event listener for the new dropdown
            newSelect.on('change', function () {
                const value = $(this).val();
                if (value) {
                    selectedOptions.add(value); // Add selected value to the set
                }
                updateDropdowns(); // Update all dropdowns
            });

            $('#addMoreBtn').after(newDropdown);

            // Update the new dropdown options
            updateDropdowns();
        }

        // Initialize the first dropdown's event listener
        $(document).on('change', '#selectTarget', function () {
            const value = $(this).val();
            if (value) {
                selectedOptions.add(value); // Add selected value to the set
            }
            updateDropdowns(); // Update all dropdowns
        });

        //Script to clear Modal everytime it is closed
        $('#addModal').on('hidden.bs.modal', function () {
            selectedOptions.clear();
            $(this).find('form')[0].reset();
            $(this).find('.dup-div').remove();

            // Reset the dropdown to its original options
            const divTarget = $(this).find('#divTarget');
            const originalDropdown = divTarget.find('select');

            // Restore original options if they were stored
            const originalOptions = originalDropdown.data('originalOptions');
            if (originalOptions) {
                originalDropdown.html(originalOptions); // Restore dropdown options
            }
            // Clear any value selection in the remaining dropdown
            originalDropdown.val('');
            
            console.log('Modal cleared - all fields reset');
        });

        //Script to Store Original Data on Show of Modal
        $('#addModal').on('show.bs.modal', function () {
            const dropdown = $(this).find('#divTarget select');
            if (!dropdown.data('originalOptions')) {
                dropdown.data('originalOptions', dropdown.html()); // Store original options
            }
            
            console.log('Modal opened - ready for employee selection');
        });

        // Clear edit modal when closed
        $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset();
            $('#editRejectionReasonDiv').hide();
            $('#edit-btn').html('Update').prop('disabled', false);
        });

        //Script to clear Modal everytime it is closed
        $('#rejectModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset();
        });

        // Clear bulk reject modal when closed
        $('#bulkRejectModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset();
            $('#bulkRejectBtn').html('<i class="fas fa-times"></i> Reject Selected').prop('disabled', false);
        });

        //Function to Fill EmployeeID
        function fillEmployeeId(id) {
            $('#targetID').val(id);
        }

        //AJAX to Add Points
        $('#addModal').on("submit", function (e) {
            e.preventDefault()
            var form = $('#pointsForm')[0];
            var formdata = new FormData(form);
            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('pAdmin.points.add') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 10);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#sub-btn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#sub-btn').html('Submit').prop('disabled', false);
                }

            });
        });

        //AJAX to Reject Point
        $('#rejectModal').on("submit", function (e) {
            e.preventDefault()
            var form = $('#rejectForm')[0];
            var formdata = new FormData(form);
            $('#rejectBtn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('pAdmin.points.reject') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#rejectModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 10);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#rejectBtn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#rejectBtn').html('Submit').prop('disabled', false);
                }

            });
        });

        //Function and AJAX to Approve Points
        function approvePoints(id) {
            Swal.fire({
                title: 'Points Confirmed?',
                // text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Approve!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('pAdmin.points.approve') }}',
                        data: {
                            id: id,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function (res) {
                            if (res.Error === false) {
                                Swal.fire({ // Swirl Success MSG
                                    title: "Points Approved!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                                setTimeout(function () {
                                    window.location.reload();
                                }, 100);
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function (e) {
                            let first_error = 'An unknown error occurred.';
                            if (e.responseJSON && e.responseJSON.errors) {
                                first_error = Object.values(e.responseJSON.errors)[0][0];
                            }
                            swirlmsg(first_error);
                        }
                    });
                }
            })
        }

    </script>
@endsection