@extends('PointsAdmin.layout')
@section('title',"Dashboard")
@section('page-name',"Hello ".$admin['name'])
@section('page-detail',"Welcome Back!")
@section('pagelink', 'dashboard')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card ">
            <div class="card-body">
                <!-- Assigned Emojis/GIFs Section -->
                @if(isset($assignedEmojis) && $assignedEmojis->count() > 0)
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="border rounded-3 p-4 bg-primary bg-opacity-10">
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    <i class="fas fa-gift text-primary" style="font-size: 1.5rem;"></i>
                                </div>
                                <div>
                                    <h5 class="mb-1 text-primary">Your Assigned Emojis & GIFs</h5>
                                    <small class="text-muted">Special emojis and GIFs assigned to you</small>
                                </div>
                            </div>
                            <div class="row">
                                @foreach($assignedEmojis as $assignment)
                                    <div class="col-md-4 col-sm-6 mb-3">
                                        <div class="card border-0 shadow-sm">
                                            <div class="card-body text-center p-3">
                                                <div class="mb-2" style="min-height: 60px; display: flex; align-items: center; justify-content: center;">
                                                    @if($assignment->emoji->type === 'emoji')
                                                        <span style="font-size: 2.5rem;">{{ $assignment->emoji->emoji_text }}</span>
                                                    @else
                                                        <img src="{{ asset($assignment->emoji->file_path) }}" 
                                                             alt="{{ $assignment->emoji->name }}" 
                                                             style="max-height: 60px; max-width: 100%;">
                                                    @endif
                                                </div>
                                                <h6 class="card-title mb-1">{{ $assignment->emoji->name }}</h6>
                                                @if($assignment->message)
                                                    <p class="card-text text-muted small mb-0">{{ $assignment->message }}</p>
                                                @endif
                                                <small class="text-muted">{{ $assignment->created_at->format('M d, Y') }}</small>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <div class=" border rounded-3 p-3">
                            <div class="d-flex align-items-center mb-3">
                                <div class="users-icon-box">
                                    <i class="fas fa-users"></i>
                                </div>
                                <h4 class="ms-3">{{$admin['category']}}</h4>
                            </div>
                            <div class="row">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">Name & Product</th>
                                            <th scope="col">Progress</th>
                                            <th scope="col">Total Quantity</th>
                                            <th scope="col" class="align-middle">Redeemed Points</th>
                                            <th scope="col">Target Points</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($targets as $target)
                                            <tr>
                                                <td class="align-middle">
                                                    @if($target->custom == null)
                                                        <h5 class="mb-2">{{$target->name}}</h5>
                                                    @else
                                                        <h5 class="mb-2">{{$target->custom}}</h5>
                                                    @endif
                                                </td>
                                                <th class="align-middle">
                                                    @php
                                                        $percent = calculatePercentage($target->progress, $target->quantity);
//                                                        dd($percent);
                                                    @endphp
                                                    <h5 class="mb-2">{{$percent['value']}}% <span
                                                            class="ms-4 p-light">{{$percent['status']}}</span></h5>
                                                    <div class="progress mb-3" style="height: 6px;">
                                                        <div class="progress-bar" role="progressbar"
                                                             style="width: {{$percent['value']}}%; background-color: #6EA0F9;"
                                                             aria-valuenow="{{$percent['value']}}" aria-valuemin="0"
                                                             aria-valuemax="100">
                                                        </div>
                                                    </div>
                                                </th>

                                                <td class="align-middle">{{$target->quantity}}</td>
                                                <td class="align-middle">
                                                    <a href="#" class="btn btn-primary"
                                                       style="width: 100px; height: 35px">{{$target->progress ?? '0'}}</a>
                                                </td>

                                                <td class="align-middle">
                                                    <small class="p-light mb-2"
                                                           style="font-size: 12px">Until: {{ \Carbon\Carbon::parse($target->last_date)->format('M d, Y') }}</small>
                                                    <h5>{{$target->quantity - $target->progress}}</h5>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <hr>
                            <p class="p-light mb-0">Updated at: {{$currentDate}}</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="border rounded-3 p-3">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col">Employee Name</th>
                                        <th scope="col">Employee ID</th>
                                        <th scope="col">Redeemed</th>
                                        <th scope="col">Pending</th>
                                        <th scope="col">Last Claimed</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($employees as $employee)
                                        <tr>
                                            <th class="align-middle">
                                                <div class="d-flex align-items-center">
                                                    <div class="ms-2">
                                                        <h5 class="mb-0">{{$employee->name}}</h5>
                                                    </div>
                                                </div>
                                            </th>
                                            <td class="align-middle">{{$employee->id}}</td>
                                            <td class="align-middle">{{$employee->redeemed_points}}</td>
                                            <td class="align-middle">{{$employee->pending_points}}</td>
                                            <td class="align-middle">{{ \Carbon\Carbon::parse($employee->date)->format('M-d-Y') }}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
