@extends('Manager.layout')
@section('title', 'Admin Details')
@section('page-name', 'Admin Details')
@section('page-detail', 'Admin Information')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row mb-3">

                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a type="button" class="btn btn-primary px-3 me-2" data-bs-toggle="modal"
                                   data-bs-target="#addModal" data-bs-whatever="@getbootstrap"><i
                                        class="fas fa-plus-circle me-3"></i> Add New Admin</a>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="card col-md-8">
                            <div class="card-body border rounded-3">
                                <div>
                                    <div class="d-flex align-items-center justify-content-between">
                                        <!-- Employee Info -->
                                        <div class="d-flex align-items-center">
                                            @if (!empty($employee->image))
                                                <img src="{{ asset($employee->image) }}"
                                                     alt="Employee Image"
                                                     style="height: 50px; width: 50px; border-radius: 20%;"
                                                     class="me-2">
                                            @else
                                                <span class="initials-container me-2"
                                                      style="border-radius: 20%;">
                                                {{ strtoupper(implode('', array_merge(array_map(fn($part) => is_numeric($part) ? $part : $part[0], array_slice(explode(' ', $employeeOrg->name), 0, 2)),preg_match('/\d/', $employeeOrg->name, $matches) ? [$matches[0]] : []))) }}
                                                </span>
                                            @endif
                                            <h4 class="mb-0">Personal Information</h4>
                                        </div>
                                        <!-- Action Buttons -->
                                        <div class="d-flex">
                                            <a type="button" class="btn btn-primary-white me-2" style="width: 100px"
                                               data-bs-toggle="modal" data-bs-target="#editModal" data-bs-whatever="@getbootstrap"
                                               onclick="populateForm({{ json_encode($employeeOrg) }})">Edit</a>

                                            <a type="button" class="btn btn-primary me-2" style="width: 100px; background-color: #DC3545FF !important;"
                                               onclick="deleteEmployee('{{ $employeeOrg->employee_id }}', $(this));">Delete</a>

                                        </div>
                                    </div>
                                    <div class="row mt-4">
                                        <div class="col-md-6">
                                            <p class="p-light">Name</p>
                                            <h5>{{$employeeOrg->name ?? 'N/A'}}</h5>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="p-light">Empolyee ID</p>
                                            <h5>{{$employeeOrg->employee_id}}</h5>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p class="p-light">Mobile Number</p>
                                            <h5>{{$employeeOrg->phn ?? 'N/A'}}</h5>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="p-light">Email Address</p>
                                            <h5>{{$employeeOrg->email ?? 'N/A'}}</h5>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p class="p-light">Date of Birth</p>
                                            <h5>{{\Carbon\Carbon::parse($employeeOrg->dob)->format('M d, Y') ?? 'N/A'}}</h5>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="p-light">Marital Status</p>
                                            <h5>{{$employeeOrg->marital ?? 'N/A'}}</h5>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p class="p-light">Gender</p>
                                            <h5>{{$employeeOrg->gender ?? 'N/A'}}</h5>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="p-light">Nationality</p>
                                            <h5>{{$employeeOrg->nationality ?? 'N/A'}}</h5>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p class="p-light">Address</p>
                                            <h5>{{$employeeOrg->address ?? 'N/A'}}</h5>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="p-light">Zip Code</p>
                                            <h5>{{$employeeOrg->zip ?? 'N/A'}}</h5>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p class="p-light">State</p>
                                            <h5>{{$employeeOrg->state ?? 'N/A'}}</h5>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="p-light">City</p>
                                            <h5>{{$employeeOrg->city ?? 'N/A'}}</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body border rounded-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h4 class="mb-4">Redeemed Points</h4>
                                    </div>
                                    <canvas id="overallPointsChart" class="px-3"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ========================================= -->
    <!-- MODAL -->

    <!-- To Edit Personal Information -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Employee</h4>
                    <hr>
                    <form id="editForm">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 d-none">
                                <div class="mb-md-4 mb-3">
                                    <input name="employee_id" type="number" readonly
                                           class="form-control shadow-none" id="employee_id"
                                           placeholder="Employee ID (auto)">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <!-- Name -->
                                    <input id="name" name="name" type="text" maxlength="50"
                                           class="form-control shadow-none" placeholder="Name of Employees" required>
                                    <small class="form-text" style="font-size: small;">Limit: 50 characters</small>
                                </div>
                                <!-- Email -->
                                <div class="mb-md-4 mb-3">
                                    <input id="email" name="email" type="email" class="form-control shadow-none"
                                           placeholder="Enter Email" required>
                                </div>
                            </div>

                            <!-- Image -->
                            <div class="col-md-5 justify-content-end">
                                <div class="mb-md-4 mb-3 text-center">
                                    <img onclick="$(this).siblings('input[type=file]').click()"
                                         id="addimage"
                                         style="height: 100%; width: 145px; object-fit: fill; cursor: pointer;"
                                         src="{{ asset('assets/img/placeholder-img-2.png') }}"
                                         alt="Employee Image Preview">
                                    <input id="addimage" onchange="displaySelectedImage(this, 'addimage')" type="file"
                                           class="d-none" name="image" accept="image/*">
                                </div>
                            </div>

                            <!-- Password -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="password" name="password" type="password" maxlength="50"
                                           class="form-control shadow-none" placeholder="Password" required>
                                </div>
                            </div>

                            <!-- Date of Birth -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3 text-left">
                                    <input id="dob" name="dob" type="date" class="form-control shadow-none"
                                           placeholder="Date of Birth" max="{{ date('Y-m-d') }}" required>
                                </div>
                            </div>

                            <!-- Mobile Number -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="phn" name="phn" type="tel" maxlength="15" pattern="[0-9+\-\(\)\s]*"
                                           class="form-control shadow-none" placeholder="Mobile Number" required>
                                </div>
                            </div>

                            <!-- Gender -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="gender" name="gender" class="form-control" aria-label="Gender"
                                            required>
                                        <option selected disabled value="">--- Select Gender ---</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Marital Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="marital" name="marital" class="form-control"
                                            aria-label="Marital Status" required>
                                        <option selected disabled value="">--- Select Marital Status ---</option>
                                        <option value="Married">Married</option>
                                        <option value="Unmarried">Unmarried</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Employee Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="status" name="status" class="form-control"
                                            aria-label="Status of Employee" required>
                                        <option selected disabled value="">--- Select Status of Employee ---</option>
                                        <option value="2">Active</option>
                                        <option value="1">Inactive</option>
                                        <option value="0">Pending</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to add Department -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="department" name="department" class="form-control"
                                            aria-label="Department"
                                            onchange="populateCategory({{ json_encode($department) }})" required>
                                        <option selected disabled>--- Select Department ---</option>
                                        <option value="{{$department->id}}">{{$department->name}}</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Role of Employee -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="role" name="role" class="form-control" aria-label="role">
                                        <option disabled >--- Select Role ---</option>
                                        <option selected value="Admin">Admin</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to Add Category -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="category" name="category" class="form-control" aria-label="category">
                                        <option selected disabled>--- Select Category ---</option>
                                        <option value="{{$employeeOrg->category}}">{{$employeeOrg->category}}</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Nationality -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="nationality" name="nationality" type="text" maxlength="15"
                                           class="form-control shadow-none" placeholder="Nationality" required>
                                </div>
                            </div>

                            <!-- State -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="state" name="state" type="text" maxlength="15"
                                           class="form-control shadow-none" placeholder="State" required>
                                </div>
                            </div>

                            <!-- Zip Code -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="zip" name="zip" type="number" maxlength="15"
                                           class="form-control shadow-none" placeholder="Zip Code" required>
                                </div>
                            </div>

                            <!-- City -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="city" name="city" type="text" maxlength="30"
                                           class="form-control shadow-none" placeholder="City" required>
                                </div>
                            </div>

                            <!-- Address -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <textarea id="address" name="address" type="text" rows="3" maxlength="100"
                                              class="form-control shadow-none" required>Address</textarea>
                                    <small class="form-text" style="font-size: small;">Limit: 100 characters</small>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button type="button" id="cancelBtn" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel
                            </button>
                            <button type="submit" id="sub-btn"
                                    class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- To Add New Admin -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Admin</h4>
                    <hr>
                    <form id="adminForm">
                        @csrf
                        <div class="row">
                            <!-- Select Employee -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="selectAdmin" class="form-control"
                                            aria-label="Employees"
                                            onchange="employeeId(this)" required>
                                        <option selected disabled value="">--- Select Employee ---</option>
                                        @foreach($employees as $employee)
                                            <option value="{{$employee->employee_id}}">{{$employee->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Employee ID -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input type="text" name="employee_id" readonly class="form-control shadow-none"
                                           id="adminId" placeholder="Employee ID (auto)">
                                </div>
                            </div>

                            <!-- Dropdown to add Department -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="adminDepartment" name="department" class="form-control"
                                            aria-label="Department" required>
                                        <option selected disabled>--- Select Department ---</option>
                                        <option value="{{$department->id}}">{{$department->name}}</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to Add Category -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="adminCategory" name="category" class="form-control" aria-label="category">
                                        <option selected disabled>--- Select Category ---</option>
                                        <option value="{{$employeeOrg->category}}">{{$employeeOrg->category}}</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Employee Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="adminStatus" name="status" class="form-control"
                                            aria-label="Status of Employee" required>
                                        <option selected disabled>--- Select Status of Employee ---</option>
                                        <option value="2">Active</option>
                                        <option value="0">Pending</option>
                                        <option disabled id="disOption" value="1">Inactive</option>
                                    </select>
                                </div>
                            </div>

                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel
                            </button>
                            <button type="submit" id="sub-btn" class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">
                                Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- ========================================= -->

@endsection

@section('custom-scripts')
    <script>

        // Function runs Automatically when Page Loads
        window.onload = function() {
            //Fill Data in Array to Plot Pie Chart
            const redeemedPoints = {!! json_encode(calculatePercentage($piePoints->redeemed ?? 0, $piePoints->total_points ?? 0)) !!}.value;
            const pieData = [
                redeemedPoints, // Add the redeemed value
                100 - redeemedPoints,  // Add the pending value
            ];
            createPieChart(pieData);
        };

        // Plot Pie Chart for All the Redeemed and Pending Points
        function createPieChart(chartData) {
            const ctxPie = document.getElementById('overallPointsChart').getContext('2d');
            new Chart(ctxPie, {
                type: 'doughnut',
                data: {
                    labels: ['Redeemed Points', 'Pending Points'],
                    datasets: [{
                        data: chartData, // Example data (in percentages)
                        backgroundColor: ['#6EA0F9', '#1a1a2e'],
                        hoverOffset: 4,
                        borderWidth: 2,
                        borderColor: '#ffffff' // White border for separation
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%', // Creates a thicker donut appearance
                    plugins: {
                        legend: {
                            display: true,
                            position: 'bottom',
                            labels: {
                                color: '#000',
                                font: {
                                    family: 'Montserrat', // Ensure Montserrat is included in your CSS
                                    size: 14
                                }
                            }
                        },
                        tooltip: {
                            backgroundColor: '#ffffff',
                            bodyColor: '#1a1a2e',
                            titleColor: '#1a1a2e',
                            borderColor: 'var(--primary-color)',
                            borderWidth: 1,
                            padding: 10,
                            callbacks: {
                                label: function(tooltipItem) {
                                    return `${tooltipItem.label}: ${tooltipItem.raw}%`;
                                }
                            }
                        }
                    }
                }
            });
        }

        //Populates Employee ID
        function employeeId(selectElement) {
            var selectedId = $(selectElement).val();
            $('#adminId').empty();
            @foreach($employees as $employee)
            if ('{{ $employee->employee_id }}' === selectedId) {
                $('#adminId').val('{{ $employee->employee_id }}');
            }
            @endforeach
        }

        //Function to Populate Form
        function populateForm(employee, read) {
            // Reset the form
            $('form')[0].reset();
            // Populate the input fields with employee data
            $('#employee_id').val(employee.employee_id);
            $('#name').val(employee.name);
            $('#email').val(employee.email);
            $('#password').removeAttr('required');
            $('#status').val(employee.status);
            $('#addimage').attr('src', employee.image ? '{{ asset('') }}' + employee.image : '{{ asset('assets/img/placeholder-img-2.png') }}');
            $('#dob').val(employee.dob);
            $('#phn').val(employee.phn);
            $('#gender').val(employee.gender);
            $('#marital').val(employee.marital);
            $('#nationality').val(employee.nationality);
            $('#city').val(employee.city);
            $('#state').val(employee.state);
            $('#zip').val(employee.zip);
            $('#address').val(employee.address);
            $('#department').val(employee.department_id);//.trigger('change');
            $('#role').val(employee.role);
            $('#category').val(employee.category);
        }

        // // Function to Populate Category
        // function populateCategory(department) {
        //     cate = JSON.parse(department.categories);
        //     $('#category').empty()
        //         .append('<option selected disabled >--- Select Category ---</option>')
        //     for (let i = 0; i < cate.length; i++) {
        //         $('#category').append('<option value="' + cate[i] + '">' + cate[i] + '</option>');
        //     }
        // }

        //AJAX to Edit Admin Info
        $('#editModal').on("submit", function (e) {
            e.preventDefault()

            var form = $('#editForm')[0];
            var formdata = new FormData(form);
            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('m.manager.add') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#editModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 100);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#sub-btn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#sub-btn').html('Submit').prop('disabled', false);
                }

            });
        });

        //Function and AJAX to Delete Admin
        function deleteEmployee(id, element) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('m.manager.delete') }}',
                        data: {
                            id: id,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function (res) {
                            if (res.Error === false) {
                                element.parent().parent().remove();
                                Swal.fire({ // Swirl Success MSG
                                    title: "Deleted!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function (e) {
                            let first_error = 'An unknown error occurred.';
                            if (e.responseJSON && e.responseJSON.errors) {
                                first_error = Object.values(e.responseJSON.errors)[0][0];
                            }
                            swirlmsg(first_error);
                        }
                    });
                }
            })
        }

    </script>
@endsection
