@extends('Manager.layout')
@section('title',"Targets")
@section('page-name',"Department Targets")
@section('page-detail',"All Assigned Targets Information")
{{--@section('pagelink', 'target')--}}
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <div class="serch">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i></span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search"
                                           aria-label="search" aria-describedby="basic-addon1">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a href="#" class="btn btn-primary w-auto-fix" data-bs-toggle="modal"
                                   data-bs-target="#addModal" data-bs-whatever="@getbootstrap">
                                    <i class="fas fa-pen me-2"></i> Add New Target</a>
                            </div>
                        </div>
                    </div>
                    <hr>

                    @if($targets->isEmpty())
                        <h4> No Targets Assigned Yet! </h4>
                    @else
                        <!--------- Start Loop ------------>
                            <div class="row mt-4">
                                <div class="col-md-6 mt-auto">
                                    <div class="d-flex align-items-center">
                                        <div>
                                            <h4> Department :  {{ $department->name ?? 'No Department Assigned' }} </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <table id="entryTable" class="table">
                                            <thead>
                                            <tr>
                                                <th scope="col">Category</th>
                                                <th scope="col">Target/Product</th>
                                                <th scope="col">Total Points</th>
                                                <th scope="col">Redeemed</th>
                                                <th scope="col">Last Date</th>
                                                <th scope="col">Status</th>
                                                <th scope="col">Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($targets as $target)
                                                <tr>
                                                    <td class="align-middle">{{ $target->category }}</td>
                                                    @if($target->product_id)
                                                        <td class="align-middle">{{ $products->firstWhere('id', $target->product_id)->name }}</td>
                                                    @else
                                                        <td class="align-middle">{{ Str::limit($target->custom ?? 'No Custom', 50) }}</td>

                                                    @endif
                                                    <td class="align-middle justify-content-center">{{ $target->quantity }}</td>
                                                    <td class="align-middle">{{ $target->progress ?? "Nothing Yet" }}</td>
                                                    <td class="align-middle">{{ \Carbon\Carbon::parse($target->last_date)->format('m-d-y') }}</td>
                                                    <td class="align-middle">
                                                        @if($target->status === '2')
                                                            <a href="#" class="btn btn-active">Active</a>
                                                        @elseif($target->status === '1')
                                                            <a href="#" class="btn btn-inactive">Inactive</a>
                                                        @else
                                                            <a href="#" class="btn btn-pending">Pending</a>
                                                        @endif
                                                    </td>

                                                    <td class="align-middle">

                                                        <a href="#" onclick="renewTarget({{$target->id}} )">
                                                            <i class="fa-solid fa-repeat"></i></a>

                                                        <a href="#" onclick="populateForm({{ json_encode($target) }})"
                                                           data-bs-toggle="modal"
                                                           data-bs-target="#addModal" data-bs-whatever="@getbootstrap">
                                                            <i class="fas fa-pen px-1"></i></a>

                                                        <a href="#" onclick="deleteTarget({{$target->id}}, $(this) )">
                                                            <i class="fas fa-trash px-1"></i></a>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        <!--------- End Loop ------------>
                    @endif

                </div>
            </div>
        </div>
    </div>

    <!--------- Start Modal ------------>

    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Target</h4>
                    <hr>
                    <form id="targetForm">
                        @csrf
                        <div class="row">
                            <input type="hidden" name="id" id="trgtID" value="">

                            <!-- Dropdown to add Department -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="department" name="department_id" class="form-control"
                                            aria-label="Department"
                                            onchange="populateCategory({{ json_encode($department) }})" required>
                                        <option selected disabled>--- Select Department ---</option>
                                        <option value="{{$department->id}}">{{$department->name}}</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to Add Category -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="category" name="category" class="form-control" aria-label="category" required>
                                        <option selected disabled >--- Select category ---</option>
                                        <option value="All Categories" >All Categories</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to Select Type of Target -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="targetType" class="form-control" aria-label="category"
                                            onchange="typeOfTarget()" required>
                                        <option selected disabled >--- Select Target Type ---</option>
                                        <option value="product">Target Product</option>
                                        <option value="custom">Custom</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to add Product -->
                            <div class="col-md-6 d-none" id="typeProduct">
                                <div class="mb-md-4 mb-3">
                                    <select id="product" name="product_id" class="form-control"
                                            aria-label="Product">
                                        <option selected disabled value="">--- Select a Product ---</option>
                                        @foreach($products as $product)
                                            <option value="{{$product->id}}">{{$product->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Input for Target -->
                            <div class="col-md-6 d-none" id="typeCustom">
                                <div class="mb-md-4 mb-3">
                                    <input id="custom" name="custom" type="text" maxlength="100"
                                           class="form-control shadow-none" placeholder="Enter Target Input" required>
                                    <small class="form-text">Limit : 100 Characters Only</small>
                                </div>
                            </div>

                            <!-- Quantity for Target -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="quantity" name="quantity" type="number" min="1"
                                           class="form-control shadow-none" placeholder="Target Quantity" required>
                                </div>
                            </div>

                            <!-- Last Date for Target -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
{{--                                    <input id="last_date" name="last_date" type="date"--}}
{{--                                           class="form-control shadow-none" placeholder="Custom Target Input" required>--}}

                                    <input id="last_date" name="last_date" type="text"
                                           class="form-control shadow-none" placeholder="MM/DD/YYYY" required>

                                </div>
                            </div>

                            <!-- Target Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="status" name="status" class="form-control"
                                            aria-label="Status of Target" required>
                                        <option selected disabled>--- Select Status of Target ---</option>
                                        <option value="2">Active</option>
                                        <option value="0">Pending</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel</button>

                            <button type="submit" id="sub-btn" class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!--------- End Modal ------------>

@endsection

@section('custom-scripts')
    <script>

        //Script to clear Modal everytime it is closed
        $('#addModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset();
            $('#department').css('pointer-events', 'auto');
            $('#category').css('pointer-events', 'auto');
            $('#targetType').css('pointer-events', 'auto');
            $('#product').css('pointer-events', 'auto');
        });

        // Function to Populate Category
        function populateCategory(department) {
            cate = JSON.parse(department.categories);
            $('#category').empty()
                .append('<option selected disabled >--- Select Category ---</option>')
                .append('<option value="All Categories">All Categories</option>')
            for (let i = 0; i < cate.length; i++) {
                $('#category').append('<option value="' + cate[i] + '">' + cate[i] + '</option>');
            }
        }

        //Function to show type of Target
        function typeOfTarget() {
            let type = $('#targetType').val();
            if(type == "product")
            {
                $('#typeProduct').removeClass('d-none');
                $('#typeCustom').addClass('d-none');
                $('#product').prop('required', true);
                $('#custom').attr('required', false).val('');
            }
            else
            {
                $('#typeProduct').addClass('d-none');
                $('#typeCustom').removeClass('d-none');
                $('#product').prop('required', false).val('');
                $('#custom').attr('required', true);
            }
        }

        //Function To Populate Form
        function populateForm(target) {
            $('#trgtID').val(target.id);
            $('#department').val(target.department_id).trigger('change').css('pointer-events', 'none');
            if(target.category == 'All Categories')
            {
                $('#category').val(target.category).css('pointer-events', 'auto');
            }
            else
            {
                $('#category').val(target.category).css('pointer-events', 'none');
            }
            if(target.product_id != null)
            {
                $('#targetType').val("product").trigger('change').css('pointer-events', 'none');
                $('#product').val(target.product_id).css('pointer-events', 'none');
            }
            else
            {
                $('#targetType').val("custom").trigger('change').css('pointer-events', 'none');
                $('#custom').val(target.custom);
            }
            $('#quantity').val(target.quantity);
            $('#last_date').val(target.last_date);
            $('#status').val(target.status);
        }

        //AJAX to Add/Update  Target
        $('#addModal').on("submit", function (e) {
            e.preventDefault()
            console.log('inside ajax');
            var form = $('#targetForm')[0];
            var formdata = new FormData(form);
            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('dep.target.add') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 10);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#sub-btn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#sub-btn').html('Submit').prop('disabled', false);
                }

            });
        });

        //Function and AJAX to Delete Target
        function deleteTarget(id, element) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('dep.target.delete') }}',
                        data: {
                            id: id,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function (res) {
                            if (res.Error === false) {
                                element.parent().parent().remove();
                                Swal.fire({ // Swirl Success MSG
                                    title: "Deleted!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function (e) {
                            let first_error = 'An unknown error occurred.';
                            if (e.responseJSON && e.responseJSON.errors) {
                                first_error = Object.values(e.responseJSON.errors)[0][0];
                            }
                            swirlmsg(first_error);
                        }
                    });
                }
            })
        }

        // Ajax to Renew Target
        function renewTarget(id) {
            $.ajax({
                type: 'POST',
                url: '{{ route('dep.target.renew') }}',
                data: {
                    id: id,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function (res) {
                    if (res.Error === false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        setTimeout(function () {
                            window.location.reload();
                        }, 10);
                    } else {
                        swirlmsg(res.Message);
                    }
                },
                error: function (e) {
                    let first_error = 'An unknown error occurred.';
                    if (e.responseJSON && e.responseJSON.errors) {
                        first_error = Object.values(e.responseJSON.errors)[0][0];
                    }
                    swirlmsg(first_error);
                }
            });
        }

    </script>
@endsection
