@extends('Manager.layout')
@section('title',"Leader Board")
@section('page-name',"Leader Board")
@section('page-detail',"All Rankings Information")
@section('body')
    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row align-items-center">
                        <div class="col-md-5 col-lg-4 mb-3">
                            <h4>Leader Board</h4>
                        </div>
                        <div class="col-md-7 ms-auto mb-3">
                            <div class="d-flex justify-content-end gap-2 align-items-center flex-wrap">
                                <!-- Advanced Category Filter -->
                                <div class="filter-group" id="categoryFilterGroup" style="display: none;">
                                    <label class="form-label small">Specific Category</label>
                                    <select class="form-select shadow-none" id="categoryFilter" style="width: 150px" onchange="filterBySpecificCategory()">
                                        <option value="all">All Categories</option>
                                        @foreach($availableCategories as $category)
                                            <option value="{{ $category }}">{{ $category }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <!-- Month Dropdown -->
                                <div class="filter-group">
                                    <label class="form-label small">Month</label>
                                    <select class="form-select shadow-none" style="width: 150px" id="dateFilter" onchange="filterByDate()">
                                        @foreach($months as $month)
                                            <option value="{{ $month }}">{{ \Carbon\Carbon::parse($month)->format('M-y') }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <!-- Filter Dropdown -->
                                <div class="filter-group">
                                    <label class="form-label small">View</label>
                                    <select class="form-select shadow-none" style="width: 150px" id="filter" onchange="switchBoards()">
                                        <option value="emp">Employees</option>
                                        <option value="dep">Department</option>
                                        <option value="cat">Category</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Department Leader Board -->
                    <div class="row d-none" id="depLeaderBoard">
                        @include('partials.departmentLeaderBoard', ['departments' => $departments])
                    </div>

                    <!-- Employee Leader Board -->
                    <div class="row" id="empLeaderBoard">
                        @include('partials.employeeLeaderBoard', ['employees' => $employees])
                    </div>

                    <!-- Category Leader Board -->
                    <div class="row d-none" id="catLeaderBoard">
                        @include('partials.categoryLeaderBoard', ['categories' => $categories])
                    </div>

                    <!-- Dealership Leader Board -->
                    <div class="row d-none" id="dealerLeaderBoard">
                        {{--                        @include('partials.dealershipLeaderBoard', ['dealerships' => $dealerships])--}}
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-scripts')
    <script>

        //Function to switch between Leader Boards
        function switchBoards() {
            filterByDate();
            let choice = $('#filter').val();
            if(choice == 'emp')
            {
                $('#empLeaderBoard').removeClass('d-none');
                $('#depLeaderBoard').addClass('d-none');
                $('#catLeaderBoard').addClass('d-none');
            }
            else if(choice == 'dep')
            {
                $('#depLeaderBoard').removeClass('d-none');
                $('#empLeaderBoard').addClass('d-none');
                $('#catLeaderBoard').addClass('d-none');
            }
            else
            {
                $('#catLeaderBoard').removeClass('d-none');
                $('#empLeaderBoard').addClass('d-none');
                $('#depLeaderBoard').addClass('d-none');
            }
        }

        //Function to get Filtered Data By Date
        function filterByDate() {
            let selectedMonth = $('#dateFilter').val();
            let choice = $('#filter').val();
            if(choice == 'emp')
            {
                let url = "{{ route('mngr.empFilter.leaderboard', ['currentMonth' => ':currentMonth']) }}".replace(':currentMonth', selectedMonth);
                $.ajax({
                    url: url, // Create this route in Laravel
                    type: "GET",
                    success: function(response) {
                        $("#empLeaderBoard").html(response); // Replace the leaderboard div with the updated content
                    },
                    error: function(xhr) {
                        console.error("Error fetching leaderboard:", xhr.responseText);
                    }
                });
            }
            else if(choice == 'dep')
            {
                let url = "{{ route('mngr.depFilter.leaderboard', ['currentMonth' => ':currentMonth']) }}".replace(':currentMonth', selectedMonth);
                $.ajax({
                    url: url, // Create this route in Laravel
                    type: "GET",
                    success: function(response) {
                        $("#depLeaderBoard").html(response); // Replace the leaderboard div with the updated content
                    },
                    error: function(xhr) {
                        console.error("Error fetching leaderboard:", xhr.responseText);
                    }
                });
            }
            else
            {
                let url = "{{ route('mngr.catFilter.leaderboard', ['currentMonth' => ':currentMonth']) }}".replace(':currentMonth', selectedMonth);
                $.ajax({
                    url: url, // Create this route in Laravel
                    type: "GET",
                    success: function(response) {
                        $("#catLeaderBoard").html(response); // Replace the leaderboard div with the updated content
                    },
                    error: function(xhr) {
                        console.error("Error fetching leaderboard:", xhr.responseText);
                    }
                });
            }
        }

        // Advanced Category Filtering Functions
        function filterBySpecificCategory() {
            const category = $('#categoryFilter').val();
            const selectedMonth = $('#dateFilter').val();
            const choice = $('#filter').val();
            
            console.log('Filtering by category:', category, 'Month:', selectedMonth, 'Choice:', choice);
            
            if (category === 'all') {
                // Show all categories - reload without category filter
                filterByDate();
                return;
            }
            
            if (choice === 'emp') {
                showLoadingState();
                
                let url = "{{ route('mngr.empFilter.leaderboard', ['currentMonth' => ':currentMonth']) }}".replace(':currentMonth', selectedMonth);
                url += '?category=' + encodeURIComponent(category);
                
                console.log('Fetching URL:', url);
                
                fetch(url)
                    .then(response => {
                        console.log('Response status:', response.status);
                        if (!response.ok) {
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }
                        return response.text();
                    })
                    .then(data => {
                        console.log('Received data length:', data.length);
                        $("#empLeaderBoard").html(data);
                        hideLoadingState();
                    })
                    .catch(error => {
                        console.error('Error fetching filtered leaderboard:', error);
                        hideLoadingState();
                        showErrorMessage('Failed to load filtered leaderboard data');
                    });
            } else {
                // For other views, just show all data
                filterByDate();
            }
        }

        function showLoadingState() {
            const currentChoice = $('#filter').val();
            const container = $('#' + currentChoice + 'LeaderBoard');
            
            container.html(`
                <div class="col-12">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <p class="mt-3 text-muted">Loading leaderboard data...</p>
                    </div>
                </div>
            `);
        }

        function hideLoadingState() {
            // Loading state is automatically hidden when content is replaced
        }

        function showErrorMessage(message) {
            const currentChoice = $('#filter').val();
            const container = $('#' + currentChoice + 'LeaderBoard');
            
            container.html(`
                <div class="col-12">
                    <div class="alert alert-danger text-center">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        ${message}
                    </div>
                </div>
            `);
        }

        // Override the switchBoards function to show/hide category filter
        function switchBoards() {
            let choice = $('#filter').val();
            
            // Show/hide category filter based on selection
            if (choice === 'cat') {
                $('#categoryFilterGroup').show();
            } else {
                $('#categoryFilterGroup').hide();
                $('#categoryFilter').val('all'); // Reset category filter
            }
            
            if(choice == 'emp')
            {
                $('#empLeaderBoard').removeClass('d-none');
                $('#depLeaderBoard').addClass('d-none');
                $('#catLeaderBoard').addClass('d-none');
                // Load employee data for current month
                filterByDate();
            }
            else if(choice == 'dep')
            {
                $('#depLeaderBoard').removeClass('d-none');
                $('#empLeaderBoard').addClass('d-none');
                $('#catLeaderBoard').addClass('d-none');
                // Load department data for current month
                filterByDate();
            }
            else
            {
                $('#catLeaderBoard').removeClass('d-none');
                $('#empLeaderBoard').addClass('d-none');
                $('#depLeaderBoard').addClass('d-none');
                // Load category data for current month
                filterByDate();
            }
        }

        // Initialize page on load
        $(document).ready(function() {
            // Ensure employee view is selected by default
            $('#filter').val('emp');
            
            // Hide category filter initially (only show for category view)
            $('#categoryFilterGroup').hide();
            
            // Ensure employee leaderboard is visible by default
            $('#empLeaderBoard').removeClass('d-none');
            $('#depLeaderBoard').addClass('d-none');
            $('#catLeaderBoard').addClass('d-none');
            
            // The employee data is already loaded in the view, so no need for AJAX call
            console.log('Manager leaderboard initialized with employee view as default');
        });

    </script>

    <style>
        .filter-group {
            margin-bottom: 15px;
        }

        .filter-group label {
            font-weight: 600;
            color: #495057;
            margin-bottom: 5px;
        }

        .filter-group .form-select {
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
        }

        .filter-group .form-select:focus {
            border-color: #86b7fe;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
    </style>
@endsection
