@extends('Manager.layout')
@section('title',"Employee Points")
@section('page-name',$category." Employee Point")
@section('page-detail',"All Requested Points Information")
{{--@section('pagelink', 'dashboard')--}}
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <div class="serch">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i></span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search"
                                           aria-label="serch" aria-describedby="basic-addon1">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a href="#" class="btn btn-primary w-auto-fix me-2" data-bs-toggle="modal"
                                   data-bs-target="#addModal" data-bs-whatever="@getbootstrap">
                                    <i class="fas fa-plus-circle me-3"></i>Add Points
                                </a>
                                {{--                                <a href="#" class="btn btn-primary-white px-4"><i class="fa-solid rounded-3 fa-sliders me-2"></i> Filter</a> --}}
                            </div>
                        </div>
                    </div>

                    <hr>

                    @if($points->isEmpty())
                        <h4> No Points Yet! </h4>
                    @else
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="entryTable" class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">Employee</th>
                                            <th scope="col">VIN#</th>
                                            <th scope="col">Target/Product</th>
                                            <th scope="col">Points</th>
                                            <th scope="col">Claimed Date</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($points as $point)
                                            <tr>
                                                @php
                                                    $empName = $employees->firstWhere('employee_id', $point->employee_id)->name;
                                                @endphp
                                                <td class="align-middle">{{ $empName }}</td>
                                                <td class="align-middle">{{ $point->vin_no }}</td>
                                                
                                                @if($targets->firstWhere('id', $point->target_id)->product_id )
                                                    @php
                                                        $prod = $targets->firstWhere('id', $point->target_id)->product_id;
                                                        $name = $products->firstWhere('id', $prod)->name;
                                                    @endphp
                                                    <td class="align-middle">{{ $name }}</td>
                                                @else
                                                    <td class="align-middle">{{ Str::limit($targets->firstWhere('id', $point->target_id)->custom ?? 'No Custom', 20) }}</td>
                                                @endif

                                                <td class="align-middle justify-content-center">{{ $point->points }}</td>
                                                <td class="align-middle">{{ \Carbon\Carbon::parse($point->created_at)->format('m-d-y') }}</td>

                                                <td>
                                                    @if($point->status === 'Pending')
                                                        <a href="#" onclick="approvePoints({{$point->id}}, $(this))" class="btn btn-pending">Approve</a>

                                                        <a href="#" class="btn btn-inactive" onclick="fillEmployeeId({{$point->id}})" data-bs-toggle="modal"
                                                           data-bs-target="#rejectModal" data-bs-whatever="@getbootstrap">Reject</a>

                                                    @elseif($point->status === 'Redeemed')
                                                        <a href="#" class="btn btn-active">Approved</a>
                                                    @elseif($point->status === 'Rejected')
                                                        <a href="#" class="btn btn-inactive">Rejected</a>
                                                    @endif
                                                </td>

                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <!--------- End Loop ------------>
                    @endif

                </div>
            </div>
        </div>
    </div>
    <!--------- Start Modal ------------>

    <!-- Modal To Give Points To an Employee Directly -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Claim Points</h4>
                    <hr>
                    <form id="pointsForm">
                        @csrf
                        <div class="row">

                            <input type="hidden" id="category" name="category" value="{{$category}}">
                            <!-- Employee Name -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="selectEmployee" name="employee_id" class="form-control"
                                            aria-label="Product" required>
                                        <option selected disabled value="">--- Select Employee ---</option>
                                        @foreach($employees as $employee)

                                            @if($employee->category == $category && $employee->status == '2' && $employee->role == 'Employee')
                                                <option value="{{$employee->employee_id}}">{{$employee->name}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Vehicle Number -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="vin_no" name="vin_no" type="text"
                                           class="form-control shadow-none" value="" placeholder="Enter VIN#" required>
                                </div>
                            </div>

                            <!-- Dropdown to Select Target -->
                            <div class="col-md-6" id="divTarget">
                                <div class="mb-md-4 mb-3">
                                    <select id="selectTarget" name="target_id[]" class="form-control duplicated-div" aria-label="Product" required>
                                        <option selected disabled value="">--- Select Target ---</option>
                                        @foreach($targets as $target)
                                            @if($target->status == '2')
                                                @if($target->product_id)
                                                    @php
                                                        $name = $products->firstWhere('id', $target->product_id)->name;
                                                    @endphp
                                                    <option value="{{$target->id}}">{{$name}}</option>
                                                @else
                                                    <option value="{{$target->id}}">{{$target->custom}}</option>
                                                @endif
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <!-- Add More Button -->
                            <div class="col-md-6 " id="addMoreBtn">
                                <div class="mb-md-4 mb-3">
                                    <button type="button" class="btn btn-primary mb-3 px-5"
                                            onclick="addMore()">Add More</button>
                                </div>
                            </div>


                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Cancel
                                </button>

                                <button type="submit" id="sub-btn"
                                        class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal To Reject Points -->
    <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Reject Reason</h4>
                    <hr>
                    <form id="rejectForm">
                        @csrf
                        <div class="row">
                            <input type="hidden" id="targetID" name="id" value="">

                            <!-- Reject Reason -->
                            {{--                            <div class="col-md-6">--}}
                            <div class="mb-md-4 mb-3">
                                    <textarea id="detail" name="details" rows="5" class="form-control shadow-none"
                                              style="height: 100px" maxlength="250"
                                              placeholder="Enter Reason of Rejection" required></textarea>
                                <small>Limit : 250 Characters</small>
                            </div>
                            {{--                            </div>--}}


                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Cancel
                                </button>

                                <button type="submit" id="rejectBtn"
                                        class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!--------- End Modal ------------>

@endsection

@section('custom-scripts')
    <script>

        let selectedOptions = new Set(); // To keep track of selected options globally

        // Function to handle dropdown changes
        function updateDropdowns() {
            // Get all dropdowns with the 'duplicated-div' class
            const allDropdowns = $('.duplicated-div');

            // Loop through each dropdown and update its options
            allDropdowns.each(function () {
                const currentDropdown = $(this);
                const currentValue = currentDropdown.val(); // Preserve current value

                // Save the dropdown's original options
                const originalOptions = currentDropdown.data('originalOptions') || currentDropdown.html();

                // Update the dropdown options to exclude selected options
                currentDropdown.html(originalOptions); // Reset to original options
                selectedOptions.forEach(selectedValue => {
                    if (selectedValue !== currentValue) {
                        currentDropdown.find(`option[value="${selectedValue}"]`).remove();
                    }
                });

                // Preserve the current value if still valid
                if (currentValue) {
                    currentDropdown.val(currentValue);
                }
            });
        }

        // Function for Add More
        function addMore() {
            const newDropdown = $('#divTarget').clone();
            const newSelect = newDropdown.find('#selectTarget');

            newSelect.val(''); // Reset the new dropdown's value
            newSelect.addClass('dup-div');

            // Save the original options in the new dropdown
            if (!newSelect.data('originalOptions')) {
                newSelect.data('originalOptions', newSelect.html());
            }

            // Add a change event listener for the new dropdown
            newSelect.on('change', function () {
                const value = $(this).val();
                if (value) {
                    selectedOptions.add(value); // Add selected value to the set
                }
                updateDropdowns(); // Update all dropdowns
            });

            $('#addMoreBtn').after(newDropdown);

            // Update the new dropdown options
            updateDropdowns();
        }

        // Initialize the first dropdown's event listener
        $(document).on('change', '#selectTarget', function () {
            const value = $(this).val();
            if (value) {
                selectedOptions.add(value); // Add selected value to the set
            }
            updateDropdowns(); // Update all dropdowns
        });

        //Script to clear Modal everytime it is closed
        $('#addModal').on('hidden.bs.modal', function () {
            selectedOptions.clear();
            $(this).find('form')[0].reset();
            $(this).find('.dup-div').remove();

            // Reset the dropdown to its original options
            const divTarget = $(this).find('#divTarget');
            const originalDropdown = divTarget.find('select');

            // Restore original options if they were stored
            const originalOptions = originalDropdown.data('originalOptions');
            if (originalOptions) {
                originalDropdown.html(originalOptions); // Restore dropdown options
            }
            // Clear any value selection in the remaining dropdown
            originalDropdown.val('');
        });

        $('#addModal').on('show.bs.modal', function () {
            const dropdown = $(this).find('#divTarget select');
            if (!dropdown.data('originalOptions')) {
                dropdown.data('originalOptions', dropdown.html()); // Store original options
            }
        });

        //Script to clear Modal everytime it is closed
        $('#rejectModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset();
        });

        //Function to Fill EmployeeID
        function fillEmployeeId(id) {
            $('#targetID').val(id);
        }

        //AJAX to Add Points
        $('#addModal').on("submit", function (e) {
            e.preventDefault()
            var form = $('#pointsForm')[0];
            var formdata = new FormData(form);
            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('mngr.points.add') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 10);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#sub-btn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#sub-btn').html('Submit').prop('disabled', false);
                }

            });
        });

        //AJAX to Reject Point
        $('#rejectModal').on("submit", function (e) {
            e.preventDefault()
            var form = $('#rejectForm')[0];
            var formdata = new FormData(form);
            $('#rejectBtn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('mngr.points.reject') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 10);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#rejectBtn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#rejectBtn').html('Submit').prop('disabled', false);
                }

            });
        });

        //Function and AJAX to Approve Points
        function approvePoints(id) {
            Swal.fire({
                title: 'Points Confirmed?',
                // text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Approve!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('mngr.points.approve') }}',
                        data: {
                            id: id,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function (res) {
                            if (res.Error === false) {
                                Swal.fire({ // Swirl Success MSG
                                    title: "Points Approved!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                                setTimeout(function () {
                                    window.location.reload();
                                }, 100);
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function (e) {
                            let first_error = 'An unknown error occurred.';
                            if (e.responseJSON && e.responseJSON.errors) {
                                first_error = Object.values(e.responseJSON.errors)[0][0];
                            }
                            swirlmsg(first_error);
                        }
                    });
                }
            })
        }

    </script>
@endsection
