@extends('Manager.layout')
@section('title',"Employee")
@section('page-name',"Employee")
@section('page-detail',"All Employees Information")
@section('pagelink', 'employee')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <div class="serch">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i></span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search"
                                           aria-label="serch" aria-describedby="basic-addon1">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a type="button" class="btn btn-primary px-3 me-2" data-bs-toggle="modal"
                                   data-bs-target="#addModal" data-bs-whatever="@getbootstrap" onclick="e_id()"><i
                                        class="fas fa-plus-circle me-3"></i> Add New Employee</a>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table class="table" id="entryTable">
                                    <thead>
                                    <tr>
                                        <th scope="col">Employee Name</th>
                                        <th scope="col">Employee ID</th>
                                        <th scope="col">Role</th>
                                        <th scope="col">Category</th>
                                        <th scope="col">Hire Date</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Assigned Emojis</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($employees as $employee)
                                        @if( $employee->role != 'Manager' )
                                            <tr>
                                                <th class="align-middle">
                                                    <div class="d-flex align-items-center">
                                                        <div class="position-relative">
                                                            @if (!empty($employee->image))
                                                                <img src="{{ asset($employee->image) }}"
                                                                     alt="Employee Image"
                                                                     style="height: 50px; width: 50px"
                                                                     class="img-fluid rounded-circle">
                                                            @else
                                                                <span class="initials-container">
                                                                {{ strtoupper(implode('', array_merge(array_map(fn($part) => is_numeric($part) ? $part : $part[0], array_slice(explode(' ', $employee->name), 0, 2)),preg_match('/\d/', $employee->name, $matches) ? [$matches[0]] : []))) }}
                                                                </span>
                                                            @endif
                                                            @php
                                                                $latestEmoji = \App\Models\EmojiAssignment::with('emoji')
                                                                    ->where('assignable_id', $employee->employee_id)
                                                                    ->where('assignable_type', 'App\Models\Employee')
                                                                    ->where('tenant_id', $employee->tenant_id)
                                                                    ->orderBy('created_at', 'desc')
                                                                    ->first();
                                                            @endphp
                                                            @if($latestEmoji)
                                                                <div class="custom-emoji-badge position-absolute" 
                                                                     style="bottom: -2px; right: -2px; font-size: 16px; 
                                                                            background: white; border-radius: 50%; 
                                                                            padding: 2px; line-height: 1; min-width: 24px; min-height: 24px; display: flex; align-items: center; justify-content: center;">
                                                                    @if($latestEmoji->emoji->type === 'emoji')
                                                                        <span style="font-size: 14px;">{{ $latestEmoji->emoji->emoji_text }}</span>
                                                                    @else
                                                                        <img src="{{ asset($latestEmoji->emoji->file_path) }}" 
                                                                             alt="{{ $latestEmoji->emoji->name }}" 
                                                                             style="height: 16px; width: 16px; object-fit: cover; border-radius: 50%;">
                                                                    @endif
                                                                </div>
                                                            @endif
                                                        </div>
                                                        <div class="ms-2">
                                                            <h5 class="mb-0">{{ $employee->name }}</h5>
                                                        </div>
                                                    </div>
                                                </th>
                                                <td class="align-middle">{{$employee->employee_id}}</td>
                                                <td class="align-middle">{{$employee->role ?? 'N/A'}}</td>
                                                <td class="align-middle">{{$employee->category ?? 'N/A'}}</td>
                                                <td class="align-middle">{{ $employee->created_at->format('m-d-y') }}</td>
                                                <td class="align-middle">
                                                    @if($employee->status === '2')
                                                        <a href="#" class="btn btn-active">Active</a>
                                                    @elseif($employee->status === '1')
                                                        <a href="#" class="btn btn-inactive">Inactive</a>
                                                    @else
                                                        <a href="#" class="btn btn-pending">Pending</a>
                                                    @endif
                                                </td>
                                                <!-- Assigned Emojis Column -->
                                                <td class="align-middle">
                                                    <div class="assigned-emojis-container" id="emojis-{{ $employee->employee_id }}">
                                                        @php
                                                            $assignedEmojis = \App\Models\EmojiAssignment::with('emoji')
                                                                ->where('assignable_id', $employee->employee_id)
                                                                ->where('assignable_type', 'App\Models\Employee')
                                                                ->where('tenant_id', $employee->tenant_id)
                                                                ->orderBy('created_at', 'desc')
                                                                ->take(3)
                                                                ->get();
                                                        @endphp
                                                        
                                                        @if($assignedEmojis->count() > 0)
                                                            <div class="d-flex align-items-center">
                                                                @foreach($assignedEmojis as $assignment)
                                                                    <div class="me-1" title="{{ $assignment->emoji->name }}">
                                                                        @if($assignment->emoji->type === 'emoji')
                                                                            <span style="font-size: 1.2rem;">{{ $assignment->emoji->emoji_text }}</span>
                                                                        @else
                                                                            <img src="{{ asset($assignment->emoji->file_path) }}" 
                                                                                 alt="{{ $assignment->emoji->name }}" 
                                                                                 style="height: 20px; width: 20px; object-fit: cover;">
                                                                        @endif
                                                                    </div>
                                                                @endforeach
                                                                @if($assignedEmojis->count() >= 3)
                                                                    <small class="text-muted">+{{ \App\Models\EmojiAssignment::where('assignable_id', $employee->employee_id)->where('assignable_type', 'App\Models\Employee')->where('tenant_id', $employee->tenant_id)->count() - 3 }}</small>
                                                                @endif
                                                            </div>
                                                        @else
                                                            <span class="text-muted">None</span>
                                                        @endif
                                                    </div>
                                                </td>
                                                <td class="align-middle">
                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#addModal"
                                                       data-bs-whatever="@getbootstrap"
                                                       onclick="populateForm({{ json_encode($employee) }}, true)">
                                                        <i class="fas fa-eye px-1"></i></a>

                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#addModal"
                                                       data-bs-whatever="@getbootstrap"
                                                       onclick="populateForm({{ json_encode($employee) }}, false)">
                                                        <i class="fas fa-pen px-1"></i></a>

                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#emojiAssignmentModal"
                                                       onclick="openEmojiAssignmentModal('{{ $employee->employee_id }}', '{{ $employee->name }}')">
                                                        <i class="fas fa-smile px-1" title="Assign Emoji/GIF"></i></a>

                                                    <a href="#"
                                                       onclick="deleteEmployee('{{ $employee->employee_id }}', $(this));">
                                                        <i class="fas fa-trash px-1"></i></a>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ========================================= -->
    <!-- MODAL -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Employee</h4>
                    <hr>
                    <form id="addForm">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 d-none">
                                <div class="mb-md-4 mb-3">
                                    <input name="employee_id" type="number" readonly
                                           class="form-control shadow-none" id="employee_id"
                                           placeholder="Employee ID (auto)">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <!-- Name -->
                                    <input id="name" name="name" type="text" maxlength="20"
                                           class="form-control shadow-none" placeholder="Name (Required)" required>
                                    <small class="form-text" style="font-size: small;">Limit: 20 characters</small>
                                </div>
                                <!-- Email -->
                                <div class="mb-md-4 mb-3">
                                    <input id="email" name="email" type="email" class="form-control shadow-none"
                                           placeholder="Email (Required)" required>
                                </div>
                            </div>

                            <!-- Image -->
                            <div class="col-md-5 justify-content-end">
                                <div class="mb-md-4 mb-3 text-center position-relative">
                                    <img onclick="$(this).siblings('input[type=file]').click()"
                                         id="addimage"
                                         style="height: 100%; width: 145px; object-fit: fill; cursor: pointer;"
                                         src="{{ asset('assets/img/placeholder-img-2.png') }}"
                                         alt="Employee Image Preview">
                                    <!-- <input id="addimage" onchange="displaySelectedImage(this, 'addimage')" type="file"
                                           class="d-none" name="image" accept="image/*"> -->
                                     <input id="addimage" 
       onchange="displaySelectedImage(this, 'addimage')" 
       type="file" 
       class="d-none" 
       name="image" 
       accept="image/jpeg,image/png,image/jpg">
       <div>Max 5MB</div>
                                    <!-- Emoji Badge on Image -->
                                    <div id="emoji-badge" class="position-absolute" 
                                         style="bottom: 10px; right: 20px; font-size: 24px; 
                                                background: white; border-radius: 50%; 
                                                padding: 8px; line-height: 1; cursor: pointer;
                                                box-shadow: 0 2px 4px rgba(0,0,0,0.1);"
                                         onclick="openEmojiPicker()">
                                        😊
                                    </div>
                                </div>
                                
                                <!-- Emoji Input (Hidden) -->
                                <input type="hidden" id="emoji" name="emoji" value="😊">
                            </div>
                            <!-- Password -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="password" name="password" type="password" maxlength="50"
                                           class="form-control shadow-none" placeholder="Password (Required)" required>
                                </div>
                            </div>

                            <!-- Date of Birth -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3 text-left">
                                    <input id="dob" name="dob" type="date" class="form-control shadow-none"
                                           placeholder="Date of Birth" max="{{ date('Y-m-d') }}">
                                </div>
                            </div>

                            <!-- Mobile Number -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="phn" name="phn" type="tel" maxlength="15" pattern="[0-9+\-\(\)\s]*"
                                           class="form-control shadow-none" placeholder="Mobile Number">
                                </div>
                            </div>

                            <!-- Gender -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="gender" name="gender" class="form-control" aria-label="Gender">
                                        <option selected disabled value="">--- Select Gender ---</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                            </div> -->

                            <!-- Marital Status -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="marital" name="marital" class="form-control"
                                            aria-label="Marital Status">
                                        <option selected disabled value="">--- Select Marital Status ---</option>
                                        <option value="Married">Married</option>
                                        <option value="Unmarried">Unmarried</option>
                                    </select>
                                </div>
                            </div> -->

                            <!-- Employee Status -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="status" name="status" class="form-control"
                                            aria-label="Status of Employee">
                                        <option selected disabled value="">--- Select Status of Employee ---</option>
                                        <option value="2">Active</option>
                                        <option value="1">Inactive</option>
                                        <option value="0">Pending</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to add Department -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="department" name="department" class="form-control"
                                            aria-label="Department"
                                            onchange="populateCategory({{ json_encode($department) }})">
                                        <option selected disabled>--- Select Department ---</option>
                                        <option value="{{$department->id}}">{{$department->name}}</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Role of Employee -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="role" name="role" class="form-control" aria-label="role" required>
                                        <option disabled>--- Select category ---</option>
                                        <option value="Admin">Admin</option>
                                        <option selected value="Employee">Employee</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Dropdown to Add Category -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="category" name="category" class="form-control" aria-label="category">
                                        <option selected disabled>--- Select category ---</option>
                                        <option value="">Unspecified</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Nationality -->
                            <!-- <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="nationality" name="nationality" type="text" maxlength="15"
                                           class="form-control shadow-none" placeholder="Nationality">
                                </div>
                            </div> -->

                            <!-- State -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="state" name="state" type="text" maxlength="15"
                                           class="form-control shadow-none" placeholder="State">
                                </div>
                            </div>

                            <!-- Zip Code -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="zip" name="zip" type="number" maxlength="15"
                                           class="form-control shadow-none" placeholder="Zip Code">
                                </div>
                            </div>

                            <!-- City -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="city" name="city" type="text" maxlength="30"
                                           class="form-control shadow-none" placeholder="City">
                                </div>
                            </div>

                            <!-- Address -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <textarea id="address" name="address" type="text" rows="3" maxlength="100"
                                              class="form-control shadow-none">Address</textarea>
                                    <small class="form-text" style="font-size: small;">Limit: 100 characters</small>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button type="button" id="cancelBtn" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel
                            </button>
                            <button type="submit" id="sub-btn"
                                    class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Emoji Assignment Modal -->
    <div class="modal fade" id="emojiAssignmentModal" tabindex="-1" aria-labelledby="emojiAssignmentModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="emojiAssignmentModalLabel">Assign Emoji/GIF to Employee</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <h6>Employee: <span id="employeeNameDisplay"></span></h6>
                    </div>
                    
                    <form id="emojiAssignmentForm">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="emojiSelect" class="form-label">Select Emoji/GIF</label>
                                <select class="form-control" id="emojiSelect" name="emoji_id" required>
                                    <option value="">Choose an emoji or GIF</option>
                                    @if(isset($availableEmojis) && $availableEmojis->count() > 0)
                                        @foreach($availableEmojis as $emoji)
                                            <option value="{{ $emoji->id }}" data-type="{{ $emoji->type }}" data-content="{{ $emoji->type === 'emoji' ? $emoji->emoji_text : $emoji->url }}">
                                                {{ $emoji->name }} ({{ ucfirst($emoji->type) }})
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="emojiMessage" class="form-label">Message (Optional)</label>
                                <input type="text" class="form-control" id="emojiMessage" name="emoji_message" placeholder="Enter a message with the emoji/GIF">
                            </div>
                        </div>
                        
                        <!-- Emoji Preview -->
                        <div id="emojiPreview" class="mt-3 text-center" style="display: none;">
                            <div class="border rounded p-3 bg-light">
                                <div id="previewContent" style="font-size: 2rem; min-height: 60px; display: flex; align-items: center; justify-content: center;"></div>
                                <small class="text-muted" id="previewName"></small>
                            </div>
                        </div>

                        <!-- Current Assignments Section -->
                        <div class="mt-4" id="currentEmojiAssignments" style="display: none;">
                            <h6 class="mb-3">
                                <i class="fas fa-list me-2"></i>Current Emoji/GIF Assignments
                            </h6>
                            <div id="currentAssignmentsList" class="row">
                                <!-- Current assignments will be loaded here -->
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" onclick="assignEmojiToEmployee()">Assign Emoji/GIF</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Emoji Picker Modal -->
    <div class="modal fade" id="emojiModal" tabindex="-1" aria-labelledby="emojiModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="emojiModalLabel">Choose Emoji</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="emoji-grid" style="display: grid; grid-template-columns: repeat(6, 1fr); gap: 10px; font-size: 24px; text-align: center;">
                        <span class="emoji-option" onclick="selectEmoji('😊')">😊</span>
                        <span class="emoji-option" onclick="selectEmoji('😎')">😎</span>
                        <span class="emoji-option" onclick="selectEmoji('🤓')">🤓</span>
                        <span class="emoji-option" onclick="selectEmoji('😄')">😄</span>
                        <span class="emoji-option" onclick="selectEmoji('🙂')">🙂</span>
                        <span class="emoji-option" onclick="selectEmoji('😇')">😇</span>
                        <span class="emoji-option" onclick="selectEmoji('🤗')">🤗</span>
                        <span class="emoji-option" onclick="selectEmoji('😃')">😃</span>
                        <span class="emoji-option" onclick="selectEmoji('😁')">😁</span>
                        <span class="emoji-option" onclick="selectEmoji('🤩')">🤩</span>
                        <span class="emoji-option" onclick="selectEmoji('🥳')">🥳</span>
                        <span class="emoji-option" onclick="selectEmoji('😌')">😌</span>
                        <span class="emoji-option" onclick="selectEmoji('🤠')">🤠</span>
                        <span class="emoji-option" onclick="selectEmoji('👨‍💻')">👨‍💻</span>
                        <span class="emoji-option" onclick="selectEmoji('👩‍💻')">👩‍💻</span>
                        <span class="emoji-option" onclick="selectEmoji('👨‍💼')">👨‍💼</span>
                        <span class="emoji-option" onclick="selectEmoji('👩‍💼')">👩‍💼</span>
                        <span class="emoji-option" onclick="selectEmoji('🚀')">🚀</span>
                        <span class="emoji-option" onclick="selectEmoji('⭐')">⭐</span>
                        <span class="emoji-option" onclick="selectEmoji('🎯')">🎯</span>
                        <span class="emoji-option" onclick="selectEmoji('💎')">💎</span>
                        <span class="emoji-option" onclick="selectEmoji('🔥')">🔥</span>
                        <span class="emoji-option" onclick="selectEmoji('⚡')">⚡</span>
                        <span class="emoji-option" onclick="selectEmoji('🌟')">🌟</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- ========================================= -->
@endsection
@section('custom-scripts')

    <script>
          function displaySelectedImage(input, imageId) {
        const maxSize = 5 * 1024 * 1024; // 5MB in bytes
        const file = input.files[0];
        
        if (file) {
            // Check file size
            if (file.size > maxSize) {
                Swal.fire({
                    icon: 'error',
                    title: 'File too large',
                    text: 'Please select an image smaller than 5MB'
                });
                input.value = ''; // Clear the input
                return;
            }
            
            // Check if it's an image
            if (!file.type.match('image.*')) {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid file type',
                    text: 'Please select an image file (JPEG, PNG, etc.)'
                });
                input.value = ''; // Clear the input
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                $('#' + imageId).attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
    }
        // Emoji Picker Functions
        function openEmojiPicker() {
            $('#emojiModal').modal('show');
        }

        function selectEmoji(emoji) {
            $('#emoji').val(emoji);
            $('#emoji-badge').text(emoji);
            $('#emojiModal').modal('hide');
        }

        // Add hover effect to emoji options
        $(document).ready(function() {
            $('.emoji-option').hover(
                function() {
                    $(this).css({
                        'background-color': '#f0f0f0',
                        'border-radius': '8px',
                        'cursor': 'pointer',
                        'transform': 'scale(1.2)'
                    });
                },
                function() {
                    $(this).css({
                        'background-color': 'transparent',
                        'transform': 'scale(1)'
                    });
                }
            );
        });

        //script to Populate Fields using Zip code
        $(document).ready(function () {
            let debounceTimeout;

            $('#zip').on('input', function () {
                clearTimeout(debounceTimeout); // Clear the previous timeout

                debounceTimeout = debounceTimeout = setTimeout(() => {

                    const zipCode = $(this).val().trim(); // Example ZIP code
                    const country = "US"; //Filter on the basis of Country
                    const searchUrl = `https://nominatim.openstreetmap.org/search?postalcode=${zipCode}&country=${country}&format=json`;

                    $.getJSON(searchUrl, function (data) {
                        if (data.length > 0) {
                            const lat = data[0].lat;
                            const lon = data[0].lon;

                            // Proceed to reverse geocode for detailed address
                            const reverseUrl = `https://nominatim.openstreetmap.org/reverse?lat=${lat}&lon=${lon}&format=json`;

                            $.getJSON(reverseUrl, function (reverseData) {
                                if (reverseData.address) {
                                    // Extract city, state, and address from the response
                                    const city = reverseData.address.city || reverseData.address.town || reverseData.address.village || "";
                                    const state = reverseData.address.state || "";
                                    const rawAddress = reverseData.display_name || "";

                                    // Function to trim redundant fields from the address
                                    function trimAddress(rawAddress, city, state) {
                                        // Convert raw address into an array of parts
                                        let addressParts = rawAddress.split(",").map(part => part.trim());

                                        // Filter out the city and state from the address parts
                                        addressParts = addressParts.filter(part => part !== city && part !== state);

                                        // Remove country if necessary (optional)
                                        addressParts = addressParts.filter(part => part !== "United States");

                                        // Join the remaining parts back into a single address string
                                        return addressParts.join(", ");
                                    }

                                    // Trim the raw address
                                    const trimmedAddress = trimAddress(rawAddress, city, state);

                                    // Populate the fields with the extracted and refined values
                                    $('#address').val(trimmedAddress);
                                    $('#city').val(city);
                                    $('#state').val(state);
                                } else {
                                    console.log("No detailed address found.");
                                }

                            }).fail(function () {
                                console.error("Failed to fetch reverse geocode data.");
                            });
                        } else {
                            console.log("No results found for the given ZIP code.");
                        }
                    }).fail(function () {
                        console.error("Failed to fetch search data.");
                    });
                }, 500);
            });
        });

        //Script to clear Modal everytime it is closed
        $('#addModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset(); // Resets all form inputs
            $(this).find('img').attr('src', "{{ asset('assets/img/placeholder-img-2.png') }}");
            $('#emoji-badge').text('😊'); // Reset emoji to default
            $('#emoji').val('😊'); // Reset hidden emoji input
            reading(false);
        });

        //Function to Populate Form
        function populateForm(employee, read) {
            // Reset the form
            $('form')[0].reset();
            // Populate the input fields with employee data
            $('#employee_id').val(employee.employee_id);
            $('#name').val(employee.name);
            $('#email').val(employee.email);
            $('#password').removeAttr('required');
            $('#status').val(employee.status);
            $('#addimage').attr('src', employee.image ? '{{ asset('') }}' + employee.image : '{{ asset('assets/img/placeholder-img-2.png') }}');
            $('#dob').val(employee.dob);
            $('#phn').val(employee.phn);
            $('#gender').val(employee.gender);
            $('#marital').val(employee.marital);
            $('#nationality').val(employee.nationality);
            $('#city').val(employee.city);
            $('#state').val(employee.state);
            $('#zip').val(employee.zip);
            $('#address').val(employee.address);
            $('#department').val(employee.department_id).trigger('change');
            $('#role').val(employee.role);
            
            // Handle emoji
            if (employee.emoji) {
                $('#emoji').val(employee.emoji);
                $('#emoji-badge').text(employee.emoji);
            } else {
                $('#emoji').val('😊');
                $('#emoji-badge').text('😊');
            }

            if (employee.role === 'Manager') {
                $('#category').val("").prop('disabled', true); // Disable interaction
            } else {
                $('#category').val(employee.category).prop('disabled', false);
            }
            reading(read); // Set the form to Readonly
        }

        //Function to set the Modal to Readonly
        function reading(read) {
            $('#addModal input').prop('readonly', read);
            $('#addModal select, #addModal textarea').css('pointer-events', read ? 'none' : 'auto');
            $('#addModal img').css('pointer-events', read ? 'none' : 'auto');
            $('#emoji-badge').css('pointer-events', read ? 'none' : 'auto'); // Disable emoji picker in read mode
            
            if(read)
            {
                $('#sub-btn').addClass('d-none');
                $('#cancelBtn').html('Okay').addClass('btn-primary').removeClass('btn-primary-white');
            }
            else
            {
                $('#sub-btn').removeClass('d-none');
                $('#cancelBtn').html('Cancel').removeClass('btn-primary').addClass('btn-primary-white');
            }
        }

        //Generates Employee ID
        function e_id() {
            //Employee-ID Auto Generate
            var timestamp = Date.now().toString();
            var randomNum = Math.floor(Math.random() * (999 - 100 + 1)) + 100;
            var empid = (timestamp + randomNum).slice(-9); // Take the last 7-9 digits
            $('#employee_id').val(empid);
            
            // Reset emoji to default when creating new employee
            $('#emoji').val('😊');
            $('#emoji-badge').text('😊');
        }

        // Function to Populate Category
        function populateCategory(department) {
            cate = JSON.parse(department.categories);
            $('#category').empty();
            $('#category').append('<option selected disabled >--- Select Category ---</option>')
            for (let i = 0; i < cate.length; i++) {
                $('#category').append('<option value="' + cate[i] + '">' + cate[i] + '</option>');
            }
        }

        //AJAX to Add/Update  Employee
        $('#addModal').on("submit", function (e) {
            e.preventDefault()

            var form = $('#addForm')[0];
            var formdata = new FormData(form);
            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('m.manager.add') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 100);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#sub-btn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#sub-btn').html('Submit').prop('disabled', false);
                }

            });
        });

        //Function and AJAX to Delete Employee
        function deleteEmployee(id, element) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route('m.manager.delete') }}',
                        data: {
                            id: id,
                            _token: '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function (res) {
                            if (res.Error === false) {
                                element.parent().parent().remove();
                                Swal.fire({ // Swirl Success MSG
                                    title: "Deleted!",
                                    text: res.Message,
                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                                    imageWidth: 100,
                                    imageHeight: 100,
                                    imageAlt: "Party Image"
                                });
                            } else {
                                swirlmsg(res.Message);
                            }
                        },
                        error: function (e) {
                            let first_error = 'An unknown error occurred.';
                            if (e.responseJSON && e.responseJSON.errors) {
                                first_error = Object.values(e.responseJSON.errors)[0][0];
                            }
                            swirlmsg(first_error);
                        }
                    });
                }
            })
        }

        // Emoji Assignment Functions
        let currentEmployeeId = null;

        function openEmojiAssignmentModal(employeeId, employeeName) {
            currentEmployeeId = employeeId;
            $('#employeeNameDisplay').text(employeeName);
            $('#emojiSelect').val('');
            $('#emojiMessage').val('');
            $('#emojiPreview').hide();
            $('#currentEmojiAssignments').hide();
            
            // Fetch current assignments for this employee
            fetchEmployeeEmojiAssignments(employeeId);
        }

        function fetchEmployeeEmojiAssignments(employeeId) {
            $.ajax({
                url: '/manager/employee/emoji-assignments/' + employeeId,
                method: 'GET',
                success: function(response) {
                    if (response.success) {
                        displayCurrentAssignments(response.assignments);
                    } else {
                        $('#currentEmojiAssignments').hide();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching emoji assignments:', error);
                    $('#currentEmojiAssignments').hide();
                }
            });
        }

        function displayCurrentAssignments(assignments) {
            const container = $('#currentAssignmentsList');
            const section = $('#currentEmojiAssignments');
            
            if (assignments.length === 0) {
                container.html('<div class="col-12"><p class="text-muted">No emojis/GIFs assigned yet</p></div>');
                section.show();
                return;
            }

            let html = '';
            assignments.forEach(function(assignment) {
                const emoji = assignment.emoji;
                const content = emoji.type === 'emoji' ? emoji.emoji_text : `<img src="${emoji.file_path}" alt="${emoji.name}" style="height: 30px; width: 30px; object-fit: cover;">`;
                
                html += `
                    <div class="col-md-4 mb-3">
                        <div class="card border-0 shadow-sm">
                            <div class="card-body text-center p-2">
                                <div class="mb-2" style="min-height: 40px; display: flex; align-items: center; justify-content: center;">
                                    ${emoji.type === 'emoji' ? `<span style="font-size: 1.5rem;">${content}</span>` : content}
                                </div>
                                <h6 class="card-title mb-1 small">${emoji.name}</h6>
                                ${assignment.message ? `<p class="card-text text-muted small mb-1">${assignment.message}</p>` : ''}
                                <small class="text-muted">${new Date(assignment.created_at).toLocaleDateString()}</small>
                                <div class="mt-2">
                                    <button class="btn btn-sm btn-outline-danger" onclick="removeEmojiAssignment(${assignment.id})">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
            });
            
            container.html(html);
            section.show();
        }

        function assignEmojiToEmployee() {
            const emojiId = $('#emojiSelect').val();
            const message = $('#emojiMessage').val();

            if (!emojiId) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please select an emoji or GIF'
                });
                return;
            }

            $.ajax({
                url: '/manager/employee/assign-emoji',
                method: 'POST',
                data: {
                    employee_id: currentEmployeeId,
                    emoji_id: emojiId,
                    message: message,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message
                        });
                        
                        // Close modal
                        $('#emojiAssignmentModal').modal('hide');
                        
                        // Refresh the page to show updated assignments
                        location.reload();
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: response.message
                        });
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Failed to assign emoji/GIF'
                    });
                }
            });
        }

        function removeEmojiAssignment(assignmentId) {
            Swal.fire({
                title: 'Are you sure?',
                text: "This will remove the emoji assignment from the employee",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, remove it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '/manager/employee/remove-emoji-assignment',
                        method: 'POST',
                        data: {
                            assignment_id: assignmentId,
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Removed!',
                                    text: response.message
                                });
                                
                                // Refresh current assignments
                                fetchEmployeeEmojiAssignments(currentEmployeeId);
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: response.message
                                });
                            }
                        },
                        error: function(xhr, status, error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: 'Failed to remove emoji assignment'
                            });
                        }
                    });
                }
            });
        }

        // Emoji preview functionality
        $(document).ready(function() {
            $('#emojiSelect').on('change', function() {
                const selectedOption = $(this).find('option:selected');
                const type = selectedOption.data('type');
                const content = selectedOption.data('content');
                const name = selectedOption.text();

                if (type && content) {
                    const previewContent = $('#previewContent');
                    const previewName = $('#previewName');

                    if (type === 'emoji') {
                        previewContent.html(`<span style="font-size: 2rem;">${content}</span>`);
                    } else {
                        previewContent.html(`<img src="${content}" alt="${name}" style="max-height: 60px;">`);
                    }

                    previewName.text(name);
                    $('#emojiPreview').show();
                } else {
                    $('#emojiPreview').hide();
                }
            });
        });

    </script>

@endsection