@extends('Manager.layout')
@section('title',"Manager")
@section('page-name',"Dashboard")
@section('page-detail',"Welcome Back!")
@section('pagelink', 'dashboard')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card ">
            <div class="card-body">
                <!-- Assigned Emojis/GIFs Section -->
                @if(isset($assignedEmojis) && $assignedEmojis->count() > 0)
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="border rounded-3 p-4 bg-primary bg-opacity-10">
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    <i class="fas fa-gift text-primary" style="font-size: 1.5rem;"></i>
                                </div>
                                <div>
                                    <h5 class="mb-1 text-primary">Your Assigned Emojis & GIFs</h5>
                                    <small class="text-muted">Special emojis and GIFs assigned to you</small>
                                </div>
                            </div>
                            <div class="row">
                                @foreach($assignedEmojis as $assignment)
                                    <div class="col-md-4 col-sm-6 mb-3">
                                        <div class="card border-0 shadow-sm">
                                            <div class="card-body text-center p-3">
                                                <div class="mb-2" style="min-height: 60px; display: flex; align-items: center; justify-content: center;">
                                                    @if($assignment->emoji->type === 'emoji')
                                                        <span style="font-size: 2.5rem;">{{ $assignment->emoji->emoji_text }}</span>
                                                    @else
                                                        <img src="{{ asset($assignment->emoji->file_path) }}" 
                                                             alt="{{ $assignment->emoji->name }}" 
                                                             style="max-height: 60px; max-width: 100%;">
                                                    @endif
                                                </div>
                                                <h6 class="card-title mb-1">{{ $assignment->emoji->name }}</h6>
                                                @if($assignment->message)
                                                    <p class="card-text text-muted small mb-0">{{ $assignment->message }}</p>
                                                @endif
                                                <small class="text-muted">{{ $assignment->created_at->format('M d, Y') }}</small>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                @endif

           <!-- Targets Progress on DashBoard -->
                <div class="row">
                    <div class="col-12">
                        <div class="border rounded-3 p-3">
                            @if($targets->isEmpty())
                                <h4> No Targets Assigned Yet! </h4>
                            @else
                                <!--------- Start Loop ------------>
                            @php
                                $categories = json_decode($departments->categories);
                            @endphp
                                @foreach($categories as $category)
                                    @if($targets->firstWhere('category', $category))
                                        <div class="row mt-4">
                                            <div class="col-md-6 mt-auto">
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <h4> Category :  {{ $category ?? 'N/A' }} </h4>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="table-responsive">
                                                    <table class="table">
                                                        <thead>
                                                        <tr>
                                                            <th scope="col">Target/Product</th>
                                                            <th scope="col">Progress</th>
                                                            <th scope="col">Last Date</th>
                                                            <th scope="col">Completion Date</th>
                                                            <th scope="col">Status</th>
                                                        </tr>
                                                        </thead>
                                                        @foreach($targets as $target)
                                                            @if($target->category == $category)
                                                                <tbody>
                                                                <tr>
                                                                    @if($target->product_id)
                                                                        <td class="align-middle">{{ $products->firstWhere('id', $target->product_id)->name }}</td>
                                                                    @else
                                                                        <td class="align-middle">{{ Str::limit($target->custom ?? 'No Custom', 50) }}</td>

                                                                    @endif
                                                                    <td>
                                                                        @php
                                                                            $percent = calculatePercentage($target->progress, $target->quantity);
                                                                            if($percent['value'] > '100')
                                                                                {
                                                                                    $percent['value'] = '100';
                                                                                }
                                                                        @endphp
                                                                        <h5 class="mb-2">{{$percent['value']}}% <span
                                                                                class="ms-4 p-light">{{$percent['status']}}</span></h5>
                                                                        <div class="progress mb-3" style="height: 6px;">
                                                                            <div class="progress-bar" role="progressbar"
                                                                                 style="width: {{$percent['value']}}%; background-color: #6EA0F9;"
                                                                                 aria-valuenow="{{$percent['value']}}" aria-valuemin="0"
                                                                                 aria-valuemax="100">
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                    <td class="align-middle">{{ \Carbon\Carbon::parse($target->last_date)->format('m-d-y') }}</td>
                                                                    <td class="align-middle">
                                                                        {{ $target->completion_date ? \Carbon\Carbon::parse($target->completion_date)->format('m-d-y') : 'Pending' }}
                                                                    </td>

                                                                    <td class="align-middle">
                                                                        @if($target->status === '2')
                                                                            <a href="#" class="btn btn-active">Active</a>
                                                                        @elseif($target->status === '1')
                                                                            <a href="#" class="btn btn-inactive">Inactive</a>
                                                                        @else
                                                                            <a href="#" class="btn btn-pending">Pending</a>
                                                                        @endif
                                                                    </td>

                                                                </tr>
                                                                </tbody>
                                                            @endif
                                                        @endforeach
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                                <!--------- End Loop ------------>
                            @endif

                        </div>
                    </div>
                </div>

           <!-- Claimed Points on DashBoard -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="border rounded-3 p-3">
                            @if($points->isEmpty())
                                <h4>No Claimed Points to Show</h4>
                            @else
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">Category</th>
                                            <th scope="col">VIN#</th>
                                            <th scope="col">Target/Product</th>
                                            <th scope="col">Points</th>
                                            <th scope="col">Claimed Date</th>
                                            <th scope="col">Status</th>
                                        </tr>
                                        </thead>
                                        @foreach($points as $point)
                                            <tbody>
                                            <tr>
                                                <td class="align-middle">{{ $point->category }}</td>
                                                <td class="align-middle">{{ $point->vin_no }}</td>

                                                @if($point->custom == null)
                                                    <td class="align-middle">{{ $point->name }}</td>
                                                @else
                                                    <td class="align-middle">{{ Str::limit($point->custom, 50) }}</td>
                                                @endif

                                                <td class="align-middle justify-content-center">{{ $point->points }}</td>
                                                <td class="align-middle">{{ \Carbon\Carbon::parse($point->created_at)->format('m-d-y') }}</td>
                                                <td class="align-middle">
                                                    @if($point->status === 'Redeemed')
                                                        <a href="#" class="btn btn-active">Redeemed</a>
                                                    @elseif($point->status === 'Rejected')
                                                        <a href="#" class="btn btn-inactive">Rejected</a>
                                                    @else
                                                        <a href="#" class="btn btn-pending">Pending</a>
                                                    @endif
                                                </td>
                                            </tr>
                                            </tbody>
                                        @endforeach
                                    </table>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
