@extends('chat.layout')
@section('title',"VIN Decoder")
@section('page-name',"VIN Decoder")
@section('page-detail',"Decode Vehicle Information from VIN Number")
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    
                    <!-- VIN Input Form -->
                    <div class="row mb-4">
                        <div class="col-md-8 mx-auto">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0"><i class="fas fa-car me-2"></i>VIN Number Decoder</h5>
                                </div>

                       
                                <div class="card-body">
                                    <form action="{{ route('empVin.decode') }}" method="POST">
                                        @csrf
                                        <div class="mb-3">
                                            <label for="vin_number" class="form-label">Enter VIN Number</label>
                                            <div class="input-group">
                                                <span class="input-group-text">
                                                    <i class="fas fa-search"></i>
                                                </span>
                                                <input type="text" 
                                                       class="form-control @error('vin_number') is-invalid @enderror" 
                                                       id="vin_number" 
                                                       name="vin_number" 
                                                       placeholder="Enter 17-digit VIN number (e.g., 2C3CDZJG9PH629770)"
                                                       value="{{ old('vin_number') }}"
                                                       maxlength="17"
                                                       style="text-transform: uppercase;">
                                                @error('vin_number')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                            <small class="form-text text-muted">
                                                VIN must be exactly 17 characters long and contain only letters and numbers.
                                            </small>
                                        </div>
                                        <button type="submit" class="btn btn-primary w-100">
                                            <i class="fas fa-decode me-2"></i>Decode VIN
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Error Messages -->
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
 <!-- Recall Information Section -->
                        @if(isset($recallData) && $recallData)
                            <div class="card mt-4">
                                <!-- <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">
                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                        Recall Information
                                        @if(isset($make) && isset($model) && isset($modelYear))
                                            <small class="ms-2">({{ $modelYear }} {{ $make }} {{ $model }})</small>
                                        @endif
                                    </h5>
                                </div> -->
                                <div class="card-body">
                                    @if(isset($recallData['results']) && count($recallData['results']) > 0)
                                        <div class="alert alert-warning" role="alert">
                                            <i class="fas fa-exclamation-triangle me-2"></i>
                                            <strong>{{ count($recallData['results']) }} recall(s) found for this vehicle.</strong>
                                        </div>
                                        
                                          @else
                                        <div class="alert alert-success" role="alert">
                                            <i class="fas fa-check-circle me-2"></i>
                                            <strong>No recalls found for this vehicle.</strong>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @elseif(isset($make) && isset($model) && isset($modelYear))
                            <div class="card mt-4">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        Recall Information
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="alert alert-info" role="alert">
                                        <i class="fas fa-info-circle me-2"></i>
                                        Unable to retrieve recall information at this time. Please try again later.
                                    </div>
                                </div>
                            </div>
                        @endif
                    <!-- Success Results -->
                    @if(isset($success) && $success && isset($vinData))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            VIN successfully decoded for: <strong>{{ $vinNumber }}</strong>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>

                        <div class="card">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Vehicle Information</h5>
                            </div>
                            <div class="card-body">
                                @if(isset($vinData['Results']) && count($vinData['Results']) > 0)
                                    <div class="row">
                                        @foreach($vinData['Results'] as $result)
                                            @if(!empty($result['Value']) && 
                                                $result['Value'] !== 'Not Applicable' && 
                                                $result['Value'] !== '' &&
                                                !empty($result['Variable']) &&
                                                $result['Variable'] !== ''&&
                                                $result['Variable'] !== 'Error Text' &&
                                                $result['Variable'] !== 'Vehicle Descriptor'
                                                )
                                                <div class="col-md-6 mb-3">
                                                    <div class="info-item p-3 border rounded">
                                                        <strong class="text-primary">{{ $result['Variable'] }}:</strong>
                                                        <br>
                                                        <span class="text-dark">{{ $result['Value'] }}</span>
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                @else
                                    <div class="alert alert-warning" role="alert">
                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                        No vehicle information found for this VIN number.
                                    </div>
                                @endif

                                <!-- Raw API Response (Collapsible) -->
                                <!-- <div class="mt-4">
                                    <button class="btn btn-outline-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#rawResponse" aria-expanded="false" aria-controls="rawResponse">
                                        <i class="fas fa-code me-2"></i>View Raw API Response
                                    </button>
                                    <div class="collapse mt-3" id="rawResponse">
                                        <pre class="bg-light p-3 rounded"><code>{{ json_encode($vinData, JSON_PRETTY_PRINT) }}</code></pre>
                                    </div>
                                </div> -->
                            </div>
                        </div>
                    @endif

                    @if(!isset($success))
                        <!-- Information Card -->
                        <div class="card">
                            <div class="card-body text-center">
                                <i class="fas fa-car fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">Enter a VIN number above to decode vehicle information</h5>
                                <p class="text-muted">
                                    The Vehicle Identification Number (VIN) is a unique 17-character code that provides 
                                    detailed information about your vehicle including make, model, year, and specifications.
                                </p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

@endsection

@section('custom-scripts')

<style>
    .info-item {
        background-color: #f8f9fa;
        transition: all 0.3s ease;
    }

    .info-item:hover {
        background-color: #e9ecef;
        transform: translateY(-2px);
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    .card {
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }

    .card-header {
        border-bottom: 2px solid rgba(255,255,255,0.2);
    }

    #vin_number {
        font-family: 'Courier New', monospace;
        font-size: 1.1rem;
        letter-spacing: 1px;
    }

    pre code {
        font-size: 0.875rem;
        max-height: 400px;
        overflow-y: auto;
    }

    .btn-primary {
        background: linear-gradient(45deg, #007bff, #0056b3);
        border: none;
        padding: 0.75rem 1.5rem;
        font-weight: 600;
    }

    .btn-primary:hover {
        background: linear-gradient(45deg, #0056b3, #004085);
        transform: translateY(-1px);
    }

    .alert {
        border-left: 4px solid;
    }

    .alert-success {
        border-left-color: #28a745;
    }

    .alert-danger {
        border-left-color: #dc3545;
    }

    .alert-warning {
        border-left-color: #ffc107;
    }

    .accordion-button {
        background-color: #f8f9fa;
        border: none;
        box-shadow: none;
    }

    .accordion-button:not(.collapsed) {
        background-color: #fff3cd;
        color: #856404;
    }

    .accordion-button:focus {
        border-color: transparent;
        box-shadow: none;
    }

    .accordion-item {
        border: 1px solid #dee2e6;
        margin-bottom: 0.5rem;
    }

    .accordion-body {
        background-color: #fff;
    }

    .recall-summary {
        background-color: #fff3cd;
        border-left: 4px solid #ffc107;
        padding: 1rem;
        margin-bottom: 1rem;
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-uppercase VIN input
    const vinInput = document.getElementById('vin_number');
    if (vinInput) {
        vinInput.addEventListener('input', function() {
            this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
        });

        // Add character counter
        const charCounter = document.createElement('small');
        charCounter.className = 'form-text text-muted mt-1';
        charCounter.id = 'char-counter';
        vinInput.parentNode.appendChild(charCounter);

        function updateCharCounter() {
            const length = vinInput.value.length;
            charCounter.textContent = `${length}/17 characters`;
            charCounter.className = length === 17 ? 'form-text text-success mt-1' : 'form-text text-muted mt-1';
        }

        vinInput.addEventListener('input', updateCharCounter);
        updateCharCounter(); // Initialize counter

        // Validate VIN format on blur
        vinInput.addEventListener('blur', function() {
            const vin = this.value;
            const vinPattern = /^[A-HJ-NPR-Z0-9]{17}$/;
            
            if (vin.length === 17 && !vinPattern.test(vin)) {
                this.classList.add('is-invalid');
                let feedback = this.parentNode.querySelector('.invalid-feedback');
                if (!feedback) {
                    feedback = document.createElement('div');
                    feedback.className = 'invalid-feedback';
                    this.parentNode.appendChild(feedback);
                }
                feedback.textContent = 'Invalid VIN format. VIN cannot contain I, O, or Q.';
            } else {
                this.classList.remove('is-invalid');
                const feedback = this.parentNode.querySelector('.invalid-feedback');
                if (feedback && feedback.textContent.includes('Invalid VIN format')) {
                    feedback.remove();
                }
            }
        });
    }

    // Add loading state to form submission
    const form = document.querySelector('form');
    if (form) {
        form.addEventListener('submit', function() {
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Decoding...';
            submitBtn.disabled = true;

            // Re-enable button after 10 seconds (in case of network issues)
            setTimeout(() => {
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            }, 10000);
        });
    }
});
</script>

@endsection