@extends('chat.layout')
@section('title',"Videos")
@section('page-name',"Videos")
@section('page-detail',"All Videos Information")
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row mb-4">
                        <div class="col-md-5 col-lg-4">
                            <form class="serch">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i>
                                    </span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search videos"
                                           aria-label="serch" aria-describedby="basic-addon1">
                                </div>
                            </form>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <!-- <div class="d-flex justify-content-end">
                                <a href="#" class="btn btn-primary px-3 me-2" data-bs-toggle="modal"
                                   data-bs-target="#videoModal"
                                   data-bs-whatever="@getbootstrap"><i class="fas fa-plus-circle text-white me-3"></i> Add New Video</a>
                            </div> -->
                        </div>
                    </div>
                    
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if($videos->isEmpty())
                        <h4>No Videos Added Yet!</h4>
                    @else
                        <div class="row g-4" id="videoGallery">
                            @foreach($videos as $video)
                                <div class="col-12 col-sm-6 col-md-4 col-lg-3 video-item">
                                    <div class="card h-100 shadow-sm video-card">
                                        <div class="video-thumbnail-container position-relative">
                                            <img src="{{ $video->thumbnail_url }}" 
                                                 alt="{{ $video->title }}"
                                                 class="card-img-top video-thumbnail">
                                            <div class="video-overlay">
                                                <a href="{{ $video->youtube_url }}" target="_blank" class="play-button">
                                                    <i class="fas fa-play-circle"></i>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="card-body d-flex flex-column">
                                            <h6 class="card-title mb-2" title="{{ $video->title }}">
                                                {{ Str::limit($video->title, 40) }}
                                            </h6>
                                            <p class="card-text small text-muted mb-2">
                                                {{ Str::limit($video->description, 50) }}
                                            </p>
                                            <div class="mt-auto">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <span class="channel-name small text-primary">
                                                        <i class="fas fa-tv me-1"></i>{{ Str::limit($video->channel_name, 20) }}
                                                    </span>
                                                    <span class="video-date small text-muted">
                                                        {{ $video->created_at->format('M d, Y') }}
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        <div class="mt-4">
                            {{ $videos->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

@endsection

@section('custom-scripts')

<style>
    /* Video Gallery Styles */
    .video-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border: 1px solid #e3e6f0;
        overflow: hidden;
    }
    
    .video-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.15);
    }
    
    .video-thumbnail-container {
        position: relative;
        overflow: hidden;
        padding-top: 56.25%; /* 16:9 Aspect Ratio */
    }
    
    .video-thumbnail {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }
    
    .video-card:hover .video-thumbnail {
        transform: scale(1.05);
    }
    
    .video-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.6);
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        transition: opacity 0.3s ease;
    }
    
    .video-card:hover .video-overlay {
        opacity: 1;
    }
    
    .play-button {
        color: white;
        font-size: 3rem;
        transition: transform 0.3s ease;
    }
    
    .play-button:hover {
        transform: scale(1.2);
        color: #ff0000;
    }
    
    .card-title {
        font-weight: 600;
        line-height: 1.4;
        color: #2c3e50;
    }
    
    .channel-name {
        font-weight: 500;
    }
    
    .video-date {
        font-size: 0.75rem;
    }
    
    /* Existing Styles */
    .btn-active {
        background-color: #28a745;
        color: white;
        border: none;
        padding: 0.25rem 0.75rem;
        border-radius: 0.25rem;
        font-size: 0.875rem;
    }
    
    .btn-inactive {
        background-color: #dc3545;
        color: white;
        border: none;
        padding: 0.25rem 0.75rem;
        border-radius: 0.25rem;
        font-size: 0.875rem;
    }
    
    .btn-primary-white {
        background-color: white;
        color: #007bff;
        border: 1px solid #007bff;
    }
    
    .btn-primary-white:hover {
        background-color: #f8f9fa;
        color: #0056b3;
        border-color: #0056b3;
    }
    
    .border-radious-20 {
        border-radius: 20px;
    }
    
    .content-are-dashboard .card {
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    
    .search-icon {
        color: #6c757d;
    }
    
    /* Responsive adjustments */
    @media (max-width: 576px) {
        .video-card .card-title {
            font-size: 0.9rem;
        }
        
        .play-button {
            font-size: 2.5rem;
        }
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Search functionality
    const searchInput = document.getElementById('searchInput');
    const videoItems = document.querySelectorAll('.video-item');
    
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            
            videoItems.forEach(function(item) {
                const title = item.querySelector('.card-title').textContent.toLowerCase();
                const channel = item.querySelector('.channel-name').textContent.toLowerCase();
                const description = item.querySelector('.card-text').textContent.toLowerCase();
                
                if (title.includes(searchTerm) || channel.includes(searchTerm) || description.includes(searchTerm)) {
                    item.style.display = '';
                } else {
                    item.style.display = 'none';
                }
            });
        });
    }
});
</script>

@endsection