@extends('Employee.layout')
@section('title',"Claim Points")
@section('page-name',"Employee Point")
@section('page-detail',"All Points Information")
{{--@section('pagelink', 'dashboard')--}}
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
{{--                    <div>--}}
{{--                        <div class="d-flex justify-content-end">--}}
{{--                            <a href="#" class="btn btn-primary w-auto-fix" data-bs-toggle="modal"--}}
{{--                               data-bs-target="#addModal" data-bs-whatever="@getbootstrap"> <!-- onclick="populateTarget()" > -->--}}
{{--                                <i class="fas fa-pen me-2"></i>Claim Points</a>--}}
{{--                        </div>--}}
{{--                    </div>--}}

                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <div class="serch">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i></span>
                                    <input id="searchInput" type="text" class="form-control shadow-none" placeholder="Search"
                                           aria-label="serch" aria-describedby="basic-addon1">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <a href="#" class="btn btn-primary w-auto-fix" data-bs-toggle="modal"
                                   data-bs-target="#addModal" data-bs-whatever="@getbootstrap"> <!-- onclick="populateTarget()" > -->
                                    <i class="fas fa-plus-circle me-3"></i>Claim Points
                                </a>
                            </div>
                        </div>
                    </div>

                    <hr>

                    @if($points->isEmpty())
                        <h4> No Points Yet! </h4>
                    @else
                        <!--------- Start Loop ------------>
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="entryTable" class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">VIN#</th>
                                            <th scope="col">Target/Product</th>
                                            <th scope="col">Points</th>
                                            <th scope="col">Claimed Date</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Detail</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                      @foreach($points as $point)
    @php
        $target = $targets->firstWhere('id', $point->target_id);
    @endphp
    
    {{-- Skip this row if target doesn't exist or product_id is null --}}
    @if(!$target || !$target->product_id)
        @continue
    @endif
    
    <tr>
        <td class="align-middle">{{ $point->vin_no }}</td>

        @php
            $prod = $target->product_id;
            $product = $products->firstWhere('id', $prod);
            $name = $product ? $product->name : 'Product Not Found';
        @endphp
        <td class="align-middle">{{ $name }}</td>

        <td class="align-middle justify-content-center">{{ $point->points }}</td>
        <td class="align-middle">{{ \Carbon\Carbon::parse($point->created_at)->format('m-d-y') }}</td>
        <td class="align-middle">
            @if($point->status === 'Redeemed')
                <a href="#" class="btn btn-active">Redeemed</a>
            @elseif($point->status === 'Rejected')
                <a href="#" class="btn btn-inactive">Rejected</a>
            @else
                <a href="#" class="btn btn-pending">Pending</a>
            @endif
        </td>

        <td>
            @if($point->status === 'Rejected')
                <button type="button" class="btn btn-primary-white"
                        style="height: 35px"
                        data-detail="{{ $point->detail }}"
                        onclick="viewReason(this)"
                        data-bs-toggle="modal"
                        data-bs-target="#rejectModal"
                        data-bs-whatever="@getbootstrap">
                    See Details
                </button>
            @else
                N/A
            @endif
        </td>
    </tr>
@endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <!--------- End Loop ------------>
                    @endif

                </div>
            </div>
        </div>
    </div>

<!--------- Start Modal ------------>

    <!--------- Claim Points Modal ------------>
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Claim Points</h4>
                    <hr>
                    <form id="pointsForm">
                        @csrf
                        <div class="row">

                            <input type="hidden" name="employee_id" value="{{$employee['employee_id']}}">

                            <!-- Employee Name -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="employee_id" class="form-control shadow-none"
                                           value="{{$employee['name']}}" readonly required>
                                </div>
                            </div>

                            <!-- Vehicle Number -->
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="vin_no" name="vin_no" type="text"
                                           class="form-control shadow-none" value="" placeholder="Enter VIN#" required>
                                </div>
                            </div>

                            <!-- Dropdown to Select Target -->
                            <div class="col-md-6" id="divTarget">
                                <div class="mb-md-4 mb-3">
                                    <select id="selectTarget" name="target_id[]" class="form-control duplicated-div" aria-label="Product" required>
                                        <option selected disabled value="">--- Select Target ---</option>
                                        @foreach($targets as $target)
                                            @if($target->status == '2')
                                                @if($target->product_id)
                                                    @php
                                                        $name = $products->firstWhere('id', $target->product_id)->name;
                                                    @endphp
                                                    <option value="{{$target->id}}">{{$name}}</option>
                                                @else
                                                    <option value="{{$target->id}}">{{$target->custom}}</option>
                                                @endif
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>


                            <!-- Add More Button -->
                            <div class="col-md-6 " id="addMoreBtn">
                                <div class="mb-md-4 mb-3">
                                    <button type="button" class="btn btn-primary mb-3 px-5"
                                    onclick="addMore()">Add More</button>
                                </div>
                            </div>


                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Cancel
                                </button>

                                <button type="submit" id="sub-btn"
                                        class="btn btn-primary shadow-none mb-3 px-5 ms-md-3">Submit
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal For Reject Points -->
    <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Reject Reason</h4>
                    <hr>
                    <form>
                        <div class="row">
                            <input type="hidden" id="targetID" name="id" value="">

                            <!-- Reject Reason -->
                            <div class="mb-md-4 mb-3">
                                <textarea id="detail" name="details" rows="5" class="form-control shadow-none"
                                          style="height: 100px" maxlength="250"
                                          placeholder="Enter Reason of Rejection" readonly></textarea>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary shadow-none mb-3 px-5"
                                        data-bs-dismiss="modal" aria-label="Close">Back</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<!--------- End Modal ------------>

@endsection

@section('custom-scripts')
    <script>

        let selectedOptions = new Set(); // To keep track of selected options globally

        // Function to handle dropdown changes
        function updateDropdowns() {
            // Get all dropdowns with the 'duplicated-div' class
            const allDropdowns = $('.duplicated-div');

            // Loop through each dropdown and update its options
            allDropdowns.each(function () {
                const currentDropdown = $(this);
                const currentValue = currentDropdown.val(); // Preserve current value

                // Save the dropdown's original options
                const originalOptions = currentDropdown.data('originalOptions') || currentDropdown.html();

                // Update the dropdown options to exclude selected options
                currentDropdown.html(originalOptions); // Reset to original options
                selectedOptions.forEach(selectedValue => {
                    if (selectedValue !== currentValue) {
                        currentDropdown.find(`option[value="${selectedValue}"]`).remove();
                    }
                });

                // Preserve the current value if still valid
                if (currentValue) {
                    currentDropdown.val(currentValue);
                }
            });
        }

        // Function for Add More
        function addMore() {
            const newDropdown = $('#divTarget').clone();
            const newSelect = newDropdown.find('#selectTarget');

            newSelect.val(''); // Reset the new dropdown's value
            newSelect.addClass('dup-div');

            // Save the original options in the new dropdown
            if (!newSelect.data('originalOptions')) {
                newSelect.data('originalOptions', newSelect.html());
            }

            // Add a change event listener for the new dropdown
            newSelect.on('change', function () {
                const value = $(this).val();
                if (value) {
                    selectedOptions.add(value); // Add selected value to the set
                }
                updateDropdowns(); // Update all dropdowns
            });

            $('#addMoreBtn').after(newDropdown);

            // Update the new dropdown options
            updateDropdowns();
        }

        // Initialize the first dropdown's event listener
        $(document).on('change', '#selectTarget', function () {
            const value = $(this).val();
            if (value) {
                selectedOptions.add(value); // Add selected value to the set
            }
            updateDropdowns(); // Update all dropdowns
        });

        //Script to clear Modal everytime it is closed
        $('#addModal').on('hidden.bs.modal', function () {
            selectedOptions.clear();
            $(this).find('form')[0].reset();
            $(this).find('.dup-div').remove();

            // Reset the dropdown to its original options
            const divTarget = $(this).find('#divTarget');
            const originalDropdown = divTarget.find('select');

            // Restore original options if they were stored
            const originalOptions = originalDropdown.data('originalOptions');
            if (originalOptions) {
                originalDropdown.html(originalOptions); // Restore dropdown options
            }
            // Clear any value selection in the remaining dropdown
            originalDropdown.val('');
        });

        //Script to Store Original Data on Show of Modal
        $('#addModal').on('show.bs.modal', function () {
            const dropdown = $(this).find('#divTarget select');
            if (!dropdown.data('originalOptions')) {
                dropdown.data('originalOptions', dropdown.html()); // Store original options
            }
        });

        //Script to clear Modal everytime it is closed
        $('#rejectModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset();
        });

        //Function View Reason
        function viewReason(button) {
            // Get the detail value from the data attribute
            const detail = button.getAttribute('data-detail');
            $('#detail').val(detail);
        }

        //AJAX to Add Points
        $('#addModal').on("submit", function (e) {
            e.preventDefault()
            var form = $('#pointsForm')[0];
            var formdata = new FormData(form);
            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
                .prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '{{ route('emp.points.add') }}',
                dataType: 'json',
                data: formdata,
                contentType: false,
                processData: false,
                cache: false,
                mimeType: 'multipart/form-data',

                success: function (res) {
                    if (res.Error == false) {
                        Swal.fire({ // Swirl Success MSG
                            title: "Success!",
                            text: res.Message,
                            imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",
                            imageWidth: 100,
                            imageHeight: 100,
                            imageAlt: "Party Image"
                        });
                        $('#addModal').modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 10);
                    } else {
                        swirlmsg(res.Message);
                    }
                    $('#sub-btn').html('Submit').prop('disabled', false);
                },
                error: function (e) {
                    var first_error = '';
                    var count = 0;
                    $.each(e.responseJSON.errors, function (index, item) {
                        if (count == 0) {
                            first_error = item[0];
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                    $('#sub-btn').html('Submit').prop('disabled', false);
                }

            });
        });

    </script>
@endsection
