
@extends('Employee.layout')
@section('title',"Leader Board")
@section('page-name',"Leader Board")
@section('page-detail',"All Rankings Information")
@section('pagelink', 'leaderboard')
@section('body')
    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row align-items-center">
                        <div class="col-md-5 col-lg-4 mb-3">
                            <h4>Leader Board</h4>
                        </div>
                        <div class="col-md-5 ms-auto mb-3">
                            <div class="d-flex justify-content-end gap-2 align-items-center">
                                <!-- Month Dropdown -->
                                <select class="form-select shadow-none" style="width: 150px" id="dateFilter" onchange="filterByDate()">
                                    @foreach($months as $month)
                                        <option value="{{ $month }}">{{ \Carbon\Carbon::parse($month)->format('M-y') }}</option>
                                    @endforeach
                                </select>
                                <!-- Filter Dropdown -->
                                <select class="form-select shadow-none" style="width: 150px" id="filter" onchange="switchBoards()">
                                    <option value="emp">Employees</option>
                                    <option value="dep">Department</option>
                                    <option value="cat">Category</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <!-- Department Leader Board -->
                    <div class="row d-none" id="depLeaderBoard">
                        @include('partials.departmentLeaderBoard', ['departments' => $departments])
                    </div>

                    <!-- Employee Leader Board -->
                    <div class="row" id="empLeaderBoard">
                        @include('partials.employeeLeaderBoard', ['employees' => $employees])
                    </div>

                    <!-- Category Leader Board -->
                    <div class="row d-none" id="catLeaderBoard">
                        @include('partials.categoryLeaderBoard', ['categories' => $categories])
                    </div>

                    <!-- Dealership Leader Board -->
                    <div class="row d-none" id="dealerLeaderBoard">
                        {{--                        @include('partials.dealershipLeaderBoard', ['dealerships' => $dealerships])--}}
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-scripts')
    <script>

        //Function to switch between Leader Boards
        function switchBoards() {
            filterByDate();
            let choice = $('#filter').val();
            if(choice == 'emp')
            {
                $('#empLeaderBoard').removeClass('d-none');
                $('#depLeaderBoard').addClass('d-none');
                $('#catLeaderBoard').addClass('d-none');
            }
            else if(choice == 'dep')
            {
                $('#depLeaderBoard').removeClass('d-none');
                $('#empLeaderBoard').addClass('d-none');
                $('#catLeaderBoard').addClass('d-none');
            }
            else
            {
                $('#catLeaderBoard').removeClass('d-none');
                $('#empLeaderBoard').addClass('d-none');
                $('#depLeaderBoard').addClass('d-none');
            }
        }

        //Function to get Filtered Data By Date
        function filterByDate() {
            let selectedMonth = $('#dateFilter').val();
            let choice = $('#filter').val();
            if(choice == 'emp')
            {
                let url = "{{ route('emp.empFilter.leaderboard', ['currentMonth' => ':currentMonth']) }}".replace(':currentMonth', selectedMonth);
                $.ajax({
                    url: url, // Create this route in Laravel
                    type: "GET",
                    success: function(response) {
                        $("#empLeaderBoard").html(response); // Replace the leaderboard div with the updated content
                    },
                    error: function(xhr) {
                        console.error("Error fetching leaderboard:", xhr.responseText);
                    }
                });
            }
            else if(choice == 'dep')
            {
                let url = "{{ route('emp.depFilter.leaderboard', ['currentMonth' => ':currentMonth']) }}".replace(':currentMonth', selectedMonth);
                $.ajax({
                    url: url, // Create this route in Laravel
                    type: "GET",
                    success: function(response) {
                        $("#depLeaderBoard").html(response); // Replace the leaderboard div with the updated content
                    },
                    error: function(xhr) {
                        console.error("Error fetching leaderboard:", xhr.responseText);
                    }
                });
            }
            else
            {
                let url = "{{ route('emp.catFilter.leaderboard', ['currentMonth' => ':currentMonth']) }}".replace(':currentMonth', selectedMonth);
                $.ajax({
                    url: url, // Create this route in Laravel
                    type: "GET",
                    success: function(response) {
                        $("#catLeaderBoard").html(response); // Replace the leaderboard div with the updated content
                    },
                    error: function(xhr) {
                        console.error("Error fetching leaderboard:", xhr.responseText);
                    }
                });
            }
        }

    </script>
@endsection
