@extends('Employee.layout')
@section('title',"Dashboard")
@section('page-name',"Hello ".$employee['name'])
@section('page-detail',"Welcome Back!")
@section('pagelink', 'dashboard')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card ">
            <div class="card-body">
                <!-- Employee Welcome Section with Emoji -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="border rounded-3 p-4 bg-light">
                            <div class="d-flex align-items-center">
                                <div class="position-relative me-3">
                                    @if (!empty($employee['image']))
                                        <img src="{{ asset($employee['image']) }}"
                                             alt="Employee Image"
                                             style="height: 60px; width: 60px"
                                             class="img-fluid rounded-circle">
                                    @else
                                        <div class="initials-container-large">
                                            {{ strtoupper(substr($employee['name'], 0, 2)) }}
                                        </div>
                                    @endif
                                    @php
                                        $latestEmoji = \App\Models\EmojiAssignment::with('emoji')
                                            ->where('assignable_id', $employee['employee_id'])
                                            ->where('assignable_type', 'App\Models\Employee')
                                            ->where('tenant_id', $employee['tenant_id'])
                                            ->orderBy('created_at', 'desc')
                                            ->first();
                                    @endphp
                                    @if($latestEmoji)
                                        <div class="custom-emoji-badge-large position-absolute" 
                                             style="bottom: -5px; right: -5px; font-size: 20px; 
                                                    background: white; border-radius: 50%; 
                                                    padding: 4px; line-height: 1;
                                                    box-shadow: 0 2px 4px rgba(0,0,0,0.1); min-width: 28px; min-height: 28px; display: flex; align-items: center; justify-content: center;">
                                            @if($latestEmoji->emoji->type === 'emoji')
                                                <span style="font-size: 18px;">{{ $latestEmoji->emoji->emoji_text }}</span>
                                            @else
                                                <img src="{{ asset($latestEmoji->emoji->file_path) }}" 
                                                     alt="{{ $latestEmoji->emoji->name }}" 
                                                     style="height: 20px; width: 20px; object-fit: cover; border-radius: 50%;">
                                            @endif
                                        </div>
                                    @endif
                                </div>
                                <div>
                                    <h3 class="mb-1">Hello {{ $employee['name'] }}! 
                                        @if($latestEmoji)
                                            <span style="font-size: 1.2em;">{{ $latestEmoji->emoji->type === 'emoji' ? $latestEmoji->emoji->emoji_text : '' }}</span>
                                        @endif
                                    </h3>
                                    <p class="text-muted mb-0">Welcome back to your dashboard</p>
                                    <small class="text-primary">{{ $employee['category'] }} • {{ $employee['role'] }}</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Assigned Emojis/GIFs Section -->
                @if(isset($assignedEmojis) && $assignedEmojis->count() > 0)
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="border rounded-3 p-4 bg-primary bg-opacity-10">
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    <i class="fas fa-gift text-primary" style="font-size: 1.5rem;"></i>
                                </div>
                                <div>
                                    <h5 class="mb-1 text-primary">Your Assigned Emojis & GIFs</h5>
                                    <small class="text-muted">Special emojis and GIFs assigned to you</small>
                                </div>
                            </div>
                            <div class="row">
                                @foreach($assignedEmojis as $assignment)
                                    <div class="col-md-4 col-sm-6 mb-3">
                                        <div class="card border-0 shadow-sm">
                                            <div class="card-body text-center p-3">
                                                <div class="mb-2" style="min-height: 60px; display: flex; align-items: center; justify-content: center;">
                                                    @if($assignment->emoji->type === 'emoji')
                                                        <span style="font-size: 2.5rem;">{{ $assignment->emoji->emoji_text }}</span>
                                                    @else
                                                        <img src="{{ asset($assignment->emoji->file_path) }}" 
                                                             alt="{{ $assignment->emoji->name }}" 
                                                             style="max-height: 60px; max-width: 100%;">
                                                    @endif
                                                </div>
                                                <h6 class="card-title mb-1">{{ $assignment->emoji->name }}</h6>
                                                @if($assignment->message)
                                                    <p class="card-text text-muted small mb-0">{{ $assignment->message }}</p>
                                                @endif
                                                <small class="text-muted">{{ $assignment->created_at->format('M d, Y') }}</small>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <div class=" border rounded-3 p-3">
                            <div class="d-flex align-items-center mb-3">
                                <div class="users-icon-box">
                                    <i class="fas fa-users"></i>
                                </div>
                                <h4 class="ms-3">Your Progress in : {{$employee['category']}}</h4>
                            </div>
                            @if($targets->isEmpty())
                                <h4>No Record to Show</h4>
                            @else
                                <div class="row">
                                    <div class="table-responsive">
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th scope="col">Name & Product</th>
                                                <th scope="col">Your Contribution</th>
                                                <th scope="col">Total Points</th>
                                                <th scope="col">You Gained</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($targets as $target)
                                                <tr>
                                                    <td class="align-middle">
                                                        @if($target->custom == null)
                                                            <h5 class="mb-2">{{$target->name ?? 'No Query'}}</h5>
                                                        @else
                                                            <h5 class="mb-2">{{$target->custom}}</h5>
                                                        @endif
                                                    </td>
                                                    <th class="align-middle">
                                                        @php
                                                            $claim = $claims->filter(function ($item) use ($target) {
                                                                return $item->target_id == $target->id;
                                                            });

                                                            if ($claim->isEmpty()) {
                                                                $percent['value'] = 0;
                                                                $percent['status'] = "Completed";
                                                            } else {
                                                                $firstClaim = $claim->first(); // Get the first matching record
                                                                $redeemed = $firstClaim->redeemed_points ?? 0; // Ensure it exists
                                                                $quantity = $firstClaim->quantity ?? 1; // Avoid division by zero

                                                                $percent = calculatePercentage($redeemed, $quantity);

                                                                if ($percent['value'] > 100) {
                                                                    $percent['value'] = 100;
                                                                }
                                                            }
                                                        @endphp

                                                        <h5 class="mb-2">{{$percent['value']}}% <span
                                                                class="ms-4 p-light">{{$percent['status']}}</span></h5>
                                                        <div class="progress mb-3" style="height: 3px;">
                                                            <div class="progress-bar" role="progressbar"
                                                                 style="width: {{$percent['value']}}%; background-color: #6EA0F9;"
                                                                 aria-valuenow="{{$percent['value']}}" aria-valuemin="0"
                                                                 aria-valuemax="100">
                                                            </div>
                                                        </div>
                                                    </th>
                                                    <td> {{ $target->quantity }} pts </td>
                                                    <td> {{ $redeemed ?? "0" }} pts </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @endif
                            <p class="p-light mb-0">Updated at: {{$currentDate}}</p>
                            <!--<p class="p-light mb-0">Updated at: {{$currentDate}}</p>-->
                        </div>
                    </div>
                </div>

                <!-- Line Chart For Employee -->
                <div class="row">
                    <!-- Line Chart -->
                    <div class="col-md-8">
                        <div class=" border rounded-3 p-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <h4 class="mb-0">Redeemed Points</h4>
                                <div col-md-4>
                                    <select class="form-select" id="filter" onchange="updateChart()">
                                        <option value="today">Today</option>
                                        <option value="week">This Week</option>
                                        <option value="month">This Month</option>
                                        <option value="6_months">Last 6 Months</option>
                                        <option value="year">This Year</option>
                                    </select>
                                </div>
                            </div>
                            <canvas id="lineChart"></canvas>
                        </div>
                    </div>
                    <!-- Pie Chart -->
                    <div class="col-md-4">
                        <div class=" border rounded-3 p-3">
                            <div class="text-center">
                              <h4 class="mb-4">Overall Points</h4>
                            </div>
                            <div class="d-flex justify-content-center">
                              <div class="d-flex align-items-center px-2">
                                <div class="me-1" style="background-color: #6EA0F9; width: 15px; height: 15px; border-radius: 50px;"></div>
                                <p class="p-small mb-0">Redeemed Points</p>
                              </div>
                              <div class="d-flex align-items-center px-2">
                                <div class="me-1" style="background-color: #1a1a2e; width: 15px; height: 15px; border-radius: 50px;"></div>
                                  <p class="p-small mb-0">Pending Points</p>
                              </div>
                            </div>
                            <canvas id="overallPointsChart" class="px-3"></canvas>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <h4 class="ms-3 mt-3">Redeemed Points</h4>
                    <div class="col-12">
                        <div class="border rounded-3 p-3">
                            @if($points->isEmpty())
                                <h4>No Claimed Points to Show</h4>
                            @else
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th scope="col">VIN#</th>
                                            <th scope="col">Target/Product</th>
                                            <th scope="col">Points</th>
                                            <th scope="col">Claimed Date</th>
                                            <th scope="col">Status</th>
                                        </tr>
                                        </thead>
                                        @foreach($points as $point)

                                            <tbody>
                                            <tr>
                                                <td class="align-middle">{{ $point->vin_no }}</td>

                                                @if($point->custom == null)
                                                    <td class="align-middle">{{ $point->name }}</td>
                                                @else
                                                    <td class="align-middle">{{ Str::limit($point->custom, 50) }}</td>
                                                @endif

                                                <td class="align-middle justify-content-center">{{ $point->points }}</td>
                                                <td class="align-middle">{{ \Carbon\Carbon::parse($point->created_at)->format('m-d-y') }}</td>
                                                <td class="align-middle">
                                                    @if($point->status === 'Redeemed')
                                                        <a href="#" class="btn btn-active">Redeemed</a>
                                                    @elseif($point->status === 'Rejected')
                                                        <a href="#" class="btn btn-inactive">Rejected</a>
                                                    @else
                                                        <a href="#" class="btn btn-pending">Pending</a>
                                                    @endif
                                                </td>
                                            </tr>
                                            </tbody>
                                        @endforeach
                                    </table>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        /* Enhanced styling for dashboard emoji elements */
        .initials-container-large {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 22px;
            text-transform: uppercase;
        }

        .emoji-badge-large {
            z-index: 10;
            animation: bounceIn 0.5s ease;
        }

        @keyframes bounceIn {
            0% {
                transform: scale(0.3);
                opacity: 0;
            }
            50% {
                transform: scale(1.1);
            }
            70% {
                transform: scale(0.9);
            }
            100% {
                transform: scale(1);
                opacity: 1;
            }
        }

        .bg-light {
            background: linear-gradient(135deg, #f8f9ff 0%, #f0f4ff 100%) !important;
        }

        .users-icon-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 12px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
@endsection

@section('custom-scripts')
    <script>

        window.onload = function (){
            //Plot Chart for Employee
            updateChart();

            //Fill Data in Array to Plot Pie Chart
            const redeemedPoints = {!! json_encode(calculatePercentage($piePoints->redeemed ?? 0, $piePoints->total_points ?? 0)) !!}.value;
            const pieData = [
                redeemedPoints, // Add the redeemed value
                100 - redeemedPoints,  // Add the pending value
            ];

            createPieChart(pieData);
        };

        // Plot Pie Chart for All the Redeemed and Pending Points
        function createPieChart(chartData) {
            const ctxPie = document.getElementById('overallPointsChart').getContext('2d');
            new Chart(ctxPie, {
                type: 'doughnut',
                data: {
                    // labels: ['Redeemed Points', 'Pending Points'],
                    datasets: [{
                        data: chartData, // Example data (in percentages)
                        backgroundColor: ['#6EA0F9', '#1a1a2e'],
                        hoverOffset: 4,
                        borderWidth: 15,
                        borderColor: '#EEF0FA' // White border for separation
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%', // Creates a thicker donut appearance
                    plugins: {
                        legend: {
                            display: true,
                            position: 'bottom',
                            labels: {
                                color: '#000',
                                font: {
                                    family: 'Montserrat', // Ensure Montserrat is included in your CSS
                                    size: 14
                                }
                            }
                        },
                        tooltip: {
                            backgroundColor: '#ffffff',
                            bodyColor: '#1a1a2e',
                            titleColor: '#1a1a2e',
                            borderColor: 'var(--primary-color)',
                            borderWidth: 1,
                            padding: 10,
                            callbacks: {
                                label: function(tooltipItem) {
                                    return `${tooltipItem.label}: ${tooltipItem.raw}%`;
                                }
                            }
                        }
                    }
                }
            });
        }

        // Filtered Line-Chart
        let lineChart; // Store the chart instance

        function updateChart() {
            const filter = document.getElementById('filter').value;
            fetch(`empPointsData?filter=${filter}`)
                .then(response => response.json())
                .then(data => {
                    const currentDate = new Date();
                    let labels = [];
                    let fullData = [];

                    // Generate labels and initialize data
                    if (filter === 'today') {

                        // Generate labels for 24 hours in the format "HH:00"
                        labels = Array.from({ length: 24 }, (_, i) => {
                            const hour = i % 12 || 12; // Convert to 12-hour format, where 0 becomes 12
                            const period = i < 12 ? "AM" : "PM"; // Determine AM or PM
                            return `${hour} ${period}`;
                        });

                        // Initialize the data array for 24 hours
                        fullData = new Array(24).fill(0);

                        // Populate the data array with points
                        data.forEach(item => {
                            const hour = parseInt(item.time_group, 10); // Parse the hour from the time_group
                            if (hour >= 0 && hour < 24) { // Ensure the hour is within a valid range
                                fullData[hour] = parseInt(item.total_points, 10); // Add total_points at the corresponding hour index
                            }
                        });

                    } else if (filter === 'week') {

                        // Assuming currentDate is today's date
                        const currentDate = new Date();
                        currentDate.setHours(0, 0, 0, 0); // Normalize currentDate to midnight

                        // Create labels for the last 7 days, including today
                        labels = Array.from({ length: 7 }, (_, i) => {
                            const day = new Date(currentDate); // Copy currentDate
                            day.setDate(currentDate.getDate() - i); // Subtract i days to get the past 7 days
                            return day.toLocaleDateString("en-US", { weekday: 'short' });
                        }).reverse(); // Reverse so the most recent day comes first

                        fullData = new Array(7).fill(0);

                        // Process your data and sum points per day
                        data.forEach(item => {
                            // Parse time_group to Date (item.time_group is a string like "2024-12-04")
                            const itemDate = new Date(item.time_group);
                            itemDate.setHours(0, 0, 0, 0); // Normalize to midnight

                            // Calculate the difference in days between currentDate and itemDate
                            const dayIndex = (currentDate - itemDate) / (1000 * 60 * 60 * 24);

                            // Map dayIndex to corresponding position in labels array
                            const labelIndex = 6 - dayIndex; // This will map 0 to Sunday, 1 to Monday, etc.

                            // Ensure that dayIndex is within the last 7 days (0 to 6)
                            if (labelIndex >= 0 && labelIndex < 7) {
                                fullData[labelIndex] += parseInt(item.total_points); // Add points for the corresponding day
                            }
                        });

                    }
                    else if (filter === 'month') {
                        const daysInMonth = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, 0).getDate();
                        labels = Array.from({ length: daysInMonth }, (_, i) => `${i + 1}`); // Day of the month
                        fullData = new Array(daysInMonth).fill(0);
                        data.forEach(item => {
                            const date = new Date(item.time_group).getDate();
                            fullData[date - 1] = item.total_points; // Map points to the specific date
                        });
                    } else if (filter === '6_months') {

                        // Get current date without modifying it
                        const currentDate = new Date();

                        // Generate labels for the last 6 months
                        labels = Array.from({ length: 6 }, (_, i) => {
                            const tempDate = new Date(currentDate); // Clone the date to avoid mutation
                            tempDate.setMonth(tempDate.getMonth() - i); // Subtract i months
                            return tempDate.toLocaleString("en-US", { month: 'short' });
                        }).reverse(); // Reverse to display from oldest to latest

                        // Initialize the data array for 6 months
                        fullData = new Array(6).fill(0);

                        // Iterate through the provided data
                        data.forEach(item => {
                            // Parse the time_group into a Date object
                            const itemDate = new Date(`${item.time_group} 01`); // Adding `01` as day to parse correctly

                            // Calculate the difference in months
                            const monthDiff =
                                (currentDate.getFullYear() - itemDate.getFullYear()) * 12 +
                                (currentDate.getMonth() - itemDate.getMonth());

                            // If the monthDiff is within the last 6 months
                            if (monthDiff >= 0 && monthDiff < 6) {
                                fullData[5 - monthDiff] += parseInt(item.total_points, 10); // Add total_points to the correct index
                            }
                        });

                    } else if (filter === 'year') {
                        const currentDate = new Date(); // Get the current date
                        labels = Array.from({ length: 12 }, (_, i) => {
                            // Create a new Date object for each month (from Jan to Dec)
                            const month = new Date(currentDate.getFullYear(), i, 1); // Year is current, month is i (0 to 11)
                            return month.toLocaleString("en-US", { month: 'short' });
                        });

                        fullData = new Array(12).fill(0); // Initialize array with 12 zeros for 12 months

                        data.forEach(item => {
                            // Parse the time_group (assuming it's in "Dec 2024" format)
                            const itemDate = new Date(item.time_group + " 1"); // Add "1" to make it a valid date (e.g., "Dec 2024" -> "Dec 1 2024")
                            const month = itemDate.getMonth(); // Get the month index (0-11)
                            fullData[month] += parseInt(item.total_points); // Add points for that month
                        });

                    }

                    // Prepare dataset: replace 0 with null to skip in chart but keep labels
                    const dataToPlot = fullData.map(value => (value === 0 ? null : value));

                    // Update or create the chart
                    if (lineChart) {
                        lineChart.data.labels = labels;
                        lineChart.data.datasets[0].data = dataToPlot;
                        lineChart.update();
                    } else {
                        createChart(labels, dataToPlot, filter);
                    }
                })
                .catch(error => console.error('Error fetching data:', error));
        }

        function createChart(labels, data) {
            const ctx = document.getElementById('lineChart').getContext('2d');

            lineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: labels, // Labels for x-axis (same as before)
                    datasets: [{
                        label: 'Points Redeemed',
                        data: data, // Points for y-axis (same as before)
                        borderColor: '#4b5fea',
                        backgroundColor: 'rgba(75, 95, 234, 0.1)',
                        fill: true,
                        tension: 0.4,
                        spanGaps: true, // Skip null values
                        pointBackgroundColor: '#4b5fea',
                        pointBorderColor: '#ffffff',
                        pointHoverBackgroundColor: '#ffffff',
                        pointHoverBorderColor: '#4b5fea',
                        pointRadius: 5,
                        pointHoverRadius: 5,
                        hitRadius: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true, // Start the y-axis at 0
                            grid: {
                                color: '#e6e6e6',
                                drawBorder: true,
                                borderDash: [5, 5], // Dashed grid lines
                            }
                        },
                        x: {
                            grid: {
                                display: false // Hide the x-axis grid
                            },
                        }
                    },
                    plugins: {
                        legend: {
                            display: true,
                            labels: {
                                color: '#000',
                                usePointStyle: true
                            }
                        },
                        tooltip: {
                            backgroundColor: '#f9f9f9',
                            titleColor: '#4b5fea',
                            bodyColor: '#333',
                            borderColor: '#4b5fea',
                            borderWidth: 1,
                            padding: 10,
                            displayColors: false,
                            intersect: true,
                            mode: 'nearest',
                            callbacks: {
                                label: function(tooltipItem) {
                                    return tooltipItem.raw + ' pts'; // Tooltip format
                                }
                            }
                        }
                    },
                    elements: {
                        point: {
                            radius: 5,
                            hoverRadius: 5,
                            hitRadius: 0
                        },
                        line: {
                            borderWidth: 2 // Line width for the chart
                        }
                    },
                    layout: {
                        padding: {
                            top: 10,
                            bottom: 10
                        }
                    }
                }
            });
        }
    </script>
@endsection