<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>LOGIN</title>
    <link rel="icon" type="image/x-icon" href="{{ asset('assets') }}/img/favicon.webp">
    <!-- ===========STYLE================ -->
    <link rel="stylesheet" type="text/css" href="{{ asset('assets') }}/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets') }}/css/style.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets') }}/css/responsive.css">
    <!-- ===========font style=========== -->
    <link href="https://fonts.googleapis.com/css2?family=Lexend:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- ===========fontawsom icon=========== -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>

<body>
<style>
  .hand-wave {
  display: inline-block;
  animation: wave 3s ease-in-out infinite;
  transform-origin: 80% 80%;
}

.h-vh{
    height: 90vh;
}
@keyframes wave {
  0%, 60%, 100% {
    transform: rotate(0deg);
  }
  10%, 30%, 50%, 70% {
    transform: rotate(15deg);
  }
  20%, 40%, 80% {
    transform: rotate(-10deg);
  }
}
.img-login-box{
  background-color: #020F20; 
  border-radius: 50px; 
  height: 90vh;
  display: flex;
  align-items: center;
  justify-content: center;
}

</style>
<div class="container-fluid px-md-5 py-md-4 my-1">
    <div class="row align-items-center">
        <div class="col-lg-7 col-md-6 d-none d-mdblock">
            <div class="text-center px-md-4 img-login-box">
                <img src="{{ asset('assets') }}/img/crisma_logo_new.png" class="img-fluid px-md-5 w-100">
            </div>
        </div>
        <div class="col-lg-4 col-md-5 mx-auto">
            <div class="h-vh d-flex align-items-center">
                <div class="w-100">
                    <div class="mb-4">
                        <img src="{{ asset('assets') }}/img/logo.png" class="img-fluid">
                    </div>
                    <div class="d-flex mb-1">
                        <h3 class="mb-0">Welcome</h3>
                        <div class="ms-1">
                            <img src="{{ asset('assets') }}/img/login-hand.png" class="img-fluid mt-minus-1">
                        </div>
                    </div>
                    <p class="p-light mb-4">Owner Login</p>
                    <form id="login-form">
                        @csrf
                        <div class="form-floating mb-3">
                            <input type="email" name="email" class="form-control shadow-none" id="floatingInput" placeholder="name@example.com" required>
                            <label for="floatingInput">Email address</label>
                        </div>
                        <div class="form-floating mb-3 position-relative">
                            <input type="password" name="password" class="form-control shadow-none password-input" placeholder="Password" required>
                            <label>Password</label>
                            <span class="password-toggle-icon position-absolute top-50 end-0 translate-middle-y me-3">
                      <i class="fa fa-eye-slash toggle-password"></i>
                    </span>
                        </div>
                        <button type="submit" class="btn btn-primary shadow-none w-100 mb-3">Login</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


<script src="{{ asset('assets') }}/js/jquery-3.7.1.js"></script>
<script src="{{ asset('assets') }}/js/bootstrap.bundle.min.js"></script>
<script src="{{ asset('assets') }}/js/main.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{ asset('assets/js/sweetalert2.js')}}"></script>

<script>

    $('#login-form').on("submit", function(e) {
        e.preventDefault();
        var form = $('#login-form')[0];
        var formdata = new FormData(form);

        $('.submitBtn2').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')
            .prop('disabled', true);

        $.ajax({
            type: 'POST',
            url: '{{ route('owner.attempt.login') }}',
            dataType: 'json',
            data: formdata,
            contentType: false,
            processData: false,
            cache: false,
            mimeType: 'multipart/form-data',

            success: function(res) {
                if (res.Error == false) {
                    // Swirl MSG
                    Swal.fire({
                        title: "Login!",
                        text: res.Message,
                        imageUrl: "{{asset('assets/img/WelcomebackFabiana.png')}}",
                        imageWidth: 100,
                        imageHeight: 100,
                        imageAlt: "Party Image"
                    });

                    setTimeout(function() {
                        //window.location.reload();
                        window.location.href="{{ route('dealerships') }}";
                    }, 10);
                } else {
                    swirlmsg(res.Message);
                    // $('.submitBtn2').html('Save').prop('disabled', false);
                }
            },

            error: function(e) {
                var first_error = '';
                var count = 0;

                // Check if responseJSON and errors exist in the response
                if (e.responseJSON && e.responseJSON.errors) {
                    $.each(e.responseJSON.errors, function(index, item) {
                        if (count === 0) {
                            first_error = item[0]; // Capture the first error message
                        }
                        count++;
                    });
                    swirlmsg(first_error);
                } else {
                    swirlmsg("Invalid Email or Password");
                }

                $('.submitBtn2').html('Login').prop('disabled', false);
            }
        });
    });

    function swirlmsg(msg)
    {
        Swal.fire({
            title: "Error!",
            icon: "error",
            text: msg
        });
    }


</script>
</body>
</html>
