@extends('Dealership.includes.layout')
@section('title', 'Dealerships')
@section('page-name', 'Dealerships')
@section('page-detail', 'All Listed Dealerships')
@section('body')

    <div class="content-are-dashboard p-3">
        <div class="card rounded-3">
            <div class="card-body">
                <div class="border rounded-3 p-3">
                    <div class="row">
                        <div class="col-md-5 col-lg-4">
                            <div class="search">
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-transparent" id="basic-addon1">
                                        <i class="fas fa-search search-icon"></i></span>
                                    <input id="searchInput" type="text" class="form-control shadow-none"
                                           placeholder="Search"
                                           aria-label="search" aria-describedby="basic-addon1">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary px-3 me-2" data-bs-toggle="modal"
                                        data-bs-target="#addModal" data-bs-whatever="@getbootstrap"><i
                                        class="fas fa-plus-circle me-3"></i> Add New Dealership
                                </button>
                            </div>
                        </div>
                    </div>
                    {{--                    @if($products->isEmpty())--}}
                    {{--                        <h4>No Product Added Yet!</h4>--}}
                    {{--                    @else--}}
                    {{--                        <div class="row">--}}
                    {{--                            <div class="col-12">--}}
                    {{--                                <div class="table-responsive">--}}
                    {{--                                    <table id="entryTable" class="table">--}}
                    {{--                                        <thead>--}}
                    {{--                                        <tr>--}}
                    {{--                                            <th scope="col">Code</th>--}}
                    {{--                                            <th scope="col">Name</th>--}}
                    {{--                                            <th scope="col">Number</th>--}}
                    {{--                                            <th scope="col">Status</th>--}}
                    {{--                                            <th scope="col">Date</th>--}}
                    {{--                                            <th scope="col">Action</th>--}}
                    {{--                                        </tr>--}}
                    {{--                                        </thead>--}}
                    {{--                                        <tbody>--}}
                    {{--                                        @foreach($products as $product)--}}

                    {{--                                            <tr>--}}

                    {{--                                                <td class="align-middle">{{$product->code}}</td>--}}
                    {{--                                                <td class="align-middle">{{$product->name}}</td>--}}
                    {{--                                                <td class="align-middle">{{$product->number}}</td>--}}

                    {{--                                                <td class="align-middle">--}}
                    {{--                                                    @if($product->status === '2')--}}
                    {{--                                                        <a href="#" class="btn btn-active">Active</a>--}}
                    {{--                                                    @elseif($product->status === '1')--}}
                    {{--                                                        <a href="#" class="btn btn-inactive">Inactive</a>--}}
                    {{--                                                    @else--}}
                    {{--                                                        <a href="#" class="btn btn-pending">Pending</a>--}}
                    {{--                                                    @endif--}}
                    {{--                                                </td>--}}

                    {{--                                                <td class="align-middle">{{$product->created_at->format('d-m-y')}}</td>--}}

                    {{--                                                <td class="align-middle">--}}
                    {{--                                                    <a href="#"><i class="fas fa-eye px-1"></i></a>--}}

                    {{--                                                    <a href="#" onclick="setValues({{ $product }})" data-bs-toggle="modal"--}}
                    {{--                                                       data-bs-target="#addModal"><i class="fas fa-pen px-1"></i></a>--}}

                    {{--                                                    <a href="javascript:void(0);"--}}
                    {{--                                                       onclick="deleteProducts('{{ $product->id }}', $(this));">--}}
                    {{--                                                        <i class="fas fa-trash px-1"></i></a>--}}
                    {{--                                                </td>--}}
                    {{--                                            </tr>--}}
                    {{--                                        @endforeach--}}
                    {{--                                        </tbody>--}}
                    {{--                                    </table>--}}
                    {{--                                </div>--}}
                    {{--                            </div>--}}
                    {{--                        </div>--}}
                    {{--                    @endif--}}
                </div>
            </div>
        </div>
    </div>


    <!-- ========================================= -->
    <!-- MODAL -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-radious-20">
                <div class="modal-body p-4">
                    <h4>Add New Products</h4>
                    <hr>
                    <form id="addProductsForm">
                        @csrf
                        <input type="hidden" name="id" id="product_id">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="prodName" name="name" type="text" maxlength="20"
                                           class="form-control shadow-none" placeholder="Product name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <input id="prodNumber" name="number" type="text" maxlength="20"
                                           class="form-control shadow-none" placeholder="Product number" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-md-4 mb-3">
                                    <select id="prodStatus" name="status" class="form-control"
                                            aria-label="Status of Department" required>
                                        <option disabled selected value="">Select Status</option>
                                        <option value="2">Active</option>
                                        <option value="1">Inactive</option>
                                        <option value="0">Pending</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-primary-white shadow-none mb-3 px-5"
                                    data-bs-dismiss="modal" aria-label="Close">Cancel
                            </button>

                            <button class="btn btn-primary shadow-none mb-3 px-5 ms-md-3"
                                    type="submit" id="sub-btn">Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- ========================================= -->

@endsection
{{--@section('custom-scripts')--}}

{{--    <script>--}}

{{--        //Function to Empty the Form everytime it hides--}}
{{--        $('#addModal').on('hidden.bs.modal', function () {--}}
{{--            $(this).find('form')[0].reset(); // Resets all form inputs--}}
{{--        });--}}

{{--        //Function to Populate the Form--}}
{{--        function setValues(product) {--}}
{{--            // Set form values for ID, name, and number--}}
{{--            $('#product_id').val(product.id);--}}
{{--            $('#prodName').val(product.name);--}}
{{--            $('#prodNumber').val(product.number);--}}
{{--            $('#prodStatus').val(product.status);--}}
{{--        }--}}

{{--        //AJAX to Add New Products--}}
{{--        $('#addModal').on("submit", function (e) {--}}
{{--            e.preventDefault()--}}

{{--            var form = $('#addProductsForm')[0];--}}
{{--            var formdata = new FormData(form);--}}
{{--            $('#sub-btn').html('<span class="me-2"><i class="fa fa-spinner fa-spin"></i></span> Processing')--}}
{{--                .prop('disabled', true);--}}
{{--            $.ajax({--}}
{{--                type: 'POST',--}}
{{--                url: '{{ route('product.add') }}',--}}
{{--                dataType: 'json',--}}
{{--                data: formdata,--}}
{{--                contentType: false,--}}
{{--                processData: false,--}}
{{--                cache: false,--}}
{{--                mimeType: 'multipart/form-data',--}}

{{--                success: function (res) {--}}
{{--                    if (res.Error == false) {--}}
{{--                        Swal.fire({             // Swirl Success MSG--}}
{{--                            title: "Success!",--}}
{{--                            text: res.Message,--}}
{{--                            imageUrl: "{{asset('assets/img/WelcomebackFabiana.png')}}",--}}
{{--                            imageWidth: 100,--}}
{{--                            imageHeight: 100,--}}
{{--                            imageAlt: "Party Image"--}}
{{--                        });--}}
{{--                        $('#addModal').modal('hide');--}}
{{--                        setTimeout(function () {--}}
{{--                            window.location.reload();--}}
{{--                        }, 10);--}}
{{--                    } else {--}}
{{--                        swirlmsg(res.Message);--}}
{{--                    }--}}
{{--                    // $('#sub-btn').html('Submit').prop('disabled', false);--}}
{{--                },--}}
{{--                error: function (e) {--}}
{{--                    var first_error = '';--}}
{{--                    var count = 0;--}}
{{--                    $.each(e.responseJSON.errors, function (index, item) {--}}
{{--                        if (count == 0) {--}}
{{--                            first_error = item[0];--}}
{{--                        }--}}
{{--                        count++;--}}
{{--                    });--}}
{{--                    swirlmsg(first_error);--}}
{{--                    $('#sub-btn').html('Submit').prop('disabled', false);--}}
{{--                }--}}

{{--            });--}}
{{--        });--}}

{{--        //Function and AJAX to Delete Employee--}}
{{--        function deleteProducts(id, element) {--}}
{{--            Swal.fire({--}}
{{--                title: 'Are you sure?',--}}
{{--                text: "You won't be able to revert this!",--}}
{{--                icon: 'warning',--}}
{{--                showCancelButton: true,--}}
{{--                confirmButtonColor: '#3085d6',--}}
{{--                cancelButtonColor: '#d33',--}}
{{--                confirmButtonText: 'Yes, delete it!'--}}
{{--            }).then((result) => {--}}
{{--                if (result.isConfirmed) {--}}
{{--                    $.ajax({--}}
{{--                        type: 'POST',--}}
{{--                        url: '{{ route('product.delete') }}',--}}
{{--                        data: {--}}
{{--                            id: id,--}}
{{--                            _token: '{{ csrf_token() }}'--}}
{{--                        },--}}
{{--                        dataType: 'json',--}}
{{--                        success: function (res) {--}}
{{--                            if (res.Error === false) {--}}
{{--                                element.parent().parent().remove();--}}
{{--                                Swal.fire({ // Swirl Success MSG--}}
{{--                                    title: "Deleted!",--}}
{{--                                    text: res.Message,--}}
{{--                                    imageUrl: "{{ asset('assets/img/WelcomebackFabiana.png') }}",--}}
{{--                                    imageWidth: 100,--}}
{{--                                    imageHeight: 100,--}}
{{--                                    imageAlt: "Party Image"--}}
{{--                                });--}}
{{--                            } else {--}}
{{--                                swirlmsg(res.Message);--}}
{{--                            }--}}
{{--                        },--}}
{{--                        error: function (e) {--}}
{{--                            let first_error = 'An unknown error occurred.';--}}
{{--                            if (e.responseJSON && e.responseJSON.errors) {--}}
{{--                                first_error = Object.values(e.responseJSON.errors)[0][0];--}}
{{--                            }--}}
{{--                            swirlmsg(first_error);--}}
{{--                        }--}}
{{--                    });--}}
{{--                }--}}
{{--            })--}}
{{--        }--}}
{{--    </script>--}}

{{--@endsection--}}
