<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('emoji_assignments', function (Blueprint $table) {
            $table->id();
            $table->morphs('assignable'); // assignable_id, assignable_type (Employee, Admin, etc.)
            $table->morphs('assigned_by'); // assigned_by_id, assigned_by_type
            $table->unsignedBigInteger('emoji_id');
            $table->text('message')->nullable();
            $table->unsignedBigInteger('tenant_id');
            $table->timestamps();

            $table->foreign('emoji_id')->references('id')->on('custom_emojis')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('admins')->onDelete('cascade');
            
            $table->index(['assignable_id', 'assignable_type']);
            $table->index(['assigned_by_id', 'assigned_by_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('emoji_assignments');
    }
};