<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('custom_emojis', function (Blueprint $table) {
            // Make file-related columns nullable for emoji text types
            $table->string('file_path')->nullable()->change();
            $table->string('file_name')->nullable()->change();
            $table->string('mime_type')->nullable()->change();
            $table->integer('file_size')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('custom_emojis', function (Blueprint $table) {
            // Revert back to not nullable
            $table->string('file_path')->nullable(false)->change();
            $table->string('file_name')->nullable(false)->change();
            $table->string('mime_type')->nullable(false)->change();
            $table->integer('file_size')->nullable(false)->change();
        });
    }
};