<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_emoji_assignments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // User who receives the emoji/GIF
            $table->unsignedBigInteger('assigned_by'); // User who assigned the emoji/GIF
            $table->unsignedBigInteger('emoji_id'); // Reference to custom_emojis table
            $table->text('message')->nullable(); // Optional message with the emoji/GIF
            $table->unsignedBigInteger('tenant_id');
            $table->timestamps();
            
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('assigned_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('emoji_id')->references('id')->on('custom_emojis')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');
            
            $table->index(['user_id', 'tenant_id']);
            $table->index(['assigned_by', 'tenant_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_emoji_assignments');
    }
};