<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prizes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tenant_id');
            $table->integer('position'); // 1, 2, 3 for top 3 positions
            $table->string('title'); // e.g., "First Place Prize", "Gold Medal"
            $table->text('description')->nullable(); // Detailed description of the prize
            $table->decimal('prize_amount', 10, 2)->nullable(); // Prize money amount
            $table->string('prize_type')->default('money'); // money, gift, recognition, etc.
            $table->string('currency', 3)->default('USD'); // Currency code
            $table->string('category')->nullable(); // BDC, Service Advisor, Department, etc.
            $table->string('time_period')->default('current_month'); // current_month, last_month, quarter, year
            $table->boolean('is_active')->default(true);
            $table->timestamp('start_date')->nullable(); // When the prize becomes effective
            $table->timestamp('end_date')->nullable(); // When the prize expires
            $table->string('created_by_type')->nullable(); // admin, manager, superadmin
            $table->unsignedBigInteger('created_by_id')->nullable(); // ID of the creator
            $table->timestamps();
            
            // Indexes for better performance
            $table->index(['tenant_id', 'position', 'is_active']);
            $table->index(['tenant_id', 'category', 'time_period']);
            $table->index(['tenant_id', 'is_active', 'start_date', 'end_date']);
            
            // Foreign key constraint
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prizes');
    }
};