<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employee_leader_boards', function (Blueprint $table) {
            // Add composite indexes for better query performance
            $table->index(['tenant_id', 'month_year', 'rank'], 'idx_emp_leaderboard_tenant_month_rank');
            $table->index(['tenant_id', 'employee_id', 'month_year'], 'idx_emp_leaderboard_tenant_emp_month');
            $table->index(['month_year', 'rank'], 'idx_emp_leaderboard_month_rank');
            $table->index(['updated_at'], 'idx_emp_leaderboard_updated_at');
        });

        Schema::table('department_leader_boards', function (Blueprint $table) {
            // Add composite indexes for better query performance
            $table->index(['tenant_id', 'month_year', 'rank'], 'idx_dep_leaderboard_tenant_month_rank');
            $table->index(['tenant_id', 'department_id', 'month_year'], 'idx_dep_leaderboard_tenant_dep_month');
            $table->index(['month_year', 'rank'], 'idx_dep_leaderboard_month_rank');
            $table->index(['updated_at'], 'idx_dep_leaderboard_updated_at');
        });

        Schema::table('category_leader_board', function (Blueprint $table) {
            // Add composite indexes for better query performance
            $table->index(['tenant_id', 'month_year', 'rank'], 'idx_cat_leaderboard_tenant_month_rank');
            $table->index(['tenant_id', 'department_id', 'month_year'], 'idx_cat_leaderboard_tenant_dep_month');
            $table->index(['month_year', 'rank'], 'idx_cat_leaderboard_month_rank');
            $table->index(['updated_at'], 'idx_cat_leaderboard_updated_at');
        });

        Schema::table('employees', function (Blueprint $table) {
            // Add indexes for employee filtering
            $table->index(['tenant_id', 'category'], 'idx_employees_tenant_category');
            $table->index(['tenant_id', 'department_id', 'category'], 'idx_employees_tenant_dep_category');
            $table->index(['category', 'role'], 'idx_employees_category_role');
        });

        Schema::table('departments', function (Blueprint $table) {
            // Add indexes for department filtering
            $table->index(['tenant_id', 'name'], 'idx_departments_tenant_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employee_leader_boards', function (Blueprint $table) {
            $table->dropIndex('idx_emp_leaderboard_tenant_month_rank');
            $table->dropIndex('idx_emp_leaderboard_tenant_emp_month');
            $table->dropIndex('idx_emp_leaderboard_month_rank');
            $table->dropIndex('idx_emp_leaderboard_updated_at');
        });

        Schema::table('department_leader_boards', function (Blueprint $table) {
            $table->dropIndex('idx_dep_leaderboard_tenant_month_rank');
            $table->dropIndex('idx_dep_leaderboard_tenant_dep_month');
            $table->dropIndex('idx_dep_leaderboard_month_rank');
            $table->dropIndex('idx_dep_leaderboard_updated_at');
        });

        Schema::table('category_leader_board', function (Blueprint $table) {
            $table->dropIndex('idx_cat_leaderboard_tenant_month_rank');
            $table->dropIndex('idx_cat_leaderboard_tenant_dep_month');
            $table->dropIndex('idx_cat_leaderboard_month_rank');
            $table->dropIndex('idx_cat_leaderboard_updated_at');
        });

        Schema::table('employees', function (Blueprint $table) {
            $table->dropIndex('idx_employees_tenant_category');
            $table->dropIndex('idx_employees_tenant_dep_category');
            $table->dropIndex('idx_employees_category_role');
        });

        Schema::table('departments', function (Blueprint $table) {
            $table->dropIndex('idx_departments_tenant_name');
        });
    }
};