<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('business_cards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tenant_id');
            $table->unsignedBigInteger('user_id'); // Can be employee_id or admin_id
            $table->enum('user_type', ['employee', 'admin']); // To identify user type
            
            // Basic Information
            $table->string('name');
            $table->string('title');
            $table->string('company_name');
            $table->string('phone');
            $table->string('email');
            $table->string('website')->nullable();
            $table->text('bio')->nullable();
            
            // Car Dealership Specific Fields
            $table->json('specialties')->nullable(); // ["Sales", "Service", "Parts", "Finance"]
            $table->json('brands_worked_with')->nullable(); // ["Toyota", "Honda", "Ford"]
            $table->json('certifications')->nullable(); // ["ASE Certified", "Manufacturer Certified"]
            $table->integer('years_experience')->nullable();
            $table->string('languages_spoken')->nullable(); // "English, Spanish, French"
            
            // Additional Services
            $table->text('services_offered')->nullable();
            $table->string('location')->nullable(); // "Los Angeles, CA"
            $table->string('preferred_contact_method')->nullable(); // "Phone", "Email", "Text"
            
            // Media
            $table->string('profile_photo')->nullable();
            $table->string('company_logo')->nullable();
            $table->string('background_image')->nullable();
            
            // Social Media & Contact
            $table->json('social_links')->nullable(); // {"facebook": "url", "linkedin": "url", etc.}
            $table->string('whatsapp')->nullable();
            $table->string('linkedin')->nullable();
            $table->string('facebook')->nullable();
            $table->string('instagram')->nullable();
            $table->string('twitter')->nullable();
            
            // Customization
            $table->integer('template_id')->default(1); // 1-5 for different templates
            $table->json('custom_colors')->nullable(); // {"primary": "#color", "secondary": "#color"}
            $table->string('font_style')->default('modern'); // modern, classic, elegant
            
            // Sharing & Analytics
            $table->string('unique_slug')->unique();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_public')->default(true);
            $table->integer('view_count')->default(0);
            $table->timestamp('last_viewed_at')->nullable();
            
            // QR Code & Additional Features
            $table->text('qr_code')->nullable(); // Base64 encoded QR code
            $table->text('additional_notes')->nullable();
            $table->json('business_hours')->nullable(); // {"monday": "9-6", "tuesday": "9-6"}
            
            $table->timestamps();
            
            // Indexes
            $table->index(['tenant_id', 'user_id', 'user_type']);
            $table->index('unique_slug');
            $table->index(['is_active', 'is_public']);
            
            // Foreign Keys
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('business_cards');
    }
};